/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;

public class H5BufferBuilder {
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final DataOutputStream dataOutputStream;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;

    public H5BufferBuilder() {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    }

    public int getSize() {
        return this.dataOutputStream.size();
    }

    public void writeByte(int i) {
        try {
            this.dataOutputStream.writeByte(i);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public void writeBytes(byte[] bytes) {
        try {
            this.dataOutputStream.write(bytes);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public void writeInt(int i) {
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                i = Integer.reverseBytes(i);
            }
            this.dataOutputStream.writeInt(i);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public void writeShort(short i) {
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                i = Short.reverseBytes(i);
            }
            this.dataOutputStream.writeShort(i);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public void writeLong(long l) {
        try {
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                l = Long.reverseBytes(l);
            }
            this.dataOutputStream.writeLong(l);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public strictfp Double getNewVal(double d) {
        return d;
    }

    public static BitSet convert(long value) {
        BitSet bits = new BitSet();
        Object a = "";
        int index = 0;
        while (value != 0L) {
            if (value % 2L != 0L) {
                bits.set(index);
                a = (String)a + "1";
            } else {
                a = (String)a + "0";
            }
            ++index;
            value >>>= 1;
        }
        System.out.println((String)a);
        return bits;
    }

    public void writeDouble(double l) {
        try {
            this.writeLong(Double.doubleToLongBits(l));
        }
        catch (Exception e) {
            throw new H5RuntimeException(e);
        }
    }

    public void write(long v, int sizeOfLength) {
        try {
            switch (sizeOfLength) {
                case 2: {
                    this.writeShort((short)v);
                    break;
                }
                case 4: {
                    this.writeInt((int)v);
                    break;
                }
                case 8: {
                    this.writeLong(v);
                }
            }
        }
        catch (Exception e) {
            throw new H5RuntimeException(e);
        }
    }

    public ByteBuffer build() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArrayOutputStream.toByteArray());
            byteBuffer.order(this.byteOrder);
            this.dataOutputStream.close();
            this.byteArrayOutputStream.close();
            return byteBuffer;
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public ByteBuffer noOrderBuild() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArrayOutputStream.toByteArray());
            this.dataOutputStream.close();
            this.byteArrayOutputStream.close();
            return byteBuffer;
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public void writeBitSet(BitSet bitSet, int length) {
        if (bitSet.length() > length) {
            throw new H5RuntimeException("BitSet is longer than length provided");
        }
        try {
            byte[] bytes = Arrays.copyOf(bitSet.toByteArray(), length);
            this.dataOutputStream.write(bytes);
        }
        catch (IOException e) {
            throw new H5RuntimeException(e);
        }
    }

    public void goToPositionWithWriteZero(long pos) {
        long gap = pos - (long)this.dataOutputStream.size();
        byte[] gapByte = new byte[(int)gap];
        this.writeBytes(gapByte);
    }
}

