/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.privacy.finegrained.DataRange;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacyList;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.apache.wink.json4j.OrderedJSONObject;

public class PrivacyConstraint
implements Externalizable {
    protected PrivacyLevel privacyLevel = PrivacyLevel.None;
    protected FineGrainedPrivacy fineGrainedPrivacy;

    public PrivacyConstraint() {
        this(new FineGrainedPrivacyList());
    }

    public PrivacyConstraint(FineGrainedPrivacy fineGrainedPrivacyCollection) {
        this.setFineGrainedPrivacyConstraints(fineGrainedPrivacyCollection);
    }

    public PrivacyConstraint(PrivacyLevel privacyLevel) {
        this();
        this.setPrivacyLevel(privacyLevel);
    }

    public void setPrivacyLevel(PrivacyLevel privacyLevel) {
        this.privacyLevel = privacyLevel;
    }

    public PrivacyLevel getPrivacyLevel() {
        return this.privacyLevel;
    }

    public boolean hasFineGrainedConstraints() {
        return this.fineGrainedPrivacy.hasConstraints();
    }

    public void setFineGrainedPrivacyConstraints(FineGrainedPrivacy fineGrainedPrivacy) {
        this.fineGrainedPrivacy = fineGrainedPrivacy;
    }

    public FineGrainedPrivacy getFineGrainedPrivacy() {
        return this.fineGrainedPrivacy;
    }

    public boolean hasPrivateElements() {
        if (this.privacyLevel == PrivacyLevel.Private) {
            return true;
        }
        if (this.hasFineGrainedConstraints()) {
            DataRange[] dataRanges = this.fineGrainedPrivacy.getDataRangesOfPrivacyLevel(PrivacyLevel.Private);
            return dataRanges != null && dataRanges.length > 0;
        }
        return false;
    }

    public boolean hasConstraints() {
        if (this.privacyLevel != null && (this.privacyLevel == PrivacyLevel.Private || this.privacyLevel == PrivacyLevel.PrivateAggregation)) {
            return true;
        }
        if (this.hasFineGrainedConstraints()) {
            DataRange[] privateRanges = this.fineGrainedPrivacy.getDataRangesOfPrivacyLevel(PrivacyLevel.Private);
            DataRange[] aggregateRanges = this.fineGrainedPrivacy.getDataRangesOfPrivacyLevel(PrivacyLevel.PrivateAggregation);
            return privateRanges != null && privateRanges.length > 0 || aggregateRanges != null && aggregateRanges.length > 0;
        }
        return false;
    }

    public void toJson(JSONObject json) throws JSONException {
        if (this.getPrivacyLevel() != null && this.getPrivacyLevel() != PrivacyLevel.None) {
            json.put("privacy", (Object)this.getPrivacyLevel().name());
        }
        if (this.hasFineGrainedConstraints()) {
            DataRange[] privateRanges = this.getFineGrainedPrivacy().getDataRangesOfPrivacyLevel(PrivacyLevel.Private);
            JSONArray privateRangesJson = PrivacyConstraint.getJsonArray(privateRanges);
            DataRange[] aggregateRanges = this.getFineGrainedPrivacy().getDataRangesOfPrivacyLevel(PrivacyLevel.PrivateAggregation);
            JSONArray aggregateRangesJson = PrivacyConstraint.getJsonArray(aggregateRanges);
            OrderedJSONObject rangesJson = new OrderedJSONObject();
            rangesJson.put(PrivacyLevel.Private.name(), privateRangesJson);
            rangesJson.put(PrivacyLevel.PrivateAggregation.name(), aggregateRangesJson);
            json.put("fine_grained_privacy", rangesJson);
        }
    }

    private static JSONArray getJsonArray(DataRange[] ranges) throws JSONException {
        JSONArray rangeObjects = new JSONArray();
        for (DataRange range : ranges) {
            List rangeBegin = Arrays.stream(range.getBeginDims()).boxed().collect(Collectors.toList());
            List rangeEnd = Arrays.stream(range.getEndDims()).boxed().collect(Collectors.toList());
            JSONArray beginJson = new JSONArray((Collection)rangeBegin);
            JSONArray endJson = new JSONArray((Collection)rangeEnd);
            JSONArray rangeObject = new JSONArray();
            rangeObject.put(beginJson);
            rangeObject.put(endJson);
            rangeObjects.add(rangeObject);
        }
        return rangeObjects;
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.privacyLevel = PrivacyLevel.values()[is.readInt()];
        int fineGrainedConstraintLength = is.readInt();
        if (fineGrainedConstraintLength > 0) {
            for (int i = 0; i < fineGrainedConstraintLength; ++i) {
                int levelIndex = is.readInt();
                PrivacyLevel rangePrivacy = PrivacyLevel.values()[levelIndex];
                DataRange dataRange = PrivacyConstraint.readExternalDataRangeObject(is);
                this.fineGrainedPrivacy.put(dataRange, rangePrivacy);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.getPrivacyLevel().ordinal());
        if (this.fineGrainedPrivacy != null && this.fineGrainedPrivacy.hasConstraints()) {
            ArrayList<Map.Entry<DataRange, PrivacyLevel>> fineGrainedConstraints = this.fineGrainedPrivacy.getAllConstraintsList();
            objectOutput.writeInt(fineGrainedConstraints.size());
            for (Map.Entry entry : fineGrainedConstraints) {
                objectOutput.writeInt(((PrivacyLevel)((Object)entry.getValue())).ordinal());
                DataRange dataRange = (DataRange)entry.getKey();
                objectOutput.writeInt(dataRange.getBeginDims().length);
                PrivacyConstraint.writeExternalRangeDim(objectOutput, dataRange.getBeginDims());
                PrivacyConstraint.writeExternalRangeDim(objectOutput, dataRange.getEndDims());
            }
        } else {
            objectOutput.writeInt(0);
        }
    }

    private static DataRange readExternalDataRangeObject(ObjectInput is) throws IOException {
        int dimLength = is.readInt();
        long[] beginDims = PrivacyConstraint.readExternalDataRangeDim(is, dimLength);
        long[] endDims = PrivacyConstraint.readExternalDataRangeDim(is, dimLength);
        return new DataRange(beginDims, endDims);
    }

    private static long[] readExternalDataRangeDim(ObjectInput is, int dimLength) throws IOException {
        long[] dims = new long[dimLength];
        for (int i = 0; i < dimLength; ++i) {
            dims[i] = is.readLong();
        }
        return dims;
    }

    private static void writeExternalRangeDim(ObjectOutput objectOutput, long[] rangeDim) throws IOException {
        for (long beginIndex : rangeDim) {
            objectOutput.writeLong(beginIndex);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof PrivacyConstraint) {
            PrivacyConstraint otherPrivacyConstraint = (PrivacyConstraint)other;
            return otherPrivacyConstraint.privacyLevel == this.privacyLevel && otherPrivacyConstraint.getFineGrainedPrivacy().equals(this.fineGrainedPrivacy);
        }
        return false;
    }

    public String toString() {
        String constraintString = "General privacy level: " + this.privacyLevel;
        if (this.fineGrainedPrivacy != null && this.fineGrainedPrivacy.hasConstraints()) {
            constraintString = constraintString + System.getProperty("line.separator") + "Fine-grained privacy level: " + this.fineGrainedPrivacy.toString();
        }
        return constraintString;
    }

    public static enum PrivacyLevel {
        None,
        Private,
        PrivateAggregation;

    }
}

