/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.sysds.common.Types;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DoubleIdentifier
extends ConstIdentifier {
    private double _val;

    public DoubleIdentifier(double val) {
        this.setInfo(val);
        this.setBeginLine(-1);
        this.setBeginColumn(-1);
        this.setEndLine(-1);
        this.setEndColumn(-1);
        this.setText(null);
    }

    public DoubleIdentifier(double val, ParseInfo parseInfo) {
        this(val);
        this.setParseInfo(parseInfo);
    }

    public DoubleIdentifier(DoubleIdentifier d, ParseInfo parseInfo) {
        this(d.getValue());
        this.setParseInfo(parseInfo);
    }

    public DoubleIdentifier(ParserRuleContext ctx, double val, String filename) {
        this(val);
        this.setCtxValuesAndFilename(ctx, filename);
    }

    private void setInfo(double val) {
        this._val = val;
        this.setDimensions(0L, 0L);
        this.computeDataType();
        this.setValueType(Types.ValueType.FP64);
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        return this;
    }

    public void multiplyByMinusOne() {
        this._val = -1.0 * this._val;
    }

    public double getValue() {
        return this._val;
    }

    public void setValue(double v) {
        this._val = v;
    }

    public String toString() {
        return Double.toString(this._val);
    }

    @Override
    public VariableSet variablesRead() {
        return null;
    }

    @Override
    public VariableSet variablesUpdated() {
        return null;
    }

    @Override
    public long getLongValue() {
        return UtilFunctions.toLong(this.getValue());
    }
}

