/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.AEncode;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.estim.encoding.SparseEncoding;

public class DenseEncoding
extends AEncode {
    private final AMapToData map;

    public DenseEncoding(AMapToData map) {
        this.map = map;
        if (CompressedMatrixBlock.debug) {
            int[] freq = map.getCounts();
            for (int i = 0; i < freq.length; ++i) {
                if (freq[i] != 0) continue;
                throw new DMLCompressionException("Invalid counts in fact contains 0");
            }
        }
    }

    @Override
    public IEncode combine(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return this;
        }
        if (e instanceof SparseEncoding) {
            return this.combineSparse((SparseEncoding)e);
        }
        return this.combineDense((DenseEncoding)e);
    }

    @Override
    public Pair<IEncode, Map<Integer, Integer>> combineWithMap(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return new ImmutablePair((Object)this, null);
        }
        if (e instanceof SparseEncoding) {
            return this.combineSparseNoResize((SparseEncoding)e);
        }
        return this.combineDenseNoResize((DenseEncoding)e);
    }

    protected IEncode combineSparse(SparseEncoding e) {
        int maxUnique = e.getUnique() * this.getUnique();
        int size = this.map.size();
        int nVl = this.getUnique();
        AMapToData ret = this.assignSparse(e);
        if (maxUnique + nVl > size) {
            return (IEncode)this.combineSparseHashMap(ret).getLeft();
        }
        return this.combineSparseMapToData(ret, maxUnique, nVl);
    }

    private AMapToData assignSparse(SparseEncoding e) {
        int maxUnique = e.getUnique() * this.getUnique();
        int size = this.map.size();
        int nVl = this.getUnique();
        AMapToData ret = MapToFactory.create(size, maxUnique);
        ret.copy(this.map);
        AIterator itr = e.off.getIterator();
        int fr = e.off.getOffsetToLast();
        int ir = itr.value();
        while (ir < fr) {
            ret.set(ir, ret.getIndex(ir) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
            ir = itr.next();
        }
        ret.set(fr, ret.getIndex(fr) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
        return ret;
    }

    private final Pair<IEncode, Map<Integer, Integer>> combineSparseHashMap(AMapToData ret) {
        int size = ret.size();
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(size);
        for (int r = 0; r < size; ++r) {
            int prev = ret.getIndex(r);
            int v = m.size();
            Integer mv = m.putIfAbsent(prev, v);
            if (mv == null) {
                ret.set(r, v);
                continue;
            }
            ret.set(r, mv);
        }
        return new ImmutablePair((Object)new DenseEncoding(MapToFactory.resize(ret, m.size())), m);
    }

    private final DenseEncoding combineSparseMapToData(AMapToData ret, int maxUnique, int nVl) {
        int size = ret.size();
        AMapToData m = MapToFactory.create(maxUnique, maxUnique + nVl);
        int newUID = 1;
        for (int r = 0; r < size; ++r) {
            int prev = ret.getIndex(r);
            int mv = m.getIndex(prev);
            if (mv == 0) {
                mv = m.setAndGet(prev, newUID++);
            }
            ret.set(r, mv - 1);
        }
        return new DenseEncoding(MapToFactory.resize(ret, newUID - 1));
    }

    protected DenseEncoding combineDense(DenseEncoding other) {
        if (this.map == other.map) {
            return this;
        }
        AMapToData lm = this.map;
        AMapToData rm = other.map;
        int nVL = lm.getUnique();
        int nVR = rm.getUnique();
        int size = this.map.size();
        int maxUnique = nVL * nVR;
        AMapToData ret = MapToFactory.create(size, maxUnique);
        if (maxUnique > size && maxUnique > 2048) {
            HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(size);
            return this.combineDenseWithHashMap(lm, rm, size, nVL, ret, m);
        }
        AMapToData m = MapToFactory.create(maxUnique, maxUnique + 1);
        return this.combineDenseWithMapToData(lm, rm, size, nVL, ret, maxUnique, m);
    }

    private Pair<IEncode, Map<Integer, Integer>> combineDenseNoResize(DenseEncoding other) {
        if (this.map == other.map) {
            LOG.warn((Object)"Constructing perfect mapping, this could be optimized to skip hashmap");
            HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(this.map.size());
            for (int i = 0; i < this.map.getUnique(); ++i) {
                m.put(i * i, i);
            }
            return new ImmutablePair((Object)this, m);
        }
        AMapToData lm = this.map;
        AMapToData rm = other.map;
        int nVL = lm.getUnique();
        int nVR = rm.getUnique();
        int size = this.map.size();
        int maxUnique = nVL * nVR;
        AMapToData ret = MapToFactory.create(size, maxUnique);
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(Math.min(size, maxUnique));
        return new ImmutablePair((Object)this.combineDenseWithHashMap(lm, rm, size, nVL, ret, m), m);
    }

    private Pair<IEncode, Map<Integer, Integer>> combineSparseNoResize(SparseEncoding other) {
        AMapToData a = this.assignSparse(other);
        return this.combineSparseHashMap(a);
    }

    protected final DenseEncoding combineDenseWithHashMap(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, Map<Integer, Integer> m) {
        for (int r = 0; r < size; ++r) {
            DenseEncoding.addValHashMap(lm.getIndex(r) + rm.getIndex(r) * nVL, r, m, ret);
        }
        return new DenseEncoding(MapToFactory.resize(ret, m.size()));
    }

    protected final DenseEncoding combineDenseWithMapToData(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, int maxUnique, AMapToData m) {
        int newUID = 1;
        for (int r = 0; r < size; ++r) {
            newUID = DenseEncoding.addValMapToData(lm.getIndex(r) + rm.getIndex(r) * nVL, r, m, newUID, ret);
        }
        return new DenseEncoding(MapToFactory.resize(ret, newUID - 1));
    }

    protected static int addValMapToData(int nv, int r, AMapToData map, int newId, AMapToData d) {
        int mv = map.getIndex(nv);
        if (mv == 0) {
            mv = map.setAndGet(nv, newId++);
        }
        d.set(r, mv - 1);
        return newId;
    }

    protected static void addValHashMap(int nv, int r, Map<Integer, Integer> map, AMapToData d) {
        int v = map.size();
        Integer mv = map.putIfAbsent(nv, v);
        if (mv == null) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    @Override
    public int getUnique() {
        return this.map.getUnique();
    }

    @Override
    public EstimationFactors extractFacts(int nRows, double tupleSparsity, double matrixSparsity, CompressionSettings cs) {
        int largestOffs = 0;
        int[] counts = this.map.getCounts();
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] > largestOffs) {
                largestOffs = counts[i];
                continue;
            }
            if (counts[i] != 0) continue;
            throw new DMLCompressionException("Invalid count of 0 all values should have at least one instance");
        }
        if (cs.isRLEAllowed()) {
            return new EstimationFactors(this.map.getUnique(), nRows, largestOffs, counts, 0, nRows, this.map.countRuns(), false, false, matrixSparsity, tupleSparsity);
        }
        return new EstimationFactors(this.map.getUnique(), nRows, largestOffs, counts, 0, nRows, false, false, matrixSparsity, tupleSparsity);
    }

    public AMapToData getMap() {
        return this.map;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean equals(IEncode e) {
        return e instanceof DenseEncoding && ((DenseEncoding)e).map.equals(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        sb.append("mapping: ");
        sb.append(this.map);
        return sb.toString();
    }
}

