/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.lops.PickByCount;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.QuantilePickCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantilePickSPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class QuantilePickFEDInstruction
extends BinaryFEDInstruction {
    private final PickByCount.OperationTypes _type;

    public QuantilePickFEDInstruction(Operator op, CPOperand in, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        this(op, in, null, out, type, inmem, opcode, istr);
    }

    public QuantilePickFEDInstruction(Operator op, CPOperand in, CPOperand in2, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.QPick, op, in, in2, out, opcode, istr, fedOut);
        this._type = type;
    }

    public QuantilePickFEDInstruction(Operator op, CPOperand in, CPOperand in2, CPOperand out, PickByCount.OperationTypes type, boolean inmem, String opcode, String istr) {
        this(op, in, in2, out, type, inmem, opcode, istr, FEDInstruction.FederatedOutput.NONE);
    }

    public static QuantilePickFEDInstruction parseInstruction(QuantilePickCPInstruction instr) {
        return new QuantilePickFEDInstruction(instr.getOperator(), instr.input1, instr.input2, instr.output, instr.getOperationType(), instr.isInMem(), instr.getOpcode(), instr.getInstructionString());
    }

    public static QuantilePickFEDInstruction parseInstruction(QuantilePickSPInstruction instr) {
        return new QuantilePickFEDInstruction(instr.getOperator(), instr.input1, instr.input2, instr.output, instr.getOperationType(), false, instr.getOpcode(), instr.getInstructionString());
    }

    public static QuantilePickFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("qpick")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a QuantilePickCPInstruction: " + str);
        }
        FEDInstruction.FederatedOutput fedOut = FEDInstruction.FederatedOutput.valueOf(parts[parts.length - 1]);
        QuantilePickFEDInstruction inst = null;
        if (parts.length == 5) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.IQM;
            boolean inmem = false;
            inst = new QuantilePickFEDInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        } else if (parts.length == 6) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand out = new CPOperand(parts[2]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[3]);
            boolean inmem = Boolean.parseBoolean(parts[4]);
            inst = new QuantilePickFEDInstruction(null, in1, out, ptype, inmem, opcode, str);
        } else if (parts.length == 7) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            PickByCount.OperationTypes ptype = PickByCount.OperationTypes.valueOf(parts[4]);
            boolean inmem = Boolean.parseBoolean(parts[5]);
            inst = new QuantilePickFEDInstruction(null, in1, in2, out, ptype, inmem, opcode, str);
        }
        if (inst != null) {
            inst._fedOut = fedOut;
        }
        return inst;
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (ec.getMatrixObject(this.input1).isFederated(FTypes.FType.COL) || ec.getMatrixObject(this.input1).isFederated(FTypes.FType.FULL)) {
            this.processColumnQPick(ec);
        } else {
            this.processRowQPick(ec);
        }
    }

    public <T> MatrixBlock getEquiHeightBins(ExecutionContext ec, int colID, double[] quantiles) {
        FrameObject inFrame = ec.getFrameObject(this.input1);
        FederationMap frameFedMap = inFrame.getFedMapping();
        MatrixObject in = ExecutionContext.createMatrixObject(new MatrixBlock((int)inFrame.getNumRows(), 1, false));
        long varID = FederationUtils.getNextFedDataID();
        ec.setVariable(String.valueOf(varID), in);
        ArrayList ranges = new ArrayList();
        FederationMap oldFedMap = frameFedMap.mapParallel(varID, (range, data) -> {
            block7: {
                try {
                    int colIDWorker = colID;
                    if ((long)colID < range.getBeginDims()[1] || (long)colID >= range.getEndDims()[1]) break block7;
                    if (range.getBeginDims()[1] > 1L) {
                        colIDWorker = colID - (int)range.getBeginDims()[1];
                    }
                    FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new CreateMatrixFromFrame(data.getVarID(), varID, colIDWorker))).get();
                    List list = ranges;
                    synchronized (list) {
                        ranges.add(range);
                    }
                    if (!response.isSuccessful()) {
                        response.throwExceptionFromResponse();
                    }
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
            }
            return null;
        });
        ArrayList<Pair<FederatedRange, FederatedData>> newFedMapPairs = new ArrayList<Pair<FederatedRange, FederatedData>>();
        for (Pair<FederatedRange, FederatedData> mapPair : oldFedMap.getMap()) {
            for (FederatedRange r : ranges) {
                if (!((FederatedRange)mapPair.getLeft()).equals(r)) continue;
                newFedMapPairs.add(mapPair);
            }
        }
        FederationMap newFedMap = new FederationMap(varID, newFedMapPairs, FTypes.FType.COL);
        in.getDataCharacteristics().setDimension(in.getNumRows(), 1L);
        in.setFedMapping(newFedMap);
        ArrayList minMax = new ArrayList();
        newFedMap.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new MinMax(data.getVarID()))).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                double[] rangeMinMax = (double[])response.getData()[0];
                minMax.add(rangeMinMax);
                return null;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        });
        double globalMin = Double.MAX_VALUE;
        double globalMax = Double.MIN_VALUE;
        double vectorLength = inFrame.getNumColumns() == 2L ? 0.0 : (double)inFrame.getNumRows();
        for (double[] values : minMax) {
            globalMin = Math.min(globalMin, values[0]);
            globalMax = Math.max(globalMax, values[1]);
        }
        int numBuckets = 256;
        T ret = this.createHistogram(in, (int)vectorLength, globalMin, globalMax, numBuckets, -1, false);
        MatrixBlock quantileValues = this.computeMultipleQuantiles(ec, in, (int[])ret, quantiles, (int)vectorLength, varID, (globalMax - globalMin) / (double)numBuckets, globalMin, this._type, true);
        ec.removeVariable(String.valueOf(varID));
        MatrixBlock res = new MatrixBlock(quantileValues.getNumRows() + 1, 1, false);
        res.setValue(0, 0, globalMin);
        res.copy(1, quantileValues.getNumRows(), 0, 0, quantileValues, false);
        return res;
    }

    public <T> void processRowQPick(ExecutionContext ec) {
        double[] quantiles;
        double[] dArray;
        boolean average;
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap fedMap = in.getFedMapping();
        boolean bl = average = this._type == PickByCount.OperationTypes.MEDIAN;
        if (this.input2 != null) {
            if (this.input2.isMatrix()) {
                dArray = ec.getMatrixInput(this.input2).getDenseBlockValues();
            } else if (this.input2.isScalar()) {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = ec.getScalarInput(this.input2).getDoubleValue();
            } else {
                dArray = null;
            }
        } else if (average) {
            double[] dArray3 = new double[1];
            dArray = dArray3;
            dArray3[0] = 0.5;
        } else if (this._type == PickByCount.OperationTypes.IQM) {
            double[] dArray4 = new double[2];
            dArray4[0] = 0.25;
            dArray = dArray4;
            dArray4[1] = 0.75;
        } else {
            dArray = quantiles = null;
        }
        if (this.input2 != null && this.input2.isMatrix()) {
            ec.releaseMatrixInput(this.input2.getName());
        }
        long varID = FederationUtils.getNextFedDataID();
        ArrayList minMax = new ArrayList();
        fedMap.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new MinMax(data.getVarID()))).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                double[] rangeMinMax = (double[])response.getData()[0];
                minMax.add(rangeMinMax);
                return null;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        });
        double globalMin = Double.MAX_VALUE;
        double globalMax = Double.MIN_VALUE;
        double vectorLength = in.getNumColumns() == 2L ? 0.0 : (double)in.getNumRows();
        double sumWeights = 0.0;
        for (double[] values : minMax) {
            globalMin = Math.min(globalMin, values[0]);
            globalMax = Math.max(globalMax, values[1]);
            if (in.getNumColumns() == 2L) {
                vectorLength += values[2];
            }
            sumWeights += values[3];
        }
        average = average && (in.getNumColumns() == 2L ? sumWeights : (double)in.getNumRows()) % 2.0 == 0.0;
        int numBuckets = 256;
        int quantileIndex = quantiles != null && quantiles.length == 1 ? (int)Math.round(vectorLength * quantiles[0]) : -1;
        T ret = this.createHistogram(in, (int)vectorLength, globalMin, globalMax, numBuckets, quantileIndex, average);
        if (quantiles != null && quantiles.length > 1) {
            double finalVectorLength = vectorLength;
            quantiles = Arrays.stream(quantiles).map(val -> (int)Math.round(finalVectorLength * val)).toArray();
            this.computeMultipleQuantiles(ec, in, (int[])ret, quantiles, (int)vectorLength, varID, (globalMax - globalMin) / (double)numBuckets, globalMin, this._type, false);
        } else {
            this.getSingleQuantileResult(ret, ec, fedMap, varID, average, false, (int)vectorLength, null);
        }
    }

    private <T> MatrixBlock computeMultipleQuantiles(ExecutionContext ec, MatrixObject in, int[] bucketsFrequencies, double[] quantiles, int vectorLength, long varID, double bucketRange, double min, PickByCount.OperationTypes type, boolean returnOutput) {
        MatrixBlock out = new MatrixBlock(quantiles.length, 1, false);
        ImmutableTriple[] bucketsWithIndex = new ImmutableTriple[quantiles.length];
        int sizeBeforeTmp = 0;
        int sizeBefore = 0;
        int countFoundBins = 0;
        for (int j = 0; j < bucketsFrequencies.length; ++j) {
            sizeBeforeTmp += bucketsFrequencies[j];
            for (int i = 0; i < quantiles.length; ++i) {
                if (!(quantiles[i] > (double)sizeBefore) || !(quantiles[i] <= (double)sizeBeforeTmp)) continue;
                ImmutablePair bucketWithQ = new ImmutablePair((Object)(min + (double)j * bucketRange), (Object)(min + (double)(j + 1) * bucketRange));
                bucketsWithIndex[i] = new ImmutableTriple((Object)(quantiles[i] == 1.0 ? 1 : (int)quantiles[i] - sizeBefore), (Object)bucketsFrequencies[j], (Object)bucketWithQ);
                ++countFoundBins;
            }
            sizeBefore = sizeBeforeTmp;
            if (countFoundBins == quantiles.length) break;
        }
        HashMap retBuckets = new HashMap();
        double q25Left = 0.0;
        double q25Right = 0.0;
        double q75Left = 0.0;
        double q75Right = 0.0;
        for (int i = 0; i < bucketsWithIndex.length; ++i) {
            int nextNumBuckets = (Integer)bucketsWithIndex[i].middle < 100 ? (Integer)bucketsWithIndex[i].middle * 2 : (int)Math.round((double)((Integer)bucketsWithIndex[i].middle).intValue() / 2.0);
            T hist = this.createHistogram(in, vectorLength, (Double)((ImmutablePair)bucketsWithIndex[i].right).left, (Double)((ImmutablePair)bucketsWithIndex[i].right).right, nextNumBuckets, (Integer)bucketsWithIndex[i].left, false);
            if (this._type == PickByCount.OperationTypes.IQM) {
                double d = i == 0 ? (hist instanceof ImmutablePair ? (Double)((ImmutablePair)hist).right : (Double)hist) : (q25Right = q25Right);
                double d2 = i == 0 ? (hist instanceof ImmutablePair ? (Double)((ImmutablePair)hist).left : (Double)hist) : (q25Left = q25Left);
                double d3 = i == 1 ? (hist instanceof ImmutablePair ? (Double)((ImmutablePair)hist).right : (Double)hist) : (q75Right = q75Right);
                q75Left = i == 1 ? (hist instanceof ImmutablePair ? (Double)((ImmutablePair)hist).left : (Double)hist) : q75Left;
                continue;
            }
            if (hist instanceof ImmutablePair) {
                retBuckets.put(i, hist);
                continue;
            }
            out.setValue(i, 0, (Double)hist);
        }
        if (type == PickByCount.OperationTypes.IQM) {
            ImmutablePair IQMRange = new ImmutablePair((Object)q25Right, (Object)q75Right);
            if (q25Right == q75Right) {
                ec.setScalarOutput(this.output.getName(), new DoubleObject(q25Left));
            } else {
                this.getSingleQuantileResult(IQMRange, ec, in.getFedMapping(), varID, false, true, vectorLength, (ImmutablePair<Double, Double>)new ImmutablePair((Object)q25Left, (Object)q75Left));
            }
        } else {
            if (!retBuckets.isEmpty()) {
                in.getFedMapping().mapParallel(varID, (range, data) -> {
                    try {
                        FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetValuesInRanges(data.getVarID(), quantiles.length, retBuckets))).get();
                        if (!response.isSuccessful()) {
                            response.throwExceptionFromResponse();
                        }
                        MatrixBlock tmp = (MatrixBlock)response.getData()[0];
                        MatrixBlock matrixBlock = out;
                        synchronized (matrixBlock) {
                            out.binaryOperationsInPlace(InstructionUtils.parseBinaryOperator("+"), tmp);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        throw new DMLRuntimeException(e);
                    }
                });
            }
            if (returnOutput) {
                return out;
            }
            ec.setMatrixOutput(this.output.getName(), out);
        }
        return null;
    }

    private <T> void getSingleQuantileResult(T ret, ExecutionContext ec, FederationMap fedMap, long varID, boolean average, boolean isIQM, int vectorLength, ImmutablePair<Double, Double> iqmRange) {
        double result = 0.0;
        double q25Part = 0.0;
        double q25Val = 0.0;
        double q75Val = 0.0;
        double q75Part = 0.0;
        if (ret instanceof ImmutablePair) {
            ArrayList values = new ArrayList();
            ArrayList iqmValues = new ArrayList();
            fedMap.mapParallel(varID, (range, data) -> {
                try {
                    FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetValuesInRange(data.getVarID(), (ImmutablePair<Double, Double>)((ImmutablePair)ret), isIQM, iqmRange))).get();
                    if (!response.isSuccessful()) {
                        response.throwExceptionFromResponse();
                    }
                    if (isIQM) {
                        iqmValues.add((double[])response.getData()[0]);
                    } else {
                        values.add(Double.valueOf((Double)response.getData()[0]));
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new DMLRuntimeException(e);
                }
            });
            if (isIQM) {
                for (double[] vals : iqmValues) {
                    result += vals[0];
                    q25Part += vals[1];
                    q25Val += vals[2];
                    q75Part += vals[3];
                    q75Val += vals[4];
                }
                q25Part -= 0.25 * (double)vectorLength;
                q75Part -= 0.75 * (double)vectorLength;
            } else {
                result = values.stream().reduce(0.0, Double::sum);
            }
        } else {
            result = (Double)ret;
        }
        result = average ? result / 2.0 : (isIQM ? (result + q25Part * q25Val - q75Part * q75Val) / ((double)vectorLength * 0.5) : result);
        ec.setScalarOutput(this.output.getName(), new DoubleObject(result));
    }

    public <T> T createHistogram(CacheableData<?> in, int vectorLength, double globalMin, double globalMax, int numBuckets, int quantileIndex, boolean average) {
        int nextNumBuckets;
        HashSet distinctsSet;
        FederationMap fedMap = in.getFedMapping();
        ArrayList hists = new ArrayList();
        ArrayList distincts = new ArrayList();
        double bucketRange = (globalMax - globalMin) / (double)numBuckets;
        boolean isEvenNumRows = vectorLength % 2 == 0;
        long varID = FederationUtils.getNextFedDataID();
        fedMap.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new GetHistogram(data.getVarID(), globalMin, globalMax, bucketRange, numBuckets))).get();
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                int[] rangeHist = (int[])response.getData()[0];
                hists.add(rangeHist);
                Set rangeDistinct = (Set)response.getData()[1];
                distincts.add(rangeDistinct);
                return null;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        });
        int[] bucketsFrequencies = new int[numBuckets];
        for (int[] hist : hists) {
            for (int i = 0; i < hist.length; ++i) {
                int n = i;
                bucketsFrequencies[n] = bucketsFrequencies[n] + hist[i];
            }
        }
        if (quantileIndex == -1) {
            return (T)bucketsFrequencies;
        }
        ImmutableTriple<Integer, Integer, ImmutablePair<Double, Double>> bucketWithIndex = this.getBucketWithIndex(bucketsFrequencies, globalMin, quantileIndex, average, isEvenNumRows, bucketRange);
        Set distinctValues = distincts.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (distinctValues.size() > quantileIndex - 1 && !average) {
            return (T)distinctValues.stream().sorted().toArray()[quantileIndex > 0 ? quantileIndex - 1 : 0];
        }
        if (average && distinctValues.size() > quantileIndex) {
            Double[] distinctsSorted = (Double[])distinctValues.stream().flatMap(Stream::of).sorted().toArray(Double[]::new);
            Double medianSum = Double.sum(distinctsSorted[quantileIndex - 1], distinctsSorted[quantileIndex]);
            return (T)medianSum;
        }
        if (average && distinctValues.size() == 2 || !average && distinctValues.size() == 1) {
            return (T)distinctValues.stream().reduce(0.0, Double::sum);
        }
        ImmutablePair finalBucketWithQ = (ImmutablePair)bucketWithIndex.right;
        List distinctInNewBucket = distinctValues.stream().filter(e -> e >= (Double)finalBucketWithQ.left && e <= (Double)finalBucketWithQ.right).collect(Collectors.toList());
        if (distinctInNewBucket.size() == 1 && !average || average && distinctInNewBucket.size() == 2) {
            return (T)distinctInNewBucket.stream().reduce(0.0, Double::sum);
        }
        if (!average && (distinctsSet = new HashSet(distinctInNewBucket)).size() == 1) {
            return (T)distinctsSet.toArray()[0];
        }
        if (distinctValues.size() == 1 || (Integer)bucketWithIndex.middle == 1 && !average || (Integer)bucketWithIndex.middle == 2 && isEvenNumRows && average || globalMin == globalMax) {
            return (T)bucketWithIndex.right;
        }
        int n = nextNumBuckets = (Integer)bucketWithIndex.middle < 100 ? (Integer)bucketWithIndex.middle * 2 : (int)Math.round((double)((Integer)bucketWithIndex.middle).intValue() / 2.0);
        if (numBuckets == nextNumBuckets && globalMin == (Double)((ImmutablePair)bucketWithIndex.right).left && globalMax == (Double)((ImmutablePair)bucketWithIndex.right).right) {
            nextNumBuckets *= 2;
        }
        return this.createHistogram(in, vectorLength, (Double)((ImmutablePair)bucketWithIndex.right).left, (Double)((ImmutablePair)bucketWithIndex.right).right, nextNumBuckets, (Integer)bucketWithIndex.left, average);
    }

    private ImmutableTriple<Integer, Integer, ImmutablePair<Double, Double>> getBucketWithIndex(int[] bucketFrequencies, double min, int quantileIndex, boolean average, boolean isEvenNumRows, double bucketRange) {
        int sizeBeforeTmp = 0;
        int sizeBefore = 0;
        int bucketWithQSize = 0;
        ImmutablePair bucketWithQ = null;
        double tmpBinLeft = min;
        for (int i = 0; i < bucketFrequencies.length; ++i) {
            int bucket2Size;
            if (quantileIndex <= (sizeBeforeTmp += bucketFrequencies[i]) && bucketWithQSize == 0) {
                bucketWithQ = new ImmutablePair((Object)tmpBinLeft, (Object)(tmpBinLeft + bucketRange));
                bucketWithQSize = bucketFrequencies[i];
                sizeBefore = sizeBeforeTmp -= bucketWithQSize;
                if (!average || sizeBefore + bucketWithQSize >= quantileIndex + 1) {
                    break;
                }
            } else if (quantileIndex + 1 <= sizeBeforeTmp + bucketWithQSize && isEvenNumRows && average && (bucket2Size = bucketFrequencies[i]) != 0) {
                bucketWithQ = new ImmutablePair((Object)((Double)bucketWithQ.left), (Object)(tmpBinLeft + bucketRange));
                bucketWithQSize += bucket2Size;
                break;
            }
            tmpBinLeft += bucketRange;
        }
        quantileIndex = quantileIndex == 1 ? 1 : quantileIndex - sizeBefore;
        return new ImmutableTriple((Object)quantileIndex, (Object)bucketWithQSize, bucketWithQ);
    }

    public void processColumnQPick(ExecutionContext ec) {
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap fedMapping = in.getFedMapping();
        ArrayList res = new ArrayList();
        long varID = FederationUtils.getNextFedDataID();
        fedMapping.mapParallel(varID, (range, data) -> {
            try {
                FederatedResponse response;
                switch (this._type) {
                    case VALUEPICK: {
                        if (this.input2.isScalar()) {
                            ScalarObject quantile = ec.getScalarInput(this.input2);
                            response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new ValuePick(data.getVarID(), quantile))).get();
                            break;
                        }
                        MatrixBlock quantiles = ec.getMatrixInput(this.input2.getName());
                        response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new ValuePick(data.getVarID(), quantiles))).get();
                        break;
                    }
                    case IQM: {
                        response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new ColIQM(data.getVarID()))).get();
                        break;
                    }
                    case MEDIAN: {
                        response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new ColMedian(data.getVarID()))).get();
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unsupported qpick operation type: " + this._type);
                    }
                }
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                res.add(response.getData()[0]);
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        assert (res.size() == 1);
        if (this.input2 != null && this.input2.isMatrix()) {
            ec.releaseMatrixInput(this.input2.getName());
        }
        if (this.output.isScalar()) {
            ec.setScalarOutput(this.output.getName(), new DoubleObject((Double)res.get(0)));
        } else {
            ec.setMatrixOutput(this.output.getName(), (MatrixBlock)res.get(0));
        }
    }

    private static class ColMedian
    extends FederatedUDF {
        private static final long serialVersionUID = -2808597461054603816L;

        protected ColMedian(long input) {
            super(new long[]{input});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{mb.median()});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class ColIQM
    extends FederatedUDF {
        private static final long serialVersionUID = 2223186699111957677L;

        protected ColIQM(long input) {
            super(new long[]{input});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{mb.interQuartileMean()});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    public static class GetValuesInRange
    extends FederatedUDF {
        private static final long serialVersionUID = 5413355823424777742L;
        private final ImmutablePair<Double, Double> _range;
        private final ImmutablePair<Double, Double> _iqmRange;
        private final boolean _sumInRange;

        private GetValuesInRange(long input, ImmutablePair<Double, Double> range, boolean sumInRange, ImmutablePair<Double, Double> iqmRange) {
            super(new long[]{input});
            this._range = range;
            this._sumInRange = sumInRange;
            this._iqmRange = iqmRange;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            Object object;
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            double[] values = mb.getDenseBlockValues();
            boolean isWeighted = mb.getNumColumns() == 2;
            double res = 0.0;
            int counter = 0;
            double q25Part = 0.0;
            double q25Val = 0.0;
            double q75Val = 0.0;
            double q75Part = 0.0;
            for (int i = 0; i < values.length - (isWeighted ? 1 : 0); i += isWeighted ? 2 : 1) {
                int weight;
                double val = values[i];
                int n = weight = isWeighted ? (int)values[i + 1] : 1;
                if (this._iqmRange != null && val <= (Double)this._iqmRange.left) {
                    q25Part += (double)weight;
                }
                if (this._iqmRange != null && val >= (Double)this._iqmRange.left && val <= (Double)this._range.left) {
                    q25Val = val;
                } else if (this._iqmRange != null && val <= (Double)this._iqmRange.right && val >= (Double)this._range.right) {
                    q75Val = val;
                }
                if (!this._sumInRange && (Double)this._range.left <= val && val <= (Double)this._range.right || this._sumInRange && (Double)this._range.left < val && val <= (Double)this._range.right) {
                    res += val * (double)(!this._sumInRange && weight > 1 ? 2 : weight);
                    counter += weight;
                }
                if (this._iqmRange != null && val <= (Double)this._range.right) {
                    q75Part += (double)weight;
                }
                if (!this._sumInRange && counter > 2) break;
            }
            if (!this._sumInRange) {
                object = res;
            } else {
                double[] dArray = new double[5];
                dArray[0] = res;
                dArray[1] = q25Part;
                dArray[2] = q25Val;
                dArray[3] = q75Part;
                object = dArray;
                dArray[4] = q75Val;
            }
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, object);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class ValuePick
    extends FederatedUDF {
        private static final long serialVersionUID = -2594912886841345102L;
        private final MatrixBlock _quantiles;

        protected ValuePick(long input, ScalarObject quantile) {
            super(new long[]{input});
            this._quantiles = new MatrixBlock(quantile.getDoubleValue());
        }

        protected ValuePick(long input, MatrixBlock quantiles) {
            super(new long[]{input});
            this._quantiles = quantiles;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            if (this._quantiles.getLength() == 1L) {
                return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{mb.pickValue(this._quantiles.getValue(0, 0))});
            }
            MatrixBlock picked = mb.pickValues(this._quantiles, new MatrixBlock());
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, new Object[]{picked});
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    public static class MinMax
    extends FederatedUDF {
        private static final long serialVersionUID = -3906698363866500744L;

        private MinMax(long input) {
            super(new long[]{input});
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            double[] ret = new double[]{mb.getNumColumns() == 2 ? mb.colMin().quickGetValue(0, 0) : mb.min(), mb.getNumColumns() == 2 ? mb.colMax().quickGetValue(0, 0) : mb.max(), mb.getNumColumns() == 2 ? mb.colSum().quickGetValue(0, 1) : 0.0, mb.getNumColumns() == 2 ? mb.sumWeightForQuantile() : 0.0};
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, (Object)ret);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    public static class GetValuesInRanges
    extends FederatedUDF {
        private static final long serialVersionUID = 8663298932616139153L;
        private final int _numQuantiles;
        private final HashMap<Integer, ImmutablePair<Double, Double>> _ranges;

        private GetValuesInRanges(long input, int numQuantiles, HashMap<Integer, ImmutablePair<Double, Double>> ranges) {
            super(new long[]{input});
            this._ranges = ranges;
            this._numQuantiles = numQuantiles;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            double[] values = mb.getDenseBlockValues();
            MatrixBlock res = new MatrixBlock(this._numQuantiles, 1, false);
            block0: for (double val : values) {
                for (Map.Entry<Integer, ImmutablePair<Double, Double>> entry : this._ranges.entrySet()) {
                    if (!((Double)entry.getValue().left <= val) || !(val <= (Double)entry.getValue().right)) continue;
                    res.setValue(entry.getKey(), 0, val);
                    continue block0;
                }
            }
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, res);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    public static class GetHistogram
    extends FederatedUDF {
        private static final long serialVersionUID = 5413355823424777742L;
        private final double _max;
        private final double _min;
        private final double _range;
        private final int _numBuckets;

        private GetHistogram(long input, double min, double max, double range, int numBuckets) {
            super(new long[]{input});
            this._max = max;
            this._min = min;
            this._range = range;
            this._numBuckets = numBuckets;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            double[] values = mb.getDenseBlockValues();
            boolean isWeighted = mb.getNumColumns() == 2;
            HashSet<Double> distinct = new HashSet<Double>();
            int[] frequencies = new int[this._numBuckets];
            for (int i = 0; i < values.length - (isWeighted ? 1 : 0); i += isWeighted ? 2 : 1) {
                double val = values[i];
                int weight = isWeighted ? (int)values[i + 1] : 1;
                int index = (int)Math.ceil((val - this._min) / this._range);
                int n = index = index == 0 ? 0 : index - 1;
                if (!(val >= this._min) || !(val <= this._max)) continue;
                int n2 = index;
                frequencies[n2] = frequencies[n2] + weight;
                distinct.add(val);
            }
            Object[] ret = new Object[]{frequencies, distinct.size() < 3 ? distinct : new HashSet<Double>()};
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, ret);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    public static class CreateMatrixFromFrame
    extends FederatedUDF {
        private static final long serialVersionUID = -6569370318237863595L;
        private final long _outputID;
        private final int _id;

        public CreateMatrixFromFrame(long input, long output, int id) {
            super(new long[]{input});
            this._outputID = output;
            this._id = id;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            FrameBlock fb = (FrameBlock)((FrameObject)data[0]).acquireReadAndRelease();
            double[] colData = ArrayUtils.toPrimitive((Double[])((Double[])Arrays.stream((Object[])fb.getColumnData(this._id)).map(e -> Double.valueOf(String.valueOf(e))).toArray(Double[]::new)));
            MatrixBlock mbout = new MatrixBlock(fb.getNumRows(), 1, colData);
            MatrixObject mo = ExecutionContext.createMatrixObject(mbout);
            ec.setVariable(String.valueOf(this._outputID), mo);
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

