/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.FrameWriterBinaryBlock;
import org.apache.sysds.runtime.io.FrameWriterBinaryBlockParallel;
import org.apache.sysds.runtime.io.FrameWriterCompressed;
import org.apache.sysds.runtime.io.FrameWriterProto;
import org.apache.sysds.runtime.io.FrameWriterTextCSV;
import org.apache.sysds.runtime.io.FrameWriterTextCSVParallel;
import org.apache.sysds.runtime.io.FrameWriterTextCell;
import org.apache.sysds.runtime.io.FrameWriterTextCellParallel;

public class FrameWriterFactory {
    protected static final Log LOG = LogFactory.getLog((String)FrameWriterFactory.class.getName());

    public static FrameWriter createFrameWriter(Types.FileFormat fmt) {
        return FrameWriterFactory.createFrameWriter(fmt, null);
    }

    public static FrameWriter createFrameWriter(Types.FileFormat fmt, FileFormatProperties props) {
        boolean textParallel = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS);
        boolean binaryParallel = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS);
        switch (fmt) {
            case TEXT: {
                return textParallel ? new FrameWriterTextCellParallel() : new FrameWriterTextCell();
            }
            case CSV: {
                if (props != null && !(props instanceof FileFormatPropertiesCSV)) {
                    throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
                }
                FileFormatPropertiesCSV fp = (FileFormatPropertiesCSV)props;
                return textParallel ? new FrameWriterTextCSVParallel(fp) : new FrameWriterTextCSV(fp);
            }
            case COMPRESSED: {
                return new FrameWriterCompressed(binaryParallel);
            }
            case BINARY: {
                return binaryParallel ? new FrameWriterBinaryBlockParallel() : new FrameWriterBinaryBlock();
            }
            case PROTO: {
                return new FrameWriterProto();
            }
        }
        throw new DMLRuntimeException("Failed to create frame writer for unknown format: " + fmt.toString());
    }
}

