/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CollectionUtils {
    @SafeVarargs
    public static <T> List<T> asList(List<T> ... inputs) {
        ArrayList<T> ret = new ArrayList<T>();
        for (List<T> list : inputs) {
            ret.addAll(list);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> ArrayList<T> asArrayList(T ... inputs) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T list : inputs) {
            ret.add(list);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        for (T element : inputs) {
            ret.add(element);
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T[] ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        T[][] TArray = inputs;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] input;
            for (T element : input = TArray[i]) {
                ret.add(element);
            }
        }
        return ret;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(List<T> ... inputs) {
        HashSet<T> ret = new HashSet<T>();
        for (List<T> list : inputs) {
            ret.addAll(list);
        }
        return ret;
    }

    public static <T> Stream<T> getStream(Iterator<T> iter) {
        Iterable iterable = () -> iter;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> boolean equals(List<T> a, List<T> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.size() != b.size()) {
            return false;
        }
        ListIterator<T> iter1 = a.listIterator();
        ListIterator<T> iter2 = b.listIterator();
        while (iter1.hasNext()) {
            if (iter1.next().equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsAny(Collection<T> a, Collection<T> b) {
        Collection<T> tmp1 = a.size() < b.size() ? a : b;
        Set<Object> probe = tmp1 instanceof HashSet ? (Set<Object>)tmp1 : new HashSet<T>(tmp1);
        Collection<T> tmp2 = a.size() < b.size() ? b : a;
        for (T item : tmp2) {
            if (!probe.contains(item)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean intersect(Collection<T> ... inputs) {
        Collection[] nonEmpty = (Collection[])Arrays.stream(inputs).filter(l -> !l.isEmpty()).toArray(Collection[]::new);
        if (nonEmpty.length == 0) {
            return false;
        }
        Arrays.sort(nonEmpty, Comparator.comparingInt(Collection::size));
        Set<T> probe = nonEmpty[0] instanceof HashSet ? (Set)nonEmpty[0] : new HashSet(nonEmpty[0]);
        for (int i = 1; i < nonEmpty.length; ++i) {
            for (Object item : nonEmpty[i]) {
                if (!probe.contains(item)) continue;
                return true;
            }
            probe.addAll(inputs[i]);
        }
        return false;
    }

    public static <T> List<T> unionDistinct(List<T> a, List<T> b) {
        ArrayList ret = new ArrayList();
        HashSet probe = new HashSet();
        for (List list : new List[]{a, b}) {
            for (Object item : list) {
                if (probe.contains(item)) continue;
                ret.add(item);
                probe.add(item);
            }
        }
        return ret;
    }

    public static <T> List<T> unionAll(List<T> a, List<T> b) {
        return CollectionUtils.asList(a, b);
    }

    public static <T> List<T> except(List<T> a, List<T> exceptions) {
        ArrayList<T> ret = new ArrayList<T>();
        HashSet<T> probe = new HashSet<T>(exceptions);
        for (T item : a) {
            if (probe.contains(item)) continue;
            ret.add(item);
        }
        return ret;
    }

    public static <T> void addAll(Collection<T> a, T[] b) {
        for (T item : b) {
            a.add(item);
        }
    }

    public static <T> int cardinality(T a, List<T> b) {
        int count = 0;
        for (T item : b) {
            count += a.equals(item) ? 1 : 0;
        }
        return count;
    }
}

