/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.Arrays;
import java.util.List;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysds.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysds.parser.StatementBlock;

public class RewriteRemoveTransformEncodeMeta
extends StatementBlockRewriteRule {
    private static final String TF_OPCODE = "TRANSFORMENCODE";

    @Override
    public List<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus state) {
        if (sb.getHops() == null || sb.getHops().isEmpty()) {
            return Arrays.asList(sb);
        }
        Hop root = sb.getHops().get(0);
        if (root instanceof FunctionOp && TF_OPCODE.equals(((FunctionOp)root).getFunctionName())) {
            FunctionOp func = (FunctionOp)root;
            if (!sb.liveOut().containsVariable(func.getOutputVariableNames()[1]) && func.getInput().size() == 2) {
                func.getInput().add(new LiteralOp(false));
                LOG.debug((Object)("Applied removeTransformEncodeMeta (line " + func.getBeginLine() + ")."));
            }
        }
        return Arrays.asList(sb);
    }

    @Override
    public List<StatementBlock> rewriteStatementBlocks(List<StatementBlock> sbs, ProgramRewriteStatus sate) {
        return sbs;
    }

    @Override
    public boolean createsSplitDag() {
        return false;
    }
}

