/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;

public class RewriteRemoveReadAfterWrite
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        HashMap<String, Hop> reads = new HashMap<String, Hop>();
        HashMap<String, Hop> writes = new HashMap<String, Hop>();
        for (Hop hop : roots) {
            this.collectPersistentReadWriteOps(hop, writes, reads);
        }
        Hop.resetVisitStatus(roots);
        for (Map.Entry entry : reads.entrySet()) {
            String rfname = (String)entry.getKey();
            Hop rhop = (Hop)entry.getValue();
            if (!writes.containsKey(rfname) || writes.get(rfname).getBeginLine() >= rhop.getBeginLine() && writes.get(rfname).getEndLine() >= rhop.getEndLine()) continue;
            Hop input = writes.get(rfname).getInput().get(0);
            ArrayList<Hop> parents = new ArrayList<Hop>(rhop.getParent());
            for (Hop p : parents) {
                HopRewriteUtils.replaceChildReference(p, rhop, input);
            }
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        return root;
    }

    private void collectPersistentReadWriteOps(Hop hop, HashMap<String, Hop> pWrites, HashMap<String, Hop> pReads) {
        if (hop.isVisited()) {
            return;
        }
        if (!hop.getInput().isEmpty()) {
            for (Hop c : hop.getInput()) {
                this.collectPersistentReadWriteOps(c, pWrites, pReads);
            }
        }
        if (hop instanceof DataOp) {
            Hop fname;
            DataOp dop = (DataOp)hop;
            if (dop.getOp() == Types.OpOpData.PERSISTENTREAD) {
                pReads.put(dop.getFileName(), dop);
            } else if (dop.getOp() == Types.OpOpData.PERSISTENTWRITE && (fname = dop.getInput().get(dop.getParameterIndex("iofilename"))) instanceof LiteralOp) {
                pWrites.put(((LiteralOp)fname).getStringValue(), dop);
            }
        }
        hop.setVisited();
    }
}

