/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.dp;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysds.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import scala.Tuple2;

public abstract class DataPartitionSparkScheme
implements Serializable {
    private static final long serialVersionUID = -3462829818083371171L;
    protected List<PartitionedBroadcast<MatrixBlock>> _globalPerms;
    protected PartitionedBroadcast<MatrixBlock> _workerIndicator;

    protected void setGlobalPermutation(List<PartitionedBroadcast<MatrixBlock>> gps) {
        this._globalPerms = gps;
    }

    protected void setWorkerIndicator(PartitionedBroadcast<MatrixBlock> wi) {
        this._workerIndicator = wi;
    }

    protected List<Tuple2<Integer, Tuple2<Long, MatrixBlock>>> nonShuffledPartition(int rblkID, MatrixBlock mb) {
        MatrixBlock indicator = this._workerIndicator.getBlock(rblkID, 1);
        return LongStream.range(0L, mb.getNumRows()).mapToObj(r -> {
            int workerID = (int)indicator.get((int)r, 0);
            MatrixBlock rowMB = ParamservUtils.sliceMatrixBlock(mb, r + 1L, r + 1L);
            long shiftedPosition = r + (long)((rblkID - 1) * 1000);
            return new Tuple2((Object)workerID, (Object)new Tuple2((Object)shiftedPosition, (Object)rowMB));
        }).collect(Collectors.toList());
    }

    public abstract Result doPartitioning(int var1, int var2, MatrixBlock var3, MatrixBlock var4);

    protected final class Result {
        protected final List<Tuple2<Integer, Tuple2<Long, MatrixBlock>>> pFeatures;
        protected final List<Tuple2<Integer, Tuple2<Long, MatrixBlock>>> pLabels;

        protected Result(List<Tuple2<Integer, Tuple2<Long, MatrixBlock>>> pFeatures, List<Tuple2<Integer, Tuple2<Long, MatrixBlock>>> pLabels) {
            this.pFeatures = pFeatures;
            this.pLabels = pLabels;
        }
    }
}

