/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5.message;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RootObject;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.Utils;
import org.apache.sysds.runtime.io.hdf5.message.H5DataLayoutMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5DataSpaceMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5DataTypeMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5FillValueMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5NilMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5ObjectModificationTimeMessage;
import org.apache.sysds.runtime.io.hdf5.message.H5SymbolTableMessage;

public abstract class H5Message {
    private final BitSet flags;
    protected H5RootObject rootObject;

    public H5Message(H5RootObject rootObject, BitSet flags) {
        this.rootObject = rootObject;
        this.flags = flags;
    }

    public static H5Message readObjectHeaderMessage(H5RootObject rootObject, ByteBuffer bb) {
        Utils.seekBufferToNextMultipleOfEight(bb);
        int messageType = Utils.readBytesAsUnsignedInt(bb, 2);
        int dataSize = Utils.readBytesAsUnsignedInt(bb, 2);
        BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
        bb.position(bb.position() + 3);
        ByteBuffer headerData = Utils.createSubBuffer(bb, dataSize);
        H5Message message = H5Message.readMessage(rootObject, headerData, messageType, flags);
        return message;
    }

    protected H5BufferBuilder toBuffer() {
        H5BufferBuilder bb = new H5BufferBuilder();
        this.toBuffer(bb);
        return bb;
    }

    protected void toBuffer(H5BufferBuilder bb) {
        throw new H5RuntimeException("Unimplemented method!");
    }

    protected void toBuffer(H5BufferBuilder bb, int messageType) {
        bb.writeShort((short)messageType);
        byte[] reserved = new byte[]{0, 0, 0};
        switch (messageType) {
            case 0: {
                bb.writeShort((short)104);
                break;
            }
            case 1: {
                bb.writeShort((short)40);
                break;
            }
            case 3: {
                bb.writeShort((short)24);
                break;
            }
            case 5: {
                bb.writeShort((short)8);
                break;
            }
            case 17: {
                bb.writeShort((short)16);
                break;
            }
            case 18: {
                bb.writeShort((short)8);
                break;
            }
            case 8: {
                bb.writeShort((short)24);
                break;
            }
            default: {
                throw new H5RuntimeException("Unrecognized message type = " + messageType);
            }
        }
        if (this.flags.length() != 0) {
            bb.writeBitSet(this.flags, this.flags.length());
        } else {
            bb.writeByte(0);
        }
        bb.writeBytes(reserved);
    }

    private static H5Message readMessage(H5RootObject rootObject, ByteBuffer bb, int messageType, BitSet flags) {
        switch (messageType) {
            case 0: {
                return new H5NilMessage(rootObject, flags, bb);
            }
            case 1: {
                return new H5DataSpaceMessage(rootObject, flags, bb);
            }
            case 3: {
                return new H5DataTypeMessage(rootObject, flags, bb);
            }
            case 5: {
                return new H5FillValueMessage(rootObject, flags, bb);
            }
            case 8: {
                return new H5DataLayoutMessage(rootObject, flags, bb);
            }
            case 17: {
                return new H5SymbolTableMessage(rootObject, flags, bb);
            }
            case 18: {
                return new H5ObjectModificationTimeMessage(rootObject, flags, bb);
            }
        }
        throw new H5RuntimeException("Unrecognized message type = " + messageType);
    }
}

