/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.parser.BinaryExpression;
import org.apache.sysds.parser.BooleanIdentifier;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.IndexedIdentifier;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.ParameterExpression;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.StringIdentifier;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.parser.dml.CustomErrorListener;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.FileFormatPropertiesMM;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.meta.MetaDataAll;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class DataExpression
extends DataIdentifier {
    private static final Log LOG = LogFactory.getLog((String)DataExpression.class.getName());
    public static final String RAND_DIMS = "dims";
    public static final String RAND_ROWS = "rows";
    public static final String RAND_COLS = "cols";
    public static final String RAND_MIN = "min";
    public static final String RAND_MAX = "max";
    public static final String RAND_SPARSITY = "sparsity";
    public static final String RAND_SEED = "seed";
    public static final String RAND_PDF = "pdf";
    public static final String RAND_LAMBDA = "lambda";
    public static final String RAND_PDF_UNIFORM = "uniform";
    public static final String RAND_BY_ROW = "byrow";
    public static final String RAND_DIMNAMES = "dimnames";
    public static final String RAND_DATA = "data";
    public static final String IO_FILENAME = "iofilename";
    public static final String READROWPARAM = "rows";
    public static final String READCOLPARAM = "cols";
    public static final String READNNZPARAM = "nnz";
    public static final String SQL_CONN = "conn";
    public static final String SQL_USER = "user";
    public static final String SQL_PASS = "password";
    public static final String SQL_QUERY = "query";
    public static final String FED_ADDRESSES = "addresses";
    public static final String FED_RANGES = "ranges";
    public static final String FED_TYPE = "type";
    public static final String FED_LOCAL_OBJECT = "local_matrix";
    public static final String FORMAT_TYPE = "format";
    public static final String ROWBLOCKCOUNTPARAM = "rows_in_block";
    public static final String COLUMNBLOCKCOUNTPARAM = "cols_in_block";
    public static final String DATATYPEPARAM = "data_type";
    public static final String VALUETYPEPARAM = "value_type";
    public static final String DESCRIPTIONPARAM = "description";
    public static final String AUTHORPARAM = "author";
    public static final String SCHEMAPARAM = "schema";
    public static final String CREATEDPARAM = "created";
    public static final String PRIVACY = "privacy";
    public static final String FINE_GRAINED_PRIVACY = "fine_grained_privacy";
    public static final String DELIM_DELIMITER = "sep";
    public static final String DELIM_HAS_HEADER_ROW = "header";
    public static final String DELIM_FILL = "fill";
    public static final String DELIM_FILL_VALUE = "default";
    public static final String DELIM_NA_STRINGS = "naStrings";
    public static final String DELIM_NA_STRING_SEP = "\u00b7";
    public static final String LIBSVM_INDEX_DELIM = "indSep";
    public static final String HDF5_DATASET_NAME = "dataset";
    public static final String DELIM_SPARSE = "sparse";
    public static final Set<String> RAND_VALID_PARAM_NAMES = new HashSet<String>(Arrays.asList("rows", "cols", "dims", "min", "max", "sparsity", "seed", "pdf", "lambda"));
    public static final Set<String> RESHAPE_VALID_PARAM_NAMES = new HashSet<String>(Arrays.asList("byrow", "dimnames", "data", "rows", "cols", "dims"));
    public static final Set<String> FRAME_VALID_PARAM_NAMES = new HashSet<String>(Arrays.asList("schema", "data", "rows", "cols"));
    public static final Set<String> SQL_VALID_PARAM_NAMES = new HashSet<String>(Arrays.asList("conn", "user", "password", "query"));
    public static final Set<String> FEDERATED_VALID_PARAM_NAMES = new HashSet<String>(Arrays.asList("addresses", "ranges", "type", "local_matrix"));
    public static final Set<String> READ_VALID_MTD_PARAM_NAMES = new HashSet<String>(Arrays.asList("iofilename", "rows", "cols", "nnz", "format", "rows_in_block", "cols_in_block", "data_type", "value_type", "schema", "description", "author", "created", "default", "sep", "fill", "header", "naStrings", "indSep", "dataset", "privacy", "fine_grained_privacy"));
    public static final Set<String> READ_VALID_PARAM_NAMES = new HashSet<String>(Arrays.asList("iofilename", "rows", "cols", "format", "data_type", "value_type", "schema", "rows_in_block", "cols_in_block", "nnz", "default", "sep", "fill", "header", "naStrings", "indSep", "dataset"));
    public static final String DEFAULT_DELIM_DELIMITER = ",";
    public static final boolean DEFAULT_DELIM_HAS_HEADER_ROW = false;
    public static final boolean DEFAULT_DELIM_FILL = true;
    public static final double DEFAULT_DELIM_FILL_VALUE = 0.0;
    public static final boolean DEFAULT_DELIM_SPARSE = false;
    public static final String DEFAULT_NA_STRINGS = "";
    public static final String DEFAULT_SCHEMAPARAM = "NULL";
    public static final String DEFAULT_LIBSVM_INDEX_DELIM = ":";
    private static Map<String, Object> csvDefaults = new HashMap<String, Object>();
    private Expression.DataOp _opcode;
    private HashMap<String, Expression> _varParams;
    private boolean _strInit = false;
    private boolean _checkMetadata = true;

    public DataExpression() {
    }

    public void setCheckMetadata(boolean checkMetadata) {
        this._checkMetadata = checkMetadata;
    }

    public static DataExpression getDataExpression(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> passedParamExprs, String filename, CustomErrorListener errorListener) {
        ParseInfo pi = ParseInfo.ctxAndFilenameToParseInfo(ctx, filename);
        return DataExpression.getDataExpression(functionName, passedParamExprs, pi, errorListener);
    }

    public static DataExpression getDataExpression(String functionName, ArrayList<ParameterExpression> passedParamExprs, ParseInfo parseInfo, CustomErrorListener errorListener) {
        if (functionName == null || passedParamExprs == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getDataExpression: " + functionName + " " + passedParamExprs + " " + parseInfo + " " + errorListener));
        }
        DataExpression dataExpr = null;
        if (functionName.equals("read") || functionName.equals("readMM") || functionName.equals("read.csv")) {
            dataExpr = DataExpression.processReadDataExpression(functionName, passedParamExprs, errorListener, parseInfo);
        } else if (functionName.equalsIgnoreCase("rand")) {
            dataExpr = DataExpression.processRandDataExpression(functionName, passedParamExprs, errorListener, parseInfo);
        } else if (functionName.equals("matrix")) {
            dataExpr = DataExpression.processMatrixExpression(functionName, passedParamExprs, errorListener, parseInfo);
        } else if (functionName.equals("frame")) {
            dataExpr = DataExpression.processFrameExpression(functionName, passedParamExprs, errorListener, parseInfo);
        } else if (functionName.equals("tensor")) {
            dataExpr = DataExpression.processTensorExpression(functionName, passedParamExprs, errorListener, parseInfo);
        } else if (functionName.equals("sql")) {
            dataExpr = DataExpression.processSQLExpression(functionName, passedParamExprs, errorListener, parseInfo);
        } else if (functionName.equals("federated")) {
            dataExpr = DataExpression.processFederatedExpression(functionName, passedParamExprs, errorListener, parseInfo);
        }
        if (dataExpr != null) {
            dataExpr.setParseInfo(parseInfo);
        }
        return dataExpr;
    }

    private static DataExpression processReadDataExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        ParameterExpression pexpr;
        DataExpression dataExpr = new DataExpression(Expression.DataOp.READ, new HashMap<String, Expression>(), parseInfo);
        if (functionName.equals("readMM")) {
            dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(Types.FileFormat.MM.toString(), parseInfo));
        }
        if (functionName.equals("read.csv")) {
            dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(Types.FileFormat.CSV.toString(), parseInfo));
        }
        if (functionName.equals("read.libsvm")) {
            dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(Types.FileFormat.LIBSVM.toString(), parseInfo));
        }
        if (passedParamExprs.size() < 1) {
            errorListener.validationError(parseInfo, "read method must have at least filename parameter");
            return null;
        }
        ParameterExpression parameterExpression = pexpr = passedParamExprs.size() == 0 ? null : passedParamExprs.get(0);
        if (pexpr != null && (pexpr.getName() != null || pexpr.getName() != null && pexpr.getName().equalsIgnoreCase(IO_FILENAME))) {
            errorListener.validationError(parseInfo, "first parameter to read statement must be filename");
            return null;
        }
        if (pexpr != null) {
            dataExpr.addVarParam(IO_FILENAME, pexpr.getExpr());
        }
        for (int i = 1; i < passedParamExprs.size(); ++i) {
            String currName = passedParamExprs.get(i).getName();
            Expression currExpr = passedParamExprs.get(i).getExpr();
            if (dataExpr.getVarParam(currName) != null) {
                errorListener.validationError(parseInfo, "attempted to add IOStatement parameter " + currName + " more than once");
                return null;
            }
            boolean isValidName = READ_VALID_PARAM_NAMES.contains(currName);
            if (!isValidName) {
                errorListener.validationError(parseInfo, "attempted to add invalid read statement parameter " + currName);
                return null;
            }
            dataExpr.addVarParam(currName, currExpr);
        }
        return dataExpr;
    }

    private static DataExpression processRandDataExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        DataExpression dataExpr = new DataExpression(Expression.DataOp.RAND, new HashMap<String, Expression>(), parseInfo);
        for (ParameterExpression currExpr : passedParamExprs) {
            String pname = currExpr.getName();
            Expression pexpr = currExpr.getExpr();
            if (pname == null) {
                errorListener.validationError(parseInfo, "for rand statement, all arguments must be named parameters");
                return null;
            }
            dataExpr.addRandExprParam(pname, pexpr);
        }
        dataExpr.setRandDefault();
        return dataExpr;
    }

    private static DataExpression processMatrixExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        DataExpression dataExpr = new DataExpression(Expression.DataOp.MATRIX, new HashMap<String, Expression>(), parseInfo);
        int namedParamCount = (int)passedParamExprs.stream().filter(p -> p.getName() != null).count();
        int unnamedParamCount = passedParamExprs.size() - namedParamCount;
        if (passedParamExprs.size() < 3) {
            errorListener.validationError(parseInfo, "for matrix statement, must specify at least 3 arguments: data, rows, cols");
            return null;
        }
        if (unnamedParamCount > 1) {
            if (namedParamCount > 0) {
                errorListener.validationError(parseInfo, "for matrix statement, cannot mix named and unnamed parameters");
                return null;
            }
            if (unnamedParamCount < 3) {
                errorListener.validationError(parseInfo, "for matrix statement, must specify at least 3 arguments: data, rows, cols");
                return null;
            }
            dataExpr.addMatrixExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
            dataExpr.addMatrixExprParam("rows", passedParamExprs.get(1).getExpr());
            dataExpr.addMatrixExprParam("cols", passedParamExprs.get(2).getExpr());
            if (unnamedParamCount >= 4) {
                dataExpr.addMatrixExprParam(RAND_BY_ROW, passedParamExprs.get(3).getExpr());
            }
            if (unnamedParamCount == 5) {
                dataExpr.addMatrixExprParam(RAND_DIMNAMES, passedParamExprs.get(4).getExpr());
            }
            if (unnamedParamCount > 5) {
                errorListener.validationError(parseInfo, "for matrix statement, at most 5 arguments supported: data, rows, cols, byrow, dimname");
                return null;
            }
        } else {
            ParameterExpression firstParam = passedParamExprs.get(0);
            if (firstParam.getName() != null && !firstParam.getName().equals(RAND_DATA)) {
                errorListener.validationError(parseInfo, "matrix method must have data parameter as first parameter or unnamed parameter");
                return null;
            }
            dataExpr.addMatrixExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
            for (int i = 1; i < passedParamExprs.size(); ++i) {
                if (passedParamExprs.get(i).getName() == null) {
                    errorListener.validationError(parseInfo, "for matrix statement, cannot mix named and unnamed parameters, only data parameter can be unnamed");
                    return null;
                }
                dataExpr.addMatrixExprParam(passedParamExprs.get(i).getName(), passedParamExprs.get(i).getExpr());
            }
        }
        dataExpr.setMatrixDefault();
        return dataExpr;
    }

    private static DataExpression processFrameExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        DataExpression dataExpr = new DataExpression(Expression.DataOp.FRAME, new HashMap<String, Expression>(), parseInfo);
        int namedParamCount = (int)passedParamExprs.stream().filter(p -> p.getName() != null).count();
        int unnamedParamCount = passedParamExprs.size() - namedParamCount;
        if (passedParamExprs.size() < 3) {
            errorListener.validationError(parseInfo, "for frame statement, must specify at least 3 arguments: data, rows and cols");
            return null;
        }
        if (unnamedParamCount > 1) {
            if (namedParamCount > 0) {
                errorListener.validationError(parseInfo, "for frame statement, cannot mix named and unnamed parameters");
                return null;
            }
            if (unnamedParamCount < 3) {
                errorListener.validationError(parseInfo, "for frame statement, must specify at least 3 arguments: rows, cols");
                return null;
            }
            dataExpr.addFrameExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
            dataExpr.addFrameExprParam("rows", passedParamExprs.get(1).getExpr());
            dataExpr.addFrameExprParam("cols", passedParamExprs.get(2).getExpr());
            if (unnamedParamCount == 3) {
                dataExpr.addFrameExprParam(SCHEMAPARAM, passedParamExprs.get(3).getExpr());
            }
            if (unnamedParamCount > 3) {
                errorListener.validationError(parseInfo, "for frame  statement, at most 4 arguments supported: data, rows, cols, schema");
                return null;
            }
        } else {
            ParameterExpression firstParam = passedParamExprs.get(0);
            if (firstParam.getName() != null && !firstParam.getName().equals(RAND_DATA)) {
                errorListener.validationError(parseInfo, "frame method must have data parameter as first parameter or unnamed parameter");
                return null;
            }
            dataExpr.addFrameExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
            for (int i = 1; i < passedParamExprs.size(); ++i) {
                if (passedParamExprs.get(i).getName() == null) {
                    errorListener.validationError(parseInfo, "for frame statement, cannot mix named and unnamed parameters, only data parameter can be unnamed");
                    return null;
                }
                dataExpr.addFrameExprParam(passedParamExprs.get(i).getName(), passedParamExprs.get(i).getExpr());
            }
        }
        dataExpr.setFrameDefault();
        return dataExpr;
    }

    private static DataExpression processTensorExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        DataExpression dataExpr = new DataExpression(Expression.DataOp.TENSOR, new HashMap<String, Expression>(), parseInfo);
        int namedParamCount = (int)passedParamExprs.stream().filter(p -> p.getName() != null).count();
        int unnamedParamCount = passedParamExprs.size() - namedParamCount;
        if (passedParamExprs.size() < 2) {
            errorListener.validationError(parseInfo, "for tensor statement, must specify at least 2 arguments: data, dims[]");
            return null;
        }
        if (unnamedParamCount > 1) {
            if (namedParamCount > 0) {
                errorListener.validationError(parseInfo, "for tensor statement, cannot mix named and unnamed parameters");
                return null;
            }
            dataExpr.addTensorExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
            dataExpr.addTensorExprParam(RAND_DIMS, passedParamExprs.get(1).getExpr());
            if (unnamedParamCount >= 3) {
                dataExpr.addTensorExprParam(RAND_BY_ROW, passedParamExprs.get(2).getExpr());
            }
            if (unnamedParamCount == 4) {
                dataExpr.addTensorExprParam(RAND_DIMNAMES, passedParamExprs.get(3).getExpr());
            }
            if (unnamedParamCount > 4) {
                errorListener.validationError(parseInfo, "for tensor statement, at most 4 arguments supported: data, dims, byrow, dimname");
                return null;
            }
        } else {
            ParameterExpression firstParam = passedParamExprs.get(0);
            if (firstParam.getName() != null && !firstParam.getName().equals(RAND_DATA)) {
                errorListener.validationError(parseInfo, "tensor method must have data parameter as first parameter or unnamed parameter");
                return null;
            }
            dataExpr.addTensorExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
            for (int i = 1; i < passedParamExprs.size(); ++i) {
                if (passedParamExprs.get(i).getName() == null) {
                    errorListener.validationError(parseInfo, "for tensor statement, cannot mix named and unnamed parameters, only data parameter can be unnamed");
                    return null;
                }
                dataExpr.addTensorExprParam(passedParamExprs.get(i).getName(), passedParamExprs.get(i).getExpr());
            }
        }
        dataExpr.setTensorDefault();
        return dataExpr;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataExpression processSQLExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        DataExpression dataExpr = new DataExpression(Expression.DataOp.SQL, new HashMap<String, Expression>(), parseInfo);
        int namedParamCount = (int)passedParamExprs.stream().filter(p -> p.getName() != null).count();
        int unnamedParamCount = passedParamExprs.size() - namedParamCount;
        if (passedParamExprs.size() < 2) {
            errorListener.validationError(parseInfo, "for sql statement, must specify at least 2 arguments: conn, query");
            return null;
        }
        if (unnamedParamCount > 0) {
            if (namedParamCount > 0) {
                errorListener.validationError(parseInfo, "for sql statement, cannot mix named and unnamed parameters");
                return null;
            }
            if (unnamedParamCount != 2 && unnamedParamCount != 4) {
                errorListener.validationError(parseInfo, "for sql statement, at most 4 arguments supported: conn, user, password, query");
                return null;
            }
            dataExpr.addSqlExprParam(SQL_CONN, passedParamExprs.get(0).getExpr());
            dataExpr.addSqlExprParam(SQL_QUERY, passedParamExprs.get(1).getExpr());
            if (unnamedParamCount == 4) {
                dataExpr.addSqlExprParam(SQL_PASS, passedParamExprs.get(2).getExpr());
                dataExpr.addSqlExprParam(SQL_QUERY, passedParamExprs.get(3).getExpr());
            }
        } else {
            for (ParameterExpression passedParamExpr : passedParamExprs) {
                dataExpr.addSqlExprParam(passedParamExpr.getName(), passedParamExpr.getExpr());
            }
        }
        dataExpr.setSqlDefault();
        return dataExpr;
    }

    private static DataExpression processFederatedExpression(String functionName, List<ParameterExpression> passedParamExprs, CustomErrorListener errorListener, ParseInfo parseInfo) {
        DataExpression dataExpr = new DataExpression(Expression.DataOp.FEDERATED, new HashMap<String, Expression>(), parseInfo);
        int namedParamCount = (int)passedParamExprs.stream().filter(p -> p.getName() != null).count();
        int unnamedParamCount = passedParamExprs.size() - namedParamCount;
        if (passedParamExprs.size() < 2) {
            errorListener.validationError(parseInfo, "for federated statement, must specify at least 2 arguments: addresses, ranges");
            return null;
        }
        if (unnamedParamCount > 0) {
            if (namedParamCount > 0) {
                errorListener.validationError(parseInfo, "for federated statement, cannot mix named and unnamed parameters");
                return null;
            }
            if (unnamedParamCount == 2) {
                ParameterExpression param = passedParamExprs.get(0);
                dataExpr.addFederatedExprParam(FED_ADDRESSES, param.getExpr());
                param = passedParamExprs.get(1);
                dataExpr.addFederatedExprParam(FED_RANGES, param.getExpr());
            } else if (unnamedParamCount == 3) {
                ParameterExpression param = passedParamExprs.get(0);
                dataExpr.addFederatedExprParam(FED_ADDRESSES, param.getExpr());
                param = passedParamExprs.get(1);
                dataExpr.addFederatedExprParam(FED_RANGES, param.getExpr());
                param = passedParamExprs.get(2);
                dataExpr.addFederatedExprParam(FED_TYPE, param.getExpr());
            } else if (unnamedParamCount == 4) {
                ParameterExpression param = passedParamExprs.get(0);
                dataExpr.addFederatedExprParam(FED_LOCAL_OBJECT, param.getExpr());
                param = passedParamExprs.get(1);
                dataExpr.addFederatedExprParam(FED_ADDRESSES, param.getExpr());
                param = passedParamExprs.get(2);
                dataExpr.addFederatedExprParam(FED_RANGES, param.getExpr());
                param = passedParamExprs.get(3);
                dataExpr.addFederatedExprParam(FED_TYPE, param.getExpr());
            } else {
                errorListener.validationError(parseInfo, "for federated statement, at most 3 arguments are supported: addresses, ranges, type");
            }
        } else {
            for (ParameterExpression passedParamExpr : passedParamExprs) {
                dataExpr.addFederatedExprParam(passedParamExpr.getName(), passedParamExpr.getExpr());
            }
        }
        dataExpr.setFederatedDefault();
        return dataExpr;
    }

    public void addRandExprParam(String paramName, Expression paramValue) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && paramValue == null) {
            return;
        }
        boolean found = RAND_VALID_PARAM_NAMES.contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for Rand statement are (capitalization-sensitive): rows, cols, min, max, sparsity, seed, pdf, lambda");
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add Rand statement parameter " + paramValue + " more than once");
        }
        if (paramName.equals("rows") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        } else if (paramName.equals("cols") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addMatrixExprParam(String paramName, Expression paramValue) {
        boolean found = RESHAPE_VALID_PARAM_NAMES.contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for  matrix statement are (capitalization-sensitive): data, rows, cols, byrow");
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add matrix statement parameter " + paramValue + " more than once");
        }
        if (paramName.equals("rows") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        } else if (paramName.equals("cols") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addFrameExprParam(String paramName, Expression paramValue) {
        boolean found = FRAME_VALID_PARAM_NAMES.contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for  frame statement are (capitalization-sensitive): data, rows, cols, schema");
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add frame statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addTensorExprParam(String paramName, Expression paramValue) {
        boolean found = RESHAPE_VALID_PARAM_NAMES.contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for tensor statement are (capitalization-sensitive): data, dims, byrow, dimnames");
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add tensor statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addSqlExprParam(String paramName, Expression paramValue) {
        boolean found = SQL_VALID_PARAM_NAMES.contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for sql statement are (capitalization-sensitive): conn, user, password, query");
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add sql statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addFederatedExprParam(String paramName, Expression paramValue) {
        boolean found = FEDERATED_VALID_PARAM_NAMES.contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for federated statement are (capitalization-sensitive): addresses, ranges, type");
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add federated statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public DataExpression(Expression.DataOp op, HashMap<String, Expression> varParams, ParseInfo parseInfo) {
        this._opcode = op;
        this._varParams = varParams;
        this.setParseInfo(parseInfo);
    }

    public DataExpression(ParserRuleContext ctx, Expression.DataOp op, HashMap<String, Expression> varParams, String filename) {
        this._opcode = op;
        this._varParams = varParams;
        this.setCtxValuesAndFilename(ctx, filename);
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        HashMap<String, Expression> newVarParams = new HashMap<String, Expression>();
        for (Map.Entry<String, Expression> e : this._varParams.entrySet()) {
            String key = e.getKey();
            Expression newExpr = e.getValue().rewriteExpression(prefix);
            newVarParams.put(key, newExpr);
        }
        DataExpression retVal = new DataExpression(this._opcode, newVarParams, this);
        retVal._strInit = this._strInit;
        return retVal;
    }

    public void setMatrixDefault() {
        if (this.getVarParam(RAND_BY_ROW) == null) {
            this.addVarParam(RAND_BY_ROW, new BooleanIdentifier(true, this));
        }
    }

    public void setFrameDefault() {
        if (this.getVarParam(RAND_DATA) == null) {
            this.addVarParam(RAND_DATA, new StringIdentifier(null, this));
        }
        if (this.getVarParam(SCHEMAPARAM) == null) {
            this.addVarParam(SCHEMAPARAM, new StringIdentifier(DEFAULT_SCHEMAPARAM, this));
        }
    }

    public void setTensorDefault() {
        if (this.getVarParam(RAND_BY_ROW) == null) {
            this.addVarParam(RAND_BY_ROW, new BooleanIdentifier(true, this));
        }
    }

    public void setFederatedDefault() {
        if (this.getVarParam(FED_TYPE) == null) {
            this.addVarParam(FED_TYPE, new StringIdentifier("matrix", this));
        }
    }

    private void setSqlDefault() {
        if (this.getVarParam(SQL_USER) == null) {
            this.addVarParam(SQL_USER, new StringIdentifier(DEFAULT_NA_STRINGS, this));
        }
        if (this.getVarParam(SQL_PASS) == null) {
            this.addVarParam(SQL_PASS, new StringIdentifier(DEFAULT_NA_STRINGS, this));
        }
    }

    public void setRandDefault() {
        ConstIdentifier id;
        if (this.getVarParam(RAND_DIMS) == null) {
            if (this.getVarParam("rows") == null) {
                id = new IntIdentifier(1L, (ParseInfo)this);
                this.addVarParam("rows", id);
            }
            if (this.getVarParam("cols") == null) {
                id = new IntIdentifier(1L, (ParseInfo)this);
                this.addVarParam("cols", id);
            }
        }
        if (this.getVarParam(RAND_MIN) == null) {
            id = new DoubleIdentifier(0.0, (ParseInfo)this);
            this.addVarParam(RAND_MIN, id);
        }
        if (this.getVarParam(RAND_MAX) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_MAX, id);
        }
        if (this.getVarParam(RAND_SPARSITY) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_SPARSITY, id);
        }
        if (this.getVarParam(RAND_SEED) == null) {
            id = new IntIdentifier(-1L, (ParseInfo)this);
            this.addVarParam(RAND_SEED, id);
        }
        if (this.getVarParam(RAND_PDF) == null) {
            id = new StringIdentifier(RAND_PDF_UNIFORM, this);
            this.addVarParam(RAND_PDF, id);
        }
        if (this.getVarParam(RAND_LAMBDA) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_LAMBDA, id);
        }
    }

    public void setOpCode(Expression.DataOp op) {
        this._opcode = op;
    }

    public Expression.DataOp getOpCode() {
        return this._opcode;
    }

    public HashMap<String, Expression> getVarParams() {
        return this._varParams;
    }

    public void setVarParams(HashMap<String, Expression> varParams) {
        this._varParams = varParams;
    }

    public Expression getVarParam(String name) {
        return this._varParams.get(name);
    }

    public void addVarParam(String name, Expression value) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && value == null) {
            return;
        }
        this._varParams.put(name, value);
        this.setFilename(value.getFilename());
        if (this.getBeginLine() == 0) {
            this.setBeginLine(value.getBeginLine());
        }
        if (this.getBeginColumn() == 0) {
            this.setBeginColumn(value.getBeginColumn());
        }
        if (this.getEndLine() == 0) {
            this.setEndLine(value.getEndLine());
        }
        if (this.getEndColumn() == 0) {
            this.setEndColumn(value.getEndColumn());
        }
        if (this.getText() == null) {
            this.setText(value.getText());
        }
    }

    public void removeVarParam(String name) {
        this._varParams.remove(name);
    }

    public void removeVarParam(String ... names) {
        for (String name : names) {
            this.removeVarParam(name);
        }
    }

    private String getInputFileName(HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        String filename = null;
        Expression fileNameExpr = this.getVarParam(IO_FILENAME);
        if (fileNameExpr instanceof ConstIdentifier) {
            return fileNameExpr.toString();
        }
        if (fileNameExpr instanceof BinaryExpression) {
            BinaryExpression expr = (BinaryExpression)fileNameExpr;
            Expression.BinaryOp op = expr.getOpCode();
            switch (op) {
                case PLUS: {
                    filename = DEFAULT_NA_STRINGS;
                    filename = this.fileNameCat(expr, currConstVars, filename, conditional);
                    StringIdentifier fileString = new StringIdentifier(filename, this);
                    this.removeVarParam(IO_FILENAME);
                    this.addVarParam(IO_FILENAME, fileString);
                    break;
                }
                default: {
                    this.raiseValidateError("for read method, parameter iofilename can only be const string concatenations. ", conditional);
                    break;
                }
            }
        } else {
            this.raiseValidateError("for read method, parameter iofilename can only be a const string or const string concatenations. ", conditional);
        }
        return filename;
    }

    public static String getMTDFileName(String inputFileName) {
        return inputFileName + ".mtd";
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        for (Map.Entry<String, Expression> e : this.getVarParams().entrySet()) {
            String s = e.getKey();
            Expression inputParamExpr = e.getValue();
            if (inputParamExpr instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false, "Invalid Parameters");
            }
            inputParamExpr.validateExpression(ids, currConstVars, conditional);
            if (s == null || s.equals(RAND_DATA) || s.equals(RAND_DIMS) || s.equals(FED_ADDRESSES) || s.equals(FED_RANGES) || s.equals(FED_LOCAL_OBJECT) || s.equals(DELIM_NA_STRINGS) || s.equals(SCHEMAPARAM) || this.getVarParam(s).getOutput().getDataType() == Types.DataType.SCALAR) continue;
            this.raiseValidateError("Non-scalar data types are not supported for data expression.", conditional, "Invalid Parameters");
        }
        this.performConstantPropagationRand(currConstVars);
        this.performConstantPropagationReadWrite(currConstVars);
        Expression dataParam1 = this.getVarParam(RAND_DATA);
        if (dataParam1 == null && (this.getOpCode().equals((Object)Expression.DataOp.MATRIX) || this.getOpCode().equals((Object)Expression.DataOp.TENSOR))) {
            this.raiseValidateError("for matrix, frame or tensor, must defined data parameter", conditional, "Invalid Parameters");
        }
        if (dataParam1 != null && dataParam1.getOutput() != null && dataParam1.getOutput().getDataType() == Types.DataType.SCALAR && (this._opcode == Expression.DataOp.MATRIX || this._opcode == Expression.DataOp.TENSOR)) {
            this.setOpCode(Expression.DataOp.RAND);
        }
        switch (this.getOpCode()) {
            case READ: {
                String valueTypeString;
                boolean isCSV;
                String formatTypeString;
                boolean shouldReadMTD;
                String dataTypeString;
                if (this.getVarParam(DATATYPEPARAM) != null && !(this.getVarParam(DATATYPEPARAM) instanceof StringIdentifier)) {
                    this.raiseValidateError("for read statement, parameter data_type can only be a string. Valid values are: matrix, scalar", conditional);
                }
                String string = dataTypeString = this.getVarParam(DATATYPEPARAM) == null ? null : this.getVarParam(DATATYPEPARAM).toString();
                if (dataTypeString != null && dataTypeString.equalsIgnoreCase("scalar") && (this.getVarParam("rows") != null || this.getVarParam("cols") != null || this.getVarParam(ROWBLOCKCOUNTPARAM) != null || this.getVarParam(COLUMNBLOCKCOUNTPARAM) != null || this.getVarParam(FORMAT_TYPE) != null || this.getVarParam(DELIM_DELIMITER) != null || this.getVarParam(LIBSVM_INDEX_DELIM) != null || this.getVarParam(DELIM_HAS_HEADER_ROW) != null || this.getVarParam(DELIM_FILL) != null || this.getVarParam(DELIM_FILL_VALUE) != null || this.getVarParam(DELIM_NA_STRINGS) != null)) {
                    this.raiseValidateError("Invalid parameters in read statement of a scalar: " + this.toString() + ". Only value_type is allowed.", conditional, "Invalid Parameters");
                }
                MetaDataAll configObj = new MetaDataAll();
                String inputFileName = this.getInputFileName(currConstVars, conditional);
                String mtdFileName = DataExpression.getMTDFileName(inputFileName);
                boolean bl = shouldReadMTD = !(!this._checkMetadata || dataTypeString != null && this.getVarParam(VALUETYPEPARAM) != null && dataTypeString.equalsIgnoreCase("scalar") || ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA) && !HDFSTool.existsFileOnHDFS(mtdFileName));
                if (shouldReadMTD && !HDFSTool.existsFileOnHDFS(inputFileName) && !ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.RESOURCE_OPTIMIZATION)) {
                    String fsext = InfrastructureAnalyzer.isLocalMode() ? "FS (local mode)" : "HDFS";
                    this.raiseValidateError("Read input file does not exist on " + fsext + ": " + inputFileName, conditional);
                }
                boolean inferredFormatType = false;
                String string2 = formatTypeString = this.getVarParam(FORMAT_TYPE) == null ? null : this.getVarParam(FORMAT_TYPE).toString();
                if (formatTypeString == null && shouldReadMTD && MetaDataAll.checkHasMatrixMarketFormat(inputFileName, mtdFileName, conditional)) {
                    formatTypeString = Types.FileFormat.MM.toString();
                    this.addVarParam(FORMAT_TYPE, new StringIdentifier(formatTypeString, this));
                    configObj.setFormatTypeString(formatTypeString);
                    inferredFormatType = true;
                    shouldReadMTD = false;
                }
                if (formatTypeString == null && shouldReadMTD && (formatTypeString = MetaDataAll.checkHasDelimitedFormat(inputFileName, conditional)) != null) {
                    this.addVarParam(FORMAT_TYPE, new StringIdentifier(formatTypeString, this));
                    configObj.setFormatTypeString(formatTypeString);
                    inferredFormatType = true;
                }
                if (formatTypeString != null && formatTypeString.equalsIgnoreCase(Types.FileFormat.MM.toString())) {
                    shouldReadMTD = false;
                    String[] headerLines = null;
                    try {
                        headerLines = IOUtilFunctions.readMatrixMarketHeader(inputFileName);
                    }
                    catch (DMLRuntimeException ex) {
                        this.raiseValidateError(ex.getMessage(), conditional);
                    }
                    if (headerLines != null && headerLines.length >= 2) {
                        long nnzCount2;
                        long colsCount2;
                        long rowsCount2;
                        long rowsCount;
                        String firstLine = headerLines[0].trim();
                        FileFormatPropertiesMM fileFormatPropertiesMM = FileFormatPropertiesMM.parse(firstLine);
                        String secondLine = headerLines[1];
                        String[] sizeInfo = secondLine.trim().split("\\s+");
                        if (sizeInfo.length != 3) {
                            this.raiseValidateError("Unsupported size line in MatrixMarket file: " + headerLines[1] + ". Only supported format in MatrixMarket file has size line: <NUM ROWS> <NUM COLS> <NUM NON-ZEROS>, where each value is an integer.", conditional);
                        }
                        if ((rowsCount = Long.parseLong(sizeInfo[0])) < 0L) {
                            this.raiseValidateError("MM file: invalid number of rows: " + rowsCount);
                        } else if (this.getVarParam("rows") != null && (rowsCount2 = Long.parseLong(this.getVarParam("rows").toString())) != rowsCount) {
                            this.raiseValidateError("MM file: invalid specified number of rows: " + rowsCount2 + " vs " + rowsCount);
                        }
                        this.addVarParam("rows", new IntIdentifier(rowsCount, (ParseInfo)this));
                        long colsCount = Long.parseLong(sizeInfo[1]);
                        if (colsCount < 0L) {
                            this.raiseValidateError("MM file: invalid number of columns: " + colsCount);
                        } else if (this.getVarParam("cols") != null && (colsCount2 = Long.parseLong(this.getVarParam("cols").toString())) != colsCount) {
                            this.raiseValidateError("MM file: invalid specified number of columns: " + colsCount2 + " vs " + colsCount);
                        }
                        this.addVarParam("cols", new IntIdentifier(colsCount, (ParseInfo)this));
                        configObj.setDimensions(rowsCount, colsCount);
                        long nnzCount = Long.parseLong(sizeInfo[2]) * (long)(fileFormatPropertiesMM.isSymmetric() ? 2 : 1);
                        if (nnzCount < 0L) {
                            this.raiseValidateError("MM file: invalid number of non-zeros: " + nnzCount);
                        } else if (this.getVarParam(READNNZPARAM) != null && (nnzCount2 = Long.parseLong(this.getVarParam(READNNZPARAM).toString())) != nnzCount) {
                            this.raiseValidateError("MM file: invalid specified number of non-zeros: " + nnzCount2 + " vs " + nnzCount);
                        }
                        this.addVarParam(READNNZPARAM, new IntIdentifier(nnzCount, (ParseInfo)this));
                        configObj.setNnz(nnzCount);
                    }
                }
                boolean bl2 = isCSV = formatTypeString != null && formatTypeString.equalsIgnoreCase(Types.FileFormat.CSV.toString());
                if (shouldReadMTD) {
                    configObj = new MetaDataAll(mtdFileName, conditional, false);
                    if (configObj.mtdExists()) {
                        this._varParams = configObj.parseMetaDataFileParameters(mtdFileName, conditional, this._varParams);
                        inferredFormatType = true;
                    } else if (!isCSV) {
                        LOG.warn((Object)("Metadata file: " + new Path(mtdFileName) + " not provided"));
                    }
                }
                if (isCSV) {
                    shouldReadMTD = true;
                    if (!inferredFormatType) {
                        for (String string3 : this._varParams.keySet()) {
                            if (READ_VALID_PARAM_NAMES.contains(string3)) continue;
                            String msg = "Only parameters allowed are: " + READ_VALID_PARAM_NAMES;
                            this.raiseValidateError("Invalid parameter " + string3 + " in read statement: " + this.toString() + ". " + msg, conditional, "Invalid Parameters");
                        }
                    }
                    this.handleCSVDefaultParam(DELIM_DELIMITER, Types.ValueType.STRING, conditional);
                    this.handleCSVDefaultParam(DELIM_FILL_VALUE, Types.ValueType.FP64, conditional);
                    this.handleCSVDefaultParam(DELIM_HAS_HEADER_ROW, Types.ValueType.BOOLEAN, conditional);
                    this.handleCSVDefaultParam(DELIM_FILL, Types.ValueType.BOOLEAN, conditional);
                    this.handleCSVDefaultParam(DELIM_NA_STRINGS, Types.ValueType.STRING, conditional);
                }
                boolean isLIBSVM = false;
                boolean bl3 = isLIBSVM = formatTypeString != null && formatTypeString.equalsIgnoreCase(Types.FileFormat.LIBSVM.toString());
                if (isLIBSVM) {
                    shouldReadMTD = true;
                    if (!inferredFormatType) {
                        for (String key : this._varParams.keySet()) {
                            if (key.equals(IO_FILENAME) || key.equals(FORMAT_TYPE) || key.equals("rows") || key.equals("cols") || key.equals(READNNZPARAM) || key.equals(DATATYPEPARAM) || key.equals(VALUETYPEPARAM) || key.equals(DELIM_DELIMITER) || key.equals(LIBSVM_INDEX_DELIM)) continue;
                            String msg = "Only parameters allowed are: iofilename,rows,colssep,indSep";
                            this.raiseValidateError("Invalid parameter " + key + " in read statement: " + this.toString() + ". " + msg, conditional, "Invalid Parameters");
                        }
                    }
                    this.handleCSVDefaultParam(DELIM_DELIMITER, Types.ValueType.STRING, conditional);
                    this.handleCSVDefaultParam(LIBSVM_INDEX_DELIM, Types.ValueType.STRING, conditional);
                }
                boolean bl4 = formatTypeString != null && formatTypeString.equalsIgnoreCase(Types.FileFormat.HDF5.toString());
                boolean isCOG = formatTypeString != null && formatTypeString.equalsIgnoreCase(Types.FileFormat.COG.toString());
                String string4 = dataTypeString = this.getVarParam(DATATYPEPARAM) == null ? null : this.getVarParam(DATATYPEPARAM).toString();
                if (dataTypeString == null || dataTypeString.equalsIgnoreCase("matrix") || dataTypeString.equalsIgnoreCase("frame")) {
                    boolean isMatrix = false;
                    if (dataTypeString == null || dataTypeString.equalsIgnoreCase("matrix")) {
                        isMatrix = true;
                    }
                    this.getOutput().setDataType(isMatrix ? Types.DataType.MATRIX : Types.DataType.FRAME);
                    Expression ennz = this.getVarParam(READNNZPARAM);
                    long nnz = -1L;
                    if (ennz != null) {
                        nnz = Long.valueOf(ennz.toString());
                        this.getOutput().setNnz(nnz);
                    }
                    this.getOutput().setDimensions(-1L, -1L);
                    if (!(isCSV || isLIBSVM || bl4 || isCOG || !ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS) || this.getVarParam("rows") != null && this.getVarParam("cols") != null)) {
                        this.raiseValidateError("Missing or incomplete dimension information in read statement: " + mtdFileName, conditional, "Invalid Parameters");
                    }
                    if (this.getVarParam("rows") instanceof ConstIdentifier && this.getVarParam("cols") instanceof ConstIdentifier) {
                        Long dim2;
                        Long dim1 = this.getVarParam("rows") == null ? null : Long.valueOf(this.getVarParam("rows").toString());
                        Long l = dim2 = this.getVarParam("cols") == null ? null : Long.valueOf(this.getVarParam("cols").toString());
                        if (!isCSV && (dim1 < 0L || dim2 < 0L) && ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS)) {
                            this.raiseValidateError("Invalid dimension information in read statement", conditional, "Invalid Parameters");
                        }
                        if (dim1 != null && dim2 != null) {
                            this.getOutput().setDimensions(dim1, dim2);
                        } else if (!(isCSV || dim1 == null && dim2 == null)) {
                            this.raiseValidateError("Partial dimension information in read statement", conditional, "Invalid Parameters");
                        }
                    }
                    if (isLIBSVM) {
                        Long dim2;
                        Long l = dim2 = this.getVarParam("cols") == null ? null : Long.valueOf(this.getVarParam("cols").toString());
                        if (dim2 < 0L && ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS)) {
                            this.raiseValidateError("Invalid dimension information in read statement", conditional, "Invalid Parameters");
                        }
                        this.getOutput().setDimensions(-1L, dim2 + 1L);
                    }
                    this.getOutput().setBlocksize(-1);
                    String fmt = this.getVarParam(FORMAT_TYPE) == null ? Types.FileFormat.defaultFormatString() : this.getVarParam(FORMAT_TYPE).toString();
                    try {
                        this.getOutput().setFileFormat(Types.FileFormat.safeValueOf(fmt));
                    }
                    catch (Exception ex) {
                        this.raiseValidateError("Invalid format '" + fmt + "' in statement: " + this.toString(), conditional);
                    }
                    if (this.getVarParam(ROWBLOCKCOUNTPARAM) instanceof ConstIdentifier && this.getVarParam(COLUMNBLOCKCOUNTPARAM) instanceof ConstIdentifier) {
                        Integer rowBlockCount = this.getVarParam(ROWBLOCKCOUNTPARAM) == null ? null : Integer.valueOf(this.getVarParam(ROWBLOCKCOUNTPARAM).toString());
                        this.getOutput().setBlocksize(rowBlockCount != null ? rowBlockCount : -1);
                    }
                    if ((this.getOutput().getFileFormat().isTextFormat() || !isMatrix) && this.getOutput().getBlocksize() != -1) {
                        this.raiseValidateError("Invalid block dimensions (" + this.getOutput().getBlocksize() + ") when format=" + this.getVarParam(FORMAT_TYPE) + " in \"" + this.toString() + "\".", conditional);
                    }
                } else if (dataTypeString.equalsIgnoreCase("scalar")) {
                    this.getOutput().setDataType(Types.DataType.SCALAR);
                    this.getOutput().setNnz(-1L);
                } else if (dataTypeString.equalsIgnoreCase(Types.DataType.LIST.name())) {
                    this.getOutput().setDataType(Types.DataType.LIST);
                } else {
                    this.raiseValidateError("Unknown Data Type " + dataTypeString + ". Valid  values: scalar, matrix, frame, " + Types.DataType.LIST.name().toLowerCase(), conditional, "Invalid Parameters");
                }
                if (this.getVarParam(VALUETYPEPARAM) != null && !(this.getVarParam(VALUETYPEPARAM) instanceof StringIdentifier)) {
                    this.raiseValidateError("for read method, parameter value_type can only be a string. Valid values are: double, int, boolean, string", conditional);
                }
                String string5 = valueTypeString = this.getVarParam(VALUETYPEPARAM) == null ? null : this.getVarParam(VALUETYPEPARAM).toString();
                if (valueTypeString != null) {
                    if (valueTypeString.equalsIgnoreCase("double")) {
                        this.getOutput().setValueType(Types.ValueType.FP64);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase("string")) {
                        this.getOutput().setValueType(Types.ValueType.STRING);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase("int")) {
                        this.getOutput().setValueType(Types.ValueType.INT64);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase("boolean")) {
                        this.getOutput().setValueType(Types.ValueType.BOOLEAN);
                        break;
                    }
                    if (valueTypeString.equalsIgnoreCase(Types.ValueType.UNKNOWN.name())) {
                        this.getOutput().setValueType(Types.ValueType.UNKNOWN);
                        break;
                    }
                    this.raiseValidateError("Unknown Value Type " + valueTypeString + ". Valid values are: double, int, boolean, string", conditional);
                    break;
                }
                this.getOutput().setValueType(Types.ValueType.FP64);
                break;
            }
            case WRITE: {
                if (this.getVarParam(FORMAT_TYPE) == null || this.checkFormatType(Types.FileFormat.CSV)) {
                    if (this.getVarParam(DELIM_DELIMITER) == null) {
                        this.addVarParam(DELIM_DELIMITER, new StringIdentifier(DEFAULT_DELIM_DELIMITER, this));
                    }
                    if (this.getVarParam(DELIM_HAS_HEADER_ROW) == null) {
                        this.addVarParam(DELIM_HAS_HEADER_ROW, new BooleanIdentifier(false, this));
                    }
                    if (this.getVarParam(DELIM_SPARSE) == null) {
                        this.addVarParam(DELIM_SPARSE, new BooleanIdentifier(false, this));
                    }
                }
                if (this.getVarParam(FORMAT_TYPE) == null || this.checkFormatType(Types.FileFormat.LIBSVM)) {
                    if (this.getVarParam(DELIM_DELIMITER) == null) {
                        this.addVarParam(DELIM_DELIMITER, new StringIdentifier(DEFAULT_DELIM_DELIMITER, this));
                    }
                    if (this.getVarParam(LIBSVM_INDEX_DELIM) == null) {
                        this.addVarParam(LIBSVM_INDEX_DELIM, new StringIdentifier(DEFAULT_LIBSVM_INDEX_DELIM, this));
                    }
                    if (this.getVarParam(DELIM_SPARSE) == null) {
                        this.addVarParam(DELIM_SPARSE, new BooleanIdentifier(false, this));
                    }
                }
                if (this.getVarParam(FORMAT_TYPE) == null || Types.FileFormat.isTextFormat(this.getVarParam(FORMAT_TYPE).toString())) {
                    this.getOutput().setBlocksize(-1);
                    break;
                }
                if (this.checkFormatType(Types.FileFormat.BINARY, Types.FileFormat.COMPRESSED, Types.FileFormat.UNKNOWN)) {
                    if (this.getVarParam(ROWBLOCKCOUNTPARAM) != null) {
                        this.getOutput().setBlocksize(Integer.parseInt(this.getVarParam(ROWBLOCKCOUNTPARAM).toString()));
                        break;
                    }
                    this.getOutput().setBlocksize(ConfigurationManager.getBlocksize());
                    break;
                }
                if (!(this.getVarParam(FORMAT_TYPE) instanceof StringIdentifier)) break;
                this.raiseValidateError("Invalid format " + this.getVarParam(FORMAT_TYPE) + " in statement: " + this.toString(), conditional);
                break;
            }
            case RAND: {
                Expression minExpr;
                Expression lambda;
                boolean isTensorOperation;
                Expression dataParam = this.getVarParam(RAND_DATA);
                if (dataParam != null) {
                    if (dataParam instanceof DataIdentifier) {
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    } else if (dataParam instanceof IntIdentifier) {
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    } else if (dataParam instanceof DoubleIdentifier) {
                        double roundedValue = ((DoubleIdentifier)dataParam).getValue();
                        DoubleIdentifier minExpr2 = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                        this.addVarParam(RAND_MIN, minExpr2);
                        this.addVarParam(RAND_MAX, minExpr2);
                    } else if (dataParam instanceof StringIdentifier) {
                        String data = ((StringIdentifier)dataParam).getValue();
                        StringIdentifier minExpr3 = new StringIdentifier(data, this);
                        this.addVarParam(RAND_MIN, minExpr3);
                        this.addVarParam(RAND_MAX, minExpr3);
                        this._strInit = true;
                    } else {
                        dataParam.validateExpression(ids, currConstVars, conditional);
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    }
                    this.removeVarParam(RAND_DATA);
                    this.removeVarParam(RAND_BY_ROW);
                    this.setRandDefault();
                }
                this.validateParams(conditional, RAND_VALID_PARAM_NAMES, "Legal parameters for Rand statement are (capitalization-sensitive): rows, cols, dims, min, max, sparsity, seed, pdf, lambda");
                if (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement cols has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_DIMS) instanceof IntIdentifier || this.getVarParam(RAND_DIMS) instanceof DoubleIdentifier || this.getVarParam(RAND_DIMS) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement dims has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_SEED) instanceof StringIdentifier || this.getVarParam(RAND_SEED) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement seed has incorrect value type", conditional);
                }
                boolean bl = isTensorOperation = this.getVarParam(RAND_DIMS) != null;
                if (this.getVarParam(RAND_MAX) instanceof StringIdentifier && !this._strInit || this.getVarParam(RAND_MAX) instanceof BooleanIdentifier && !isTensorOperation) {
                    this.raiseValidateError("for Rand statement max has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_MIN) instanceof StringIdentifier && !this._strInit || this.getVarParam(RAND_MIN) instanceof BooleanIdentifier && !isTensorOperation) {
                    this.raiseValidateError("for Rand statement min has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_PDF) instanceof StringIdentifier)) {
                    this.raiseValidateError("for Rand statement pdf has incorrect value type", conditional);
                }
                if (!((lambda = this.getVarParam(RAND_LAMBDA)) instanceof DataIdentifier) && !(lambda instanceof ConstIdentifier) || lambda.getOutput().getValueType() != Types.ValueType.FP64 && lambda.getOutput().getValueType() != Types.ValueType.INT64) {
                    this.raiseValidateError("for Rand statement lambda has incorrect data type", conditional);
                }
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                Expression colsExpr = this.getVarParam("cols");
                if (!isTensorOperation) {
                    long roundedValue;
                    ConstIdentifier constValue;
                    String identifierName;
                    if (rowsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)rowsExpr).getValue() < 0L) {
                            this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                        }
                        rowsLong = ((IntIdentifier)rowsExpr).getValue();
                    } else if (rowsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)rowsExpr).getValue() < 0.0) {
                            this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                        }
                        rowsLong = UtilFunctions.toLong(Math.floor(((DoubleIdentifier)rowsExpr).getValue()));
                    } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)rowsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 0L) {
                                    this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 0.0) {
                                    this.raiseValidateError("In rand statement, can only assign rows a long (double) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            rowsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                    if (colsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)colsExpr).getValue() < 0L) {
                            this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                        colsLong = ((IntIdentifier)colsExpr).getValue();
                    } else if (colsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)colsExpr).getValue() < 0.0) {
                            this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                        colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                    } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)colsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 0L) {
                                    this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 0.0) {
                                    this.raiseValidateError("In rand statement, can only assign cols a long (double) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            colsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                if ((minExpr = this.getVarParam(RAND_MIN)) instanceof DataIdentifier && !(minExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)minExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            long roundedValue = ((IntIdentifier)constValue).getValue();
                            minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MIN, minExpr);
                        } else if (constValue instanceof DoubleIdentifier) {
                            double roundedValue = ((DoubleIdentifier)constValue).getValue();
                            minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MIN, minExpr);
                        } else {
                            this.raiseValidateError("In rand statement, can only assign min a numerical value -- attempted to assign: " + constValue.toString(), conditional);
                        }
                    } else {
                        minExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    minExpr.validateExpression(ids, currConstVars, conditional);
                }
                Expression maxExpr = this.getVarParam(RAND_MAX);
                if (maxExpr instanceof DataIdentifier && !(maxExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)maxExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            long roundedValue = ((IntIdentifier)constValue).getValue();
                            maxExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MAX, maxExpr);
                        } else if (constValue instanceof DoubleIdentifier) {
                            double roundedValue = ((DoubleIdentifier)constValue).getValue();
                            maxExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MAX, maxExpr);
                        } else {
                            this.raiseValidateError("In rand statement, can only assign max a numerical value -- attempted to assign: " + constValue.toString(), conditional);
                        }
                    } else {
                        maxExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    maxExpr.validateExpression(ids, currConstVars, conditional);
                }
                this.getOutput().setFileFormat(Types.FileFormat.BINARY);
                if (isTensorOperation) {
                    this.getOutput().setDataType(Types.DataType.TENSOR);
                    this.getOutput().setValueType(this.getVarParam(RAND_MIN).getOutput().getValueType());
                    this.getOutput().setDimensions(-1L, -1L);
                } else {
                    this.getOutput().setDataType(Types.DataType.MATRIX);
                    this.getOutput().setValueType(Types.ValueType.FP64);
                    this.getOutput().setDimensions(rowsLong, colsLong);
                }
                if (this.getOutput() instanceof IndexedIdentifier) {
                    DataIdentifier targetAsSeen = ids.get(((DataIdentifier)this.getOutput()).getName());
                    if (targetAsSeen == null) {
                        this.raiseValidateError("cannot assign value to indexed identifier " + ((DataIdentifier)this.getOutput()).getName() + " without first initializing " + ((DataIdentifier)this.getOutput()).getName(), conditional);
                    }
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(targetAsSeen.getDim1(), targetAsSeen.getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for Rand Statement may have incorrect size information"));
                break;
            }
            case MATRIX: {
                Expression colsExpr;
                long roundedValue;
                ConstIdentifier constValue;
                String identifierName;
                this.setMatrixDefault();
                this.validateParams(conditional, RESHAPE_VALID_PARAM_NAMES, "Legal parameters for matrix statement are (case-sensitive): data, rows, cols, byrow");
                if (this.getVarParam(RAND_DATA) != null && this.getVarParam(RAND_DATA) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for matrix statement data has incorrect value type", conditional);
                }
                if (this.getVarParam("rows") != null && (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") != null && (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement cols has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_BY_ROW) instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement byrow has incorrect value type", conditional);
                }
                this.getVarParam(RAND_DATA).validateExpression(ids, currConstVars, conditional);
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                if (rowsExpr != null) {
                    if (rowsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)rowsExpr).getValue() >= 1L) {
                            rowsLong = ((IntIdentifier)rowsExpr).getValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                        }
                    } else if (rowsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)rowsExpr).getValue() >= 1.0) {
                            rowsLong = Double.valueOf(Math.floor(((DoubleIdentifier)rowsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                        }
                    } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)rowsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            rowsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                if ((colsExpr = this.getVarParam("cols")) != null) {
                    if (colsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)colsExpr).getValue() >= 1L) {
                            colsLong = ((IntIdentifier)colsExpr).getValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)colsExpr).getValue() >= 1.0) {
                            colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)colsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            colsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                this.getOutput().setFileFormat(Types.FileFormat.BINARY);
                this.getOutput().setDataType(Types.DataType.MATRIX);
                this.getOutput().setValueType(Types.ValueType.FP64);
                this.getOutput().setDimensions(rowsLong, colsLong);
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(this.getOutput().getDim1(), this.getOutput().getDim2());
                LOG.warn((Object)(this.printWarningLocation() + "Output for matrix Statement may have incorrect size information"));
                break;
            }
            case FRAME: {
                Expression colsExpr;
                long roundedValue;
                ConstIdentifier constValue;
                String identifierName;
                this.setFrameDefault();
                this.validateParams(conditional, FRAME_VALID_PARAM_NAMES, "Legal parameters for frame statement are (case-sensitive): data, rows, cols, schema");
                if (this.getVarParam("rows") != null && (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for frame statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") != null && (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for frame statement cols has incorrect value type", conditional);
                }
                this.getVarParam(RAND_DATA).validateExpression(ids, currConstVars, conditional);
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                if (rowsExpr != null) {
                    if (rowsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)rowsExpr).getValue() >= 1L) {
                            rowsLong = ((IntIdentifier)rowsExpr).getValue();
                        } else {
                            this.raiseValidateError("In frame statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                        }
                    } else if (rowsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)rowsExpr).getValue() >= 1.0) {
                            rowsLong = Double.valueOf(Math.floor(((DoubleIdentifier)rowsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In frame statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                        }
                    } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)rowsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In frame statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In frame statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In frame statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            rowsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                if ((colsExpr = this.getVarParam("cols")) != null) {
                    if (colsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)colsExpr).getValue() >= 1L) {
                            colsLong = ((IntIdentifier)colsExpr).getValue();
                        } else {
                            this.raiseValidateError("In frame statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)colsExpr).getValue() >= 1.0) {
                            colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In frame statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)colsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In frame statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In frame statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In frame statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            colsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                this.getOutput().setFileFormat(Types.FileFormat.BINARY);
                this.getOutput().setDataType(Types.DataType.FRAME);
                this.getOutput().setValueType(Types.ValueType.UNKNOWN);
                this.getOutput().setDimensions(rowsLong, colsLong);
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(this.getOutput().getDim1(), this.getOutput().getDim2());
                LOG.warn((Object)(this.printWarningLocation() + "Output for frame Statement may have incorrect size information"));
                break;
            }
            case TENSOR: {
                this.setTensorDefault();
                this.validateParams(conditional, RESHAPE_VALID_PARAM_NAMES, "Legal parameters for tensor statement are (case-sensitive): data, dims, byrow");
                if (this.getVarParam(RAND_DIMS) != null && this.getVarParam(RAND_DIMS) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for tensor statement dims has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_BY_ROW) instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for tensor statement byrow has incorrect value type", conditional);
                }
                this.getVarParam(RAND_DATA).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(RAND_DIMS).validateExpression(ids, currConstVars, conditional);
                this.getOutput().setFileFormat(Types.FileFormat.BINARY);
                this.getOutput().setDataType(Types.DataType.TENSOR);
                this.getOutput().setValueType(this.getVarParam(RAND_DATA).getOutput().getValueType());
                this.getOutput().setDimensions(-1L, -1L);
                if (this.getOutput() instanceof IndexedIdentifier) {
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(this.getOutput().getDim1(), this.getOutput().getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for tensor Statement may have incorrect size information"));
                break;
            }
            case SQL: {
                this.setSqlDefault();
                this.validateParams(conditional, SQL_VALID_PARAM_NAMES, "Legal parameters for tensor statement are (case-sensitive): conn, user, password, query");
                Expression exp = this.getVarParam(SQL_CONN);
                if (!(exp instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement conn has incorrect value type", conditional);
                }
                if (!((exp = this.getVarParam(SQL_USER)) instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement user has incorrect value type", conditional);
                }
                if (!((exp = this.getVarParam(SQL_PASS)) instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement password has incorrect value type", conditional);
                }
                if (!((exp = this.getVarParam(SQL_QUERY)) instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement query has incorrect value type", conditional);
                }
                this.getVarParam(SQL_CONN).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(SQL_USER).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(SQL_PASS).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(SQL_QUERY).validateExpression(ids, currConstVars, conditional);
                this.getOutput().setFileFormat(Types.FileFormat.BINARY);
                this.getOutput().setDataType(Types.DataType.TENSOR);
                this.getOutput().setValueType(Types.ValueType.UNKNOWN);
                this.getOutput().setDimensions(-1L, -1L);
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for sql statement may have incorrect size information"));
                break;
            }
            case FEDERATED: {
                this.validateParams(conditional, FEDERATED_VALID_PARAM_NAMES, "Legal parameters for federated statement are (case-sensitive): type, addresses, ranges");
                Expression exp = this.getVarParam(FED_ADDRESSES);
                if (!(exp instanceof DataIdentifier)) {
                    this.raiseValidateError("for federated statement addresses has incorrect value type", conditional);
                }
                this.getVarParam(FED_ADDRESSES).validateExpression(ids, currConstVars, conditional);
                exp = this.getVarParam(FED_RANGES);
                if (!(exp instanceof DataIdentifier)) {
                    this.raiseValidateError("for federated statement ranges has incorrect value type", conditional);
                }
                this.getVarParam(FED_RANGES).validateExpression(ids, currConstVars, conditional);
                exp = this.getVarParam(FED_TYPE);
                if (!(exp instanceof StringIdentifier)) {
                    this.raiseValidateError("for federated statement type has incorrect value type", conditional);
                }
                this.getVarParam(FED_TYPE).validateExpression(ids, currConstVars, conditional);
                this.getOutput().setFileFormat(Types.FileFormat.BINARY);
                StringIdentifier fedType = (StringIdentifier)exp;
                if (fedType.getValue().equalsIgnoreCase("matrix")) {
                    this.getOutput().setDataType(Types.DataType.MATRIX);
                    this.getOutput().setValueType(Types.ValueType.FP64);
                } else if (fedType.getValue().equalsIgnoreCase("frame")) {
                    this.getOutput().setDataType(Types.DataType.FRAME);
                }
                if (this._varParams.size() == 4) {
                    exp = this.getVarParam(FED_LOCAL_OBJECT);
                    if (!(exp instanceof DataIdentifier)) {
                        this.raiseValidateError("for federated statement local_matrix has incorrect value type", conditional);
                    }
                    this.getVarParam(FED_LOCAL_OBJECT).validateExpression(ids, currConstVars, conditional);
                }
                this.getOutput().setDimensions(-1L, -1L);
                break;
            }
            default: {
                this.raiseValidateError("Unsupported Data expression " + this.getOpCode(), false, "Invalid Parameters");
            }
        }
    }

    private void handleCSVDefaultParam(String param, Types.ValueType vt, boolean conditional) {
        if (this.getVarParam(param) == null) {
            ConstIdentifier defExpr = null;
            switch (vt) {
                case BOOLEAN: {
                    defExpr = new BooleanIdentifier((Boolean)csvDefaults.get(param), this);
                    break;
                }
                case FP64: {
                    defExpr = new DoubleIdentifier((Double)csvDefaults.get(param), (ParseInfo)this);
                    break;
                }
                default: {
                    defExpr = new StringIdentifier((String)csvDefaults.get(param), this);
                }
            }
            this.addVarParam(param, defExpr);
        } else if (this.getVarParam(param) instanceof ConstIdentifier && !this.checkValueType(this.getVarParam(param), vt)) {
            this.raiseValidateError("For delimited file '" + this.getVarParam(param) + "' must be a '" + vt.toExternalString() + "' value ", conditional);
        }
    }

    private boolean checkFormatType(Types.FileFormat ... fmts) {
        String fmtStr = this.getVarParam(FORMAT_TYPE).toString();
        return Arrays.stream(fmts).anyMatch(fmt -> fmtStr.equalsIgnoreCase(fmt.toString()));
    }

    private boolean checkValueType(Expression expr, Types.ValueType vt) {
        return vt == Types.ValueType.STRING && expr instanceof StringIdentifier || vt == Types.ValueType.FP64 && (expr instanceof DoubleIdentifier || expr instanceof IntIdentifier) || vt == Types.ValueType.BOOLEAN && expr instanceof BooleanIdentifier;
    }

    private void validateParams(boolean conditional, Set<String> validParamNames, String legalMessage) {
        for (String key : this._varParams.keySet()) {
            boolean found = validParamNames.contains(key);
            if (found) continue;
            this.raiseValidateError("unexpected parameter \"" + key + "\". " + legalMessage, conditional);
        }
    }

    private void performConstantPropagationRand(HashMap<String, ConstIdentifier> currConstVars) {
        String[] paramNamesForEval = new String[]{RAND_DATA, RAND_SPARSITY, RAND_MIN, RAND_MAX};
        this.performConstantPropagation(currConstVars, paramNamesForEval);
    }

    private void performConstantPropagationReadWrite(HashMap<String, ConstIdentifier> currConstVars) {
        String[] paramNamesForEval = new String[]{FORMAT_TYPE, IO_FILENAME, "rows", "cols", READNNZPARAM};
        this.performConstantPropagation(currConstVars, paramNamesForEval);
    }

    private void performConstantPropagation(HashMap<String, ConstIdentifier> currConstVars, String[] paramNames) {
        for (String paramName : paramNames) {
            Expression paramExp = this.getVarParam(paramName);
            if (paramExp == null || !(paramExp instanceof DataIdentifier) || paramExp instanceof IndexedIdentifier || !currConstVars.containsKey(((DataIdentifier)paramExp).getName())) continue;
            this.addVarParam(paramName, currConstVars.get(((DataIdentifier)paramExp).getName()));
        }
    }

    private String fileNameCat(BinaryExpression expr, HashMap<String, ConstIdentifier> currConstVars, String filename, boolean conditional) {
        String name;
        if (expr.getLeft() instanceof BinaryExpression && ((BinaryExpression)expr.getLeft()).getOpCode() == Expression.BinaryOp.PLUS) {
            filename = this.fileNameCat((BinaryExpression)expr.getLeft(), currConstVars, (String)filename, conditional) + (String)filename;
        } else if (expr.getLeft() instanceof ConstIdentifier) {
            filename = ((ConstIdentifier)expr.getLeft()).toString() + (String)filename;
        } else if (expr.getLeft() instanceof DataIdentifier && ((DataIdentifier)expr.getLeft()).getDataType() == Types.DataType.SCALAR) {
            name = ((DataIdentifier)expr.getLeft()).getName();
            filename = ((StringIdentifier)currConstVars.get(name)).getValue() + (String)filename;
        } else {
            this.raiseValidateError("Parameter iofilename only supports a const string or const string concatenations.", conditional);
        }
        if (expr.getRight() instanceof BinaryExpression && ((BinaryExpression)expr.getRight()).getOpCode() == Expression.BinaryOp.PLUS) {
            filename = (String)filename + this.fileNameCat((BinaryExpression)expr.getRight(), currConstVars, (String)filename, conditional);
        } else if (expr.getRight() instanceof ConstIdentifier) {
            filename = (String)filename + ((ConstIdentifier)expr.getRight()).toString();
        } else if (expr.getRight() instanceof DataIdentifier && ((DataIdentifier)expr.getRight()).getDataType() == Types.DataType.SCALAR && ((DataIdentifier)expr.getRight()).getValueType() == Types.ValueType.STRING) {
            name = ((DataIdentifier)expr.getRight()).getName();
            filename = (String)filename + ((StringIdentifier)currConstVars.get(name)).getValue();
        } else {
            this.raiseValidateError("Parameter iofilename only supports a const string or const string concatenations.", conditional);
        }
        return filename;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._opcode.toString());
        sb.append("(");
        boolean first = true;
        for (Map.Entry<String, Expression> e : this._varParams.entrySet()) {
            String key = e.getKey();
            Expression expr = e.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key);
            sb.append("=");
            if (expr instanceof StringIdentifier) {
                sb.append("\"");
                sb.append(expr);
                sb.append("\"");
                continue;
            }
            sb.append(expr);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (Expression expr : this._varParams.values()) {
            result.addVariables(expr.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (Expression expr : this._varParams.values()) {
            result.addVariables(expr.variablesUpdated());
        }
        result.addVariable(((DataIdentifier)this.getOutput()).getName(), (DataIdentifier)this.getOutput());
        return result;
    }

    public boolean isCSVReadWithUnknownSize() {
        Expression format = this.getVarParam(FORMAT_TYPE);
        if (this._opcode == Expression.DataOp.READ && format != null && this.checkFormatType(Types.FileFormat.CSV)) {
            Expression rows = this.getVarParam("rows");
            Expression cols = this.getVarParam("cols");
            return rows == null || Long.parseLong(rows.toString()) < 0L || cols == null || Long.parseLong(cols.toString()) < 0L;
        }
        return false;
    }

    public boolean isLIBSVMReadWithUnknownSize() {
        Expression format = this.getVarParam(FORMAT_TYPE);
        if (this._opcode == Expression.DataOp.READ && format != null && this.checkFormatType(Types.FileFormat.LIBSVM)) {
            Expression rows = this.getVarParam("rows");
            Expression cols = this.getVarParam("cols");
            return rows == null || Long.parseLong(rows.toString()) < 0L || cols == null || Long.parseLong(cols.toString()) < 0L;
        }
        return false;
    }

    public boolean isRead() {
        return this._opcode == Expression.DataOp.READ;
    }

    static {
        csvDefaults.put(DELIM_DELIMITER, DEFAULT_DELIM_DELIMITER);
        csvDefaults.put(DELIM_HAS_HEADER_ROW, false);
        csvDefaults.put(DELIM_FILL, true);
        csvDefaults.put(DELIM_FILL_VALUE, 0.0);
        csvDefaults.put(DELIM_SPARSE, false);
        csvDefaults.put(DELIM_NA_STRINGS, DEFAULT_NA_STRINGS);
        csvDefaults.put(SCHEMAPARAM, DEFAULT_SCHEMAPARAM);
        csvDefaults.put(LIBSVM_INDEX_DELIM, DEFAULT_LIBSVM_INDEX_DELIM);
    }
}

