/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.ArrayList;
import jcuda.Pointer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.runtime.codegen.SpoofCUDAOperator;
import org.apache.sysds.runtime.codegen.SpoofCellwise;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.matrix.data.LibMatrixCUDA;

public class SpoofCUDACellwise
extends SpoofCellwise
implements SpoofCUDAOperator {
    private static final long serialVersionUID = -5255791443086948200L;
    private static final Log LOG = LogFactory.getLog((String)SpoofCUDACellwise.class.getName());
    private final int ID;
    private final SpoofCUDAOperator.PrecisionProxy call;
    private final SpoofCellwise fallback_java_op;
    private final long ctx;

    public SpoofCUDACellwise(SpoofCellwise.CellType type, boolean sparseSafe, boolean containsSeq, SpoofCellwise.AggOp aggOp, int id, SpoofCUDAOperator.PrecisionProxy ep, SpoofCellwise fallback) {
        super(type, sparseSafe, containsSeq, aggOp);
        this.ID = id;
        this.call = ep;
        this.fallback_java_op = fallback;
        this.ctx = SpoofCompiler.native_contexts.get((Object)SpoofCompiler.GeneratorAPI.CUDA);
    }

    @Override
    public ScalarObject execute(ExecutionContext ec, ArrayList<MatrixObject> inputs, ArrayList<ScalarObject> scalarObjects) {
        double[] result = new double[1];
        Pointer[] ptr = new Pointer[1];
        this.packDataForTransfer(ec, inputs, scalarObjects, null, 1, this.ID, 0L, false, ptr);
        if (SpoofCUDACellwise.NotEmpty(inputs.get(0).getGPUObject(ec.getGPUContext(0))) && this.call.exec(this) != 0) {
            LOG.error((Object)("SpoofCUDA " + this.getSpoofType() + " operator " + this.ID + " failed to execute!\n"));
        }
        LibMatrixCUDA.cudaSupportFunctions.deviceToHost(ec.getGPUContext(0), ptr[0], result, this.getName(), false);
        ec.getGPUContext(0).cudaFreeHelper(this.getSpoofType(), ptr[0], DMLScript.EAGER_CUDA_FREE);
        return new DoubleObject(result[0]);
    }

    @Override
    public String getName() {
        return this.getSpoofType();
    }

    @Override
    public MatrixObject execute(ExecutionContext ec, ArrayList<MatrixObject> inputs, ArrayList<ScalarObject> scalarObjects, String outputName) {
        long out_rows = ec.getMatrixObject(outputName).getNumRows();
        long out_cols = ec.getMatrixObject(outputName).getNumColumns();
        if (this._type == SpoofCellwise.CellType.COL_AGG) {
            out_rows = 1L;
        } else if (this._type == SpoofCellwise.CellType.ROW_AGG) {
            out_cols = 1L;
        }
        double[] scalars = SpoofCUDACellwise.prepInputScalars(scalarObjects);
        boolean sparseSafe = this.isSparseSafe() || inputs.size() < 2 && this.genexec(0.0, new SpoofOperator.SideInput[0], scalars, (int)inputs.get(0).getNumRows(), (int)inputs.get(0).getNumColumns(), 0, 0) == 0.0;
        GPUObject in_obj = inputs.get(0).getGPUObject(ec.getGPUContext(0));
        boolean sparseOut = this._type == SpoofCellwise.CellType.NO_AGG && sparseSafe && in_obj.isSparse();
        long nnz = in_obj.getNnz("spoofCUDA" + this.getSpoofType(), false);
        MatrixObject out_obj = sparseOut ? ec.getSparseMatrixOutputForGPUInstruction(outputName, out_rows, out_cols, this.isSparseSafe() && nnz > 0L ? nnz : out_rows * out_cols, false).getKey() : ec.getDenseMatrixOutputForGPUInstruction(outputName, out_rows, out_cols, false).getKey();
        this.packDataForTransfer(ec, inputs, scalarObjects, out_obj, 1, this.ID, 0L, false, null);
        if ((SpoofCUDACellwise.NotEmpty(in_obj) || !sparseSafe) && this.call.exec(this) != 0) {
            LOG.error((Object)("SpoofCUDA " + this.getSpoofType() + " operator " + this.ID + " failed to execute!\n"));
        }
        return out_obj;
    }

    private static boolean NotEmpty(GPUObject g) {
        return g.getDensePointer() != null || g.getSparseMatrixCudaPointer() != null;
    }

    @Override
    protected double genexec(double a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, long gix, int rix, int cix) {
        return this.fallback_java_op.genexec(a, b, scalars, m, n, 0L, 0, 0);
    }

    @Override
    public int execute_dp(long ctx) {
        return SpoofCUDACellwise.execute_d(ctx);
    }

    @Override
    public int execute_sp(long ctx) {
        return SpoofCUDACellwise.execute_f(ctx);
    }

    @Override
    public long getContext() {
        return this.ctx;
    }

    public static native int execute_d(long var0);

    public static native int execute_f(long var0);
}

