/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class DeltaDictionary
extends ADictionary {
    private static final long serialVersionUID = -5700139221491143705L;
    private final int _numCols;
    protected final double[] _values;

    public DeltaDictionary(double[] values, int numCols) {
        this._values = values;
        this._numCols = numCols;
    }

    @Override
    public double[] getValues() {
        return this._values;
    }

    @Override
    public DeltaDictionary applyScalarOp(ScalarOperator op) {
        double[] retV = new double[this._values.length];
        if (op.fn instanceof Multiply || op.fn instanceof Divide) {
            for (int i = 0; i < this._values.length; ++i) {
                retV[i] = op.executeScalar(this._values[i]);
            }
        } else if (op.fn instanceof Plus || op.fn instanceof Minus) {
            for (int i = 0; i < this._values.length; ++i) {
                retV[i] = i < this._numCols ? op.executeScalar(this._values[i]) : this._values[i];
            }
        } else {
            throw new NotImplementedException();
        }
        return new DeltaDictionary(retV, this._numCols);
    }

    @Override
    public long getInMemorySize() {
        return Dictionary.getInMemorySize(this._values.length);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public long getExactSizeOnDisk() {
        throw new NotImplementedException();
    }

    @Override
    public IDictionary.DictType getDictType() {
        throw new NotImplementedException();
    }

    @Override
    public int getNumberOfValues(int ncol) {
        return this._values.length / ncol;
    }

    @Override
    public int getNumberOfColumns(int nrow) {
        return this._values.length / nrow;
    }

    @Override
    public String getString(int colIndexes) {
        throw new NotImplementedException();
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(IDictionary o) {
        throw new NotImplementedException();
    }

    @Override
    public IDictionary clone() {
        throw new NotImplementedException();
    }
}

