/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.InstructionType;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.And;
import org.apache.sysds.runtime.functionobjects.BitwAnd;
import org.apache.sysds.runtime.functionobjects.BitwOr;
import org.apache.sysds.runtime.functionobjects.BitwShiftL;
import org.apache.sysds.runtime.functionobjects.BitwShiftR;
import org.apache.sysds.runtime.functionobjects.BitwXor;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Equals;
import org.apache.sysds.runtime.functionobjects.GreaterThan;
import org.apache.sysds.runtime.functionobjects.GreaterThanEquals;
import org.apache.sysds.runtime.functionobjects.IfElse;
import org.apache.sysds.runtime.functionobjects.IndexFunction;
import org.apache.sysds.runtime.functionobjects.IntegerDivide;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.LessThan;
import org.apache.sysds.runtime.functionobjects.LessThanEquals;
import org.apache.sysds.runtime.functionobjects.Mean;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Minus1Multiply;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.MinusNz;
import org.apache.sysds.runtime.functionobjects.Modulus;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Multiply2;
import org.apache.sysds.runtime.functionobjects.Not;
import org.apache.sysds.runtime.functionobjects.NotEquals;
import org.apache.sysds.runtime.functionobjects.Or;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.PlusMultiply;
import org.apache.sysds.runtime.functionobjects.Power;
import org.apache.sysds.runtime.functionobjects.Power2;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceCol;
import org.apache.sysds.runtime.functionobjects.ReduceDiag;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.functionobjects.Xor;
import org.apache.sysds.runtime.instructions.GPUInstructionParser;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.matrix.data.LibCommonsMath;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperator;
import org.apache.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnarySketchOperator;

public class InstructionUtils {
    protected static final Log LOG = LogFactory.getLog((String)InstructionUtils.class.getName());
    private static ThreadLocal<StringBuilder> _strBuilders = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder(64);
        }
    };

    public static StringBuilder getStringBuilder() {
        StringBuilder sb = _strBuilders.get();
        sb.setLength(0);
        return sb;
    }

    public static int checkNumFields(String str, int expected) {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        if (numFields != expected) {
            throw new DMLRuntimeException("checkNumFields() for (" + str + ") -- expected number (" + expected + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int expected) {
        int numParts = parts.length;
        int numFields = numParts - 1;
        if (numFields != expected) {
            throw new DMLRuntimeException("checkNumFields() -- expected number (" + expected + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int expected1, int expected2) {
        int numParts = parts.length;
        int numFields = numParts - 1;
        if (numFields != expected1 && numFields != expected2) {
            throw new DMLRuntimeException("checkNumFields() -- expected number (" + expected1 + " or " + expected2 + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static int checkNumFields(String[] parts, int ... expected) {
        int numParts = parts.length;
        int numFields = numParts - 1;
        return InstructionUtils.checkMatchingNumField(numFields, expected);
    }

    private static int checkMatchingNumField(int numFields, int ... expected) {
        if (Arrays.stream(expected).noneMatch(i -> numFields == i)) {
            StringBuilder sb = new StringBuilder();
            sb.append("checkNumFields() -- expected number (");
            for (int i2 = 0; i2 < expected.length; ++i2) {
                sb.append(expected[i2]);
                if (i2 == expected.length - 1) continue;
                sb.append(", ");
            }
            sb.append(") != is not equal to actual number (").append(numFields).append(").");
            throw new DMLRuntimeException(sb.toString());
        }
        return numFields;
    }

    public static int checkNumFields(String str, int ... expected) {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        return InstructionUtils.checkMatchingNumField(numFields, expected);
    }

    public static int checkNumFields(String str, int expected1, int expected2) {
        int numParts = str.split("\u00b0").length;
        int numFields = numParts - 2;
        if (numFields != expected1 && numFields != expected2) {
            throw new DMLRuntimeException("checkNumFields() for (" + str + ") -- expected number (" + expected1 + " or " + expected2 + ") != is not equal to actual number (" + numFields + ").");
        }
        return numFields;
    }

    public static String[] getInstructionParts(String str) {
        StringTokenizer st = new StringTokenizer(str, "\u00b0");
        String[] ret = new String[st.countTokens() - 1];
        st.nextToken();
        ret[0] = st.nextToken();
        int index = 1;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            int ix = tmp.indexOf("\u00b7");
            ret[index++] = tmp.substring(0, ix >= 0 ? ix : tmp.length());
        }
        return ret;
    }

    public static String[] getInstructionPartsWithValueType(String str) {
        String[] parts = str.split("\u00b0", -1);
        String[] ret = new String[parts.length - 1];
        ret[0] = parts[1];
        for (int i = 1; i < parts.length; ++i) {
            ret[i - 1] = parts[i];
        }
        return ret;
    }

    public static String stripThreadCount(String str) {
        String[] parts = str.split("\u00b0", -1);
        String[] ret = new String[parts.length - 1];
        for (int i = 0; i < parts.length - 1; ++i) {
            ret[i] = parts[i];
        }
        return InstructionUtils.concatOperands(ret);
    }

    public static Types.ExecType getExecType(String str) {
        try {
            int ix = str.indexOf("\u00b0");
            return Types.ExecType.valueOf(str.substring(0, ix));
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Unable to extract Execution type from " + str, e);
        }
    }

    public static String getOpCode(String str) {
        int ix1 = str.indexOf("\u00b0");
        int ix2 = str.indexOf("\u00b0", ix1 + 1);
        return str.substring(ix1 + 1, ix2);
    }

    public static InstructionType getSPType(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        return Opcodes.getTypeByOpcode(opcode, Types.ExecType.SPARK);
    }

    public static InstructionType getCPType(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        return Opcodes.getTypeByOpcode(opcode, Types.ExecType.CP);
    }

    public static InstructionType getSPTypeByOpcode(String opcode) {
        String op = InstructionUtils.getOpCode(opcode);
        return Opcodes.getTypeByOpcode(op, Types.ExecType.SPARK);
    }

    public static InstructionType getCPTypeByOpcode(String opcode) {
        String op = InstructionUtils.getOpCode(opcode);
        return Opcodes.getTypeByOpcode(op, Types.ExecType.CP);
    }

    public static GPUInstruction.GPUINSTRUCTION_TYPE getGPUType(String str) {
        return GPUInstructionParser.String2GPUInstructionType.get(InstructionUtils.getOpCode(str));
    }

    public static InstructionType getFEDType(String str) {
        String op = InstructionUtils.getOpCode(str);
        return Opcodes.getTypeByOpcode(op, Types.ExecType.FED);
    }

    public static boolean isBuiltinFunction(String opcode) {
        Builtin.BuiltinCode bfc = Builtin.String2BuiltinCode.get(opcode);
        return bfc != null;
    }

    public static boolean isUnaryMetadata(String opcode) {
        return opcode != null && (opcode.equals("nrow") || opcode.equals("ncol"));
    }

    public static AggregateUnaryOperator parseBasicAggregateUnaryOperator(String opcode) {
        return InstructionUtils.parseBasicAggregateUnaryOperator(opcode, 1);
    }

    public static AggregateUnaryOperator parseBasicAggregateUnaryOperator(String opcode, int numThreads) {
        AggregateUnaryOperator aggun = null;
        if (opcode.equalsIgnoreCase(Opcodes.UAKP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARKP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACKP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UASQKP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARSQKP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACSQKP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), Types.CorrectionLocationType.LASTROW);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAMEAN.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), Types.CorrectionLocationType.LASTTWOCOLUMNS);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARMEAN.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), Types.CorrectionLocationType.LASTTWOCOLUMNS);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACMEAN.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Mean.getMeanFnObject(), Types.CorrectionLocationType.LASTTWOROWS);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAVAR.toString())) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            Types.CorrectionLocationType cloc = Types.CorrectionLocationType.LASTFOURCOLUMNS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARVAR.toString())) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            Types.CorrectionLocationType cloc = Types.CorrectionLocationType.LASTFOURCOLUMNS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACVAR.toString())) {
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            Types.CorrectionLocationType cloc = Types.CorrectionLocationType.LASTFOURROWS;
            AggregateOperator agg = new AggregateOperator(0.0, varFn, cloc);
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACP.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAM.toString())) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARM.toString())) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACM.toString())) {
            AggregateOperator agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAMAX.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAMIN.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceAll.getReduceAllFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UATRACE.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            aggun = new AggregateUnaryOperator(agg, ReduceDiag.getReduceDiagFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UAKTRACE.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceDiag.getReduceDiagFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARMAX.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARIMAX.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("maxindex"), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARMIN.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARIMIN.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("minindex"), Types.CorrectionLocationType.LASTCOLUMN);
            aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACMAX.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACMIN.toString())) {
            AggregateOperator agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
            aggun = new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject(), numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UACD.toString())) {
            aggun = new CountDistinctOperator(AggregateUnaryCPInstruction.AUType.COUNT_DISTINCT, Types.Direction.RowCol, ReduceAll.getReduceAllFnObject());
        } else if (opcode.equalsIgnoreCase(Opcodes.UACDR.toString())) {
            aggun = new CountDistinctOperator(AggregateUnaryCPInstruction.AUType.COUNT_DISTINCT, Types.Direction.Row, ReduceCol.getReduceColFnObject());
        } else if (opcode.equalsIgnoreCase(Opcodes.UACDC.toString())) {
            aggun = new CountDistinctOperator(AggregateUnaryCPInstruction.AUType.COUNT_DISTINCT, Types.Direction.Col, ReduceRow.getReduceRowFnObject());
        } else if (opcode.equalsIgnoreCase(Opcodes.UACDAP.toString())) {
            aggun = new CountDistinctOperator(AggregateUnaryCPInstruction.AUType.COUNT_DISTINCT_APPROX, Types.Direction.RowCol, ReduceAll.getReduceAllFnObject());
        } else if (opcode.equalsIgnoreCase(Opcodes.UACDAPR.toString())) {
            aggun = new CountDistinctOperator(AggregateUnaryCPInstruction.AUType.COUNT_DISTINCT_APPROX, Types.Direction.Row, ReduceCol.getReduceColFnObject());
        } else if (opcode.equalsIgnoreCase(Opcodes.UACDAPC.toString())) {
            aggun = new CountDistinctOperator(AggregateUnaryCPInstruction.AUType.COUNT_DISTINCT_APPROX, Types.Direction.Col, ReduceRow.getReduceRowFnObject());
        } else if (opcode.equalsIgnoreCase(Opcodes.UNIQUE.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("unique"));
            aggun = new UnarySketchOperator(agg, ReduceAll.getReduceAllFnObject(), Types.Direction.RowCol, numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UNIQUER.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("unique"));
            aggun = new UnarySketchOperator(agg, ReduceCol.getReduceColFnObject(), Types.Direction.Row, numThreads);
        } else if (opcode.equalsIgnoreCase(Opcodes.UNIQUEC.toString())) {
            AggregateOperator agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("unique"));
            aggun = new UnarySketchOperator(agg, ReduceRow.getReduceRowFnObject(), Types.Direction.Col, numThreads);
        }
        return aggun;
    }

    public static AggregateUnaryOperator parseAggregateUnaryRowIndexOperator(String opcode, int numOutputs, int numThreads) {
        AggregateUnaryOperator aggun = null;
        AggregateOperator agg = null;
        if (opcode.equalsIgnoreCase(Opcodes.UARIMAX.toString())) {
            agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("maxindex"), numOutputs == 1 ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.NONE);
        } else if (opcode.equalsIgnoreCase(Opcodes.UARIMIN.toString())) {
            agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("minindex"), numOutputs == 1 ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.NONE);
        }
        aggun = new AggregateUnaryOperator(agg, ReduceCol.getReduceColFnObject(), numThreads);
        return aggun;
    }

    public static AggregateTernaryOperator parseAggregateTernaryOperator(String opcode) {
        return InstructionUtils.parseAggregateTernaryOperator(opcode, 1);
    }

    public static AggregateTernaryOperator parseAggregateTernaryOperator(String opcode, int numThreads) {
        Types.CorrectionLocationType corr = opcode.equalsIgnoreCase(Opcodes.TAKPM.toString()) ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.LASTROW;
        AggregateOperator agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), corr);
        IndexFunction ixfun = opcode.equalsIgnoreCase(Opcodes.TAKPM.toString()) ? ReduceAll.getReduceAllFnObject() : ReduceRow.getReduceRowFnObject();
        return new AggregateTernaryOperator(Multiply.getMultiplyFnObject(), agg, ixfun, numThreads);
    }

    public static AggregateOperator parseAggregateOperator(String opcode, String corrLoc) {
        AggregateOperator agg = null;
        if (opcode.equalsIgnoreCase("ak+") || opcode.equalsIgnoreCase("aktrace")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), lcorrLoc);
        } else if (opcode.equalsIgnoreCase("asqk+")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTCOLUMN : Types.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlusSq.getKahanPlusSqFnObject(), lcorrLoc);
        } else if (opcode.equalsIgnoreCase("a+")) {
            agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        } else if (opcode.equalsIgnoreCase("a*")) {
            agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject());
        } else if (opcode.equalsIgnoreCase("arimax")) {
            agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("maxindex"), Types.CorrectionLocationType.LASTCOLUMN);
        } else if (opcode.equalsIgnoreCase("amax")) {
            agg = new AggregateOperator(Double.NEGATIVE_INFINITY, Builtin.getBuiltinFnObject("max"));
        } else if (opcode.equalsIgnoreCase("amin")) {
            agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("min"));
        } else if (opcode.equalsIgnoreCase("arimin")) {
            agg = new AggregateOperator(Double.POSITIVE_INFINITY, Builtin.getBuiltinFnObject("minindex"), Types.CorrectionLocationType.LASTCOLUMN);
        } else if (opcode.equalsIgnoreCase("amean")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTTWOCOLUMNS : Types.CorrectionLocationType.valueOf(corrLoc);
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), lcorrLoc);
        } else if (opcode.equalsIgnoreCase("avar")) {
            Types.CorrectionLocationType lcorrLoc = corrLoc == null ? Types.CorrectionLocationType.LASTFOURCOLUMNS : Types.CorrectionLocationType.valueOf(corrLoc);
            CM varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
            agg = new AggregateOperator(0.0, varFn, lcorrLoc);
        }
        return agg;
    }

    public static AggregateUnaryOperator parseBasicCumulativeAggregateUnaryOperator(UnaryOperator uop) {
        Builtin f = (Builtin)uop.fn;
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMSUM) {
            return InstructionUtils.parseBasicAggregateUnaryOperator(Opcodes.UACKP.toString());
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMPROD) {
            return InstructionUtils.parseBasicAggregateUnaryOperator(Opcodes.UACM.toString());
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMMIN) {
            return InstructionUtils.parseBasicAggregateUnaryOperator(Opcodes.UACMIN.toString());
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMMAX) {
            return InstructionUtils.parseBasicAggregateUnaryOperator(Opcodes.UACMAX.toString());
        }
        if (f.getBuiltinCode() == Builtin.BuiltinCode.CUMSUMPROD) {
            return InstructionUtils.parseBasicAggregateUnaryOperator("uack+*");
        }
        throw new RuntimeException("Unsupported cumulative aggregate unary operator: " + f.getBuiltinCode());
    }

    public static AggregateUnaryOperator parseCumulativeAggregateUnaryOperator(String opcode) {
        AggregateOperator agg = null;
        if (Opcodes.UCUMACKP.toString().equals(opcode)) {
            agg = new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTROW);
        } else if (Opcodes.UCUMACM.toString().equals(opcode)) {
            agg = new AggregateOperator(1.0, Multiply.getMultiplyFnObject(), Types.CorrectionLocationType.NONE);
        } else if (Opcodes.UCUMACPM.toString().equals(opcode)) {
            agg = new AggregateOperator(0.0, PlusMultiply.getFnObject(), Types.CorrectionLocationType.NONE);
        } else if (Opcodes.UCUMACMIN.toString().equals(opcode)) {
            agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("min"), Types.CorrectionLocationType.NONE);
        } else if (Opcodes.UCUMACMAX.toString().equals(opcode)) {
            agg = new AggregateOperator(0.0, Builtin.getBuiltinFnObject("max"), Types.CorrectionLocationType.NONE);
        }
        return new AggregateUnaryOperator(agg, ReduceRow.getReduceRowFnObject());
    }

    public static UnaryOperator parseUnaryOperator(String opcode) {
        return opcode.equals(Opcodes.NOT.toString()) ? new UnaryOperator(Not.getNotFnObject()) : new UnaryOperator(Builtin.getBuiltinFnObject(opcode));
    }

    public static UnaryOperator parseUnaryOperator(String opcode, int k) {
        return opcode.equals(Opcodes.NOT.toString()) ? new UnaryOperator(Not.getNotFnObject(), k) : new UnaryOperator(Builtin.getBuiltinFnObject(opcode), k);
    }

    public static MultiThreadedOperator parseBinaryOrBuiltinOperator(String opcode, CPOperand in1, CPOperand in2) {
        boolean matrixScalar;
        if (LibCommonsMath.isSupportedMatrixMatrixOperation(opcode)) {
            return null;
        }
        boolean bl = matrixScalar = in1.getDataType() != in2.getDataType();
        return Builtin.isBuiltinFnObject(opcode) ? (matrixScalar ? new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), 0.0) : new BinaryOperator(Builtin.getBuiltinFnObject(opcode))) : (matrixScalar ? InstructionUtils.parseScalarBinaryOperator(opcode, in1.getDataType().isScalar()) : InstructionUtils.parseBinaryOperator(opcode));
    }

    public static Operator parseExtendedBinaryOrBuiltinOperator(String opcode, CPOperand in1, CPOperand in2) {
        boolean matrixScalar;
        boolean bl = matrixScalar = in1.getDataType() != in2.getDataType() && in1.getDataType() != Types.DataType.FRAME && in2.getDataType() != Types.DataType.FRAME;
        return Builtin.isBuiltinFnObject(opcode) ? (matrixScalar ? new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), 0.0) : new BinaryOperator(Builtin.getBuiltinFnObject(opcode))) : (matrixScalar ? InstructionUtils.parseScalarBinaryOperator(opcode, in1.getDataType().isScalar()) : InstructionUtils.parseExtendedBinaryOperator(opcode));
    }

    public static BinaryOperator parseBinaryOperator(String opcode, int k) {
        BinaryOperator bop = InstructionUtils.parseBinaryOperator(opcode);
        bop.setNumThreads(k);
        return bop;
    }

    public static BinaryOperator parseBinaryOperator(String opcode) {
        if (opcode.equalsIgnoreCase(Opcodes.EQUAL.toString())) {
            return new BinaryOperator(Equals.getEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.NOTEQUAL.toString())) {
            return new BinaryOperator(NotEquals.getNotEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.LESS.toString())) {
            return new BinaryOperator(LessThan.getLessThanFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.GREATER.toString())) {
            return new BinaryOperator(GreaterThan.getGreaterThanFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.LESSEQUAL.toString())) {
            return new BinaryOperator(LessThanEquals.getLessThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.GREATEREQUAL.toString())) {
            return new BinaryOperator(GreaterThanEquals.getGreaterThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.AND.toString())) {
            return new BinaryOperator(And.getAndFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.OR.toString())) {
            return new BinaryOperator(Or.getOrFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.XOR.toString())) {
            return new BinaryOperator(Xor.getXorFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWAND.toString())) {
            return new BinaryOperator(BitwAnd.getBitwAndFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWOR.toString())) {
            return new BinaryOperator(BitwOr.getBitwOrFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWXOR.toString())) {
            return new BinaryOperator(BitwXor.getBitwXorFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWSHIFTL.toString())) {
            return new BinaryOperator(BitwShiftL.getBitwShiftLFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWSHIFTR.toString())) {
            return new BinaryOperator(BitwShiftR.getBitwShiftRFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.PLUS.toString())) {
            return new BinaryOperator(Plus.getPlusFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS.toString())) {
            return new BinaryOperator(Minus.getMinusFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MULT.toString())) {
            return new BinaryOperator(Multiply.getMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS1_MULT.toString())) {
            return new BinaryOperator(Minus1Multiply.getMinus1MultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MULT2.toString())) {
            return new BinaryOperator(Multiply2.getMultiply2FnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.DIV.toString())) {
            return new BinaryOperator(Divide.getDivideFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MODULUS.toString())) {
            return new BinaryOperator(Modulus.getFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.INTDIV.toString())) {
            return new BinaryOperator(IntegerDivide.getFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.POW.toString())) {
            return new BinaryOperator(Power.getPowerFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.POW2.toString())) {
            return new BinaryOperator(Power2.getPower2FnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MAX.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("max"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.MIN.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("min"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.DROPINVALIDTYPE.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("dropInvalidType"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.DROPINVALIDLENGTH.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("dropInvalidLength"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.VALUESWAP.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("valueSwap"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.FREPLICATE.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("freplicate"));
        }
        throw new RuntimeException("Unknown binary opcode " + opcode);
    }

    public static TernaryOperator parseTernaryOperator(String opcode) {
        return InstructionUtils.parseTernaryOperator(opcode, 1);
    }

    public static TernaryOperator parseTernaryOperator(String opcode, int numThreads) {
        return new TernaryOperator(opcode.equals(Opcodes.PM.toString()) ? PlusMultiply.getFnObject() : (opcode.equals(Opcodes.MINUSMULT.toString()) ? MinusMultiply.getFnObject() : IfElse.getFnObject()), numThreads);
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar) {
        double default_constant = 0.0;
        return InstructionUtils.parseScalarBinaryOperator(opcode, arg1IsScalar, default_constant);
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar, double constant) {
        if (opcode.equalsIgnoreCase(Opcodes.PLUS.toString())) {
            return new RightScalarOperator(Plus.getPlusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MULT.toString())) {
            return new RightScalarOperator(Multiply.getMultiplyFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Minus.getMinusFnObject(), constant);
            }
            return new RightScalarOperator(Minus.getMinusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS_NZ.toString())) {
            return new RightScalarOperator(MinusNz.getMinusNzFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.DIV.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Divide.getDivideFnObject(), constant);
            }
            return new RightScalarOperator(Divide.getDivideFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MODULUS.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Modulus.getFnObject(), constant);
            }
            return new RightScalarOperator(Modulus.getFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.INTDIV.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(IntegerDivide.getFnObject(), constant);
            }
            return new RightScalarOperator(IntegerDivide.getFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.POW.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Power.getPowerFnObject(), constant);
            }
            return new RightScalarOperator(Power.getPowerFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MAX.toString())) {
            return new RightScalarOperator(Builtin.getBuiltinFnObject("max"), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MIN.toString())) {
            return new RightScalarOperator(Builtin.getBuiltinFnObject("min"), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.LOG.toString()) || opcode.equalsIgnoreCase(Opcodes.LOGNZ.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Builtin.getBuiltinFnObject(opcode), constant);
            }
            return new RightScalarOperator(Builtin.getBuiltinFnObject(opcode), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.GREATER.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(GreaterThan.getGreaterThanFnObject(), constant);
            }
            return new RightScalarOperator(GreaterThan.getGreaterThanFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.GREATEREQUAL.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(GreaterThanEquals.getGreaterThanEqualsFnObject(), constant);
            }
            return new RightScalarOperator(GreaterThanEquals.getGreaterThanEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.LESS.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(LessThan.getLessThanFnObject(), constant);
            }
            return new RightScalarOperator(LessThan.getLessThanFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.LESSEQUAL.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(LessThanEquals.getLessThanEqualsFnObject(), constant);
            }
            return new RightScalarOperator(LessThanEquals.getLessThanEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.EQUAL.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(Equals.getEqualsFnObject(), constant);
            }
            return new RightScalarOperator(Equals.getEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.NOTEQUAL.toString())) {
            if (arg1IsScalar) {
                return new LeftScalarOperator(NotEquals.getNotEqualsFnObject(), constant);
            }
            return new RightScalarOperator(NotEquals.getNotEqualsFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.AND.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(And.getAndFnObject(), constant) : new RightScalarOperator(And.getAndFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.OR.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(Or.getOrFnObject(), constant) : new RightScalarOperator(Or.getOrFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.XOR.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(Xor.getXorFnObject(), constant) : new RightScalarOperator(Xor.getXorFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWAND.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(BitwAnd.getBitwAndFnObject(), constant) : new RightScalarOperator(BitwAnd.getBitwAndFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWOR.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(BitwOr.getBitwOrFnObject(), constant) : new RightScalarOperator(BitwOr.getBitwOrFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWXOR.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(BitwXor.getBitwXorFnObject(), constant) : new RightScalarOperator(BitwXor.getBitwXorFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWSHIFTL.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(BitwShiftL.getBitwShiftLFnObject(), constant) : new RightScalarOperator(BitwShiftL.getBitwShiftLFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWSHIFTR.toString())) {
            return arg1IsScalar ? new LeftScalarOperator(BitwShiftR.getBitwShiftRFnObject(), constant) : new RightScalarOperator(BitwShiftR.getBitwShiftRFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MULT2.toString())) {
            return new RightScalarOperator(Multiply2.getMultiply2FnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.POW2.toString())) {
            return new RightScalarOperator(Power2.getPower2FnObject(), constant);
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS1_MULT.toString())) {
            return new RightScalarOperator(Minus1Multiply.getMinus1MultiplyFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("s-r")) {
            return new LeftScalarOperator(Minus.getMinusFnObject(), constant);
        }
        if (opcode.equalsIgnoreCase("so")) {
            return new LeftScalarOperator(Divide.getDivideFnObject(), constant);
        }
        throw new RuntimeException("Unknown binary opcode " + opcode);
    }

    public static BinaryOperator parseExtendedBinaryOperator(String opcode) {
        if (opcode.equalsIgnoreCase(Opcodes.EQUAL.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPEQ.toString())) {
            return new BinaryOperator(Equals.getEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.NOTEQUAL.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPNEQ.toString())) {
            return new BinaryOperator(NotEquals.getNotEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.LESS.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPLT.toString())) {
            return new BinaryOperator(LessThan.getLessThanFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.GREATER.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPGT.toString())) {
            return new BinaryOperator(GreaterThan.getGreaterThanFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.LESSEQUAL.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPLE.toString())) {
            return new BinaryOperator(LessThanEquals.getLessThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.GREATEREQUAL.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPGE.toString())) {
            return new BinaryOperator(GreaterThanEquals.getGreaterThanEqualsFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.AND.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPAND.toString())) {
            return new BinaryOperator(And.getAndFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.OR.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPOR.toString())) {
            return new BinaryOperator(Or.getOrFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.XOR.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPXOR.toString())) {
            return new BinaryOperator(Xor.getXorFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWAND.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPBITWAND.toString())) {
            return new BinaryOperator(BitwAnd.getBitwAndFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWOR.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPBITWOR.toString())) {
            return new BinaryOperator(BitwOr.getBitwOrFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWXOR.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPBITWXOR.toString())) {
            return new BinaryOperator(BitwXor.getBitwXorFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWSHIFTL.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPBITWSHIFTL.toString())) {
            return new BinaryOperator(BitwShiftL.getBitwShiftLFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.BITWSHIFTR.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPBITWSHIFTR.toString())) {
            return new BinaryOperator(BitwShiftR.getBitwShiftRFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.PLUS.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPPLUS.toString())) {
            return new BinaryOperator(Plus.getPlusFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPMINUS.toString())) {
            return new BinaryOperator(Minus.getMinusFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MULT.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPMULT.toString())) {
            return new BinaryOperator(Multiply.getMultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MINUS1_MULT.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPMINUS1_MULT.toString())) {
            return new BinaryOperator(Minus1Multiply.getMinus1MultiplyFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MULT2.toString())) {
            return new BinaryOperator(Multiply2.getMultiply2FnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.DIV.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPDIV.toString())) {
            return new BinaryOperator(Divide.getDivideFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MODULUS.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPMOD.toString())) {
            return new BinaryOperator(Modulus.getFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.INTDIV.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPINTDIV.toString())) {
            return new BinaryOperator(IntegerDivide.getFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.POW.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPPOW.toString())) {
            return new BinaryOperator(Power.getPowerFnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.POW2.toString())) {
            return new BinaryOperator(Power2.getPower2FnObject());
        }
        if (opcode.equalsIgnoreCase(Opcodes.MAX.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPMAX.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("max"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.MIN.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPMIN.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("min"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.DROPINVALIDLENGTH.toString()) || opcode.equalsIgnoreCase(Opcodes.MAPDROPINVALIDLENGTH.toString())) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("dropInvalidLength"));
        }
        if (opcode.equalsIgnoreCase(Opcodes.VALUESWAP.toString()) || opcode.equalsIgnoreCase("mapValueSwap")) {
            return new BinaryOperator(Builtin.getBuiltinFnObject("valueSwap"));
        }
        throw new DMLRuntimeException("Unknown binary opcode " + opcode);
    }

    public static ScalarOperator parseScalarBinaryOperator(String opcode, boolean arg1IsScalar, double constant, int k) {
        ScalarOperator sop = InstructionUtils.parseScalarBinaryOperator(opcode, arg1IsScalar, constant);
        sop.setNumThreads(k);
        return sop;
    }

    public static String deriveAggregateOperatorOpcode(String opcode) {
        switch (opcode) {
            case "uak+": 
            case "uark+": 
            case "uack+": {
                return "ak+";
            }
            case "uacd": 
            case "ua+": 
            case "uar+": 
            case "uac+": {
                return "a+";
            }
            case "uatrace": 
            case "uaktrace": {
                return "aktrace";
            }
            case "uasqk+": 
            case "uarsqk+": 
            case "uacsqk+": {
                return "asqk+";
            }
            case "uamean": 
            case "uarmean": 
            case "uacmean": {
                return "amean";
            }
            case "uavar": 
            case "uarvar": 
            case "uacvar": {
                return "avar";
            }
            case "ua*": 
            case "uar*": 
            case "uac*": {
                return "a*";
            }
            case "uamax": 
            case "uarmax": 
            case "uacmax": {
                return "amax";
            }
            case "uamin": 
            case "uarmin": 
            case "uacmin": {
                return "amin";
            }
            case "uarimax": {
                return "arimax";
            }
            case "uarimin": {
                return "arimin";
            }
        }
        return null;
    }

    public static Types.AggOp getAggOp(String opcode) {
        switch (opcode) {
            case "uak+": 
            case "uark+": 
            case "uack+": 
            case "ua+": 
            case "uar+": 
            case "uac+": 
            case "uatrace": 
            case "uaktrace": {
                return Types.AggOp.SUM;
            }
            case "uasqk+": 
            case "uarsqk+": 
            case "uacsqk+": {
                return Types.AggOp.SUM_SQ;
            }
            case "uamean": 
            case "uarmean": 
            case "uacmean": {
                return Types.AggOp.MEAN;
            }
            case "uavar": 
            case "uarvar": 
            case "uacvar": {
                return Types.AggOp.VAR;
            }
            case "ua*": 
            case "uar*": 
            case "uac*": {
                return Types.AggOp.PROD;
            }
            case "uamax": 
            case "uarmax": 
            case "uacmax": {
                return Types.AggOp.MAX;
            }
            case "uamin": 
            case "uarmin": 
            case "uacmin": {
                return Types.AggOp.MIN;
            }
            case "uarimax": {
                return Types.AggOp.MAXINDEX;
            }
            case "uarimin": {
                return Types.AggOp.MININDEX;
            }
        }
        return null;
    }

    public static Types.Direction getAggDirection(String opcode) {
        switch (opcode) {
            case "uak+": 
            case "ua+": 
            case "uatrace": 
            case "uaktrace": 
            case "uasqk+": 
            case "uamean": 
            case "uavar": 
            case "ua*": 
            case "uamax": 
            case "uamin": {
                return Types.Direction.RowCol;
            }
            case "uark+": 
            case "uar+": 
            case "uarsqk+": 
            case "uarmean": 
            case "uar*": 
            case "uarmax": 
            case "uarmin": 
            case "uarimax": 
            case "uarimin": {
                return Types.Direction.Row;
            }
            case "uack+": 
            case "uac+": 
            case "uacsqk+": 
            case "uacmean": 
            case "uarvar": 
            case "uacvar": 
            case "uac*": 
            case "uacmax": 
            case "uacmin": {
                return Types.Direction.Col;
            }
        }
        return null;
    }

    public static Types.CorrectionLocationType deriveAggregateOperatorCorrectionLocation(String opcode) {
        if (opcode.equalsIgnoreCase(Opcodes.UAKP.toString()) || opcode.equalsIgnoreCase(Opcodes.UARKP.toString()) || opcode.equalsIgnoreCase(Opcodes.UASQKP.toString()) || opcode.equalsIgnoreCase(Opcodes.UARSQKP.toString()) || opcode.equalsIgnoreCase(Opcodes.UATRACE.toString()) || opcode.equalsIgnoreCase(Opcodes.UAKTRACE.toString())) {
            return Types.CorrectionLocationType.LASTCOLUMN;
        }
        if (opcode.equalsIgnoreCase(Opcodes.UACKP.toString()) || opcode.equalsIgnoreCase(Opcodes.UACSQKP.toString())) {
            return Types.CorrectionLocationType.LASTROW;
        }
        if (opcode.equalsIgnoreCase(Opcodes.UAMEAN.toString()) || opcode.equalsIgnoreCase(Opcodes.UARMEAN.toString())) {
            return Types.CorrectionLocationType.LASTTWOCOLUMNS;
        }
        if (opcode.equalsIgnoreCase(Opcodes.UACMEAN.toString())) {
            return Types.CorrectionLocationType.LASTTWOROWS;
        }
        if (opcode.equalsIgnoreCase(Opcodes.UAVAR.toString()) || opcode.equalsIgnoreCase(Opcodes.UARVAR.toString())) {
            return Types.CorrectionLocationType.LASTFOURCOLUMNS;
        }
        if (opcode.equalsIgnoreCase(Opcodes.UACVAR.toString())) {
            return Types.CorrectionLocationType.LASTFOURROWS;
        }
        if (opcode.equalsIgnoreCase(Opcodes.UARIMAX.toString()) || opcode.equalsIgnoreCase(Opcodes.UARIMIN.toString())) {
            return Types.CorrectionLocationType.LASTCOLUMN;
        }
        return Types.CorrectionLocationType.NONE;
    }

    public static boolean isDistQuaternaryOpcode(String opcode) {
        return Opcodes.WEIGHTEDSQUAREDLOSS.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDSQUAREDLOSSR.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDSIGMOID.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDSIGMOIDR.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDDIVMM.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDDIVMMR.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDCROSSENTROPY.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDCROSSENTROPYR.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDUNARYMM.toString().equalsIgnoreCase(opcode) || Opcodes.WEIGHTEDUNARYMMR.toString().equalsIgnoreCase(opcode);
    }

    public static AggregateBinaryOperator getMatMultOperator(int k) {
        AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
        return new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg, k);
    }

    public static Operator parseGroupedAggOperator(String fn, String other) {
        CMOperator.AggregateOperationTypes op = CMOperator.AggregateOperationTypes.INVALID;
        op = fn.equalsIgnoreCase("centralmoment") ? CMOperator.getAggOpType(fn, other) : CMOperator.getAggOpType(fn, null);
        switch (op) {
            case SUM: {
                return new AggregateOperator(0.0, KahanPlus.getKahanPlusFnObject(), Types.CorrectionLocationType.LASTCOLUMN);
            }
            case COUNT: 
            case MEAN: 
            case VARIANCE: 
            case CM2: 
            case CM3: 
            case CM4: 
            case MIN: 
            case MAX: {
                return new CMOperator(CM.getCMFnObject(op), op);
            }
        }
        throw new DMLRuntimeException("Invalid Aggregate Operation in GroupedAggregateInstruction: " + op);
    }

    public static String createLiteralOperand(String val, Types.ValueType vt) {
        return InstructionUtils.concatOperandParts(val, Types.DataType.SCALAR.name(), vt.name(), "true");
    }

    public static String createOperand(CPOperand operand) {
        return InstructionUtils.concatOperandParts(operand.getName(), operand.getDataType().name(), operand.getValueType().name());
    }

    public static String replaceOperand(String instStr, int operand, String newValue) {
        String[] parts = instStr.split("\u00b0");
        if (operand >= parts.length) {
            throw new DMLRuntimeException("Operand position " + operand + " exceeds the length of the instruction.");
        }
        parts[operand] = newValue;
        return InstructionUtils.concatOperands(parts);
    }

    public static String removeOperand(String instStr, int operand) {
        Object[] parts = instStr.split("\u00b0");
        if (operand >= parts.length) {
            throw new DMLRuntimeException("Operand position " + operand + " exceeds the length of the instruction.");
        }
        return InstructionUtils.concatOperands((String[])ArrayUtils.remove((Object[])parts, (int)operand));
    }

    public static String replaceOperandName(String instStr) {
        String newName;
        String[] parts = instStr.split("\u00b0");
        String oldName = parts[parts.length - 1];
        String[] Nameparts = oldName.split("\u00b7");
        Nameparts[0] = "xxx";
        parts[parts.length - 1] = newName = InstructionUtils.concatOperandParts(Nameparts);
        return InstructionUtils.concatOperands(parts);
    }

    public static String concatOperands(String ... inputs) {
        StringBuilder sb = _strBuilders.get();
        sb.setLength(0);
        return InstructionUtils.concatOperands(sb, inputs);
    }

    public static String concatOperands(StringBuilder sb, String ... inputs) {
        return InstructionUtils.concatBaseOperandsWithDelim(sb, "\u00b0", inputs);
    }

    public static String concatOperandParts(String ... inputs) {
        StringBuilder sb = _strBuilders.get();
        sb.setLength(0);
        return InstructionUtils.concatBaseOperandsWithDelim(sb, "\u00b7", inputs);
    }

    private static String concatBaseOperandsWithDelim(StringBuilder sb, String delim, String ... inputs) {
        for (int i = 0; i < inputs.length - 1; ++i) {
            sb.append(inputs[i]);
            sb.append(delim);
        }
        sb.append(inputs[inputs.length - 1]);
        return sb.toString();
    }

    public static String concatStrings(String ... inputs) {
        StringBuilder sb = _strBuilders.get();
        sb.setLength(0);
        for (int i = 0; i < inputs.length; ++i) {
            sb.append(inputs[i]);
        }
        return sb.toString();
    }

    public static String constructTernaryString(String instString, CPOperand op1, CPOperand op2, CPOperand op3, CPOperand out) {
        return InstructionUtils.concatOperands(InstructionUtils.constructBinaryInstString(instString, "ifelse", op1, op2, op3), InstructionUtils.createOperand(out));
    }

    public static String constructBinaryInstString(String instString, String opcode, CPOperand op1, CPOperand op2, CPOperand out) {
        String[] parts = instString.split("\u00b0");
        return InstructionUtils.concatOperands(parts[0], opcode, InstructionUtils.createOperand(op1), InstructionUtils.createOperand(op2), InstructionUtils.createOperand(out));
    }

    public static String constructUnaryInstString(String instString, String opcode, CPOperand op1, CPOperand out) {
        String[] parts = instString.split("\u00b0");
        return InstructionUtils.concatOperands(parts[0], opcode, InstructionUtils.createOperand(op1), InstructionUtils.createOperand(out));
    }

    public static String instructionStringFEDPrepare(String inst, CPOperand varOldOut, long id, CPOperand[] varOldIn, long[] varNewIn, boolean rmFederatedOutput) {
        boolean isFedInstr = inst.startsWith(Types.ExecType.FED.name() + "\u00b0");
        String linst = InstructionUtils.replaceExecTypeWithCP(inst);
        linst = InstructionUtils.replaceOutputOperand(linst, varOldOut, id);
        linst = InstructionUtils.replaceInputOperand(linst, varOldIn, varNewIn);
        if (rmFederatedOutput && isFedInstr) {
            linst = InstructionUtils.removeFEDOutputFlag(linst);
        }
        return linst;
    }

    private static String replaceExecTypeWithCP(String inst) {
        return inst.replace(Types.ExecType.FED.name(), Types.ExecType.CP.name());
    }

    private static String replaceOutputOperand(String linst, CPOperand varOldOut, long id) {
        return InstructionUtils.replaceOperand(linst, varOldOut, Long.toString(id));
    }

    private static String replaceInputOperand(String linst, CPOperand[] varOldIn, long[] varNewIn) {
        for (int i = 0; i < varOldIn.length; ++i) {
            if (varOldIn[i] == null) continue;
            linst = InstructionUtils.replaceOperand(linst, varOldIn[i], Long.toString(varNewIn[i]));
            linst = linst.replace("=" + varOldIn[i].getName(), "=" + varNewIn[i]);
        }
        return linst;
    }

    public static String removeFEDOutputFlag(String linst) {
        int lastOperandStartIndex = linst.lastIndexOf("\u00b0");
        String lastOperand = linst.substring(lastOperandStartIndex);
        if (InstructionUtils.containsFEDOutputFlag(lastOperand)) {
            return linst.substring(0, lastOperandStartIndex);
        }
        return linst;
    }

    private static boolean containsFEDOutputFlag(String operandString) {
        for (FEDInstruction.FederatedOutput fedOutput : FEDInstruction.FederatedOutput.values()) {
            if (!operandString.contains(fedOutput.name())) continue;
            return true;
        }
        return false;
    }

    private static String replaceOperand(String linst, CPOperand oldOperand, String newOperandName) {
        return linst.replace("\u00b0" + oldOperand.getName() + "\u00b7", "\u00b0" + newOperandName + "\u00b7");
    }

    protected static boolean isInteger(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }
}

