/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ReblockBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 5000000;
    private final long[][] _buff;
    private final int _bufflen;
    private int _count;
    private final long _rlen;
    private final long _clen;
    private final int _blen;

    public ReblockBuffer(int buffersize, long rlen, long clen, int blen) {
        this._bufflen = Math.max(buffersize, 16);
        this._count = 0;
        this._buff = new long[this._bufflen][3];
        this._rlen = rlen;
        this._clen = clen;
        this._blen = blen;
    }

    public void appendCell(long r, long c, double v) {
        long tmp = Double.doubleToRawLongBits(v);
        this._buff[this._count][0] = r;
        this._buff[this._count][1] = c;
        this._buff[this._count][2] = tmp;
        ++this._count;
    }

    public int getSize() {
        return this._count;
    }

    public int getCapacity() {
        return this._bufflen;
    }

    public List<IndexedMatrixValue> flushBufferToBinaryBlocks() throws DMLRuntimeException {
        if (this._count == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(this._buff, 0, this._count, new ReblockBufferComparator());
        long numBlocks = 0L;
        long cbi = -1L;
        long cbj = -1L;
        for (int i = 0; i < this._count; ++i) {
            long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._blen);
            long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._blen);
            if (bi == cbi && bj == cbj) continue;
            cbi = bi;
            cbj = bj;
            ++numBlocks;
        }
        ArrayList<IndexedMatrixValue> ret = new ArrayList<IndexedMatrixValue>();
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(this._blen, this._blen, (long)this._count / numBlocks);
        MatrixIndexes tmpIx = new MatrixIndexes();
        MatrixBlock tmpBlock = new MatrixBlock();
        cbi = -1L;
        cbj = -1L;
        for (int i = 0; i < this._count; ++i) {
            long bi = UtilFunctions.computeBlockIndex(this._buff[i][0], this._blen);
            long bj = UtilFunctions.computeBlockIndex(this._buff[i][1], this._blen);
            if (bi != cbi || bj != cbj) {
                ReblockBuffer.outputBlock(ret, tmpIx, tmpBlock);
                cbi = bi;
                cbj = bj;
                tmpIx = new MatrixIndexes(bi, bj);
                tmpBlock = new MatrixBlock(UtilFunctions.computeBlockSize(this._rlen, bi, this._blen), UtilFunctions.computeBlockSize(this._clen, bj, this._blen), sparse);
            }
            int ci = UtilFunctions.computeCellInBlock(this._buff[i][0], this._blen);
            int cj = UtilFunctions.computeCellInBlock(this._buff[i][1], this._blen);
            double tmp = Double.longBitsToDouble(this._buff[i][2]);
            tmpBlock.appendValue(ci, cj, tmp);
        }
        ReblockBuffer.outputBlock(ret, tmpIx, tmpBlock);
        this._count = 0;
        return ret;
    }

    private static void outputBlock(ArrayList<IndexedMatrixValue> out, MatrixIndexes key, MatrixBlock value) throws DMLRuntimeException {
        if (key.getRowIndex() == -1L || key.getColumnIndex() == -1L) {
            return;
        }
        if (value.isInSparseFormat()) {
            value.sortSparseRows();
        }
        value.examSparsity();
        if (value.isUltraSparse()) {
            value = new MatrixBlock(value, SparseBlock.Type.COO, false);
        }
        out.add(new IndexedMatrixValue(key, value));
    }

    private class ReblockBufferComparator
    implements Comparator<long[]> {
        private ReblockBufferComparator() {
        }

        @Override
        public int compare(long[] arg0, long[] arg1) {
            long bi0 = UtilFunctions.computeBlockIndex(arg0[0], ReblockBuffer.this._blen);
            long bj0 = UtilFunctions.computeBlockIndex(arg0[1], ReblockBuffer.this._blen);
            long bi1 = UtilFunctions.computeBlockIndex(arg1[0], ReblockBuffer.this._blen);
            long bj1 = UtilFunctions.computeBlockIndex(arg1[1], ReblockBuffer.this._blen);
            return bi0 < bi1 || bi0 == bi1 && bj0 < bj1 ? -1 : (bi0 == bi1 && bj0 == bj1 ? 0 : 1);
        }
    }
}

