/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class MatrixWriter {
    protected static final Log LOG = LogFactory.getLog((String)MatrixWriter.class.getName());
    protected boolean _forcedParallel = false;

    public void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int blen, long nnz) throws IOException {
        this.writeMatrixToHDFS(src, fname, rlen, clen, blen, nnz, false);
    }

    public abstract void writeMatrixToHDFS(MatrixBlock var1, String var2, long var3, long var5, int var7, long var8, boolean var10) throws IOException;

    public void setForcedParallel(boolean par) {
        this._forcedParallel = par;
    }

    public abstract void writeEmptyMatrixToHDFS(String var1, long var2, long var4, int var6) throws IOException;

    public static MatrixBlock[] createMatrixBlocksForReuse(long rlen, long clen, int blen, boolean sparse, long nonZeros) {
        MatrixBlock[] blocks = new MatrixBlock[4];
        double sparsity = (double)nonZeros / (double)(rlen * clen);
        long estNNZ = -1L;
        if (rlen >= (long)blen && clen >= (long)blen) {
            estNNZ = (long)((double)(blen * blen) * sparsity);
            blocks[0] = new MatrixBlock(blen, blen, sparse, (int)estNNZ);
        }
        if (rlen >= (long)blen && clen % (long)blen != 0L) {
            estNNZ = (long)((double)((long)blen * (clen % (long)blen)) * sparsity);
            blocks[1] = new MatrixBlock(blen, (int)(clen % (long)blen), sparse, (int)estNNZ);
        }
        if (rlen % (long)blen != 0L && clen >= (long)blen) {
            estNNZ = (long)((double)(rlen % (long)blen * (long)blen) * sparsity);
            blocks[2] = new MatrixBlock((int)(rlen % (long)blen), blen, sparse, (int)estNNZ);
        }
        if (rlen % (long)blen != 0L && clen % (long)blen != 0L) {
            estNNZ = (long)((double)(rlen % (long)blen * (clen % (long)blen)) * sparsity);
            blocks[3] = new MatrixBlock((int)(rlen % (long)blen), (int)(clen % (long)blen), sparse, (int)estNNZ);
        }
        for (MatrixBlock b : blocks) {
            if (b == null || sparse) continue;
            b.allocateDenseBlockUnsafe(b.getNumRows(), b.getNumColumns());
        }
        return blocks;
    }

    public static MatrixBlock getMatrixBlockForReuse(MatrixBlock[] blocks, int rows, int cols, int blen) {
        int index = -1;
        index = rows == blen && cols == blen ? 0 : (rows == blen && cols < blen ? 1 : (rows < blen && cols == blen ? 2 : 3));
        return blocks[index];
    }
}

