/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.JobArtifactSet;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.AllJobsCancelled$;
import org.apache.spark.scheduler.BeginEvent;
import org.apache.spark.scheduler.CompletionEvent;
import org.apache.spark.scheduler.DAGScheduler;
import org.apache.spark.scheduler.DAGSchedulerEvent;
import org.apache.spark.scheduler.ExecutorAdded;
import org.apache.spark.scheduler.ExecutorDecommission;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.ExecutorLost;
import org.apache.spark.scheduler.ExecutorProcessLost;
import org.apache.spark.scheduler.GettingResultEvent;
import org.apache.spark.scheduler.JobCancelled;
import org.apache.spark.scheduler.JobGroupCancelled;
import org.apache.spark.scheduler.JobListener;
import org.apache.spark.scheduler.JobSubmitted;
import org.apache.spark.scheduler.JobTagCancelled;
import org.apache.spark.scheduler.MapStageSubmitted;
import org.apache.spark.scheduler.MergeStatus;
import org.apache.spark.scheduler.RegisterMergeStatuses;
import org.apache.spark.scheduler.ResubmitFailedStages$;
import org.apache.spark.scheduler.ShuffleMapStage;
import org.apache.spark.scheduler.ShuffleMergeFinalized;
import org.apache.spark.scheduler.ShufflePushCompleted;
import org.apache.spark.scheduler.SpeculativeTaskSubmitted;
import org.apache.spark.scheduler.StageCancelled;
import org.apache.spark.scheduler.StageFailed;
import org.apache.spark.scheduler.Task;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.scheduler.TaskSet;
import org.apache.spark.scheduler.TaskSetFailed;
import org.apache.spark.scheduler.UnschedulableTaskSetAdded;
import org.apache.spark.scheduler.UnschedulableTaskSetRemoved;
import org.apache.spark.scheduler.WorkerRemoved;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.EventLoop;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3Q\u0001C\u0005\u0001\u0013EA\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0017\t\u000bY\u0002A\u0011I\u001c\t\u000b\u0001\u0003A\u0011B!\t\u000b\r\u0003A\u0011\t#\t\u000bM\u0003A\u0011\t+\u00039\u0011\u000buiU2iK\u0012,H.\u001a:Fm\u0016tG\u000f\u0015:pG\u0016\u001c8\u000fT8pa*\u0011!bC\u0001\ng\u000eDW\rZ;mKJT!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\n\u0004\u0001Ia\u0002cA\n\u001715\tAC\u0003\u0002\u0016\u0017\u0005!Q\u000f^5m\u0013\t9BCA\u0005Fm\u0016tG\u000fT8paB\u0011\u0011DG\u0007\u0002\u0013%\u00111$\u0003\u0002\u0012\t\u0006;5k\u00195fIVdWM]#wK:$\bCA\u000f!\u001b\u0005q\"BA\u0010\f\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0011\u001f\u0005\u001daunZ4j]\u001e\fA\u0002Z1h'\u000eDW\rZ;mKJ\u001c\u0001\u0001\u0005\u0002\u001aK%\u0011a%\u0003\u0002\r\t\u0006;5k\u00195fIVdWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%R\u0003CA\r\u0001\u0011\u0015\u0011#\u00011\u0001%\u0003\u0015!\u0018.\\3s!\tiC'D\u0001/\u0015\ty\u0003'A\u0004nKR\u0014\u0018nY:\u000b\u0005E\u0012\u0014\u0001C2pI\u0006D\u0017\r\\3\u000b\u0003M\n1aY8n\u0013\t)dFA\u0003US6,'/A\u0005p]J+7-Z5wKR\u0011\u0001H\u0010\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0005+:LG\u000fC\u0003@\t\u0001\u0007\u0001$A\u0003fm\u0016tG/A\u0006e_>s'+Z2fSZ,GC\u0001\u001dC\u0011\u0015yT\u00011\u0001\u0019\u0003\u001dyg.\u0012:s_J$\"\u0001O#\t\u000b\u00193\u0001\u0019A$\u0002\u0003\u0015\u0004\"\u0001\u0013)\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'$\u0003\u0019a$o\\8u}%\t1(\u0003\u0002Pu\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005%!\u0006N]8xC\ndWM\u0003\u0002Pu\u00051qN\\*u_B$\u0012\u0001\u000f")
public class DAGSchedulerEventProcessLoop
extends EventLoop<DAGSchedulerEvent> {
    private final DAGScheduler dagScheduler;
    private final Timer timer;

    @Override
    public void onReceive(DAGSchedulerEvent event) {
        Timer.Context timerContext = this.timer.time();
        try {
            this.doOnReceive(event);
        }
        finally {
            timerContext.stop();
        }
    }

    private void doOnReceive(DAGSchedulerEvent event) {
        DAGSchedulerEvent dAGSchedulerEvent = event;
        if (dAGSchedulerEvent instanceof JobSubmitted) {
            JobSubmitted jobSubmitted = (JobSubmitted)dAGSchedulerEvent;
            int jobId = jobSubmitted.jobId();
            RDD<?> rdd = jobSubmitted.finalRDD();
            Function2<TaskContext, Iterator<?>, ?> func = jobSubmitted.func();
            int[] partitions = jobSubmitted.partitions();
            CallSite callSite = jobSubmitted.callSite();
            JobListener listener = jobSubmitted.listener();
            JobArtifactSet artifacts = jobSubmitted.artifactSet();
            Properties properties = jobSubmitted.properties();
            this.dagScheduler.handleJobSubmitted(jobId, rdd, func, partitions, callSite, listener, artifacts, properties);
            return;
        }
        if (dAGSchedulerEvent instanceof MapStageSubmitted) {
            MapStageSubmitted mapStageSubmitted = (MapStageSubmitted)dAGSchedulerEvent;
            int jobId = mapStageSubmitted.jobId();
            ShuffleDependency<?, ?, ?> dependency = mapStageSubmitted.dependency();
            CallSite callSite = mapStageSubmitted.callSite();
            JobListener listener = mapStageSubmitted.listener();
            JobArtifactSet artifacts = mapStageSubmitted.artifactSet();
            Properties properties = mapStageSubmitted.properties();
            this.dagScheduler.handleMapStageSubmitted(jobId, dependency, callSite, listener, artifacts, properties);
            return;
        }
        if (dAGSchedulerEvent instanceof StageCancelled) {
            StageCancelled stageCancelled = (StageCancelled)dAGSchedulerEvent;
            int stageId = stageCancelled.stageId();
            Option<String> reason = stageCancelled.reason();
            this.dagScheduler.handleStageCancellation(stageId, reason);
            return;
        }
        if (dAGSchedulerEvent instanceof JobCancelled) {
            JobCancelled jobCancelled = (JobCancelled)dAGSchedulerEvent;
            int jobId = jobCancelled.jobId();
            Option<String> reason = jobCancelled.reason();
            this.dagScheduler.handleJobCancellation(jobId, reason);
            return;
        }
        if (dAGSchedulerEvent instanceof JobGroupCancelled) {
            JobGroupCancelled jobGroupCancelled = (JobGroupCancelled)dAGSchedulerEvent;
            String groupId = jobGroupCancelled.groupId();
            this.dagScheduler.handleJobGroupCancelled(groupId);
            return;
        }
        if (dAGSchedulerEvent instanceof JobTagCancelled) {
            JobTagCancelled jobTagCancelled = (JobTagCancelled)dAGSchedulerEvent;
            String tag = jobTagCancelled.tagName();
            this.dagScheduler.handleJobTagCancelled(tag);
            return;
        }
        if (AllJobsCancelled$.MODULE$.equals(dAGSchedulerEvent)) {
            this.dagScheduler.doCancelAllJobs();
            return;
        }
        if (dAGSchedulerEvent instanceof ExecutorAdded) {
            ExecutorAdded executorAdded = (ExecutorAdded)dAGSchedulerEvent;
            String execId = executorAdded.execId();
            String host = executorAdded.host();
            this.dagScheduler.handleExecutorAdded(execId, host);
            return;
        }
        if (dAGSchedulerEvent instanceof ExecutorLost) {
            Option<String> option;
            ExecutorLost executorLost = (ExecutorLost)dAGSchedulerEvent;
            String execId = executorLost.execId();
            ExecutorLossReason reason = executorLost.reason();
            ExecutorLossReason executorLossReason = reason;
            if (executorLossReason instanceof ExecutorProcessLost) {
                Option<String> workerHost;
                ExecutorProcessLost executorProcessLost = (ExecutorProcessLost)executorLossReason;
                option = workerHost = executorProcessLost.workerHost();
            } else if (executorLossReason instanceof ExecutorDecommission) {
                ExecutorDecommission executorDecommission = (ExecutorDecommission)executorLossReason;
                Option<String> workerHost = executorDecommission.workerHost();
                option = workerHost;
            } else {
                option = None$.MODULE$;
            }
            Option<String> workerHost = option;
            this.dagScheduler.handleExecutorLost(execId, workerHost);
            return;
        }
        if (dAGSchedulerEvent instanceof WorkerRemoved) {
            WorkerRemoved workerRemoved = (WorkerRemoved)dAGSchedulerEvent;
            String workerId = workerRemoved.workerId();
            String host = workerRemoved.host();
            String message = workerRemoved.message();
            this.dagScheduler.handleWorkerRemoved(workerId, host, message);
            return;
        }
        if (dAGSchedulerEvent instanceof BeginEvent) {
            BeginEvent beginEvent = (BeginEvent)dAGSchedulerEvent;
            Task<?> task = beginEvent.task();
            TaskInfo taskInfo = beginEvent.taskInfo();
            this.dagScheduler.handleBeginEvent(task, taskInfo);
            return;
        }
        if (dAGSchedulerEvent instanceof SpeculativeTaskSubmitted) {
            SpeculativeTaskSubmitted speculativeTaskSubmitted = (SpeculativeTaskSubmitted)dAGSchedulerEvent;
            Task<?> task = speculativeTaskSubmitted.task();
            int taskIndex = speculativeTaskSubmitted.taskIndex();
            this.dagScheduler.handleSpeculativeTaskSubmitted(task, taskIndex);
            return;
        }
        if (dAGSchedulerEvent instanceof UnschedulableTaskSetAdded) {
            UnschedulableTaskSetAdded unschedulableTaskSetAdded = (UnschedulableTaskSetAdded)dAGSchedulerEvent;
            int stageId = unschedulableTaskSetAdded.stageId();
            int stageAttemptId = unschedulableTaskSetAdded.stageAttemptId();
            this.dagScheduler.handleUnschedulableTaskSetAdded(stageId, stageAttemptId);
            return;
        }
        if (dAGSchedulerEvent instanceof UnschedulableTaskSetRemoved) {
            UnschedulableTaskSetRemoved unschedulableTaskSetRemoved = (UnschedulableTaskSetRemoved)dAGSchedulerEvent;
            int stageId = unschedulableTaskSetRemoved.stageId();
            int stageAttemptId = unschedulableTaskSetRemoved.stageAttemptId();
            this.dagScheduler.handleUnschedulableTaskSetRemoved(stageId, stageAttemptId);
            return;
        }
        if (dAGSchedulerEvent instanceof GettingResultEvent) {
            GettingResultEvent gettingResultEvent = (GettingResultEvent)dAGSchedulerEvent;
            TaskInfo taskInfo = gettingResultEvent.taskInfo();
            this.dagScheduler.handleGetTaskResult(taskInfo);
            return;
        }
        if (dAGSchedulerEvent instanceof CompletionEvent) {
            CompletionEvent completionEvent = (CompletionEvent)dAGSchedulerEvent;
            this.dagScheduler.handleTaskCompletion(completionEvent);
            return;
        }
        if (dAGSchedulerEvent instanceof StageFailed) {
            StageFailed stageFailed = (StageFailed)dAGSchedulerEvent;
            int stageId = stageFailed.stageId();
            String reason = stageFailed.reason();
            Option<Throwable> exception = stageFailed.exception();
            this.dagScheduler.handleStageFailed(stageId, reason, exception);
            return;
        }
        if (dAGSchedulerEvent instanceof TaskSetFailed) {
            TaskSetFailed taskSetFailed = (TaskSetFailed)dAGSchedulerEvent;
            TaskSet taskSet = taskSetFailed.taskSet();
            String reason = taskSetFailed.reason();
            Option<Throwable> exception = taskSetFailed.exception();
            this.dagScheduler.handleTaskSetFailed(taskSet, reason, exception);
            return;
        }
        if (ResubmitFailedStages$.MODULE$.equals(dAGSchedulerEvent)) {
            this.dagScheduler.resubmitFailedStages();
            return;
        }
        if (dAGSchedulerEvent instanceof RegisterMergeStatuses) {
            RegisterMergeStatuses registerMergeStatuses = (RegisterMergeStatuses)dAGSchedulerEvent;
            ShuffleMapStage stage = registerMergeStatuses.stage();
            Seq<Tuple2<Object, MergeStatus>> mergeStatuses = registerMergeStatuses.mergeStatuses();
            this.dagScheduler.handleRegisterMergeStatuses(stage, mergeStatuses);
            return;
        }
        if (dAGSchedulerEvent instanceof ShuffleMergeFinalized) {
            ShuffleMergeFinalized shuffleMergeFinalized = (ShuffleMergeFinalized)dAGSchedulerEvent;
            ShuffleMapStage stage = shuffleMergeFinalized.stage();
            this.dagScheduler.handleShuffleMergeFinalized(stage, stage.shuffleDep().shuffleMergeId());
            return;
        }
        if (dAGSchedulerEvent instanceof ShufflePushCompleted) {
            ShufflePushCompleted shufflePushCompleted = (ShufflePushCompleted)dAGSchedulerEvent;
            int shuffleId = shufflePushCompleted.shuffleId();
            int shuffleMergeId = shufflePushCompleted.shuffleMergeId();
            int mapIndex = shufflePushCompleted.mapIndex();
            this.dagScheduler.handleShufflePushCompleted(shuffleId, shuffleMergeId, mapIndex);
            return;
        }
        throw new MatchError((Object)dAGSchedulerEvent);
    }

    @Override
    public void onError(Throwable e) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DAGSchedulerEventProcessLoop failed; shutting down SparkContext", e);
        try {
            this.dagScheduler.doCancelAllJobs();
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DAGScheduler failed to cancel all jobs.", t);
        }
        this.dagScheduler.sc().stopInNewThread();
    }

    @Override
    public void onStop() {
        this.dagScheduler.cleanUpAfterSchedulerStop();
    }

    public DAGSchedulerEventProcessLoop(DAGScheduler dagScheduler) {
        this.dagScheduler = dagScheduler;
        super("dag-scheduler-event-loop");
        this.timer = dagScheduler.metricsSource().messageProcessingTimer();
    }
}

