/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LeftIndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.QuaternaryOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysds.lops.MapMultChain;

public class RewriteAlgebraicSimplificationDynamic
extends HopRewriteRule {
    private static Types.AggOp[] LOOKUP_VALID_ROW_COL_AGGREGATE = new Types.AggOp[]{Types.AggOp.SUM, Types.AggOp.SUM_SQ, Types.AggOp.MIN, Types.AggOp.MAX, Types.AggOp.MEAN, Types.AggOp.VAR};
    private static Types.AggOp[] LOOKUP_VALID_EMPTY_AGGREGATE = new Types.AggOp[]{Types.AggOp.SUM, Types.AggOp.SUM_SQ, Types.AggOp.MIN, Types.AggOp.MAX, Types.AggOp.PROD, Types.AggOp.TRACE};
    private static Types.AggOp[] LOOKUP_VALID_UNNECESSARY_AGGREGATE = new Types.AggOp[]{Types.AggOp.SUM, Types.AggOp.MIN, Types.AggOp.MAX, Types.AggOp.PROD, Types.AggOp.TRACE};
    private static Types.OpOp1[] LOOKUP_VALID_EMPTY_UNARY = new Types.OpOp1[]{Types.OpOp1.ABS, Types.OpOp1.SIN, Types.OpOp1.TAN, Types.OpOp1.SQRT, Types.OpOp1.ROUND, Types.OpOp1.CUMSUM};
    private static Types.OpOp2[] LOOKUP_VALID_WDIVMM_BINARY = new Types.OpOp2[]{Types.OpOp2.MULT, Types.OpOp2.DIV};
    private static Types.OpOp1[] LOOKUP_VALID_WUMM_UNARY = new Types.OpOp1[]{Types.OpOp1.ABS, Types.OpOp1.ROUND, Types.OpOp1.CEIL, Types.OpOp1.FLOOR, Types.OpOp1.EXP, Types.OpOp1.LOG, Types.OpOp1.SQRT, Types.OpOp1.SIN, Types.OpOp1.COS, Types.OpOp1.SIGMOID, Types.OpOp1.SPROP};
    private static Types.OpOp2[] LOOKUP_VALID_WUMM_BINARY = new Types.OpOp2[]{Types.OpOp2.MULT, Types.OpOp2.POW};

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return roots;
        }
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, false);
        }
        Hop.resetVisitStatus(roots, true);
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, true);
        }
        Hop.resetVisitStatus(roots, true);
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return root;
        }
        this.rule_AlgebraicSimplification(root, false);
        root.resetVisitStatus();
        this.rule_AlgebraicSimplification(root, true);
        return root;
    }

    private void rule_AlgebraicSimplification(Hop hop, boolean descendFirst) {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop hi = hop.getInput(i);
            if (descendFirst) {
                this.rule_AlgebraicSimplification(hi, descendFirst);
            }
            hi = RewriteAlgebraicSimplificationDynamic.removeEmptyRightIndexing(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryRightIndexing(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.removeEmptyLeftIndexing(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryLeftIndexing(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = RewriteAlgebraicSimplificationDynamic.fuseLeftIndexingChainToAppend(hop, hi, i);
            }
            hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryCumulativeOp(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryReorgOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryOuterProduct(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryIfElseOperation(hop, hi, i);
            if (ConfigurationManager.getDMLConfig().getBooleanValue("sysds.lineage.compilerassisted")) {
                hi = RewriteAlgebraicSimplificationDynamic.removeUnnecessaryAppendTSMM(hop, hi, i);
            }
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = RewriteAlgebraicSimplificationDynamic.fuseDatagenAndReorgOperation(hop, hi, i);
            }
            hi = RewriteAlgebraicSimplificationDynamic.simplifyColwiseAggregate(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyRowwiseAggregate(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyMeanAggregation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyColSumsMVMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyRowSumsMVMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyUnnecessaryAggregate(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptyAggregate(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptyColMeans(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptyUnaryOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptyReorgOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptySortOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptyMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyIdentityRepMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyScalarMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyMatrixMultDiag(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyDiagMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyDistributiveMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifySumDiagToTrace(hi);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyLowerTriExtraction(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyConstantCumsum(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.pushdownBinaryOperationOnDiag(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.pushdownSumOnAdditiveBinary(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = RewriteAlgebraicSimplificationDynamic.simplifyWeightedSquaredLoss(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.simplifyWeightedSigmoidMMChains(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.simplifyWeightedDivMM(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.simplifyWeightedCrossEntropy(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.simplifyWeightedUnaryMM(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.simplifyDotProductSum(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.fuseSumSquared(hop, hi, i);
                hi = RewriteAlgebraicSimplificationDynamic.fuseAxpyBinaryOperationChain(hop, hi, i);
            }
            hi = RewriteAlgebraicSimplificationDynamic.reorderMinusMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifySumMatrixMult(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyEmptyBinaryOperation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyScalarMVBinaryOperation(hi);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyNnzComputation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyNrowNcolComputation(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplifyTableSeqExpand(hop, hi, i);
            hi = RewriteAlgebraicSimplificationDynamic.simplyfyMMCBindZeroVector(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                RewriteAlgebraicSimplificationDynamic.foldMultipleMinMaxOperations(hi);
            }
            if (!descendFirst) {
                this.rule_AlgebraicSimplification(hi, descendFirst);
            }
            hi = RewriteAlgebraicSimplificationDynamic.fuseSeqAndTableExpand(hi);
        }
        hop.setVisited();
    }

    private static Hop removeEmptyRightIndexing(Hop parent, Hop hi, int pos) {
        Hop input;
        if (hi instanceof IndexingOp && hi.getDataType() == Types.DataType.MATRIX && (input = hi.getInput(0)).getNnz() == 0L && HopRewriteUtils.isDimsKnown(hi) && hi.getInput(1) instanceof LiteralOp && hi.getInput(2) instanceof LiteralOp && hi.getInput(3) instanceof LiteralOp && hi.getInput(4) instanceof LiteralOp) {
            Hop hnew = HopRewriteUtils.createDataGenOpByVal(new LiteralOp(hi.getDim1()), new LiteralOp(hi.getDim2()), null, Types.DataType.MATRIX, Types.ValueType.FP64, 0.0);
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, input);
            hi = hnew;
            LOG.debug((Object)("Applied removeEmptyRightIndexing (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private static Hop removeUnnecessaryRightIndexing(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isUnnecessaryRightIndexing(hi) && !hi.isScalar()) {
            Hop input = hi.getInput(0);
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = input;
            LOG.debug((Object)("Applied removeUnnecessaryRightIndexing  (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private static Hop removeEmptyLeftIndexing(Hop parent, Hop hi, int pos) {
        if (hi instanceof LeftIndexingOp && hi.getDataType() == Types.DataType.MATRIX) {
            Hop input1 = hi.getInput(0);
            Hop input2 = hi.getInput(1);
            if (input1.getNnz() == 0L && input2.getNnz() == 0L) {
                Hop hnew = HopRewriteUtils.createDataGenOp(input1, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, input2);
                hi = hnew;
                LOG.debug((Object)"Applied removeEmptyLeftIndexing");
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryLeftIndexing(Hop parent, Hop hi, int pos) {
        Hop input;
        if (hi instanceof LeftIndexingOp && HopRewriteUtils.isEqualSize(hi, input = hi.getInput(1))) {
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = input;
            LOG.debug((Object)"Applied removeUnnecessaryLeftIndexing");
        }
        return hi;
    }

    private static Hop fuseLeftIndexingChainToAppend(Hop parent, Hop hi, int pos) {
        BinaryOp bop;
        Hop pred1;
        Hop input1;
        Hop pred2;
        Hop input2;
        boolean applied = false;
        if (hi instanceof LeftIndexingOp && HopRewriteUtils.isFullColumnIndexing((LeftIndexingOp)hi) && hi.getInput(0) instanceof LeftIndexingOp && HopRewriteUtils.isFullColumnIndexing((LeftIndexingOp)hi.getInput(0)) && hi.getInput(0).getParent().size() == 1 && hi.getInput(0).getInput(0).getDim2() == 2L) {
            input2 = hi.getInput(1);
            pred2 = hi.getInput(4);
            input1 = hi.getInput(0).getInput(1);
            pred1 = hi.getInput(0).getInput(4);
            if (pred1 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred1) == 1.0 && pred2 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred2) == 2.0 && input1.getDataType() != Types.DataType.SCALAR && input2.getDataType() != Types.DataType.SCALAR) {
                bop = HopRewriteUtils.createBinary(input1, input2, Types.OpOp2.CBIND);
                HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
                hi = bop;
                applied = true;
            }
        }
        if (!applied && hi instanceof LeftIndexingOp && HopRewriteUtils.isFullRowIndexing((LeftIndexingOp)hi) && hi.getInput(0) instanceof LeftIndexingOp && HopRewriteUtils.isFullRowIndexing((LeftIndexingOp)hi.getInput(0)) && hi.getInput(0).getParent().size() == 1 && hi.getInput(0).getInput(0).getDim1() == 2L) {
            input2 = hi.getInput(1);
            pred2 = hi.getInput(2);
            input1 = hi.getInput(0).getInput(1);
            pred1 = hi.getInput(0).getInput(2);
            if (pred1 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred1) == 1.0 && pred2 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred2) == 2.0 && input1.getDataType() != Types.DataType.SCALAR && input2.getDataType() != Types.DataType.SCALAR) {
                bop = HopRewriteUtils.createBinary(input1, input2, Types.OpOp2.RBIND);
                HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
                hi = bop;
                applied = true;
                LOG.debug((Object)("Applied fuseLeftIndexingChainToAppend2 (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryCumulativeOp(Hop parent, Hop hi, int pos) {
        Hop input;
        if (hi instanceof UnaryOp && ((UnaryOp)hi).isCumulativeUnaryOperation() && HopRewriteUtils.isDimsKnown(input = hi.getInput(0)) && input.getDim1() == 1L) {
            Types.OpOp1 op = ((UnaryOp)hi).getOp();
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            hi = input;
            LOG.debug((Object)("Applied removeUnnecessaryCumulativeOp: " + op));
        }
        return hi;
    }

    private static Hop removeUnnecessaryReorgOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof ReorgOp) {
            ReorgOp rop = (ReorgOp)hi;
            Hop input = hi.getInput(0);
            boolean apply = false;
            apply |= rop.getOp() == Types.ReOrgOp.RESHAPE && HopRewriteUtils.isEqualSize(hi, input);
            if (apply |= (rop.getOp() == Types.ReOrgOp.TRANS || rop.getOp() == Types.ReOrgOp.RESHAPE || rop.getOp() == Types.ReOrgOp.ROLL) && rop.getDim1() == 1L && rop.getDim2() == 1L) {
                HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
                hi = input;
                LOG.debug((Object)"Applied removeUnnecessaryReorg.");
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryOuterProduct(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            Types.OpOp2 bop = ((BinaryOp)hi).getOp();
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (HopRewriteUtils.isMatrixMultiply(right) && HopRewriteUtils.isDataGenOpWithConstantValue(right.getInput(1), 1.0) && right.getInput(0).getDim2() == 1L) {
                HopRewriteUtils.replaceChildReference(hi, right, right.getInput(0), 1);
                HopRewriteUtils.cleanupUnreferenced(right);
                LOG.debug((Object)("Applied removeUnnecessaryOuterProduct1 (line " + right.getBeginLine() + ")"));
            } else if (HopRewriteUtils.isMatrixMultiply(right) && HopRewriteUtils.isDataGenOpWithConstantValue(right.getInput(0), 1.0) && right.getInput(1).getDim1() == 1L) {
                HopRewriteUtils.replaceChildReference(hi, right, right.getInput(1), 1);
                HopRewriteUtils.cleanupUnreferenced(right);
                LOG.debug((Object)("Applied removeUnnecessaryOuterProduct2 (line " + right.getBeginLine() + ")"));
            } else if (HopRewriteUtils.isValidOuterBinaryOp(bop) && HopRewriteUtils.isMatrixMultiply(left) && HopRewriteUtils.isDataGenOpWithConstantValue(left.getInput(1), 1.0) && (left.getInput(0).getDim2() == 1L || left.getInput(1).getDim1() == 1L) && left.getDim1() != 1L && right.getDim1() == 1L) {
                BinaryOp hnew = HopRewriteUtils.createBinary(left.getInput(0), right, bop, true);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hnew;
                LOG.debug((Object)("Applied removeUnnecessaryOuterProduct3 (line " + right.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop removeUnnecessaryIfElseOperation(Hop parent, Hop hi, int pos) {
        Hop hnew;
        if (!HopRewriteUtils.isTernary(hi, Types.OpOp3.IFELSE)) {
            return hi;
        }
        Hop expr = hi.getInput(0);
        Hop first = hi.getInput(1);
        Hop second = hi.getInput(2);
        boolean applied = false;
        if (expr instanceof LiteralOp) {
            Hop hop = hnew = ((LiteralOp)expr).getBooleanValue() ? first : second;
            if (HopRewriteUtils.isEqualSize(hnew, hi)) {
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                LOG.debug((Object)("Applied removeUnnecessaryIfElse1 (line " + hi.getBeginLine() + ")"));
                hi = hnew;
                applied = true;
            }
        }
        if (!applied && expr.getNnz() == expr.getLength() || expr.getNnz() == 0L) {
            Hop hop = hnew = expr.getNnz() == 0L ? second : first;
            if (HopRewriteUtils.isEqualSize(hnew, hi)) {
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                LOG.debug((Object)("Applied removeUnnecessaryIfElse2 (line " + hi.getBeginLine() + ")"));
                hi = hnew;
                applied = true;
            }
        }
        if (!applied && first == second && HopRewriteUtils.isEqualSize(first, hi)) {
            HopRewriteUtils.replaceChildReference(parent, hi, first, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            LOG.debug((Object)("Applied removeUnnecessaryIfElse3 (line " + hi.getBeginLine() + ")"));
            hi = first;
        }
        return hi;
    }

    private static Hop removeUnnecessaryAppendTSMM(Hop parent, Hop hi, int pos) {
        Hop hnew = null;
        int branch = -1;
        if (HopRewriteUtils.isTsmm(hi) && HopRewriteUtils.isTransposeOperation(hi.getInput(0)) && HopRewriteUtils.isNary(hi.getInput(1), Types.OpOpN.RBIND)) {
            List<Hop> inputs = hi.getInput(1).getInput();
            if (HopRewriteUtils.checkAvgRowsGteCols(inputs)) {
                Hop[] tsmms = (Hop[])inputs.stream().map(h -> HopRewriteUtils.createTsmm(h, true)).toArray(Hop[]::new);
                hnew = HopRewriteUtils.createNary(Types.OpOpN.PLUS, tsmms);
                branch = 1;
            }
        } else if (HopRewriteUtils.isMatrixMultiply(hi) && HopRewriteUtils.isTransposeOperation(hi.getInput(0)) && HopRewriteUtils.isNary(hi.getInput(0).getInput(0), Types.OpOpN.RBIND) && HopRewriteUtils.isNary(hi.getInput(1), Types.OpOpN.RBIND)) {
            List<Hop> inputs1 = hi.getInput(0).getInput(0).getInput();
            List<Hop> inputs2 = hi.getInput(1).getInput();
            if (HopRewriteUtils.checkAvgRowsGteCols(inputs1) && HopRewriteUtils.checkAvgRowsGteCols(inputs2) && HopRewriteUtils.checkConsistentRows(inputs1, inputs2)) {
                Hop[] mms = new Hop[inputs1.size()];
                for (int i = 0; i < inputs1.size(); ++i) {
                    mms[i] = HopRewriteUtils.createMatrixMultiply(HopRewriteUtils.createTranspose(inputs1.get(i)), inputs2.get(i));
                }
                hnew = HopRewriteUtils.createNary(Types.OpOpN.PLUS, mms);
                branch = 2;
            }
        } else if (HopRewriteUtils.isTsmm(hi) && hi.getInput(1).getParent().size() == 2 && HopRewriteUtils.isTransposeOperation(hi.getInput(0)) && HopRewriteUtils.isBinary(hi.getInput(1), Types.OpOp2.CBIND)) {
            Hop input1 = hi.getInput(1).getInput(0);
            Hop input2 = hi.getInput(1).getInput(1);
            if (input1.getDim1() > input1.getDim2() && input2.getDim2() == 1L) {
                hnew = HopRewriteUtils.createPartialTsmmCbind(input1, input2, HopRewriteUtils.createTsmm(input1, true));
                branch = 3;
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            HopRewriteUtils.removeAllChildReferences(hi);
            hi = hnew;
            LOG.debug((Object)("Applied removeUnnecessaryAppendTSMM" + branch + " (line " + hi.getBeginLine() + ")"));
        }
        return hi;
    }

    private static Hop fuseDatagenAndReorgOperation(Hop parent, Hop hi, int pos) {
        DataGenOp dop;
        if (HopRewriteUtils.isTransposeOperation(hi) && hi.getInput(0) instanceof DataGenOp && hi.getInput(0).getParent().size() == 1 && ((dop = (DataGenOp)hi.getInput(0)).getOp() == Types.OpOpDG.RAND || dop.getOp() == Types.OpOpDG.SINIT) && (dop.getDim1() == 1L || dop.getDim2() == 1L)) {
            HopRewriteUtils.removeAllChildReferences(hi);
            ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
            for (int i = 0; i < parents.size(); ++i) {
                Hop lparent = (Hop)parents.get(i);
                int ppos = HopRewriteUtils.getChildReferencePos(lparent, hi);
                HopRewriteUtils.removeChildReferenceByPos(lparent, hi, ppos);
                HopRewriteUtils.addChildReference(lparent, dop, pos);
            }
            HashMap<String, Integer> rparams = dop.getParamIndexMap();
            int pos1 = rparams.get("rows");
            int pos2 = rparams.get("cols");
            rparams.put("rows", pos2);
            rparams.put("cols", pos1);
            dop.refreshSizeInformation();
            hi = dop;
            LOG.debug((Object)"Applied fuseDatagenReorgOperation.");
        }
        return hi;
    }

    private static Hop simplifyColwiseAggregate(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_ROW_COL_AGGREGATE) && uhi.getDirection() == Types.Direction.Col) {
                if (input.getDim1() == 1L) {
                    if (uhi.getOp() == Types.AggOp.VAR) {
                        Hop emptyRow = HopRewriteUtils.createDataGenOp(uhi, input, 0.0);
                        HopRewriteUtils.replaceChildReference(parent, hi, emptyRow, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, input);
                        hi = emptyRow;
                        LOG.debug((Object)"Applied simplifyColwiseAggregate for colVars");
                    } else {
                        HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi);
                        hi = input;
                        LOG.debug((Object)"Applied simplifyColwiseAggregate1");
                    }
                } else if (input.getDim2() == 1L) {
                    ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                    uhi.setDirection(Types.Direction.RowCol);
                    uhi.setDataType(Types.DataType.SCALAR);
                    UnaryOp cast = HopRewriteUtils.createUnary((Hop)uhi, Types.OpOp1.CAST_AS_MATRIX);
                    for (Hop p : parents) {
                        int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                        HopRewriteUtils.replaceChildReference(p, hi, cast, ix);
                    }
                    hi = cast;
                    LOG.debug((Object)"Applied simplifyColwiseAggregate2");
                }
            }
        }
        return hi;
    }

    private static Hop simplifyRowwiseAggregate(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_ROW_COL_AGGREGATE) && uhi.getDirection() == Types.Direction.Row) {
                if (input.getDim2() == 1L) {
                    if (uhi.getOp() == Types.AggOp.VAR) {
                        Hop emptyCol = HopRewriteUtils.createDataGenOp(input, uhi, 0.0);
                        HopRewriteUtils.replaceChildReference(parent, hi, emptyCol, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, input);
                        hi = emptyCol;
                        LOG.debug((Object)"Applied simplifyRowwiseAggregate for rowVars");
                    } else {
                        HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi);
                        hi = input;
                        LOG.debug((Object)("Applied simplifyRowwiseAggregate1 (line " + hi.getBeginLine() + ")"));
                    }
                } else if (input.getDim1() == 1L) {
                    ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                    uhi.setDirection(Types.Direction.RowCol);
                    uhi.setDataType(Types.DataType.SCALAR);
                    UnaryOp cast = HopRewriteUtils.createUnary((Hop)uhi, Types.OpOp1.CAST_AS_MATRIX);
                    for (Hop p : parents) {
                        int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                        HopRewriteUtils.replaceChildReference(p, hi, cast, ix);
                    }
                    hi = cast;
                    LOG.debug((Object)"Applied simplifyRowwiseAggregate2");
                }
            }
        }
        return hi;
    }

    private static Hop simplifyMeanAggregation(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.DIV) && HopRewriteUtils.isAggUnaryOp(hi.getInput(0), Types.AggOp.SUM) && hi.getInput(0).getParent().size() == 1 && hi.getInput(1).getDataType().isScalar()) {
            AggUnaryOp agg = (AggUnaryOp)hi.getInput(0);
            Hop in = agg.getInput(0);
            Hop N = hi.getInput(1);
            if (agg.getDirection().isRow() && HopRewriteUtils.isSizeExpressionOf(N, in, false) || agg.getDirection().isCol() && HopRewriteUtils.isSizeExpressionOf(N, in, true)) {
                HopRewriteUtils.replaceChildReference(parent, hi, agg, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, N);
                agg.setOp(Types.AggOp.MEAN);
                hi = agg;
                LOG.debug((Object)"Applied simplifyMeanAggregation");
            }
        }
        return hi;
    }

    private static Hop simplifyColSumsMVMult(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (uhi.getOp() == Types.AggOp.SUM && uhi.getDirection() == Types.Direction.Col && HopRewriteUtils.isBinary(input, Types.OpOp2.MULT)) {
                Hop left = input.getInput(0);
                Hop right = input.getInput(1);
                if (left.getDim1() > 1L && left.getDim2() > 1L && right.getDim1() > 1L && right.getDim2() == 1L) {
                    ReorgOp trans = HopRewriteUtils.createTranspose(right);
                    AggBinaryOp mmult = HopRewriteUtils.createMatrixMultiply(trans, left);
                    HopRewriteUtils.replaceChildReference(parent, hi, mmult, pos);
                    HopRewriteUtils.cleanupUnreferenced(uhi, input);
                    hi = mmult;
                    LOG.debug((Object)"Applied simplifyColSumsMVMult");
                }
            }
        }
        return hi;
    }

    private static Hop simplifyRowSumsMVMult(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (uhi.getOp() == Types.AggOp.SUM && uhi.getDirection() == Types.Direction.Row && HopRewriteUtils.isBinary(input, Types.OpOp2.MULT)) {
                Hop left = input.getInput(0);
                Hop right = input.getInput(1);
                if (left.getDim1() > 1L && left.getDim2() > 1L && right.getDim1() == 1L && right.getDim2() > 1L) {
                    ReorgOp trans = HopRewriteUtils.createTranspose(right);
                    AggBinaryOp mmult = HopRewriteUtils.createMatrixMultiply(left, trans);
                    HopRewriteUtils.replaceChildReference(parent, hi, mmult, pos);
                    HopRewriteUtils.cleanupUnreferenced(hi, input);
                    hi = mmult;
                    LOG.debug((Object)"Applied simplifyRowSumsMVMult");
                }
            }
        }
        return hi;
    }

    private static Hop simplifyUnnecessaryAggregate(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_UNNECESSARY_AGGREGATE) && input.getDim1() == 1L && input.getDim2() == 1L && input.getDataType() == Types.DataType.MATRIX) {
                UnaryOp cast = HopRewriteUtils.createUnary(input, Types.OpOp1.CAST_AS_SCALAR);
                HopRewriteUtils.replaceChildReference(parent, hi, cast, pos);
                hi = cast;
                LOG.debug((Object)"Applied simplifyUnncessaryAggregate");
            }
        }
        return hi;
    }

    private static Hop simplifyEmptyAggregate(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_EMPTY_AGGREGATE) && HopRewriteUtils.isEmpty(input) && input.getDim1() >= 1L && input.getDim2() >= 1L) {
                Hop hnew = null;
                hnew = uhi.getDirection() == Types.Direction.RowCol ? new LiteralOp(0.0) : (uhi.getDirection() == Types.Direction.Col ? HopRewriteUtils.createDataGenOp(uhi, input, 0.0) : HopRewriteUtils.createDataGenOp(input, uhi, 0.0));
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyAggregate");
            }
        }
        return hi;
    }

    private static Hop simplifyEmptyColMeans(Hop parent, Hop hi, int pos) {
        if (hi.dimsKnown() && HopRewriteUtils.isAggUnaryOp(hi, Types.AggOp.MEAN, Types.Direction.Col)) {
            Hop in = hi.getInput(0);
            boolean apply = HopRewriteUtils.isBinary(in, Types.OpOp2.MINUS) && HopRewriteUtils.isAggUnaryOp(in.getInput(1), Types.AggOp.MEAN, Types.Direction.Col) && in.getInput(0) == in.getInput(1).getInput(0);
            boolean bl = apply = apply || HopRewriteUtils.isBinary(in, Types.OpOp2.DIV, Types.OpOp2.MULT) && in.getInput(1).getDim1() == 1L && HopRewriteUtils.isBinary(in.getInput(0), Types.OpOp2.MINUS) && HopRewriteUtils.isAggUnaryOp(in.getInput(0).getInput(1), Types.AggOp.MEAN, Types.Direction.Col) && in.getInput(0).getInput(0) == in.getInput(0).getInput(1).getInput(0);
            if (apply) {
                Hop hnew = HopRewriteUtils.createDataGenOp(hi, hi, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyColMeans");
            }
        }
        return hi;
    }

    private static Hop simplifyEmptyUnaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof UnaryOp) {
            UnaryOp uhi = (UnaryOp)hi;
            Hop input = uhi.getInput(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_EMPTY_UNARY) && HopRewriteUtils.isEmpty(input)) {
                Hop hnew = HopRewriteUtils.createDataGenOp(input, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyUnaryOperation");
            }
        }
        return hi;
    }

    private static Hop simplifyEmptyReorgOperation(Hop parent, Hop hi, int pos) {
        ReorgOp rhi;
        Hop input;
        if (hi instanceof ReorgOp && HopRewriteUtils.isEmpty(input = (rhi = (ReorgOp)hi).getInput(0))) {
            Hop hnew = null;
            if (rhi.getOp() == Types.ReOrgOp.TRANS) {
                hnew = HopRewriteUtils.createDataGenOp(input, true, input, true, 0.0);
            } else if (rhi.getOp() == Types.ReOrgOp.REV) {
                hnew = HopRewriteUtils.createDataGenOp(input, 0.0);
            } else if (rhi.getOp() == Types.ReOrgOp.DIAG) {
                if (HopRewriteUtils.isDimsKnown(input)) {
                    hnew = input.getDim2() == 1L ? HopRewriteUtils.createDataGenOp(input, false, input, true, 0.0) : HopRewriteUtils.createDataGenOpByVal(HopRewriteUtils.createValueHop(input, true), new LiteralOp(1L), null, Types.DataType.MATRIX, Types.ValueType.FP64, 0.0);
                }
            } else if (rhi.getOp() == Types.ReOrgOp.RESHAPE) {
                hnew = HopRewriteUtils.createDataGenOpByVal(rhi.getInput(1), rhi.getInput(2), rhi.getInput(3), rhi.getDataType(), rhi.getValueType(), 0.0);
            }
            if (hnew != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyReorgOperation");
            }
        }
        return hi;
    }

    private static Hop simplifyEmptySortOperation(Hop parent, Hop hi, int pos) {
        ReorgOp rhi;
        Hop input;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Types.ReOrgOp.SORT && HopRewriteUtils.isEmpty(input = (rhi = (ReorgOp)hi).getInput(0))) {
            Hop hnew = null;
            boolean ixret = false;
            if (rhi.getInput(3) instanceof LiteralOp) {
                ixret = HopRewriteUtils.getBooleanValue((LiteralOp)rhi.getInput(3));
                hnew = ixret ? HopRewriteUtils.createSeqDataGenOp(input) : HopRewriteUtils.createDataGenOp(input, 0.0);
            }
            if (hnew != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied simplifyEmptySortOperation (indexreturn=" + ixret + ")."));
            }
        }
        return hi;
    }

    private static Hop simplifyEmptyMatrixMult(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (HopRewriteUtils.isEmpty(left) || HopRewriteUtils.isEmpty(right)) {
                Hop hnew = HopRewriteUtils.createDataGenOp(left, right, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyMatrixMult");
            }
        }
        return hi;
    }

    private static Hop simplifyIdentityRepMatrixMult(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (HopRewriteUtils.isDimsKnown(right) && right.getDim1() == 1L && right.getDim2() == 1L && right instanceof DataGenOp && ((DataGenOp)right).getOp() == Types.OpOpDG.RAND && ((DataGenOp)right).hasConstantValue(1.0)) {
                HopRewriteUtils.replaceChildReference(parent, hi, left, pos);
                hi = left;
                LOG.debug((Object)"Applied simplifyIdentiyMatrixMult");
            }
        }
        return hi;
    }

    private static Hop simplifyScalarMatrixMult(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (HopRewriteUtils.isDimsKnown(left) && left.getDim1() == 1L && left.getDim2() == 1L) {
                UnaryOp cast = HopRewriteUtils.createUnary(left, Types.OpOp1.CAST_AS_SCALAR);
                BinaryOp mult = HopRewriteUtils.createBinary((Hop)cast, right, Types.OpOp2.MULT);
                HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = mult;
                LOG.debug((Object)"Applied simplifyScalarMatrixMult1");
            } else if (HopRewriteUtils.isDimsKnown(right) && right.getDim1() == 1L && right.getDim2() == 1L) {
                UnaryOp cast = HopRewriteUtils.createUnary(right, Types.OpOp1.CAST_AS_SCALAR);
                BinaryOp mult = HopRewriteUtils.createBinary((Hop)cast, left, Types.OpOp2.MULT);
                HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = mult;
                LOG.debug((Object)"Applied simplifyScalarMatrixMult2");
            }
        }
        return hi;
    }

    private static Hop simplifyMatrixMultDiag(Hop parent, Hop hi, int pos) {
        BinaryOp hnew = null;
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (left instanceof ReorgOp && ((ReorgOp)left).getOp() == Types.ReOrgOp.DIAG && HopRewriteUtils.isDimsKnown(left) && left.getDim2() > 1L) {
                if (right.getDim2() == 1L) {
                    Hop input = left.getInput(0);
                    hnew = HopRewriteUtils.createBinary(input, right, Types.OpOp2.MULT);
                    LOG.debug((Object)"Applied simplifyMatrixMultDiag1");
                } else if (right.getDim2() > 1L) {
                    Hop input = left.getInput(0);
                    hnew = HopRewriteUtils.createBinary(right, input, Types.OpOp2.MULT);
                    LOG.debug((Object)"Applied simplifyMatrixMultDiag2");
                }
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = hnew;
        }
        return hi;
    }

    private static Hop simplifyDiagMatrixMult(Hop parent, Hop hi, int pos) {
        Hop hi2;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Types.ReOrgOp.DIAG && hi.getDim2() == 1L && HopRewriteUtils.isMatrixMultiply(hi2 = hi.getInput(0))) {
            Hop left = hi2.getInput(0);
            Hop right = hi2.getInput(1);
            ReorgOp trans = HopRewriteUtils.createTranspose(right);
            BinaryOp mult = HopRewriteUtils.createBinary(left, (Hop)trans, Types.OpOp2.MULT);
            AggUnaryOp rowSum = HopRewriteUtils.createAggUnaryOp(mult, Types.AggOp.SUM, Types.Direction.Row);
            HopRewriteUtils.replaceChildReference(parent, hi, rowSum, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi2);
            hi = rowSum;
            LOG.debug((Object)"Applied simplifyDiagMatrixMult");
        }
        return hi;
    }

    private static Hop simplifyDistributiveMatrixMult(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.PLUS) && HopRewriteUtils.isMatrixMultiply(hi.getInput(0)) && HopRewriteUtils.isMatrixMultiply(hi.getInput(1)) && hi.getInput(0).getParent().size() == 1 && hi.getInput(1).getParent().size() == 1 && hi.getInput(0).getInput(0) == hi.getInput(1).getInput(0)) {
            Hop A = hi.getInput(0).getInput(0);
            Hop B = hi.getInput(0).getInput(1);
            Hop C = hi.getInput(1).getInput(1);
            boolean dense = HopRewriteUtils.isDense(A) && HopRewriteUtils.isDense(B) && HopRewriteUtils.isDense(C);
            long m = A.getDim1();
            long n = A.getDim2();
            long l = B.getDim2();
            long o = C.getDim2();
            long costOriginal = m * n * l + m * n * o + m * l + m * n + n * l + n * o + m * l + m * o + m * l;
            long costRewrite = n * l + m * n * l + m * n + n * l + n * o + n * l + m * l;
            if (dense && costRewrite < costOriginal) {
                BinaryOp BplusC = HopRewriteUtils.createBinary(B, C, Types.OpOp2.PLUS);
                AggBinaryOp newHop = HopRewriteUtils.createMatrixMultiply(A, BplusC);
                if (parent != null) {
                    HopRewriteUtils.replaceChildReference(parent, hi, newHop, pos);
                    HopRewriteUtils.cleanupUnreferenced(hi);
                    hi = newHop;
                    LOG.debug((Object)("Applied simplifyDistributiveMatrixMult (line " + hi.getBeginLine() + ")"));
                }
            }
        }
        return hi;
    }

    private static Hop simplifySumDiagToTrace(Hop hi) {
        Hop hi2;
        AggUnaryOp au;
        if (hi instanceof AggUnaryOp && (au = (AggUnaryOp)hi).getOp() == Types.AggOp.SUM && au.getDirection() == Types.Direction.RowCol && (hi2 = au.getInput(0)) instanceof ReorgOp && ((ReorgOp)hi2).getOp() == Types.ReOrgOp.DIAG && hi2.getDim2() == 1L) {
            Hop hi3 = hi2.getInput(0);
            HopRewriteUtils.replaceChildReference(au, hi2, hi3, 0);
            HopRewriteUtils.cleanupUnreferenced(hi2);
            au.setOp(Types.AggOp.TRACE);
            LOG.debug((Object)"Applied simplifySumDiagToTrace");
        }
        return hi;
    }

    private static Hop simplifyLowerTriExtraction(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MULT) && hi.getDim1() == hi.getDim2() && hi.getDim1() > 1L) {
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (HopRewriteUtils.isUnary(right, Types.OpOp1.CUMSUM) && right.getParent().size() == 1 && HopRewriteUtils.isReorg(right.getInput(0), Types.ReOrgOp.DIAG) && HopRewriteUtils.isDataGenOpWithConstantValue(right.getInput(0).getInput(0), 1.0)) {
                LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
                args.put("target", left);
                args.put("diag", new LiteralOp(true));
                args.put("values", new LiteralOp(true));
                ParameterizedBuiltinOp hnew = HopRewriteUtils.createParameterizedBuiltinOp(left, args, Types.ParamBuiltinOp.LOWER_TRI);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew);
                HopRewriteUtils.removeAllChildReferences(right);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyLowerTriExtraction");
            }
        }
        return hi;
    }

    private static Hop simplifyConstantCumsum(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isUnary(hi, Types.OpOp1.CUMSUM) && HopRewriteUtils.isDataGenOpWithConstantValue(hi.getInput(0)) && hi.getInput(0).getParent().size() == 1 && hi.dimsKnown() && hi.getDim2() == 1L) {
            Hop constVal = ((DataGenOp)hi.getInput(0)).getConstantValue();
            BinaryOp to = HopRewriteUtils.createBinary((Hop)new LiteralOp(hi.getDim1()), constVal, Types.OpOp2.MULT);
            DataGenOp hnew = HopRewriteUtils.createSeqDataGenOp(hi, constVal, to, constVal);
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
            LOG.debug((Object)("Applied simplifyConstantCumsum (line " + hi.getBeginLine() + ")."));
        }
        return hi;
    }

    private static Hop pushdownBinaryOperationOnDiag(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MULT)) {
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            boolean applyLeft = false;
            boolean applyRight = false;
            if (left instanceof ReorgOp && ((ReorgOp)left).getOp() == Types.ReOrgOp.DIAG && left.getParent().size() == 1 && left.getInput(0).getDim2() == 1L && right.getDataType() == Types.DataType.SCALAR) {
                applyLeft = true;
            } else if (right instanceof ReorgOp && ((ReorgOp)right).getOp() == Types.ReOrgOp.DIAG && right.getParent().size() == 1 && right.getInput(0).getDim2() == 1L && left.getDataType() == Types.DataType.SCALAR) {
                applyRight = true;
            }
            if (applyLeft || applyRight) {
                Hop input;
                int lpos;
                ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                ArrayList<Integer> parentspos = new ArrayList<Integer>();
                for (Hop lparent : parents) {
                    lpos = HopRewriteUtils.getChildReferencePos(lparent, hi);
                    HopRewriteUtils.removeChildReferenceByPos(lparent, hi, lpos);
                    parentspos.add(lpos);
                }
                if (applyLeft) {
                    input = left.getInput(0);
                    HopRewriteUtils.removeChildReferenceByPos(hi, left, 0);
                    HopRewriteUtils.removeChildReferenceByPos(left, input, 0);
                    HopRewriteUtils.addChildReference(left, hi, 0);
                    HopRewriteUtils.addChildReference(hi, input, 0);
                    hi.refreshSizeInformation();
                    hi = left;
                } else if (applyRight) {
                    input = right.getInput(0);
                    HopRewriteUtils.removeChildReferenceByPos(hi, right, 1);
                    HopRewriteUtils.removeChildReferenceByPos(right, input, 0);
                    HopRewriteUtils.addChildReference(right, hi, 0);
                    HopRewriteUtils.addChildReference(hi, input, 1);
                    hi.refreshSizeInformation();
                    hi = right;
                }
                for (int i = 0; i < parents.size(); ++i) {
                    Hop lparent;
                    lparent = (Hop)parents.get(i);
                    lpos = (Integer)parentspos.get(i);
                    HopRewriteUtils.addChildReference(lparent, hi, lpos);
                }
                LOG.debug((Object)"Applied pushdownBinaryOperationOnDiag.");
            }
        }
        return hi;
    }

    private static Hop pushdownSumOnAdditiveBinary(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && hi.getInput(0) instanceof BinaryOp && hi.getInput(0).getParent().size() == 1) {
            BinaryOp bop = (BinaryOp)hi.getInput(0);
            Hop left = bop.getInput(0);
            Hop right = bop.getInput(1);
            if (left.getDataType() == Types.DataType.MATRIX && right.getDataType() == Types.DataType.MATRIX) {
                Types.OpOp2 applyOp;
                Types.OpOp2 opOp2 = applyOp = bop.getOp() == Types.OpOp2.PLUS || bop.getOp() == Types.OpOp2.MINUS ? bop.getOp() : null;
                if (applyOp != null) {
                    if (HopRewriteUtils.isEqualSize(left, right)) {
                        AggUnaryOp sum1 = HopRewriteUtils.createSum(left);
                        AggUnaryOp sum2 = HopRewriteUtils.createSum(right);
                        BinaryOp newBin = HopRewriteUtils.createBinary((Hop)sum1, (Hop)sum2, applyOp);
                        HopRewriteUtils.replaceChildReference(parent, hi, newBin, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, bop);
                        hi = newBin;
                        LOG.debug((Object)("Applied pushdownSumOnAdditiveBinary (line " + hi.getBeginLine() + ")."));
                    } else if (right.getDim1() == 1L || right.getDim2() == 1L) {
                        AggUnaryOp sum1 = HopRewriteUtils.createSum(left);
                        AggUnaryOp sum2 = HopRewriteUtils.createSum(right);
                        if (right.getDim1() == 1L) {
                            UnaryOp nRows = HopRewriteUtils.createUnary(left, Types.OpOp1.NROW);
                            BinaryOp scaledSum = HopRewriteUtils.createBinary((Hop)nRows, (Hop)sum2, Types.OpOp2.MULT);
                            BinaryOp newBin = HopRewriteUtils.createBinary((Hop)sum1, (Hop)scaledSum, applyOp);
                            HopRewriteUtils.replaceChildReference(parent, hi, newBin, pos);
                            HopRewriteUtils.cleanupUnreferenced(hi, bop);
                            hi = newBin;
                            LOG.debug((Object)("Applied pushdownSumOnAdditiveBinary with row vector (line " + hi.getBeginLine() + ")."));
                        } else if (right.getDim2() == 1L) {
                            UnaryOp nCols = HopRewriteUtils.createUnary(left, Types.OpOp1.NCOL);
                            BinaryOp scaledSum = HopRewriteUtils.createBinary((Hop)nCols, (Hop)sum2, Types.OpOp2.MULT);
                            BinaryOp newBin = HopRewriteUtils.createBinary((Hop)sum1, (Hop)scaledSum, applyOp);
                            HopRewriteUtils.replaceChildReference(parent, hi, newBin, pos);
                            HopRewriteUtils.cleanupUnreferenced(hi, bop);
                            hi = newBin;
                            LOG.debug((Object)("Applied pushdownSumOnAdditiveBinary with column vector (line " + hi.getBeginLine() + ")."));
                        }
                    }
                }
            }
        }
        return hi;
    }

    private static Hop simplifyWeightedSquaredLoss(Hop parent, Hop hi, int pos) {
        QuaternaryOp hnew = null;
        boolean appliedPattern = false;
        if (HopRewriteUtils.isAggUnaryOp(hi, Types.AggOp.SUM, Types.Direction.RowCol) && hi.getInput(0) instanceof BinaryOp && hi.getInput(0).getDim2() > 1L) {
            Hop V;
            Hop U;
            Hop W;
            Hop tmp;
            Hop lright;
            Hop lleft;
            Hop X;
            int uvIndex;
            BinaryOp bop = (BinaryOp)hi.getInput(0);
            if (bop.getOp() == Types.OpOp2.MULT && HopRewriteUtils.isBinary(bop.getInput(1), Types.OpOp2.POW) && bop.getInput(0).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isEqualSize(bop.getInput(0), bop.getInput(1)) && HopRewriteUtils.isLiteralOfValue(bop.getInput(1).getInput(1), 2.0)) {
                Hop W2 = bop.getInput(0);
                Hop tmp2 = bop.getInput(1).getInput(0);
                if (HopRewriteUtils.isBinary(tmp2, Types.OpOp2.MINUS) && HopRewriteUtils.isEqualSize(tmp2.getInput(0), tmp2.getInput(1)) && tmp2.getInput(0).getDataType() == Types.DataType.MATRIX) {
                    uvIndex = -1;
                    if (tmp2.getInput(1) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(tmp2.getInput(1).getInput(0), true)) {
                        uvIndex = 1;
                    } else if (tmp2.getInput(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(tmp2.getInput(0).getInput(0), true)) {
                        uvIndex = 0;
                    }
                    if (uvIndex >= 0) {
                        X = tmp2.getInput().get(uvIndex == 0 ? 1 : 0);
                        Hop U2 = tmp2.getInput().get(uvIndex).getInput(0);
                        Hop V2 = tmp2.getInput().get(uvIndex).getInput(1);
                        Hop hop = V2 = !HopRewriteUtils.isTransposeOperation(V2) ? HopRewriteUtils.createTranspose(V2) : V2.getInput(0);
                        if (HopRewriteUtils.isNonZeroIndicator(W2, X)) {
                            W2 = new LiteralOp(1L);
                        }
                        hnew = new QuaternaryOp(hi.getName(), Types.DataType.SCALAR, Types.ValueType.FP64, Types.OpOp4.WSLOSS, X, U2, V2, W2, true);
                        HopRewriteUtils.setOutputParametersForScalar(hnew);
                        appliedPattern = true;
                        LOG.debug((Object)("Applied simplifyWeightedSquaredLoss1" + uvIndex + " (line " + hi.getBeginLine() + ")"));
                    }
                }
            }
            if (!appliedPattern && bop.getOp() == Types.OpOp2.POW && HopRewriteUtils.isLiteralOfValue(bop.getInput(1), 2.0) && HopRewriteUtils.isBinary(bop.getInput(0), Types.OpOp2.MINUS) && HopRewriteUtils.isEqualMatrixSize((BinaryOp)bop.getInput(0))) {
                lleft = bop.getInput(0).getInput(0);
                lright = bop.getInput(0).getInput(1);
                int wuvIndex = -1;
                if (lright instanceof BinaryOp && lright.getInput(1) instanceof AggBinaryOp) {
                    wuvIndex = 1;
                } else if (lleft instanceof BinaryOp && lleft.getInput(1) instanceof AggBinaryOp) {
                    wuvIndex = 0;
                }
                if (wuvIndex >= 0) {
                    X = bop.getInput(0).getInput().get(wuvIndex == 0 ? 1 : 0);
                    tmp = bop.getInput(0).getInput().get(wuvIndex);
                    if (((BinaryOp)tmp).getOp() == Types.OpOp2.MULT && tmp.getInput(0).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isEqualSize(tmp.getInput(0), tmp.getInput(1)) && HopRewriteUtils.isSingleBlock(tmp.getInput(1).getInput(0), true)) {
                        W = tmp.getInput(0);
                        U = tmp.getInput(1).getInput(0);
                        V = tmp.getInput(1).getInput(1);
                        V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                        hnew = new QuaternaryOp(hi.getName(), Types.DataType.SCALAR, Types.ValueType.FP64, Types.OpOp4.WSLOSS, X, U, V, W, false);
                        HopRewriteUtils.setOutputParametersForScalar(hnew);
                        appliedPattern = true;
                        LOG.debug((Object)("Applied simplifyWeightedSquaredLoss2" + wuvIndex + " (line " + hi.getBeginLine() + ")"));
                    }
                }
            }
            if (!appliedPattern && bop.getOp() == Types.OpOp2.POW && HopRewriteUtils.isLiteralOfValue(bop.getInput(1), 2.0) && HopRewriteUtils.isBinary(bop.getInput(0), Types.OpOp2.MINUS) && HopRewriteUtils.isEqualMatrixSize((BinaryOp)bop.getInput(0))) {
                lleft = bop.getInput(0).getInput(0);
                lright = bop.getInput(0).getInput(1);
                uvIndex = -1;
                if (lright instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(lright.getInput(0), true)) {
                    uvIndex = 1;
                } else if (lleft instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(lleft.getInput(0), true)) {
                    uvIndex = 0;
                }
                if (uvIndex >= 0) {
                    X = bop.getInput(0).getInput().get(uvIndex == 0 ? 1 : 0);
                    tmp = bop.getInput(0).getInput().get(uvIndex);
                    W = new LiteralOp(1L);
                    U = tmp.getInput(0);
                    V = tmp.getInput(1);
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.SCALAR, Types.ValueType.FP64, Types.OpOp4.WSLOSS, X, U, V, W, false);
                    HopRewriteUtils.setOutputParametersForScalar(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedSquaredLoss3" + uvIndex + " (line " + hi.getBeginLine() + ")"));
                }
            }
        }
        if (!appliedPattern && HopRewriteUtils.isAggUnaryOp(hi, Types.AggOp.SUM_SQ, Types.Direction.RowCol) && HopRewriteUtils.isBinary(hi.getInput(0), Types.OpOp2.MINUS) && HopRewriteUtils.isEqualMatrixSize((BinaryOp)hi.getInput(0))) {
            Hop lleft = hi.getInput(0).getInput(0);
            Hop lright = hi.getInput(0).getInput(1);
            int uvIndex = -1;
            if (lright instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(lright.getInput(0), true)) {
                uvIndex = 1;
            } else if (lleft instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(lleft.getInput(0), true)) {
                uvIndex = 0;
            }
            if (uvIndex >= 0) {
                Hop X = hi.getInput(0).getInput().get(uvIndex == 0 ? 1 : 0);
                Hop tmp = hi.getInput(0).getInput().get(uvIndex);
                LiteralOp W = new LiteralOp(1L);
                Hop U = tmp.getInput(0);
                Hop V = tmp.getInput(1);
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.SCALAR, Types.ValueType.FP64, Types.OpOp4.WSLOSS, X, U, V, W, false);
                HopRewriteUtils.setOutputParametersForScalar(hnew);
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSquaredLoss4" + uvIndex + " (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private static Hop simplifyWeightedSigmoidMMChains(Hop parent, Hop hi, int pos) {
        QuaternaryOp hnew = null;
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.MULT) && hi.getDim2() > 1L && HopRewriteUtils.isEqualSize(hi.getInput(0), hi.getInput(1)) && hi.getInput(0).getDataType() == Types.DataType.MATRIX && hi.getInput(1) instanceof UnaryOp) {
            BinaryOp bop;
            Hop tX;
            Hop Y;
            Hop W;
            UnaryOp uop = (UnaryOp)hi.getInput(1);
            boolean appliedPattern = false;
            if (uop.getOp() == Types.OpOp1.SIGMOID && uop.getInput(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(uop.getInput(0).getInput(0), true)) {
                W = hi.getInput(0);
                Y = uop.getInput(0).getInput(0);
                tX = uop.getInput(0).getInput(1);
                tX = !HopRewriteUtils.isTransposeOperation(tX) ? HopRewriteUtils.createTranspose(tX) : tX.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WSIGMOID, W, Y, tX, false, false);
                hnew.setBlocksize(W.getBlocksize());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid1 (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && uop.getOp() == Types.OpOp1.SIGMOID && HopRewriteUtils.isBinary(uop.getInput(0), Types.OpOp2.MINUS) && uop.getInput(0).getInput(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)uop.getInput(0).getInput(0)) == 0.0 && uop.getInput(0).getInput(1) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(uop.getInput(0).getInput(1).getInput(0), true)) {
                W = hi.getInput(0);
                Y = uop.getInput(0).getInput(1).getInput(0);
                tX = uop.getInput(0).getInput(1).getInput(1);
                tX = !HopRewriteUtils.isTransposeOperation(tX) ? HopRewriteUtils.createTranspose(tX) : tX.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WSIGMOID, W, Y, tX, false, true);
                hnew.setBlocksize(W.getBlocksize());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid2 (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && uop.getOp() == Types.OpOp1.LOG && HopRewriteUtils.isUnary(uop.getInput(0), Types.OpOp1.SIGMOID) && uop.getInput(0).getInput(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(uop.getInput(0).getInput(0).getInput(0), true)) {
                W = hi.getInput(0);
                Y = uop.getInput(0).getInput(0).getInput(0);
                tX = uop.getInput(0).getInput(0).getInput(1);
                tX = !HopRewriteUtils.isTransposeOperation(tX) ? HopRewriteUtils.createTranspose(tX) : tX.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WSIGMOID, W, Y, tX, true, false);
                hnew.setBlocksize(W.getBlocksize());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid3 (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && uop.getOp() == Types.OpOp1.LOG && HopRewriteUtils.isUnary(uop.getInput(0), Types.OpOp1.SIGMOID) && HopRewriteUtils.isBinary(uop.getInput(0).getInput(0), Types.OpOp2.MINUS) && (bop = (BinaryOp)uop.getInput(0).getInput(0)).getInput(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)bop.getInput(0)) == 0.0 && bop.getInput(1) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(bop.getInput(1).getInput(0), true)) {
                Hop W2 = hi.getInput(0);
                Hop Y2 = bop.getInput(1).getInput(0);
                Hop tX2 = bop.getInput(1).getInput(1);
                tX2 = !HopRewriteUtils.isTransposeOperation(tX2) ? HopRewriteUtils.createTranspose(tX2) : tX2.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WSIGMOID, W2, Y2, tX2, true, true);
                hnew.setBlocksize(W2.getBlocksize());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid4 (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private static Hop simplifyWeightedDivMM(Hop parent, Hop hi, int pos) {
        MultiThreadedHop hnew = null;
        boolean appliedPattern = false;
        if (HopRewriteUtils.isMatrixMultiply(hi) && (hi.getInput(0) instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi.getInput(0)).getOp(), LOOKUP_VALID_WDIVMM_BINARY) || hi.getInput(1) instanceof BinaryOp && hi.getDim2() > 1L && HopRewriteUtils.isValidOp(((BinaryOp)hi.getInput(1)).getOp(), LOOKUP_VALID_WDIVMM_BINARY))) {
            boolean mult;
            Hop V;
            Hop U;
            Hop W;
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (right instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)right).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(right.getInput(0), right.getInput(1)) && HopRewriteUtils.isOuterProductLikeMM(right.getInput(1)) && HopRewriteUtils.isSingleBlock(right.getInput(1).getInput(0), true)) {
                W = right.getInput(0);
                U = right.getInput(1).getInput(0);
                V = right.getInput(1).getInput(1);
                if (HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                    mult = ((BinaryOp)right).getOp() == Types.OpOp2.MULT;
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, new LiteralOp(-1L), 1, mult, false);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM1 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(right, LOOKUP_VALID_WDIVMM_BINARY[1]) && HopRewriteUtils.isEqualSize(right.getInput(0), right.getInput(1)) && HopRewriteUtils.isBinary(right.getInput(1), Types.OpOp2.PLUS) && right.getInput(1).getInput(1).getDataType() == Types.DataType.SCALAR && HopRewriteUtils.isOuterProductLikeMM(right.getInput(1).getInput(0)) && HopRewriteUtils.isSingleBlock(right.getInput(1).getInput(0).getInput(0), true)) {
                W = right.getInput(0);
                U = right.getInput(1).getInput(0).getInput(0);
                V = right.getInput(1).getInput(0).getInput(1);
                Hop X = right.getInput(1).getInput(1);
                if (HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, X, 3, false, false);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM1e (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && left instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)left).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(left.getInput(0), left.getInput(1)) && HopRewriteUtils.isOuterProductLikeMM(left.getInput(1)) && HopRewriteUtils.isSingleBlock(left.getInput(1).getInput(0), true)) {
                W = left.getInput(0);
                U = left.getInput(1).getInput(0);
                V = left.getInput(1).getInput(1);
                if (HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput(0);
                    mult = ((BinaryOp)left).getOp() == Types.OpOp2.MULT;
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, new LiteralOp(-1L), 2, mult, false);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM2 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(left, LOOKUP_VALID_WDIVMM_BINARY[1]) && HopRewriteUtils.isEqualSize(left.getInput(0), left.getInput(1)) && HopRewriteUtils.isBinary(left.getInput(1), Types.OpOp2.PLUS) && left.getInput(1).getInput(1).getDataType() == Types.DataType.SCALAR && HopRewriteUtils.isOuterProductLikeMM(left.getInput(1).getInput(0)) && HopRewriteUtils.isSingleBlock(left.getInput(1).getInput(0).getInput(0), true)) {
                W = left.getInput(0);
                U = left.getInput(1).getInput(0).getInput(0);
                V = left.getInput(1).getInput(0).getInput(1);
                Hop X = left.getInput(1).getInput(1);
                if (HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, X, 4, false, false);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM2e (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(right, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(right.getInput(1), Types.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(right.getInput(1).getInput(0)) && right.getInput(1).getInput(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isSingleBlock(right.getInput(1).getInput(0).getInput(0), true)) {
                W = right.getInput(0);
                U = right.getInput(1).getInput(0).getInput(0);
                V = right.getInput(1).getInput(0).getInput(1);
                Hop X = right.getInput(1).getInput(1);
                if (HopRewriteUtils.isNonZeroIndicator(W, X) && HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, X, U, V, new LiteralOp(-1L), 1, true, true);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM3 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(left, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(left.getInput(1), Types.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(left.getInput(1).getInput(0)) && left.getInput(1).getInput(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isSingleBlock(left.getInput(1).getInput(0).getInput(0), true)) {
                W = left.getInput(0);
                U = left.getInput(1).getInput(0).getInput(0);
                V = left.getInput(1).getInput(0).getInput(1);
                Hop X = left.getInput(1).getInput(1);
                if (HopRewriteUtils.isNonZeroIndicator(W, X) && HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, X, U, V, new LiteralOp(-1L), 2, true, true);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM4 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(right, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(right.getInput(1), Types.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(right.getInput(1).getInput(0)) && right.getInput(1).getInput(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isSingleBlock(right.getInput(1).getInput(0).getInput(0), true)) {
                W = right.getInput(0);
                U = right.getInput(1).getInput(0).getInput(0);
                V = right.getInput(1).getInput(0).getInput(1);
                Hop X = right.getInput(1).getInput(1);
                if (HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, X, 1, true, true);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM5 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(left, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(left.getInput(1), Types.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(left.getInput(1).getInput(0)) && left.getInput(1).getInput(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isSingleBlock(left.getInput(1).getInput(0).getInput(0), true)) {
                W = left.getInput(0);
                U = left.getInput(1).getInput(0).getInput(0);
                V = left.getInput(1).getInput(0).getInput(1);
                Hop X = left.getInput(1).getInput(1);
                if (HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput(0);
                    hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, X, 2, true, true);
                    hnew.setBlocksize(W.getBlocksize());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM6 (line " + hi.getBeginLine() + ")"));
                }
            }
        }
        if (!appliedPattern && HopRewriteUtils.isBinary(hi, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isEqualSize(hi.getInput(0), hi.getInput(1)) && hi.getDim2() > 1L && hi.getInput(0).getDataType() == Types.DataType.MATRIX && hi.getInput(0).getDim2() > (long)hi.getInput(0).getBlocksize() && HopRewriteUtils.isOuterProductLikeMM(hi.getInput(1)) && (((AggBinaryOp)hi.getInput(1)).checkMapMultChain() == MapMultChain.ChainType.NONE || hi.getInput(1).getInput(1).getDim2() > 1L) && HopRewriteUtils.isSingleBlock(hi.getInput(1).getInput(0), true)) {
            Hop W = hi.getInput(0);
            Hop U = hi.getInput(1).getInput(0);
            Hop V = hi.getInput(1).getInput(1);
            if (HopRewriteUtils.isSparse(W) && !HopRewriteUtils.isSparse(U) && !HopRewriteUtils.isSparse(V) || HopRewriteUtils.isDense(U) && HopRewriteUtils.isDense(V)) {
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WDIVMM, W, U, V, new LiteralOp(-1L), 0, true, false);
                hnew.setBlocksize(W.getBlocksize());
                hnew.refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedDivMM7 (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private static Hop simplifyWeightedCrossEntropy(Hop parent, Hop hi, int pos) {
        QuaternaryOp hnew = null;
        boolean appliedPattern = false;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && hi.getInput(0) instanceof BinaryOp && hi.getInput(0).getDim2() > 1L) {
            Hop V;
            Hop U;
            Hop X;
            BinaryOp bop = (BinaryOp)hi.getInput(0);
            Hop left = bop.getInput(0);
            Hop right = bop.getInput(1);
            if (bop.getOp() == Types.OpOp2.MULT && left.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isEqualSize(left, right) && HopRewriteUtils.isUnary(right, Types.OpOp1.LOG) && right.getInput(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(right.getInput(0).getInput(0), true)) {
                X = left;
                U = right.getInput(0).getInput(0);
                V = right.getInput(0).getInput(1);
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.SCALAR, Types.ValueType.FP64, Types.OpOp4.WCEMM, X, U, V, new LiteralOp(0.0), 0, false, false);
                hnew.setBlocksize(X.getBlocksize());
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedCEMM (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && bop.getOp() == Types.OpOp2.MULT && left.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isEqualSize(left, right) && HopRewriteUtils.isUnary(right, Types.OpOp1.LOG) && HopRewriteUtils.isBinary(right.getInput(0), Types.OpOp2.PLUS) && right.getInput(0).getInput(0) instanceof AggBinaryOp && right.getInput(0).getInput(1) instanceof LiteralOp && right.getInput(0).getInput(1).getDataType() == Types.DataType.SCALAR && HopRewriteUtils.isSingleBlock(right.getInput(0).getInput(0).getInput(0), true)) {
                X = left;
                U = right.getInput(0).getInput(0).getInput(0);
                V = right.getInput(0).getInput(0).getInput(1);
                Hop eps = right.getInput(0).getInput(1);
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.SCALAR, Types.ValueType.FP64, Types.OpOp4.WCEMM, X, U, V, eps, 1, false, false);
                hnew.setBlocksize(X.getBlocksize());
                LOG.debug((Object)("Applied simplifyWeightedCEMMEps (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private static Hop simplifyWeightedUnaryMM(Hop parent, Hop hi, int pos) {
        Hop nl;
        QuaternaryOp hnew = null;
        boolean appliedPattern = false;
        if (hi instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(hi.getInput(0), hi.getInput(1)) && hi.getDim2() > 1L && hi.getInput(0).getDataType() == Types.DataType.MATRIX && hi.getInput(0).getDim2() > (long)hi.getInput(0).getBlocksize() && hi.getInput(1) instanceof UnaryOp && HopRewriteUtils.isValidOp(((UnaryOp)hi.getInput(1)).getOp(), LOOKUP_VALID_WUMM_UNARY) && hi.getInput(1).getInput(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(hi.getInput(1).getInput(0).getInput(0), true)) {
            Hop W = hi.getInput(0);
            Hop U = hi.getInput(1).getInput(0).getInput(0);
            Hop V = hi.getInput(1).getInput(0).getInput(1);
            boolean mult = ((BinaryOp)hi).getOp() == Types.OpOp2.MULT;
            Types.OpOp1 op = ((UnaryOp)hi.getInput(1)).getOp();
            V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
            hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WUMM, W, U, V, mult, op, null);
            hnew.setBlocksize(W.getBlocksize());
            ((Hop)hnew).refreshSizeInformation();
            appliedPattern = true;
            LOG.debug((Object)("Applied simplifyWeightedUnaryMM1 (line " + hi.getBeginLine() + ")"));
        }
        if (!appliedPattern && hi instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi).getOp(), Types.OpOp2.MULT) && (HopRewriteUtils.isLiteralOfValue(hi.getInput(0), 2.0) || HopRewriteUtils.isLiteralOfValue(hi.getInput(1), 2.0)) && HopRewriteUtils.isBinary(nl = hi.getInput(0) instanceof LiteralOp ? hi.getInput(1) : hi.getInput(0), Types.OpOp2.MULT) && nl.getParent().size() == 1 && HopRewriteUtils.isEqualSize(nl.getInput(0), nl.getInput(1)) && nl.getDim2() > 1L && nl.getInput(0).getDataType() == Types.DataType.MATRIX && nl.getInput(0).getDim2() > (long)nl.getInput(0).getBlocksize() && HopRewriteUtils.isOuterProductLikeMM(nl.getInput(1)) && (((AggBinaryOp)nl.getInput(1)).checkMapMultChain() == MapMultChain.ChainType.NONE || nl.getInput(1).getInput(1).getDim2() > 1L) && HopRewriteUtils.isSingleBlock(nl.getInput(1).getInput(0), true)) {
            Hop W = nl.getInput(0);
            Hop U = nl.getInput(1).getInput(0);
            Hop V = nl.getInput(1).getInput(1);
            V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
            hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WUMM, W, U, V, true, null, Types.OpOp2.MULT);
            hnew.setBlocksize(W.getBlocksize());
            ((Hop)hnew).refreshSizeInformation();
            appliedPattern = true;
            LOG.debug((Object)("Applied simplifyWeightedUnaryMM2.7 (line " + hi.getBeginLine() + ")"));
        }
        if (!appliedPattern && hi instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(hi.getInput(0), hi.getInput(1)) && hi.getDim2() > 1L && hi.getInput(0).getDataType() == Types.DataType.MATRIX && hi.getInput(0).getDim2() > (long)hi.getInput(0).getBlocksize() && hi.getInput(1) instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi.getInput(1)).getOp(), LOOKUP_VALID_WUMM_BINARY)) {
            Hop left = hi.getInput(1).getInput(0);
            Hop right = hi.getInput(1).getInput(1);
            Hop abop = null;
            if (right.getDataType() == Types.DataType.SCALAR && right instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right) == 2.0 && left instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(left.getInput(0), true)) {
                abop = left;
            } else if (left.getDataType() == Types.DataType.SCALAR && left instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left) == 2.0 && ((BinaryOp)hi.getInput(1)).getOp() == Types.OpOp2.MULT && right instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(right.getInput(0), true)) {
                abop = right;
            }
            if (abop != null) {
                Hop W = hi.getInput(0);
                Hop U = abop.getInput(0);
                Hop V = abop.getInput(1);
                boolean mult = ((BinaryOp)hi).getOp() == Types.OpOp2.MULT;
                Types.OpOp2 op = ((BinaryOp)hi.getInput(1)).getOp();
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput(0);
                hnew = new QuaternaryOp(hi.getName(), Types.DataType.MATRIX, Types.ValueType.FP64, Types.OpOp4.WUMM, W, U, V, mult, null, op);
                hnew.setBlocksize(W.getBlocksize());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedUnaryMM2 (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private static Hop simplifyDotProductSum(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && hi.getInput(0).getDim2() == 1L) {
            Hop baLeft = null;
            Hop baRight = null;
            Hop hi2 = hi.getInput(0);
            if (HopRewriteUtils.isBinary(hi2, Types.OpOp2.POW) && hi2.getInput(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)hi2.getInput(1)) == 2.0 && hi2.getParent().size() == 1) {
                Hop input;
                baLeft = input = hi2.getInput(0);
                baRight = input;
            } else if (!(!HopRewriteUtils.isBinary(hi2, Types.OpOp2.MULT, 1) || hi2.getInput(0).getDim2() != 1L || hi2.getInput(1).getDim2() != 1L || !hi2.getInput(0).isMatrix() || !hi2.getInput(1).isMatrix() || HopRewriteUtils.isBinary(hi2.getInput(0), Types.OpOp2.MULT) || HopRewriteUtils.isBinary(hi2.getInput(1), Types.OpOp2.MULT) || OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES && HopRewriteUtils.isBinary(hi2.getInput(0), Types.OpOp2.POW) && hi2.getInput(0).getInput(1) instanceof LiteralOp && ((LiteralOp)hi2.getInput(0).getInput(1)).getLongValue() == 2L || OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES && HopRewriteUtils.isBinary(hi2.getInput(1), Types.OpOp2.POW) && hi2.getInput(1).getInput(1) instanceof LiteralOp && ((LiteralOp)hi2.getInput(1).getInput(1)).getLongValue() == 2L)) {
                baLeft = hi2.getInput(0);
                baRight = hi2.getInput(1);
            }
            if (baLeft != null && baRight != null) {
                ReorgOp trans = HopRewriteUtils.createTranspose(baLeft);
                AggBinaryOp mmult = HopRewriteUtils.createMatrixMultiply(trans, baRight);
                UnaryOp cast = HopRewriteUtils.createUnary((Hop)mmult, Types.OpOp1.CAST_AS_SCALAR);
                HopRewriteUtils.replaceChildReference(parent, hi, cast, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, hi2);
                hi = cast;
                LOG.debug((Object)("Applied simplifyDotProductSum (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop fuseSumSquared(Hop parent, Hop hi, int pos) {
        Hop x;
        Hop sumInput;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && HopRewriteUtils.isBinary(sumInput = hi.getInput(0), Types.OpOp2.POW) && sumInput.getInput(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)sumInput.getInput(1)) == 2.0 && sumInput.getParent().size() == 1 && (x = sumInput.getInput(0)).getDim2() > 1L) {
            Types.Direction dir = ((AggUnaryOp)hi).getDirection();
            AggUnaryOp sumSq = HopRewriteUtils.createAggUnaryOp(x, Types.AggOp.SUM_SQ, dir);
            HopRewriteUtils.replaceChildReference(parent, hi, sumSq, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, sumInput);
            hi = sumSq;
            LOG.debug((Object)("Applied fuseSumSquared (line " + hi.getBeginLine() + ")."));
        }
        return hi;
    }

    private static Hop fuseAxpyBinaryOperationChain(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp && !((BinaryOp)hi).isOuter() && (((BinaryOp)hi).getOp() == Types.OpOp2.PLUS || ((BinaryOp)hi).getOp() == Types.OpOp2.MINUS)) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput(0);
            Hop right = bop.getInput(1);
            Hop ternop = null;
            if (bop.getOp() == Types.OpOp2.PLUS && left.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isScalarMatrixBinaryMult(right) && HopRewriteUtils.isEqualSize(left, right) && right.getParent().size() == 1) {
                Hop smid = right.getInput().get(right.getInput(0).getDataType() == Types.DataType.SCALAR ? 0 : 1);
                Hop mright = right.getInput().get(right.getInput(0).getDataType() == Types.DataType.SCALAR ? 1 : 0);
                ternop = smid instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)smid) == 0.0 ? left : HopRewriteUtils.createTernary(left, smid, mright, Types.OpOp3.PLUS_MULT);
                LOG.debug((Object)("Applied fuseAxpyBinaryOperationChain1. (line " + hi.getBeginLine() + ")"));
            } else if (bop.getOp() == Types.OpOp2.PLUS && right.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isScalarMatrixBinaryMult(left) && HopRewriteUtils.isEqualSize(left, right) && left.getParent().size() == 1) {
                Hop smid = left.getInput().get(left.getInput(0).getDataType() == Types.DataType.SCALAR ? 0 : 1);
                Hop mright = left.getInput().get(left.getInput(0).getDataType() == Types.DataType.SCALAR ? 1 : 0);
                ternop = smid instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)smid) == 0.0 ? right : HopRewriteUtils.createTernary(right, smid, mright, Types.OpOp3.PLUS_MULT);
                LOG.debug((Object)("Applied fuseAxpyBinaryOperationChain2. (line " + hi.getBeginLine() + ")"));
            } else if (bop.getOp() == Types.OpOp2.MINUS && left.getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isScalarMatrixBinaryMult(right) && HopRewriteUtils.isEqualSize(left, right) && right.getParent().size() == 1) {
                Hop smid = right.getInput().get(right.getInput(0).getDataType() == Types.DataType.SCALAR ? 0 : 1);
                Hop mright = right.getInput().get(right.getInput(0).getDataType() == Types.DataType.SCALAR ? 1 : 0);
                ternop = smid instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)smid) == 0.0 ? left : HopRewriteUtils.createTernary(left, smid, mright, Types.OpOp3.MINUS_MULT);
                LOG.debug((Object)("Applied fuseAxpyBinaryOperationChain3. (line " + hi.getBeginLine() + ")"));
            }
            if (ternop != null) {
                if (right.getForcedExecType() == Types.ExecType.FED) {
                    ternop.setForcedExecType(Types.ExecType.FED);
                }
                HopRewriteUtils.replaceChildReference(parent, hi, ternop, pos);
                hi = ternop;
            }
        }
        return hi;
    }

    private static Hop simplifyEmptyBinaryOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput(0);
            Hop right = hi.getInput(1);
            if (left.getDataType() == Types.DataType.MATRIX && right.getDataType() == Types.DataType.MATRIX) {
                Hop hnew = null;
                boolean notBinaryMV = HopRewriteUtils.isNotMatrixVectorBinaryOperation(bop);
                switch (bop.getOp()) {
                    case MULT: {
                        if (HopRewriteUtils.isEmpty(left)) {
                            hnew = HopRewriteUtils.createDataGenOp(left, left, 0.0);
                            break;
                        }
                        if (HopRewriteUtils.isEmpty(right) && right.getDim1() > 1L && right.getDim2() > 1L) {
                            hnew = HopRewriteUtils.createDataGenOp(right, right, 0.0);
                            break;
                        }
                        if (!HopRewriteUtils.isEmpty(right)) break;
                        hnew = HopRewriteUtils.createDataGenOp(left, left, 0.0);
                        break;
                    }
                    case PLUS: {
                        if (HopRewriteUtils.isEmpty(left) && HopRewriteUtils.isEmpty(right)) {
                            hnew = HopRewriteUtils.createDataGenOp(left, left, 0.0);
                            break;
                        }
                        if (HopRewriteUtils.isEmpty(left) && notBinaryMV) {
                            hnew = right;
                            break;
                        }
                        if (!HopRewriteUtils.isEmpty(right)) break;
                        hnew = left;
                        break;
                    }
                    case MINUS: {
                        if (HopRewriteUtils.isEmpty(left) && notBinaryMV) {
                            HopRewriteUtils.removeChildReference(hi, left);
                            HopRewriteUtils.addChildReference(hi, new LiteralOp(0L), 0);
                            hnew = hi;
                            break;
                        }
                        if (!HopRewriteUtils.isEmpty(right)) break;
                        hnew = left;
                        break;
                    }
                }
                if (hnew != null) {
                    HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                    hi = hnew;
                    LOG.debug((Object)("Applied simplifyEmptyBinaryOperation (line " + hi.getBeginLine() + ")."));
                }
            }
        }
        return hi;
    }

    private static Hop reorderMinusMatrixMult(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop hileft = hi.getInput(0);
            Hop hiright = hi.getInput(1);
            if (HopRewriteUtils.isBinary(hileft, Types.OpOp2.MINUS) && hileft.getInput(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)hileft.getInput(0)) == 0.0 && hi.dimsKnown() && hileft.getInput(1).dimsKnown() && HopRewriteUtils.compareSize(hi, hileft.getInput(1)) < 0) {
                Hop hi2 = hileft.getInput(1);
                HopRewriteUtils.removeChildReference(hi, hileft);
                ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                BinaryOp minus = HopRewriteUtils.createBinary((Hop)new LiteralOp(0L), hi, Types.OpOp2.MINUS);
                for (Hop p : parents) {
                    int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                    HopRewriteUtils.removeChildReference(p, hi);
                    HopRewriteUtils.addChildReference(p, minus, ix);
                }
                HopRewriteUtils.addChildReference(hi, hi2, 0);
                HopRewriteUtils.cleanupUnreferenced(hileft);
                hi = minus;
                LOG.debug((Object)("Applied reorderMinusMatrixMult (line " + hi.getBeginLine() + ")."));
            } else if (HopRewriteUtils.isBinary(hiright, Types.OpOp2.MINUS) && hiright.getInput(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)hiright.getInput(0)) == 0.0 && hi.dimsKnown() && hiright.getInput(1).dimsKnown() && HopRewriteUtils.compareSize(hi, hiright.getInput(1)) < 0) {
                Hop hi2 = hiright.getInput(1);
                HopRewriteUtils.removeChildReference(hi, hiright);
                ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                BinaryOp minus = HopRewriteUtils.createBinary((Hop)new LiteralOp(0L), hi, Types.OpOp2.MINUS);
                for (Hop p : parents) {
                    int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                    HopRewriteUtils.removeChildReference(p, hi);
                    HopRewriteUtils.addChildReference(p, minus, ix);
                }
                HopRewriteUtils.addChildReference(hi, hi2, 1);
                HopRewriteUtils.cleanupUnreferenced(hiright);
                hi = minus;
                LOG.debug((Object)("Applied reorderMinusMatrixMult (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private static Hop simplifySumMatrixMult(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && hi.getInput(0) instanceof AggBinaryOp && (hi.getInput(0).getDim1() > 1L || hi.getInput(0).getDim2() > 1L) && hi.getInput(0).getParent().size() == 1) {
            Hop hi2 = hi.getInput(0);
            Hop left = hi2.getInput(0);
            Hop right = hi2.getInput(1);
            HopRewriteUtils.removeChildReference(hi, hi2);
            MultiThreadedHop root = null;
            if (((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol) {
                AggUnaryOp colSum = HopRewriteUtils.createAggUnaryOp(left, Types.AggOp.SUM, Types.Direction.Col);
                ReorgOp trans = HopRewriteUtils.createTranspose(colSum);
                AggUnaryOp rowSum = HopRewriteUtils.createAggUnaryOp(right, Types.AggOp.SUM, Types.Direction.Row);
                root = HopRewriteUtils.createBinary((Hop)trans, (Hop)rowSum, Types.OpOp2.MULT);
                LOG.debug((Object)"Applied simplifySumMatrixMult RC.");
            } else if (((AggUnaryOp)hi).getDirection() == Types.Direction.Col) {
                AggUnaryOp colSum = HopRewriteUtils.createAggUnaryOp(left, Types.AggOp.SUM, Types.Direction.Col);
                root = HopRewriteUtils.createMatrixMultiply(colSum, right);
                LOG.debug((Object)"Applied simplifySumMatrixMult C.");
            } else if (((AggUnaryOp)hi).getDirection() == Types.Direction.Row) {
                AggUnaryOp rowSum = HopRewriteUtils.createAggUnaryOp(right, Types.AggOp.SUM, Types.Direction.Row);
                root = HopRewriteUtils.createMatrixMultiply(left, rowSum);
                LOG.debug((Object)"Applied simplifySumMatrixMult R.");
            }
            HopRewriteUtils.addChildReference(hi, root, 0);
            hi.refreshSizeInformation();
            HopRewriteUtils.cleanupUnreferenced(hi2);
        }
        return hi;
    }

    private static Hop simplifyScalarMVBinaryOperation(Hop hi) {
        Hop right;
        if (hi instanceof BinaryOp && ((BinaryOp)hi).supportsMatrixScalarOperations() && hi.getInput(0).getDataType() == Types.DataType.MATRIX && hi.getInput(1).getDataType() == Types.DataType.MATRIX && HopRewriteUtils.isDimsKnown(right = hi.getInput(1)) && right.getDim1() == 1L && right.getDim2() == 1L) {
            UnaryOp cast = HopRewriteUtils.createUnary(right, Types.OpOp1.CAST_AS_SCALAR);
            HopRewriteUtils.replaceChildReference(hi, right, cast, 1);
            LOG.debug((Object)"Applied simplifyScalarMVBinaryOperation.");
        }
        return hi;
    }

    private static Hop simplifyNnzComputation(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Types.AggOp.SUM && ((AggUnaryOp)hi).getDirection() == Types.Direction.RowCol && HopRewriteUtils.isBinary(hi.getInput(0), Types.OpOp2.NOTEQUAL)) {
            Hop ppred = hi.getInput(0);
            Hop X = null;
            if (ppred.getInput(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)ppred.getInput(0)) == 0.0) {
                X = ppred.getInput(1);
            } else if (ppred.getInput(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)ppred.getInput(1)) == 0.0) {
                X = ppred.getInput(0);
            }
            if (X != null && X.getNnz() > 0L) {
                LiteralOp hnew = new LiteralOp(X.getNnz());
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyNnzComputation.");
            }
        }
        return hi;
    }

    private static Hop simplifyNrowNcolComputation(Hop parent, Hop hi, int pos) {
        if (hi instanceof UnaryOp) {
            if (((UnaryOp)hi).getOp() == Types.OpOp1.NROW && hi.getInput(0).rowsKnown()) {
                LiteralOp hnew = new LiteralOp(hi.getInput(0).getDim1());
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos, false);
                HopRewriteUtils.cleanupUnreferenced(hi);
                LOG.debug((Object)("Applied simplifyNrowComputation nrow(" + hi.getHopID() + ") -> " + hnew.getName() + " (line " + hi.getBeginLine() + ")."));
                hi = hnew;
            } else if (((UnaryOp)hi).getOp() == Types.OpOp1.NCOL && hi.getInput(0).colsKnown()) {
                LiteralOp hnew = new LiteralOp(hi.getInput(0).getDim2());
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos, false);
                HopRewriteUtils.cleanupUnreferenced(hi);
                LOG.debug((Object)("Applied simplifyNcolComputation ncol(" + hi.getHopID() + ") -> " + hnew.getName() + " (line " + hi.getBeginLine() + ")."));
                hi = hnew;
            }
        }
        return hi;
    }

    private static Hop simplifyTableSeqExpand(Hop parent, Hop hi, int pos) {
        if (hi instanceof TernaryOp && hi.getInput().size() == 6 && HopRewriteUtils.isLiteralOfValue(hi.getInput(2), 1.0)) {
            Hop second;
            Hop first = hi.getInput(0);
            if (HopRewriteUtils.isBasic1NSequence(first, second = hi.getInput(1), true) && HopRewriteUtils.isSizeExpressionOf(hi.getInput(3), second, true)) {
                LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
                args.put("target", second);
                args.put("max", hi.getInput().get(4));
                args.put("dir", new LiteralOp("cols"));
                args.put("ignore", new LiteralOp(false));
                args.put("cast", new LiteralOp(true));
                ParameterizedBuiltinOp pbop = HopRewriteUtils.createParameterizedBuiltinOp(second, args, Types.ParamBuiltinOp.REXPAND);
                HopRewriteUtils.replaceChildReference(parent, hi, pbop, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = pbop;
                LOG.debug((Object)("Applied simplifyTableSeqExpand1 (line " + hi.getBeginLine() + ")"));
            } else if (HopRewriteUtils.isBasic1NSequence(second, first, true) && HopRewriteUtils.isSizeExpressionOf(hi.getInput().get(4), first, true)) {
                LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
                args.put("target", first);
                args.put("max", hi.getInput(3));
                args.put("dir", new LiteralOp("rows"));
                args.put("ignore", new LiteralOp(false));
                args.put("cast", new LiteralOp(true));
                ParameterizedBuiltinOp pbop = HopRewriteUtils.createParameterizedBuiltinOp(first, args, Types.ParamBuiltinOp.REXPAND);
                HopRewriteUtils.replaceChildReference(parent, hi, pbop, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = pbop;
                LOG.debug((Object)("Applied simplifyTableSeqExpand2 (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private static Hop foldMultipleMinMaxOperations(Hop hi) {
        if ((HopRewriteUtils.isBinary(hi, Types.OpOp2.MIN, Types.OpOp2.MAX, Types.OpOp2.PLUS, Types.OpOp2.MULT) || HopRewriteUtils.isNary(hi, Types.OpOpN.MIN, Types.OpOpN.MAX, Types.OpOpN.PLUS, Types.OpOpN.MULT)) && hi.getValueType() != Types.ValueType.STRING && HopRewriteUtils.isNotMatrixVectorBinaryOperation(hi)) {
            Types.OpOp2 bop = hi instanceof BinaryOp ? ((BinaryOp)hi).getOp() : Types.OpOp2.valueOf(((NaryOp)hi).getOp().name());
            Types.OpOpN nop = hi instanceof NaryOp ? ((NaryOp)hi).getOp() : Types.OpOpN.valueOf(((BinaryOp)hi).getOp().name());
            boolean converged = false;
            while (!converged) {
                Hop first = hi.getInput().stream().filter(h -> HopRewriteUtils.isBinary(h, bop) || HopRewriteUtils.isNary(h, nop)).findFirst().orElse(null);
                Hop lhi = hi;
                if (first != null && first.getParent().size() == 1 && first.getInput().stream().allMatch(c -> c.getDataType() == Types.DataType.SCALAR || HopRewriteUtils.isEqualSize(lhi, c))) {
                    ArrayList<Hop> linputs = new ArrayList<Hop>();
                    for (Hop in : hi.getInput()) {
                        if (in == first) {
                            linputs.addAll(first.getInput());
                            continue;
                        }
                        linputs.add(in);
                    }
                    NaryOp hnew = HopRewriteUtils.createNary(nop, linputs.toArray(new Hop[0]));
                    HopRewriteUtils.removeAllChildReferences(hi);
                    HopRewriteUtils.removeAllChildReferences(first);
                    ArrayList<Hop> parents = new ArrayList<Hop>(hi.getParent());
                    for (Hop p : parents) {
                        HopRewriteUtils.replaceChildReference(p, hi, hnew);
                    }
                    hi = hnew;
                    LOG.debug((Object)("Applied foldMultipleMinMaxPlusMultOperations (line " + hi.getBeginLine() + ")."));
                    continue;
                }
                converged = true;
            }
        }
        return hi;
    }

    private static Hop simplyfyMMCBindZeroVector(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Types.OpOp2.CBIND) && HopRewriteUtils.isMatrixMultiply(hi.getInput(0)) && HopRewriteUtils.isDataGenOpWithConstantValue(hi.getInput(1), 0.0) && hi.getInput(0).getInput(0).dimsKnown() && hi.getInput(0).getInput(1).dimsKnown()) {
            long n;
            Hop y = hi.getInput(0).getInput(1);
            Hop x = hi.getInput(0).getInput(0);
            long m = x.getDim1();
            if (m > (n = y.getDim1()) * 2L) {
                Hop oldGen = hi.getInput(1);
                Hop newGen = HopRewriteUtils.createDataGenOp(y, oldGen, 0.0);
                BinaryOp newCBind = HopRewriteUtils.createBinary(y, newGen, Types.OpOp2.CBIND);
                AggBinaryOp newMM = HopRewriteUtils.createMatrixMultiply(x, newCBind);
                HopRewriteUtils.replaceChildReference(parent, hi, newMM, pos);
                LOG.debug((Object)("Applied MMCBind Zero algebraic simplification (line " + hi.getBeginLine() + ")."));
                return newMM;
            }
        }
        return hi;
    }

    private static Hop fuseSeqAndTableExpand(Hop hi) {
        if (TernaryOp.ALLOW_CTABLE_SEQUENCE_REWRITES && hi instanceof TernaryOp) {
            Hop input1;
            TernaryOp thop = (TernaryOp)hi;
            thop.getOp();
            if (thop.isSequenceRewriteApplicable(true) && thop.findExecTypeTernaryOp() == Types.ExecType.CP && thop.getInput(1).getForcedExecType() != Types.ExecType.FED && (input1 = thop.getInput(0)) instanceof DataGenOp) {
                LiteralOp literal = new LiteralOp("seq(1, " + input1.getDim1() + ")");
                HopRewriteUtils.replaceChildReference(hi, input1, literal);
            }
        }
        return hi;
    }
}

