/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.cog;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.sysds.runtime.DMLRuntimeException;

public class COGByteReader {
    private long totalBytesRead;
    private BufferedInputStream bis;
    private long readlimit = 0L;

    public COGByteReader(BufferedInputStream bis) {
        this.bis = bis;
        this.totalBytesRead = 0L;
    }

    public COGByteReader(BufferedInputStream bis, int totalBytesRead) {
        this.bis = bis;
        this.totalBytesRead = totalBytesRead;
    }

    public long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public void setTotalBytesRead(int totalBytesRead) {
        this.totalBytesRead = totalBytesRead;
    }

    public byte[] readBytes(int length) {
        byte[] header = new byte[length];
        try {
            this.bis.read(header);
            this.totalBytesRead += (long)length;
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
        return header;
    }

    public byte[] readBytes(long length) {
        if (length > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("Cannot read more than Integer.MAX_VALUE bytes at once");
        }
        return this.readBytes((int)length);
    }

    public void mark(long readlimit) {
        this.readlimit = readlimit;
        this.bis.mark((int)readlimit + 1);
    }

    public void reset() throws DMLRuntimeException {
        try {
            this.bis.reset();
            this.totalBytesRead -= this.readlimit;
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    public void skipBytes(long n) throws DMLRuntimeException {
        try {
            long skipped = this.bis.skip(n);
            if (skipped != n) {
                throw new DMLRuntimeException("Could not skip " + n + " bytes, only skipped " + skipped + " bytes");
            }
            this.totalBytesRead += n;
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }
}

