/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data.sketch.countdistinctapprox;

import java.util.Collections;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmallestPriorityQueue {
    private static final Log LOG = LogFactory.getLog((String)SmallestPriorityQueue.class.getName());
    private Set<Double> containedSet;
    private PriorityQueue<Double> smallestHashes;
    private int k;

    public SmallestPriorityQueue(int k) {
        this.smallestHashes = new PriorityQueue(k, Collections.reverseOrder());
        this.containedSet = new HashSet<Double>(1);
        this.k = k;
    }

    public void add(double v) {
        if (!this.containedSet.contains(v)) {
            if (this.smallestHashes.size() < this.k) {
                this.smallestHashes.add(v);
                this.containedSet.add(v);
            } else if (v < this.smallestHashes.peek()) {
                LOG.trace((Object)(this.smallestHashes.peek() + " -- " + v));
                this.smallestHashes.add(v);
                this.containedSet.add(v);
                double largest = this.smallestHashes.poll();
                this.containedSet.remove(largest);
            }
        }
    }

    public int size() {
        return this.smallestHashes.size();
    }

    public double peek() {
        return this.smallestHashes.peek();
    }

    public double poll() {
        return this.smallestHashes.poll();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.containedSet.clear();
        this.smallestHashes.clear();
    }

    public String toString() {
        return this.smallestHashes.toString();
    }
}

