/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.hibernate;

import org.apache.tapestry5.internal.hibernate.EntityPersistentFieldStrategy;
import org.apache.tapestry5.internal.hibernate.SessionRestorable;
import org.apache.tapestry5.internal.services.SessionApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.ApplicationStateCreator;
import org.apache.tapestry5.services.Request;
import org.hibernate.Session;

public class EntityApplicationStatePersistenceStrategy
extends SessionApplicationStatePersistenceStrategy {
    private final EntityPersistentFieldStrategy delegate;

    public EntityApplicationStatePersistenceStrategy(Request request, Session hibernateSession) {
        super(request);
        this.delegate = new EntityPersistentFieldStrategy(hibernateSession, null);
    }

    public <T> T get(Class<T> ssoClass, ApplicationStateCreator<T> creator) {
        Object persistedValue = this.getOrCreate(ssoClass, creator);
        if (persistedValue instanceof SessionRestorable) {
            Object restored = this.delegate.convertPersistedToApplicationValue(persistedValue);
            if (restored == null) {
                this.set(ssoClass, null);
                return (T)this.getOrCreate(ssoClass, creator);
            }
            return (T)restored;
        }
        return (T)persistedValue;
    }

    public <T> void set(Class<T> ssoClass, T sso) {
        String key = this.buildKey(ssoClass);
        if (sso == null) {
            this.getSession().setAttribute(key, null);
            return;
        }
        Object persistable = this.delegate.convertApplicationValueToPersisted(sso);
        this.getSession().setAttribute(key, persistable);
    }
}

