/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.ajax;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.BooleanHook;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldFocusPriority;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackPathConstructor;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.Initialization;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.javascript.ModuleConfigurationCallback;
import org.apache.tapestry5.services.javascript.StylesheetLink;

public class JavaScriptSupportImpl
implements JavaScriptSupport {
    private final IdAllocator idAllocator;
    private final DocumentLinker linker;
    private final Map<String, Boolean> addedStacks = CollectionFactory.newCaseInsensitiveMap();
    private final Set<String> otherLibraries = CollectionFactory.newSet();
    private final Set<String> importedStylesheetURLs = CollectionFactory.newSet();
    private final List<StylesheetLink> stylesheetLinks = CollectionFactory.newList();
    private final List<InitializationImpl> inits = CollectionFactory.newList();
    private final JavaScriptStackSource javascriptStackSource;
    private final JavaScriptStackPathConstructor stackPathConstructor;
    private final boolean partialMode;
    private final BooleanHook suppressCoreStylesheetsHook;
    private FieldFocusPriority focusPriority;
    private String focusFieldId;
    private Map<String, String> libraryURLToStackName;
    private Map<String, String> moduleNameToStackName;

    public JavaScriptSupportImpl(DocumentLinker linker, JavaScriptStackSource javascriptStackSource, JavaScriptStackPathConstructor stackPathConstructor, BooleanHook suppressCoreStylesheetsHook) {
        this(linker, javascriptStackSource, stackPathConstructor, new IdAllocator(), false, suppressCoreStylesheetsHook);
    }

    public JavaScriptSupportImpl(DocumentLinker linker, JavaScriptStackSource javascriptStackSource, JavaScriptStackPathConstructor stackPathConstructor, IdAllocator idAllocator, boolean partialMode, BooleanHook suppressCoreStylesheetsHook) {
        this.linker = linker;
        this.idAllocator = idAllocator;
        this.javascriptStackSource = javascriptStackSource;
        this.stackPathConstructor = stackPathConstructor;
        this.partialMode = partialMode;
        this.suppressCoreStylesheetsHook = suppressCoreStylesheetsHook;
        if (partialMode) {
            this.addedStacks.put("core", true);
        }
    }

    public void commit() {
        if (this.focusFieldId != null) {
            this.require("t5/core/pageinit").invoke("focus").with(this.focusFieldId);
        }
        F.flow(this.stylesheetLinks).each((Worker)new Worker<StylesheetLink>(){

            public void work(StylesheetLink value) {
                JavaScriptSupportImpl.this.linker.addStylesheetLink(value);
            }
        });
        ((Flow)F.flow(this.inits).sort((Comparator)new Comparator<InitializationImpl>(){

            @Override
            public int compare(InitializationImpl o1, InitializationImpl o2) {
                return o1.priority.compareTo(o2.priority);
            }
        })).each((Worker)new Worker<InitializationImpl>(){

            public void work(InitializationImpl element) {
                JavaScriptSupportImpl.this.linker.addInitialization(element.priority, element.moduleName, element.functionName, element.arguments);
            }
        });
    }

    @Override
    public void addInitializerCall(InitializationPriority priority, String functionName, JSONObject parameter) {
        this.createInitializer(priority).with(functionName, parameter);
    }

    @Override
    public void addInitializerCall(String functionName, JSONArray parameter) {
        this.addInitializerCall(InitializationPriority.NORMAL, functionName, parameter);
    }

    @Override
    public void addInitializerCall(InitializationPriority priority, String functionName, JSONArray parameter) {
        ArrayList<String> parameterList = new ArrayList<String>(parameter.length() + 1);
        parameterList.add(functionName);
        parameterList.addAll(parameter.toList());
        this.createInitializer(priority).with(parameterList.toArray());
    }

    private Initialization createInitializer(InitializationPriority priority) {
        assert (priority != null);
        this.importCoreStack();
        return this.require("t5/core/init").priority(priority);
    }

    @Override
    public void addInitializerCall(String functionName, JSONObject parameter) {
        this.addInitializerCall(InitializationPriority.NORMAL, functionName, parameter);
    }

    @Override
    public void addInitializerCall(InitializationPriority priority, String functionName, String parameter) {
        this.createInitializer(priority).with(functionName, parameter);
    }

    @Override
    public void addInitializerCall(String functionName, String parameter) {
        this.addInitializerCall(InitializationPriority.NORMAL, functionName, parameter);
    }

    @Override
    public void addScript(InitializationPriority priority, String format, Object ... arguments) {
        String newScript;
        assert (priority != null);
        assert (InternalUtils.isNonBlank((String)format));
        this.importCoreStack();
        String string = newScript = arguments.length == 0 ? format : String.format(format, arguments);
        if (this.partialMode) {
            this.require("t5/core/pageinit").invoke("evalJavaScript").with(newScript);
        } else {
            this.linker.addScript(priority, newScript);
        }
    }

    @Override
    public void addScript(String format, Object ... arguments) {
        this.addScript(InitializationPriority.NORMAL, format, arguments);
    }

    @Override
    public void addModuleConfigurationCallback(ModuleConfigurationCallback callback) {
        this.linker.addModuleConfigurationCallback(callback);
    }

    @Override
    public String allocateClientId(ComponentResources resources) {
        return this.allocateClientId(resources.getId());
    }

    @Override
    public String allocateClientId(String id) {
        return this.idAllocator.allocateId(id);
    }

    @Override
    public JavaScriptSupport importJavaScriptLibrary(Asset asset) {
        assert (asset != null);
        return this.importJavaScriptLibrary(asset.toClientURL());
    }

    @Override
    public JavaScriptSupport importJavaScriptLibrary(String libraryURL) {
        this.importCoreStack();
        String stackName = this.findStackForLibrary(libraryURL);
        if (stackName != null) {
            return this.importStack(stackName);
        }
        if (!this.otherLibraries.contains(libraryURL)) {
            this.linker.addLibrary(libraryURL);
            this.otherLibraries.add(libraryURL);
        }
        return this;
    }

    private void importCoreStack() {
        this.addAssetsFromStack("core");
    }

    private String findStackForLibrary(String libraryURL) {
        return this.getLibraryURLToStackName().get(libraryURL);
    }

    private Map<String, String> getLibraryURLToStackName() {
        if (this.libraryURLToStackName == null) {
            this.libraryURLToStackName = CollectionFactory.newMap();
            for (String stackName : this.javascriptStackSource.getStackNames()) {
                for (Asset library : this.javascriptStackSource.getStack(stackName).getJavaScriptLibraries()) {
                    this.libraryURLToStackName.put(library.toClientURL(), stackName);
                }
            }
        }
        return this.libraryURLToStackName;
    }

    private String findStackForModule(String moduleName) {
        return this.getModuleNameToStackName().get(moduleName);
    }

    private Map<String, String> getModuleNameToStackName() {
        if (this.moduleNameToStackName == null) {
            this.moduleNameToStackName = CollectionFactory.newMap();
            for (String stackName : this.javascriptStackSource.getStackNames()) {
                for (String moduleName : this.javascriptStackSource.getStack(stackName).getModules()) {
                    this.moduleNameToStackName.put(moduleName, stackName);
                }
            }
        }
        return this.moduleNameToStackName;
    }

    private void addAssetsFromStack(String stackName) {
        String initialization;
        if (this.addedStacks.containsKey(stackName)) {
            return;
        }
        JavaScriptStack stack = this.javascriptStackSource.getStack(stackName);
        for (String dependentStackname : stack.getStacks()) {
            this.addAssetsFromStack(dependentStackname);
        }
        this.addedStacks.put(stackName, true);
        boolean addAsCoreLibrary = stackName.equals("core");
        List<String> libraryURLs = this.stackPathConstructor.constructPathsForJavaScriptStack(stackName);
        for (String libraryURL : libraryURLs) {
            if (addAsCoreLibrary) {
                this.linker.addCoreLibrary(libraryURL);
                continue;
            }
            this.linker.addLibrary(libraryURL);
        }
        if (!addAsCoreLibrary || !this.suppressCoreStylesheetsHook.checkHook()) {
            this.stylesheetLinks.addAll(stack.getStylesheets());
        }
        if ((initialization = stack.getInitialization()) != null) {
            this.addScript(InitializationPriority.IMMEDIATE, initialization, new Object[0]);
        }
    }

    @Override
    public JavaScriptSupport importStylesheet(Asset stylesheet) {
        assert (stylesheet != null);
        return this.importStylesheet(new StylesheetLink(stylesheet));
    }

    @Override
    public JavaScriptSupport importStylesheet(StylesheetLink stylesheetLink) {
        assert (stylesheetLink != null);
        this.importCoreStack();
        String stylesheetURL = stylesheetLink.getURL();
        if (!this.importedStylesheetURLs.contains(stylesheetURL)) {
            this.importedStylesheetURLs.add(stylesheetURL);
            this.stylesheetLinks.add(stylesheetLink);
        }
        return this;
    }

    @Override
    public JavaScriptSupport importStack(String stackName) {
        assert (InternalUtils.isNonBlank((String)stackName));
        this.importCoreStack();
        this.addAssetsFromStack(stackName);
        return this;
    }

    @Override
    public JavaScriptSupport autofocus(FieldFocusPriority priority, String fieldId) {
        assert (priority != null);
        assert (InternalUtils.isNonBlank((String)fieldId));
        if (this.focusFieldId == null || priority.compareTo(this.focusPriority) > 0) {
            this.focusPriority = priority;
            this.focusFieldId = fieldId;
        }
        return this;
    }

    @Override
    public Initialization require(String moduleName) {
        assert (InternalUtils.isNonBlank((String)moduleName));
        this.importCoreStack();
        String stackName = this.findStackForModule(moduleName);
        if (stackName != null) {
            this.importStack(stackName);
        }
        InitializationImpl init = new InitializationImpl(moduleName);
        this.inits.add(init);
        return init;
    }

    class InitializationImpl
    implements Initialization {
        InitializationPriority priority = InitializationPriority.NORMAL;
        final String moduleName;
        String functionName;
        JSONArray arguments;

        InitializationImpl(String moduleName) {
            this.moduleName = moduleName;
        }

        @Override
        public Initialization invoke(String functionName) {
            assert (InternalUtils.isNonBlank((String)functionName));
            this.functionName = functionName;
            return this;
        }

        @Override
        public Initialization priority(InitializationPriority priority) {
            assert (priority != null);
            this.priority = priority;
            return this;
        }

        @Override
        public void with(Object ... arguments) {
            assert (arguments != null);
            this.arguments = new JSONArray(arguments);
        }
    }
}

