/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.Link;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.ActivationRequestParameter;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.util.IdAllocator;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.apache.tapestry5.services.ComponentEventHandler;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.URLEncoder;
import org.apache.tapestry5.services.ValueEncoderSource;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class ActivationRequestParameterWorker
implements ComponentClassTransformWorker2 {
    private final Request request;
    private final ComponentClassCache classCache;
    private final ValueEncoderSource valueEncoderSource;
    private final URLEncoder urlEncoder;

    public ActivationRequestParameterWorker(Request request, ComponentClassCache classCache, ValueEncoderSource valueEncoderSource, URLEncoder urlEncoder) {
        this.request = request;
        this.classCache = classCache;
        this.valueEncoderSource = valueEncoderSource;
        this.urlEncoder = urlEncoder;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(ActivationRequestParameter.class)) {
            this.mapFieldToQueryParameter(field, support);
        }
    }

    private void mapFieldToQueryParameter(PlasticField field, TransformationSupport support) {
        ActivationRequestParameter annotation = (ActivationRequestParameter)field.getAnnotation(ActivationRequestParameter.class);
        String parameterName = this.getParameterName(field, annotation);
        Class fieldType = this.classCache.forName(field.getTypeName());
        ValueEncoder encoder = this.valueEncoderSource.getValueEncoder(fieldType);
        FieldHandle handle = field.getHandle();
        String fieldName = String.format("%s.%s", field.getPlasticClass().getClassName(), field.getName());
        this.setValueFromInitializeEventHandler(support, fieldName, annotation.required(), handle, parameterName, encoder, this.urlEncoder);
        ActivationRequestParameterWorker.decorateLinks(support, fieldName, handle, parameterName, encoder, this.urlEncoder);
        ActivationRequestParameterWorker.preallocateName(support, parameterName);
    }

    private static void preallocateName(TransformationSupport support, final String parameterName) {
        ComponentEventHandler handler = new ComponentEventHandler(){

            @Override
            public void handleEvent(Component instance, ComponentEvent event) {
                IdAllocator idAllocator = event.getEventContext().get(IdAllocator.class, 0);
                idAllocator.allocateId(parameterName);
            }
        };
        support.addEventHandler("preallocateFormControlNames", 1, "ActivationRequestParameterWorker preallocate form control name '" + parameterName + "' event handler", handler);
    }

    private void setValueFromInitializeEventHandler(TransformationSupport support, final String fieldName, final boolean required, final FieldHandle handle, final String parameterName, final ValueEncoder encoder, final URLEncoder urlEncoder) {
        ComponentEventHandler handler = new ComponentEventHandler(){

            @Override
            public void handleEvent(Component instance, ComponentEvent event) {
                String clientValue = ActivationRequestParameterWorker.this.request.getParameter(parameterName);
                if (clientValue == null) {
                    if (required) {
                        throw new TapestryException(String.format("Activation request parameter field %s is marked as required, but query parameter '%s' is null.", fieldName, parameterName), null);
                    }
                    return;
                }
                clientValue = urlEncoder.decode(clientValue);
                Object value = encoder.toValue(clientValue);
                handle.set((Object)instance, value);
            }
        };
        support.addEventHandler("activate", 0, String.format("Restoring field %s from query parameter '%s'", fieldName, parameterName), handler);
    }

    private static void decorateLinks(TransformationSupport support, String fieldName, final FieldHandle handle, final String parameterName, final ValueEncoder encoder, final URLEncoder urlEncoder) {
        ComponentEventHandler handler = new ComponentEventHandler(){

            @Override
            public void handleEvent(Component instance, ComponentEvent event) {
                Object value = handle.get((Object)instance);
                if (value == null) {
                    return;
                }
                Link link = event.getEventContext().get(Link.class, 0);
                String clientValue = encoder.toClient(value);
                clientValue = urlEncoder.encode(clientValue);
                link.addParameter(parameterName, clientValue);
            }
        };
        support.addEventHandler("decorateComponentEventLink", 0, String.format("ActivationRequestParameterWorker decorate component event link event handler for field %s as query parameter '%s'", fieldName, parameterName), handler);
        support.addEventHandler("decoratePageRenderLink", 0, String.format("ActivationRequestParameterWorker decorate page render link event handler for field %s as query parameter '%s'", fieldName, parameterName), handler);
    }

    private String getParameterName(PlasticField field, ActivationRequestParameter annotation) {
        if (annotation.value().equals("")) {
            return field.getName();
        }
        return annotation.value();
    }
}

