/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.StrategyBuilder;
import org.apache.tapestry5.ioc.util.StrategyRegistry;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;

public class StrategyBuilderImpl
implements StrategyBuilder {
    private final PlasticProxyFactory proxyFactory;

    public StrategyBuilderImpl(@Builtin PlasticProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    public <S> S build(StrategyRegistry<S> registry) {
        return this.createProxy(registry.getAdapterType(), registry);
    }

    @Override
    public <S> S build(Class<S> adapterType, Map<Class, S> registrations) {
        StrategyRegistry registry = StrategyRegistry.newInstance(adapterType, registrations);
        return this.build(registry);
    }

    private <S> S createProxy(final Class<S> interfaceType, final StrategyRegistry<S> registry) {
        ClassInstantiator instantiator = this.proxyFactory.createProxy(interfaceType, new PlasticClassTransformer(){

            public void transform(PlasticClass plasticClass) {
                final PlasticField registryField = plasticClass.introduceField(StrategyRegistry.class, "registry").inject((Object)registry);
                Class<?> interfaceSelectorType = null;
                for (final Method method : interfaceType.getMethods()) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length == 0) {
                        throw new IllegalArgumentException("Invalid method " + method + ", when using the strategy pattern, every method must take at least the selector as its parameter");
                    }
                    Class<?> methodSelectorType = parameterTypes[0];
                    if (interfaceSelectorType == null) {
                        interfaceSelectorType = methodSelectorType;
                    } else if (!interfaceSelectorType.equals(methodSelectorType)) {
                        throw new IllegalArgumentException("Conflicting method definitions, expecting the first argument of every method to have the same type");
                    }
                    plasticClass.introduceMethod(new MethodDescription(method), new InstructionBuilderCallback(){

                        public void doBuild(InstructionBuilder builder) {
                            Class<?> returnType = method.getReturnType();
                            builder.loadThis().getField(registryField);
                            builder.loadArgument(0);
                            builder.invoke(StrategyRegistry.class, Object.class, "getByInstance", new Class[]{Object.class}).checkcast(interfaceType);
                            builder.loadArguments().invoke(interfaceType, returnType, method.getName(), (Class[])method.getParameterTypes());
                            builder.returnResult();
                        }
                    });
                }
                plasticClass.addToString(String.format("<Strategy for %s>", interfaceType.getName()));
            }
        });
        return interfaceType.cast(instantiator.newInstance());
    }
}

