/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry5.services.LibraryMapping;

public final class ComponentLibraryInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LibraryMapping libraryMapping;
    private SourceUrlResolver sourceUrlResolver;
    private String name;
    private String description;
    private String homepageUrl;
    private String documentationUrl;
    private String sourceBrowseUrl;
    private String issueTrackerUrl;
    private String sourceRootUrl;
    private String javadocUrl;
    private String groupId;
    private String artifactId;
    private String version;
    private String tapestryVersion;
    private List<String> tags = new ArrayList<String>();

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public String getSourceBrowseUrl() {
        return this.sourceBrowseUrl;
    }

    public String getSourceRootUrl() {
        return this.sourceRootUrl;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public String getJavadocUrl() {
        return this.javadocUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTapestryVersion() {
        return this.tapestryVersion;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getDependencyManagementInfoUrl() {
        String url = null;
        if (this.isDependencyManagementInfoPresent()) {
            url = String.format("http://search.maven.org/#artifactdetails|%s|%s|version=%s|jar", this.getGroupId(), this.getArtifactId(), this.getVersion());
        }
        return url;
    }

    public void setName(String name) {
        if (this.name != null) {
            this.throwExceptionIfAlreadySet("name", name);
        }
        this.name = name;
    }

    public void setDescription(String description) {
        if (this.description != null) {
            this.throwExceptionIfAlreadySet("description", description);
        }
        this.description = description;
    }

    public void setHomepageUrl(String homepageUrl) {
        if (this.homepageUrl != null) {
            this.throwExceptionIfAlreadySet("homepageUrl", homepageUrl);
        }
        this.homepageUrl = homepageUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        if (this.documentationUrl != null) {
            this.throwExceptionIfAlreadySet("documentationUrl", documentationUrl);
        }
        this.documentationUrl = documentationUrl;
    }

    public void setSourceBrowseUrl(String sourceBrowseUrl) {
        if (this.sourceBrowseUrl != null) {
            this.throwExceptionIfAlreadySet("sourceBrowseUrl", sourceBrowseUrl);
        }
        this.sourceBrowseUrl = sourceBrowseUrl;
    }

    public void setSourceRootUrl(String sourceRootUrl) {
        if (this.sourceRootUrl != null) {
            this.throwExceptionIfAlreadySet("sourceRootUrl", sourceRootUrl);
        }
        this.sourceRootUrl = sourceRootUrl;
    }

    public void setJavadocUrl(String javadocUrl) {
        if (this.javadocUrl != null) {
            this.throwExceptionIfAlreadySet("javadocUrl", javadocUrl);
        }
        this.javadocUrl = javadocUrl;
    }

    public void setVersion(String version) {
        if (this.version != null) {
            this.throwExceptionIfAlreadySet("version", version);
        }
        this.version = version;
    }

    public void setTapestryVersion(String tapestryVersion) {
        if (this.tapestryVersion != null) {
            this.throwExceptionIfAlreadySet("tapestryVersion", this.version);
        }
        this.tapestryVersion = tapestryVersion;
    }

    public void setGroupId(String groupId) {
        if (this.groupId != null) {
            this.throwExceptionIfAlreadySet("groupId", this.artifactId);
        }
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        if (this.artifactId != null) {
            this.throwExceptionIfAlreadySet("artifactId", artifactId);
        }
        this.artifactId = artifactId;
    }

    public void setIssueTrackerUrl(String issueTrackingUrl) {
        if (this.issueTrackerUrl != null) {
            this.throwExceptionIfAlreadySet("issueTrackingUrl", issueTrackingUrl);
        }
        this.issueTrackerUrl = issueTrackingUrl;
    }

    public void setTags(List<String> tags) {
        if (this.tags != null) {
            this.throwExceptionIfAlreadySet("tags", tags);
        }
        this.tags = tags;
    }

    public void setLibraryMapping(LibraryMapping libraryMapping) {
        if (this.libraryMapping != null) {
            this.throwExceptionIfAlreadySet("libraryMapping", libraryMapping);
        }
        this.libraryMapping = libraryMapping;
    }

    public void setSourceUrlResolver(SourceUrlResolver sourceUrlResolver) {
        if (this.sourceUrlResolver != null) {
            this.throwExceptionIfAlreadySet("sourceUrlResolver", sourceUrlResolver);
        }
        this.sourceUrlResolver = sourceUrlResolver;
        if (sourceUrlResolver != null) {
            sourceUrlResolver.setRootUrl(this.getSourceRootUrl());
        }
    }

    public boolean isDependencyManagementInfoPresent() {
        return this.groupId != null && this.artifactId != null && this.version != null;
    }

    public boolean isPart(String logicalName) {
        return logicalName.startsWith(this.libraryMapping.libraryName + "/") || this.libraryMapping.libraryName.equals("") && logicalName.indexOf("/") < 0;
    }

    public String getJavadocUrl(String className) {
        String url = null;
        String baseUrl = this.getJavadocUrl();
        if (baseUrl != null) {
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            url = baseUrl + className.replace('.', '/') + ".html";
        }
        return url;
    }

    public String getSourceUrl(String className) {
        String url = null;
        if (this.sourceRootUrl != null) {
            if (this.sourceUrlResolver == null) {
                this.sourceUrlResolver = new DefaultSourceUrlResolver();
                this.sourceUrlResolver.setRootUrl(this.sourceRootUrl);
            }
            url = this.sourceUrlResolver.resolve(className);
        }
        return url;
    }

    private void throwExceptionIfAlreadySet(String propertyName, Object propertyValue) {
        if (propertyValue != null) {
            throw new RuntimeException(String.format("%s already has a value of \"%s\"", propertyName, propertyValue));
        }
    }

    public String toString() {
        return String.format("ComponentLibraryInfo[%s]", this.libraryMapping);
    }

    public static class DefaultSourceUrlResolver
    implements SourceUrlResolver {
        private String sourceRootUrl;

        @Override
        public String resolve(String className) {
            return this.sourceRootUrl + className.replace('.', '/') + ".java";
        }

        @Override
        public void setRootUrl(String url) {
            this.sourceRootUrl = url;
            if (this.sourceRootUrl.startsWith("scm:")) {
                this.sourceRootUrl = this.sourceRootUrl.replaceFirst("[^:]+:[^:]+:", "");
            }
        }
    }

    public static interface SourceUrlResolver {
        public String resolve(String var1);

        public void setRootUrl(String var1);
    }
}

