/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.TrackableComponentEventCallback;
import org.apache.tapestry5.services.ComponentEventResultProcessor;

public class ComponentResultProcessorWrapper
implements TrackableComponentEventCallback {
    private boolean aborted;
    private IOException exception;
    private final ComponentEventResultProcessor processor;
    private Object result;

    public ComponentResultProcessorWrapper(ComponentEventResultProcessor processor) {
        this.processor = processor;
    }

    @Override
    public boolean handleResult(Object result) {
        if (this.aborted) {
            throw new IllegalStateException("Event callback has already received and processed a result value and can not do so again.");
        }
        this.result = result;
        try {
            this.processor.processResultValue(result);
        }
        catch (IOException ex) {
            this.exception = ex;
        }
        this.aborted = true;
        return true;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void rethrow() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public Object getResult() {
        return this.result;
    }
}

