/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.tez.analyzer.Result;
import org.apache.tez.common.Preconditions;
import org.apache.tez.dag.api.TezException;

public class CSVResult
implements Result {
    private final String[] headers;
    private final List<String[]> recordsList;
    private String comments;

    public CSVResult(String[] header) {
        this.headers = header;
        this.recordsList = Lists.newLinkedList();
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void addRecord(String[] record) {
        Preconditions.checkArgument((record != null ? 1 : 0) != 0, (Object)"Record can't be null");
        Preconditions.checkArgument((record.length == this.headers.length ? 1 : 0) != 0, (Object)("Record length" + record.length + " does not match headers length " + this.headers.length));
        this.recordsList.add(record);
    }

    public Iterator<String[]> getRecordsIterator() {
        return Iterators.unmodifiableIterator(this.recordsList.iterator());
    }

    public void sort(Comparator comparator) {
        Collections.sort(this.recordsList, comparator);
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public String toJson() throws TezException {
        return "";
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    public String toString() {
        return "CSVResult{headers=" + Arrays.toString(this.headers) + ", recordsList=" + this.recordsList + '}';
    }

    public void dumpToFile(String fileName) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), Charset.forName("UTF-8").newEncoder());
        BufferedWriter bw = new BufferedWriter(writer);
        bw.write(Joiner.on((String)",").join((Object[])this.headers));
        bw.newLine();
        for (String[] record : this.recordsList) {
            if (record.length != this.headers.length) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < record.length; ++i) {
                sb.append(!Strings.isNullOrEmpty((String)record[i]) ? record[i] : " ");
                if (i >= record.length - 1) continue;
                sb.append(",");
            }
            bw.write(sb.toString());
            bw.newLine();
        }
        bw.flush();
        bw.close();
    }
}

