/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.proto;

import java.util.Optional;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.logging.proto.HistoryLoggerProtos;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class HistoryEventProtoJsonConversion {
    private HistoryEventProtoJsonConversion() {
    }

    public static JSONObject convertToJson(HistoryLoggerProtos.HistoryEventProto historyEvent) throws JSONException {
        JSONObject jsonObject = null;
        switch (historyEvent.getEventType()) {
            case "APP_LAUNCHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertAppLaunchedEvent(historyEvent);
                break;
            }
            case "AM_LAUNCHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertAMLaunchedEvent(historyEvent);
                break;
            }
            case "AM_STARTED": {
                jsonObject = HistoryEventProtoJsonConversion.convertAMStartedEvent(historyEvent);
                break;
            }
            case "CONTAINER_LAUNCHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertContainerLaunchedEvent(historyEvent);
                break;
            }
            case "CONTAINER_STOPPED": {
                jsonObject = HistoryEventProtoJsonConversion.convertContainerStoppedEvent(historyEvent);
                break;
            }
            case "DAG_SUBMITTED": {
                jsonObject = HistoryEventProtoJsonConversion.convertDAGSubmittedEvent(historyEvent);
                break;
            }
            case "DAG_INITIALIZED": {
                jsonObject = HistoryEventProtoJsonConversion.convertDAGInitializedEvent(historyEvent);
                break;
            }
            case "DAG_STARTED": {
                jsonObject = HistoryEventProtoJsonConversion.convertDAGStartedEvent(historyEvent);
                break;
            }
            case "DAG_FINISHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertDAGFinishedEvent(historyEvent);
                break;
            }
            case "VERTEX_INITIALIZED": {
                jsonObject = HistoryEventProtoJsonConversion.convertVertexInitializedEvent(historyEvent);
                break;
            }
            case "VERTEX_STARTED": {
                jsonObject = HistoryEventProtoJsonConversion.convertVertexStartedEvent(historyEvent);
                break;
            }
            case "VERTEX_FINISHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertVertexFinishedEvent(historyEvent);
                break;
            }
            case "TASK_STARTED": {
                jsonObject = HistoryEventProtoJsonConversion.convertTaskStartedEvent(historyEvent);
                break;
            }
            case "TASK_FINISHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertTaskFinishedEvent(historyEvent);
                break;
            }
            case "TASK_ATTEMPT_STARTED": {
                jsonObject = HistoryEventProtoJsonConversion.convertTaskAttemptStartedEvent(historyEvent);
                break;
            }
            case "TASK_ATTEMPT_FINISHED": {
                jsonObject = HistoryEventProtoJsonConversion.convertTaskAttemptFinishedEvent(historyEvent);
                break;
            }
            case "VERTEX_CONFIGURE_DONE": {
                jsonObject = HistoryEventProtoJsonConversion.convertVertexReconfigureDoneEvent(historyEvent);
                break;
            }
            case "DAG_RECOVERED": {
                jsonObject = HistoryEventProtoJsonConversion.convertDAGRecoveredEvent(historyEvent);
                break;
            }
            case "VERTEX_COMMIT_STARTED": 
            case "VERTEX_GROUP_COMMIT_STARTED": 
            case "VERTEX_GROUP_COMMIT_FINISHED": 
            case "DAG_COMMIT_STARTED": {
                throw new UnsupportedOperationException("Invalid Event, does not support history, eventType=" + historyEvent.getEventType());
            }
            default: {
                throw new UnsupportedOperationException("Unhandled Event, eventType=" + historyEvent.getEventType());
            }
        }
        return jsonObject;
    }

    private static JSONObject convertDAGRecoveredEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject recoverEvent = new JSONObject();
        recoverEvent.put("ts", event.getEventTime());
        recoverEvent.put("eventtype", (Object)HistoryEventType.DAG_RECOVERED.name());
        JSONObject recoverEventInfo = new JSONObject();
        recoverEventInfo.put("applicationAttemptId", (Object)event.getAppAttemptId().toString());
        recoverEventInfo.put("dagState", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "dagState"));
        recoverEventInfo.put("recoveryFailureReason", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "recoveryFailureReason"));
        recoverEvent.put("eventinfo", (Object)recoverEventInfo);
        events.put((Object)recoverEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertAppLaunchedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getAppId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION.name());
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("user", (Object)event.getUser());
        otherInfo.put("config", (Object)new JSONObject());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertAMLaunchedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getAppAttemptId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)event.getAppId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getAppAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", event.getEventTime());
        initEvent.put("eventtype", (Object)HistoryEventType.AM_LAUNCHED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("appSubmitTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "appSubmitTime"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertAMStartedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + event.getAppAttemptId().toString()));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)event.getAppId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getAppAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getEventTime());
        startEvent.put("eventtype", (Object)HistoryEventType.AM_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertContainerLaunchedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + HistoryEventProtoJsonConversion.getDataValueByKey(event, "containerId")));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_CONTAINER_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getAppAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "containerId"));
        containerEntity.put("entitytype", (Object)"containerId");
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)containerEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject launchEvent = new JSONObject();
        launchEvent.put("ts", event.getEventTime());
        launchEvent.put("eventtype", (Object)HistoryEventType.CONTAINER_LAUNCHED.name());
        events.put((Object)launchEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertContainerStoppedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)("tez_" + HistoryEventProtoJsonConversion.getDataValueByKey(event, "containerId")));
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_CONTAINER_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getAppAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "containerId"));
        containerEntity.put("entitytype", (Object)"containerId");
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)containerEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject stopEvent = new JSONObject();
        stopEvent.put("ts", event.getEventTime());
        stopEvent.put("eventtype", (Object)HistoryEventType.CONTAINER_STOPPED.name());
        events.put((Object)stopEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("exitStatus", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "exitStatus"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertDAGFinishedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getEventTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.DAG_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        long startTime = HistoryEventProtoJsonConversion.getLongDataValueByKey(event, "startTime");
        otherInfo.put("startTime", startTime);
        otherInfo.put("endTime", event.getEventTime());
        otherInfo.put("timeTaken", event.getEventTime() - startTime);
        otherInfo.put("status", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "status"));
        otherInfo.put("diagnostics", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "diagnostics"));
        otherInfo.put("counters", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "counters"));
        otherInfo.put("completionApplicationAttemptId", (Object)event.getAppAttemptId().toString());
        for (HistoryLoggerProtos.KVPair pair : event.getEventDataList()) {
            otherInfo.put(pair.getKey(), (Object)pair.getValue());
        }
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertDAGInitializedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", event.getEventTime());
        initEvent.put("eventtype", (Object)HistoryEventType.DAG_INITIALIZED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("vertexNameIdMapping", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "vertexNameIdMapping"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertDAGStartedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getEventTime());
        startEvent.put("eventtype", (Object)HistoryEventType.DAG_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        return jsonObject;
    }

    private static JSONObject convertDAGSubmittedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getDagId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject tezAppEntity = new JSONObject();
        tezAppEntity.put("entity", (Object)("tez_" + event.getAppId().toString()));
        tezAppEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION.name());
        JSONObject tezAppAttemptEntity = new JSONObject();
        tezAppAttemptEntity.put("entity", (Object)("tez_" + event.getAppAttemptId().toString()));
        tezAppAttemptEntity.put("entitytype", (Object)EntityTypes.TEZ_APPLICATION_ATTEMPT.name());
        JSONObject appEntity = new JSONObject();
        appEntity.put("entity", (Object)event.getAppId().toString());
        appEntity.put("entitytype", (Object)"applicationId");
        JSONObject appAttemptEntity = new JSONObject();
        appAttemptEntity.put("entity", (Object)event.getAppAttemptId().toString());
        appAttemptEntity.put("entitytype", (Object)"applicationAttemptId");
        JSONObject userEntity = new JSONObject();
        userEntity.put("entity", (Object)event.getUser());
        userEntity.put("entitytype", (Object)"user");
        relatedEntities.put((Object)tezAppEntity);
        relatedEntities.put((Object)tezAppAttemptEntity);
        relatedEntities.put((Object)appEntity);
        relatedEntities.put((Object)appAttemptEntity);
        relatedEntities.put((Object)userEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONObject primaryFilters = new JSONObject();
        primaryFilters.put("dagName", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "dagName"));
        primaryFilters.put("callerId", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "callerId"));
        primaryFilters.put("callerType", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "callerType"));
        primaryFilters.put("queueName", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "queueName"));
        jsonObject.put("primaryfilters", (Object)primaryFilters);
        JSONArray events = new JSONArray();
        JSONObject submitEvent = new JSONObject();
        submitEvent.put("ts", event.getEventTime());
        submitEvent.put("eventtype", (Object)HistoryEventType.DAG_SUBMITTED.name());
        events.put((Object)submitEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("dagPlan", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "dagPlan"));
        otherInfo.put("callerId", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "callerId"));
        otherInfo.put("callerType", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "callerType"));
        otherInfo.put("queueName", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "queueName"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskAttemptFinishedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskAttemptId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getEventTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.TASK_ATTEMPT_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        long startTime = HistoryEventProtoJsonConversion.getLongDataValueByKey(event, "startTime");
        otherInfo.put("creationTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "creationTime"));
        otherInfo.put("allocationTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "allocationTime"));
        otherInfo.put("startTime", startTime);
        otherInfo.put("endTime", event.getEventTime());
        otherInfo.put("timeTaken", event.getEventTime() - startTime);
        otherInfo.put("creationCausalAttempt", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "creationCausalAttempt"));
        otherInfo.put("status", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "status"));
        otherInfo.put("status", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "status"));
        otherInfo.put("taskAttemptErrorEnum", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "taskAttemptErrorEnum"));
        otherInfo.put("taskFailureType", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "taskFailureType"));
        otherInfo.put("diagnostics", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "diagnostics"));
        otherInfo.put("counters", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "counters"));
        otherInfo.put("lastDataEvents", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "lastDataEvents"));
        otherInfo.put("nodeId", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "nodeId"));
        otherInfo.put("containerId", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "containerId"));
        otherInfo.put("inProgressLogsURL", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "inProgressLogsURL"));
        otherInfo.put("completedLogsURL", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "completedLogsURL"));
        otherInfo.put("nodeHttpAddress", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "nodeHttpAddress"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskAttemptStartedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskAttemptId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ATTEMPT_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject nodeEntity = new JSONObject();
        nodeEntity.put("entity", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "nodeId"));
        nodeEntity.put("entitytype", (Object)"nodeId");
        JSONObject containerEntity = new JSONObject();
        containerEntity.put("entity", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "containerId"));
        containerEntity.put("entitytype", (Object)"containerId");
        JSONObject taskEntity = new JSONObject();
        taskEntity.put("entity", (Object)event.getTaskAttemptId());
        taskEntity.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        relatedEntities.put((Object)nodeEntity);
        relatedEntities.put((Object)containerEntity);
        relatedEntities.put((Object)taskEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getEventTime());
        startEvent.put("eventtype", (Object)HistoryEventType.TASK_ATTEMPT_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("inProgressLogsURL", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "inProgressLogsURL"));
        otherInfo.put("completedLogsURL", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "completedLogsURL"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskFinishedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getEventTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.TASK_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        long startTime = HistoryEventProtoJsonConversion.getLongDataValueByKey(event, "startTime");
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", startTime);
        otherInfo.put("endTime", event.getEventTime());
        otherInfo.put("timeTaken", event.getEventTime() - startTime);
        otherInfo.put("status", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "status"));
        otherInfo.put("diagnostics", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "diagnostics"));
        otherInfo.put("counters", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "counters"));
        otherInfo.put("successfulAttemptId", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "successfulAttemptId"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertTaskStartedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getTaskId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_TASK_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)event.getVertexId());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getEventTime());
        startEvent.put("eventtype", (Object)HistoryEventType.TASK_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startTime", event.getEventTime());
        otherInfo.put("scheduledTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "scheduledTime"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexFinishedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray events = new JSONArray();
        JSONObject finishEvent = new JSONObject();
        finishEvent.put("ts", event.getEventTime());
        finishEvent.put("eventtype", (Object)HistoryEventType.VERTEX_FINISHED.name());
        events.put((Object)finishEvent);
        jsonObject.put("events", (Object)events);
        long startTime = HistoryEventProtoJsonConversion.getLongDataValueByKey(event, "startTime");
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("endTime", event.getEventTime());
        otherInfo.put("timeTaken", event.getEventTime() - startTime);
        otherInfo.put("status", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "status"));
        otherInfo.put("diagnostics", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "diagnostics"));
        otherInfo.put("counters", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "counters"));
        otherInfo.put("stats", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "stats"));
        for (HistoryLoggerProtos.KVPair pair : event.getEventDataList()) {
            otherInfo.put(pair.getKey(), (Object)pair.getValue());
        }
        otherInfo.put("servicePlugin", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "servicePlugin"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexReconfigureDoneEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray events = new JSONArray();
        JSONObject updateEvent = new JSONObject();
        updateEvent.put("ts", event.getEventTime());
        updateEvent.put("eventtype", (Object)HistoryEventType.VERTEX_CONFIGURE_DONE.name());
        JSONObject eventInfo = new JSONObject();
        eventInfo.put("numTasks", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "numTasks"));
        eventInfo.put("updatedEdgeManagers", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "updatedEdgeManagers"));
        updateEvent.put("eventinfo", (Object)eventInfo);
        events.put((Object)updateEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexInitializedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)event.getDagId());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject initEvent = new JSONObject();
        initEvent.put("ts", event.getEventTime());
        initEvent.put("eventtype", (Object)HistoryEventType.VERTEX_INITIALIZED.name());
        events.put((Object)initEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("vertexName", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "vertexName"));
        otherInfo.put("initRequestedTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "initRequestedTime"));
        otherInfo.put("initTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "initTime"));
        otherInfo.put("numTasks", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "numTasks"));
        otherInfo.put("processorClassName", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "processorClassName"));
        otherInfo.put("servicePlugin", (Object)HistoryEventProtoJsonConversion.getJSONDataValueByKey(event, "servicePlugin"));
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static JSONObject convertVertexStartedEvent(HistoryLoggerProtos.HistoryEventProto event) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("entity", (Object)event.getVertexId());
        jsonObject.put("entitytype", (Object)EntityTypes.TEZ_VERTEX_ID.name());
        JSONArray relatedEntities = new JSONArray();
        JSONObject vertexEntity = new JSONObject();
        vertexEntity.put("entity", (Object)event.getDagId());
        vertexEntity.put("entitytype", (Object)EntityTypes.TEZ_DAG_ID.name());
        relatedEntities.put((Object)vertexEntity);
        jsonObject.put("relatedEntities", (Object)relatedEntities);
        JSONArray events = new JSONArray();
        JSONObject startEvent = new JSONObject();
        startEvent.put("ts", event.getEventTime());
        startEvent.put("eventtype", (Object)HistoryEventType.VERTEX_STARTED.name());
        events.put((Object)startEvent);
        jsonObject.put("events", (Object)events);
        JSONObject otherInfo = new JSONObject();
        otherInfo.put("startRequestedTime", (Object)HistoryEventProtoJsonConversion.getDataValueByKey(event, "startRequestedTime"));
        otherInfo.put("startTime", event.getEventTime());
        jsonObject.put("otherinfo", (Object)otherInfo);
        return jsonObject;
    }

    private static String getDataValueByKey(HistoryLoggerProtos.HistoryEventProto event, String key) {
        Optional<HistoryLoggerProtos.KVPair> pair = event.getEventDataList().stream().filter(p -> p.getKey().equals(key)).findAny();
        return pair.isPresent() ? pair.get().getValue() : null;
    }

    private static long getLongDataValueByKey(HistoryLoggerProtos.HistoryEventProto event, String key) {
        String value = HistoryEventProtoJsonConversion.getDataValueByKey(event, key);
        return value == null || value.isEmpty() ? 0L : Long.parseLong(value);
    }

    private static JSONObject getJSONDataValueByKey(HistoryLoggerProtos.HistoryEventProto event, String key) throws JSONException {
        String value = HistoryEventProtoJsonConversion.getDataValueByKey(event, key);
        return value == null || value.isEmpty() ? null : new JSONObject(value);
    }
}

