/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.PeekableShortRankIterator;
import org.roaringbitmap.Util;

final class ArrayContainerShortIterator
implements PeekableShortRankIterator {
    int pos;
    ArrayContainer parent;

    ArrayContainerShortIterator() {
    }

    ArrayContainerShortIterator(ArrayContainer p) {
        this.wrap(p);
    }

    @Override
    public void advanceIfNeeded(short minval) {
        this.pos = Util.advanceUntil(this.parent.content, this.pos - 1, this.parent.cardinality, minval);
    }

    @Override
    public int peekNextRank() {
        return this.pos + 1;
    }

    @Override
    public PeekableShortRankIterator clone() {
        try {
            return (PeekableShortRankIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public short next() {
        return this.parent.content[this.pos++];
    }

    @Override
    public int nextAsInt() {
        return Util.toIntUnsigned(this.parent.content[this.pos++]);
    }

    @Override
    public short peekNext() {
        return this.parent.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.removeAtIndex(this.pos - 1);
        --this.pos;
    }

    void wrap(ArrayContainer p) {
        this.parent = p;
        this.pos = 0;
    }
}

