/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.tez.common.GuavaShim;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexStateUpdateListener;
import org.apache.tez.dag.app.dag.event.CallableEvent;
import org.apache.tez.dag.app.dag.event.DAGEventInternalError;
import org.apache.tez.dag.app.dag.event.VertexEventInputDataInformation;
import org.apache.tez.dag.app.dag.event.VertexEventManagerUserCodeError;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.dag.impl.AMUserCodeException;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.runtime.api.InputSpecUpdate;
import org.apache.tez.runtime.api.TaskAttemptIdentifier;
import org.apache.tez.runtime.api.VertexStatistics;
import org.apache.tez.runtime.api.events.CustomProcessorEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexManager {
    final VertexManagerPluginDescriptor pluginDesc;
    final UserGroupInformation dagUgi;
    final VertexManagerPlugin plugin;
    final Vertex managedVertex;
    final VertexManagerPluginContextImpl pluginContext;
    final UserPayload payload;
    final AppContext appContext;
    final BlockingQueue<TezEvent> rootInputInitEventQueue;
    final StateChangeNotifier stateChangeNotifier;
    private final ListeningExecutorService execService;
    private final LinkedBlockingQueue<VertexManagerEvent> eventQueue;
    private final AtomicBoolean eventInFlight;
    private final AtomicBoolean pluginFailed;
    private static final Logger LOG = LoggerFactory.getLogger(VertexManager.class);
    private final VertexManagerCallback VM_CALLBACK = new VertexManagerCallback();

    public VertexManager(VertexManagerPluginDescriptor pluginDesc, UserGroupInformation dagUgi, Vertex managedVertex, AppContext appContext, StateChangeNotifier stateChangeNotifier) throws TezException {
        Objects.requireNonNull(pluginDesc, "pluginDesc is null");
        Objects.requireNonNull(managedVertex, "managedVertex is null");
        Objects.requireNonNull(appContext, "appContext is null");
        Objects.requireNonNull(stateChangeNotifier, "notifier is null");
        this.pluginDesc = pluginDesc;
        this.dagUgi = dagUgi;
        this.managedVertex = managedVertex;
        this.appContext = appContext;
        this.stateChangeNotifier = stateChangeNotifier;
        this.rootInputInitEventQueue = new LinkedBlockingQueue<TezEvent>();
        this.pluginContext = new VertexManagerPluginContextImpl();
        this.payload = pluginDesc.getUserPayload();
        this.pluginFailed = new AtomicBoolean(false);
        this.plugin = (VertexManagerPlugin)ReflectionUtils.createClazzInstance((String)pluginDesc.getClassName(), (Class[])new Class[]{VertexManagerPluginContext.class}, (Object[])new Object[]{this.pluginContext});
        this.execService = appContext.getExecService();
        this.eventQueue = new LinkedBlockingQueue();
        this.eventInFlight = new AtomicBoolean(false);
    }

    public VertexManagerPlugin getPlugin() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws AMUserCodeException {
        block5: {
            try {
                if (this.pluginContext.isComplete()) break block5;
                VertexManager vertexManager = this;
                synchronized (vertexManager) {
                    this.plugin.initialize();
                }
            }
            catch (Exception e) {
                throw new AMUserCodeException(AMUserCodeException.Source.VertexManager, e);
            }
        }
    }

    private boolean pluginInvocationAllowed(String msg) {
        if (this.pluginFailed.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg + " . Manager failed. Vertex=" + this.managedVertex.getLogIdentifier());
            }
            return false;
        }
        if (this.pluginContext.isComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg + " . Manager complete. Not scheduling event. Vertex=" + this.managedVertex.getLogIdentifier());
            }
            return false;
        }
        return true;
    }

    private void enqueueAndScheduleNextEvent(VertexManagerEvent e) {
        if (!this.pluginInvocationAllowed("Dropping event")) {
            return;
        }
        this.eventQueue.add(e);
        this.tryScheduleNextEvent();
    }

    private void tryScheduleNextEvent() {
        if (!this.pluginInvocationAllowed("Not scheduling")) {
            return;
        }
        if (this.eventQueue.isEmpty()) {
            return;
        }
        if (this.eventInFlight.compareAndSet(false, true)) {
            VertexManagerEvent e = this.eventQueue.poll();
            if (e != null) {
                ListenableFuture future = this.execService.submit((Callable)e);
                Futures.addCallback((ListenableFuture)future, e.getCallback(), (Executor)GuavaShim.directExecutor());
            } else {
                Preconditions.checkState((boolean)this.eventInFlight.compareAndSet(true, false));
            }
        }
    }

    public void onVertexStarted(List<TaskAttemptIdentifier> completions) throws AMUserCodeException {
        this.enqueueAndScheduleNextEvent(new VertexManagerEventOnVertexStarted(completions));
    }

    public void onSourceTaskCompleted(TaskAttemptIdentifier attempt) throws AMUserCodeException {
        this.enqueueAndScheduleNextEvent(new VertexManagerEventSourceTaskCompleted(attempt));
    }

    public void onVertexManagerEventReceived(org.apache.tez.runtime.api.events.VertexManagerEvent vmEvent) throws AMUserCodeException {
        this.enqueueAndScheduleNextEvent(new VertexManagerEventReceived(vmEvent));
    }

    public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<org.apache.tez.runtime.api.Event> events) throws AMUserCodeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("vertex:" + this.managedVertex.getLogIdentifier() + "; enqueueing onRootVertexInitialized on input:" + inputName + ", current task events size is " + this.rootInputInitEventQueue.size());
        }
        this.enqueueAndScheduleNextEvent(new VertexManagerEventRootInputInitialized(inputName, inputDescriptor, events));
    }

    abstract class VertexManagerEvent
    extends CallableEvent {
        public VertexManagerEvent() {
            this(this$0.VM_CALLBACK);
        }

        public VertexManagerEvent(VertexManagerCallback callback) {
            super(callback);
        }

        @Override
        public Void call() throws Exception {
            final VertexManager manager = VertexManager.this;
            manager.dagUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    VertexManager vertexManager = manager;
                    synchronized (vertexManager) {
                        if (manager.pluginInvocationAllowed("Not invoking")) {
                            VertexManagerEvent.this.invoke();
                        }
                    }
                    return null;
                }
            });
            return null;
        }

        public abstract void invoke() throws Exception;
    }

    class VertexManagerEventRootInputInitialized
    extends VertexManagerEvent {
        private final String inputName;
        private final InputDescriptor inputDescriptor;
        private final List<org.apache.tez.runtime.api.Event> events;

        public VertexManagerEventRootInputInitialized(String inputName, InputDescriptor inputDescriptor, List<org.apache.tez.runtime.api.Event> events) {
            super(new VertexManagerRootInputInitializedCallback());
            this.inputName = inputName;
            this.inputDescriptor = inputDescriptor;
            this.events = events;
        }

        @Override
        public void invoke() throws Exception {
            VertexManager.this.plugin.onRootVertexInitialized(this.inputName, this.inputDescriptor, this.events);
        }
    }

    class VertexManagerEventReceived
    extends VertexManagerEvent {
        private final org.apache.tez.runtime.api.events.VertexManagerEvent vmEvent;

        public VertexManagerEventReceived(org.apache.tez.runtime.api.events.VertexManagerEvent vmEvent) {
            this.vmEvent = vmEvent;
        }

        @Override
        public void invoke() throws Exception {
            VertexManager.this.plugin.onVertexManagerEventReceived(this.vmEvent);
        }
    }

    class VertexManagerEventSourceTaskCompleted
    extends VertexManagerEvent {
        private final TaskAttemptIdentifier attempt;

        public VertexManagerEventSourceTaskCompleted(TaskAttemptIdentifier attempt) {
            this.attempt = attempt;
        }

        @Override
        public void invoke() throws Exception {
            VertexManager.this.plugin.onSourceTaskCompleted(this.attempt);
        }
    }

    class VertexManagerEventOnVertexStarted
    extends VertexManagerEvent {
        private final List<TaskAttemptIdentifier> pluginCompletions;

        public VertexManagerEventOnVertexStarted(List<TaskAttemptIdentifier> pluginCompletions) {
            this.pluginCompletions = pluginCompletions;
        }

        @Override
        public void invoke() throws Exception {
            VertexManager.this.plugin.onVertexStarted(this.pluginCompletions);
        }
    }

    class VertexManagerEventOnVertexStateUpdate
    extends VertexManagerEvent {
        private final VertexStateUpdate event;

        public VertexManagerEventOnVertexStateUpdate(VertexStateUpdate event) {
            this.event = event;
        }

        @Override
        public void invoke() throws Exception {
            VertexManager.this.plugin.onVertexStateUpdated(this.event);
        }
    }

    private class VertexManagerRootInputInitializedCallback
    extends VertexManagerCallback {
        private VertexManagerRootInputInitializedCallback() {
        }

        @Override
        protected void onSuccessDerived(Void result) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("vertex:" + VertexManager.this.managedVertex.getLogIdentifier() + "; after call of VertexManagerPlugin.onRootVertexInitialized on input:, current task events size is " + VertexManager.this.rootInputInitEventQueue.size());
            }
            ArrayList<TezEvent> resultEvents = new ArrayList<TezEvent>();
            VertexManager.this.rootInputInitEventQueue.drainTo(resultEvents);
            VertexManager.this.appContext.getEventHandler().handle((Event)new VertexEventInputDataInformation(VertexManager.this.managedVertex.getVertexId(), resultEvents));
        }
    }

    private class VertexManagerCallback
    implements FutureCallback<Void> {
        private VertexManagerCallback() {
        }

        public void onFailure(Throwable t) {
            try {
                Preconditions.checkState((boolean)VertexManager.this.eventInFlight.get());
                VertexManager.this.pluginFailed.set(true);
                VertexManager.this.eventQueue.clear();
                if (t instanceof UndeclaredThrowableException) {
                    t = t.getCause();
                }
                Preconditions.checkState((VertexManager.this.appContext != null ? 1 : 0) != 0);
                Preconditions.checkState((VertexManager.this.managedVertex != null ? 1 : 0) != 0);
                VertexManager.this.appContext.getEventHandler().handle((Event)new VertexEventManagerUserCodeError(VertexManager.this.managedVertex.getVertexId(), new AMUserCodeException(AMUserCodeException.Source.VertexManager, t)));
            }
            catch (Exception e) {
                this.sendInternalError(e);
            }
        }

        public void onSuccess(Void result) {
            try {
                this.onSuccessDerived(result);
                Preconditions.checkState((boolean)VertexManager.this.eventInFlight.compareAndSet(true, false));
                VertexManager.this.tryScheduleNextEvent();
            }
            catch (Exception e) {
                this.sendInternalError(e);
            }
        }

        protected void onSuccessDerived(Void result) {
        }

        private void sendInternalError(Exception e) {
            LOG.error("Error after vertex manager callback " + VertexManager.this.managedVertex.getLogIdentifier(), (Throwable)e);
            VertexManager.this.appContext.getEventHandler().handle((Event)new DAGEventInternalError(VertexManager.this.managedVertex.getVertexId().getDAGID(), "Error in VertexManager for vertex: " + VertexManager.this.managedVertex.getLogIdentifier() + ", error=" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    class VertexManagerPluginContextImpl
    implements VertexManagerPluginContext,
    VertexStateUpdateListener {
        private EventMetaData rootEventSourceMetadata;
        private Map<String, EventMetaData> destinationEventMetadataMap;
        private final List<String> notificationRegisteredVertices;
        AtomicBoolean isComplete;

        VertexManagerPluginContextImpl() {
            this.rootEventSourceMetadata = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, VertexManager.this.managedVertex.getName(), "NULL_VERTEX", null);
            this.destinationEventMetadataMap = Maps.newHashMap();
            this.notificationRegisteredVertices = Lists.newArrayList();
            this.isComplete = new AtomicBoolean(false);
        }

        private void checkAndThrowIfDone() {
            if (this.isComplete()) {
                throw new TezUncheckedException("Cannot invoke context methods after reporting done");
            }
            if (VertexManager.this.pluginFailed.get()) {
                throw new TezUncheckedException("Cannot invoke context methods after throwing an exception");
            }
        }

        public synchronized Map<String, EdgeProperty> getInputVertexEdgeProperties() {
            this.checkAndThrowIfDone();
            Map<Vertex, Edge> inputs = VertexManager.this.managedVertex.getInputVertices();
            HashMap vertexEdgeMap = Maps.newHashMapWithExpectedSize((int)inputs.size());
            for (Map.Entry<Vertex, Edge> entry : inputs.entrySet()) {
                vertexEdgeMap.put(entry.getKey().getName(), entry.getValue().getEdgeProperty());
            }
            return vertexEdgeMap;
        }

        public synchronized Map<String, EdgeProperty> getOutputVertexEdgeProperties() {
            this.checkAndThrowIfDone();
            Map<Vertex, Edge> outputs = VertexManager.this.managedVertex.getOutputVertices();
            HashMap vertexEdgeMap = Maps.newHashMapWithExpectedSize((int)outputs.size());
            for (Map.Entry<Vertex, Edge> entry : outputs.entrySet()) {
                vertexEdgeMap.put(entry.getKey().getName(), entry.getValue().getEdgeProperty());
            }
            return vertexEdgeMap;
        }

        public synchronized VertexStatistics getVertexStatistics(String vertexName) {
            this.checkAndThrowIfDone();
            return VertexManager.this.appContext.getCurrentDAG().getVertex(vertexName).getStatistics();
        }

        public synchronized String getVertexName() {
            this.checkAndThrowIfDone();
            return VertexManager.this.managedVertex.getName();
        }

        public synchronized int getVertexNumTasks(String vertexName) {
            this.checkAndThrowIfDone();
            return VertexManager.this.appContext.getCurrentDAG().getVertex(vertexName).getTotalTasks();
        }

        public synchronized void setVertexParallelism(int parallelism, VertexLocationHint vertexLocationHint, Map<String, EdgeManagerPluginDescriptor> sourceEdgeManagers, Map<String, InputSpecUpdate> rootInputSpecUpdate) {
            this.checkAndThrowIfDone();
            try {
                VertexManager.this.managedVertex.setParallelism(parallelism, vertexLocationHint, sourceEdgeManagers, rootInputSpecUpdate, true);
            }
            catch (AMUserCodeException e) {
                throw new TezUncheckedException((Throwable)((Object)e));
            }
        }

        public synchronized void reconfigureVertex(int parallelism, VertexLocationHint vertexLocationHint, Map<String, EdgeProperty> sourceEdgeProperties, Map<String, InputSpecUpdate> rootInputSpecUpdate) {
            this.checkAndThrowIfDone();
            try {
                VertexManager.this.managedVertex.reconfigureVertex(parallelism, vertexLocationHint, sourceEdgeProperties, rootInputSpecUpdate);
            }
            catch (AMUserCodeException e) {
                throw new TezUncheckedException((Throwable)((Object)e));
            }
        }

        public synchronized void reconfigureVertex(int parallelism, @Nullable VertexLocationHint locationHint, @Nullable Map<String, EdgeProperty> sourceEdgeProperties) {
            this.checkAndThrowIfDone();
            try {
                VertexManager.this.managedVertex.reconfigureVertex(parallelism, locationHint, sourceEdgeProperties);
            }
            catch (AMUserCodeException e) {
                throw new TezUncheckedException((Throwable)((Object)e));
            }
        }

        public void reconfigureVertex(@Nullable Map<String, InputSpecUpdate> rootInputSpecUpdate, @Nullable VertexLocationHint locationHint, int parallelism) {
            this.checkAndThrowIfDone();
            try {
                VertexManager.this.managedVertex.reconfigureVertex(rootInputSpecUpdate, parallelism, locationHint);
            }
            catch (AMUserCodeException e) {
                throw new TezUncheckedException((Throwable)((Object)e));
            }
        }

        public synchronized void scheduleTasks(List<VertexManagerPluginContext.ScheduleTaskRequest> tasks) {
            this.checkAndThrowIfDone();
            VertexManager.this.managedVertex.scheduleTasks(tasks);
        }

        public synchronized void scheduleVertexTasks(List<VertexManagerPluginContext.TaskWithLocationHint> tasks) {
            this.checkAndThrowIfDone();
            ArrayList<VertexManagerPluginContext.ScheduleTaskRequest> schedTasks = new ArrayList<VertexManagerPluginContext.ScheduleTaskRequest>(tasks.size());
            for (VertexManagerPluginContext.TaskWithLocationHint task : tasks) {
                schedTasks.add(VertexManagerPluginContext.ScheduleTaskRequest.create((int)task.getTaskIndex(), (TaskLocationHint)task.getTaskLocationHint()));
            }
            this.scheduleTasks(schedTasks);
        }

        @Nullable
        public synchronized Set<String> getVertexInputNames() {
            this.checkAndThrowIfDone();
            Set<String> inputNames = null;
            Map<String, RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> inputs = VertexManager.this.managedVertex.getAdditionalInputs();
            if (inputs != null) {
                inputNames = inputs.keySet();
            }
            return inputNames;
        }

        public synchronized UserPayload getUserPayload() {
            this.checkAndThrowIfDone();
            return VertexManager.this.payload;
        }

        public synchronized void addRootInputEvents(final String inputName, Collection<InputDataInformationEvent> events) {
            this.checkAndThrowIfDone();
            this.verifyIsRootInput(inputName);
            final long currTime = VertexManager.this.appContext.getClock().getTime();
            Collection tezEvents = Collections2.transform(events, (Function)new Function<InputDataInformationEvent, TezEvent>(){

                public TezEvent apply(InputDataInformationEvent riEvent) {
                    TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)riEvent, VertexManagerPluginContextImpl.this.rootEventSourceMetadata, currTime);
                    tezEvent.setDestinationInfo(VertexManagerPluginContextImpl.this.getDestinationMetaData(inputName));
                    return tezEvent;
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug("vertex:" + VertexManager.this.managedVertex.getLogIdentifier() + "; Added " + events.size() + " for input name " + inputName);
            }
            VertexManager.this.rootInputInitEventQueue.addAll(tezEvents);
        }

        public void sendEventToProcessor(Collection<CustomProcessorEvent> events, int taskId) {
            this.checkAndThrowIfDone();
            Preconditions.checkArgument((taskId >= 0 && taskId < VertexManager.this.managedVertex.getTotalTasks() ? 1 : 0) != 0, (Object)("Invalid taskId " + taskId + "; There are " + VertexManager.this.managedVertex.getTotalTasks() + " tasks in total."));
            if (events != null && events.size() > 0) {
                ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>();
                for (CustomProcessorEvent event : events) {
                    TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)event, null);
                    EventMetaData destinationMeta = new EventMetaData(EventMetaData.EventProducerConsumerType.PROCESSOR, VertexManager.this.managedVertex.getName(), VertexManager.this.managedVertex.getName(), TezTaskAttemptID.getInstance((TezTaskID)VertexManager.this.managedVertex.getTask(taskId).getTaskID(), (int)-1));
                    tezEvent.setDestinationInfo(destinationMeta);
                    tezEvents.add(tezEvent);
                }
                VertexManager.this.appContext.getEventHandler().handle((Event)new VertexEventRouteEvent(VertexManager.this.managedVertex.getVertexId(), tezEvents));
            }
        }

        public synchronized void setVertexLocationHint(VertexLocationHint locationHint) {
            this.checkAndThrowIfDone();
            Objects.requireNonNull(locationHint, "locationHint is null");
            VertexManager.this.managedVertex.setVertexLocationHint(locationHint);
        }

        public synchronized int getDAGAttemptNumber() {
            this.checkAndThrowIfDone();
            return VertexManager.this.appContext.getApplicationAttemptId().getAttemptId();
        }

        private void verifyIsRootInput(String inputName) {
            Preconditions.checkState((VertexManager.this.managedVertex.getAdditionalInputs().get(inputName) != null ? 1 : 0) != 0, (Object)"Cannot add events for non-root inputs");
        }

        private EventMetaData getDestinationMetaData(String inputName) {
            EventMetaData destMeta = this.destinationEventMetadataMap.get(inputName);
            if (destMeta == null) {
                destMeta = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, VertexManager.this.managedVertex.getName(), inputName, null);
                this.destinationEventMetadataMap.put(inputName, destMeta);
            }
            return destMeta;
        }

        public synchronized Resource getVertexTaskResource() {
            this.checkAndThrowIfDone();
            return VertexManager.this.managedVertex.getTaskResource();
        }

        public synchronized Resource getTotalAvailableResource() {
            this.checkAndThrowIfDone();
            return VertexManager.this.appContext.getTaskScheduler().getTotalResources(VertexManager.this.managedVertex.getTaskSchedulerIdentifier());
        }

        public synchronized int getNumClusterNodes() {
            this.checkAndThrowIfDone();
            return VertexManager.this.appContext.getTaskScheduler().getNumClusterNodes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void registerForVertexStateUpdates(String vertexName, Set<VertexState> stateSet) {
            this.checkAndThrowIfDone();
            List<String> list = this.notificationRegisteredVertices;
            synchronized (list) {
                this.notificationRegisteredVertices.add(vertexName);
            }
            VertexManager.this.stateChangeNotifier.registerForVertexUpdates(vertexName, stateSet, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterForVertexStateUpdates() {
            List<String> list = this.notificationRegisteredVertices;
            synchronized (list) {
                for (String vertexName : this.notificationRegisteredVertices) {
                    VertexManager.this.stateChangeNotifier.unregisterForVertexUpdates(vertexName, this);
                }
            }
        }

        boolean isComplete() {
            return this.isComplete.get();
        }

        public synchronized void vertexManagerDone() {
            this.checkAndThrowIfDone();
            LOG.info("Vertex Manager reported done for : " + VertexManager.this.managedVertex.getLogIdentifier());
            this.isComplete.set(true);
            this.unregisterForVertexStateUpdates();
        }

        public synchronized void vertexReconfigurationPlanned() {
            this.checkAndThrowIfDone();
            VertexManager.this.managedVertex.vertexReconfigurationPlanned();
        }

        public synchronized void doneReconfiguringVertex() {
            this.checkAndThrowIfDone();
            VertexManager.this.managedVertex.doneReconfiguringVertex();
        }

        public Map<String, List<String>> getInputVertexGroups() {
            this.checkAndThrowIfDone();
            HashMap inputGroups = Maps.newHashMap();
            if (VertexManager.this.managedVertex.getGroupInputSpecList() != null) {
                for (GroupInputSpec group : VertexManager.this.managedVertex.getGroupInputSpecList()) {
                    inputGroups.put(group.getGroupName(), Collections.unmodifiableList(group.getGroupVertices()));
                }
            }
            return inputGroups;
        }

        @Override
        public void onStateUpdated(VertexStateUpdate event) {
            VertexManager.this.enqueueAndScheduleNextEvent(new VertexManagerEventOnVertexStateUpdate(event));
        }
    }
}

