/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tez.common.io.NonSyncDataOutputStream;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.IFileOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryWriter
extends IFile.Writer {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryWriter.class);

    public InMemoryWriter(byte[] array) {
        this(new InMemoryBoundedByteArrayOutputStream(array));
    }

    public InMemoryWriter(BoundedByteArrayOutputStream arrayStream) {
        this(arrayStream, false);
    }

    public InMemoryWriter(BoundedByteArrayOutputStream arrayStream, boolean rle) {
        super(null, null, rle);
        this.out = new NonSyncDataOutputStream((OutputStream)new IFileOutputStream((OutputStream)arrayStream));
    }

    @Override
    public void append(Object key, Object value) throws IOException {
        throw new UnsupportedOperationException("InMemoryWriter.append(K key, V value");
    }

    @Override
    public void close() throws IOException {
        this.writeValueMarker(this.out);
        WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
        WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
        this.out.close();
        this.out = null;
    }

    private static class InMemoryBoundedByteArrayOutputStream
    extends BoundedByteArrayOutputStream {
        InMemoryBoundedByteArrayOutputStream(byte[] array) {
            super(array, 0, array.length);
        }
    }
}

