/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import Ember from 'ember';
import layout from '../templates/components/em-table-progress-cell';

export default Ember.Component.extend({
  layout: layout,

  content: null,

  message: Ember.computed("content", function () {
    var content = this.get("content");

    if(content === undefined || content === null) {
      return "Not Available!";
    }
    else if(isNaN(parseFloat(content))){
      return "Invalid Data!";
    }
  }),

  _definition: Ember.computed("definition", function () {
    return Ember.Object.extend({
      valueMin: 0,
      valueMax: 1,
      striped: true,
      style: null
    }).create(this.get("definition"));
  })
});
