/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.SplitLineReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class UncompressedSplitLineReader
extends SplitLineReader {
    private boolean needAdditionalRecord = false;
    private long splitLength;
    private long totalBytesRead = 0L;
    private boolean finished = false;
    private boolean usingCRLF;

    public UncompressedSplitLineReader(FSDataInputStream in, Configuration conf, byte[] recordDelimiterBytes, long splitLength) throws IOException {
        super((InputStream)in, conf, recordDelimiterBytes);
        this.splitLength = splitLength;
        this.usingCRLF = recordDelimiterBytes == null;
    }

    protected int fillBuffer(InputStream in, byte[] buffer, boolean inDelimiter) throws IOException {
        int maxBytesToRead = buffer.length;
        if (this.totalBytesRead < this.splitLength) {
            maxBytesToRead = Math.min(maxBytesToRead, (int)(this.splitLength - this.totalBytesRead));
        }
        int bytesRead = in.read(buffer, 0, maxBytesToRead);
        if (this.totalBytesRead == this.splitLength && inDelimiter && bytesRead > 0) {
            this.needAdditionalRecord = this.usingCRLF ? buffer[0] != 10 : true;
        }
        if (bytesRead > 0) {
            this.totalBytesRead += (long)bytesRead;
        }
        return bytesRead;
    }

    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        int bytesRead = 0;
        if (!this.finished) {
            if (this.totalBytesRead > this.splitLength) {
                this.finished = true;
            }
            bytesRead = super.readLine(str, maxLineLength, maxBytesToConsume);
        }
        return bytesRead;
    }

    @Override
    public boolean needAdditionalRecordAfterSplit() {
        return !this.finished && this.needAdditionalRecord;
    }

    protected void unsetNeedAdditionalRecordAfterSplit() {
        this.needAdditionalRecord = false;
    }
}

