/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.examples;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.examples.TezExampleBase;
import org.apache.tez.examples.WordCount;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.SimpleMRProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.partitioner.HashPartitioner;
import org.apache.tez.runtime.library.processor.SimpleProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedWordCount
extends TezExampleBase {
    private static String INPUT = WordCount.INPUT;
    private static String OUTPUT = WordCount.OUTPUT;
    private static String TOKENIZER = WordCount.TOKENIZER;
    private static String SUMMATION = WordCount.SUMMATION;
    private static String SORTER = "Sorter";
    private static final Logger LOG = LoggerFactory.getLogger(OrderedWordCount.class);

    public static DAG createDAG(TezConfiguration tezConf, String inputPath, String outputPath, int numPartitions, boolean disableSplitGrouping, boolean isGenerateSplitInClient, String dagName) throws IOException {
        DataSourceDescriptor dataSource = MRInput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextInputFormat.class, (String)inputPath).groupSplits(!disableSplitGrouping).generateSplitsInAM(!isGenerateSplitInClient).build();
        DataSinkDescriptor dataSink = MROutput.createConfigBuilder((Configuration)new Configuration((Configuration)tezConf), TextOutputFormat.class, (String)outputPath).build();
        Vertex tokenizerVertex = Vertex.create((String)TOKENIZER, (ProcessorDescriptor)ProcessorDescriptor.create((String)WordCount.TokenProcessor.class.getName()));
        tokenizerVertex.addDataSource(INPUT, dataSource);
        OrderedPartitionedKVEdgeConfig summationEdgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)Text.class.getName(), (String)IntWritable.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration((Configuration)tezConf).build();
        Vertex summationVertex = Vertex.create((String)SUMMATION, (ProcessorDescriptor)ProcessorDescriptor.create((String)SumProcessor.class.getName()), (int)numPartitions);
        OrderedPartitionedKVEdgeConfig sorterEdgeConf = OrderedPartitionedKVEdgeConfig.newBuilder((String)IntWritable.class.getName(), (String)Text.class.getName(), (String)HashPartitioner.class.getName()).setFromConfiguration((Configuration)tezConf).build();
        Vertex sorterVertex = Vertex.create((String)SORTER, (ProcessorDescriptor)ProcessorDescriptor.create((String)NoOpSorter.class.getName()), (int)1);
        sorterVertex.addDataSink(OUTPUT, dataSink);
        DAG dag = DAG.create((String)dagName);
        dag.addVertex(tokenizerVertex).addVertex(summationVertex).addVertex(sorterVertex).addEdge(Edge.create((Vertex)tokenizerVertex, (Vertex)summationVertex, (EdgeProperty)summationEdgeConf.createDefaultEdgeProperty())).addEdge(Edge.create((Vertex)summationVertex, (Vertex)sorterVertex, (EdgeProperty)sorterEdgeConf.createDefaultEdgeProperty()));
        return dag;
    }

    @Override
    protected void printUsage() {
        System.err.println("Usage:  orderedwordcount in out [numPartitions]");
    }

    @Override
    protected int validateArgs(String[] otherArgs) {
        if (otherArgs.length < 2 || otherArgs.length > 3) {
            return 2;
        }
        return 0;
    }

    @Override
    protected int runJob(String[] args, TezConfiguration tezConf, TezClient tezClient) throws Exception {
        DAG dag = OrderedWordCount.createDAG(tezConf, args[0], args[1], args.length == 3 ? Integer.parseInt(args[2]) : 1, this.isDisableSplitGrouping(), this.isGenerateSplitInClient(), "OrderedWordCount");
        LOG.info("Running OrderedWordCount");
        return this.runDag(dag, this.isCountersLog(), LOG);
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new OrderedWordCount(), (String[])args);
        System.exit(res);
    }

    public static class NoOpSorter
    extends SimpleMRProcessor {
        public NoOpSorter(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(OUTPUT)).getWriter();
            KeyValuesReader kvReader = (KeyValuesReader)((LogicalInput)this.getInputs().get(SUMMATION)).getReader();
            while (kvReader.next()) {
                Object sum = kvReader.getCurrentKey();
                for (Object word : kvReader.getCurrentValues()) {
                    kvWriter.write(word, sum);
                }
            }
        }
    }

    public static class SumProcessor
    extends SimpleProcessor {
        public SumProcessor(ProcessorContext context) {
            super(context);
        }

        public void run() throws Exception {
            Preconditions.checkArgument((this.getInputs().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getOutputs().size() == 1 ? 1 : 0) != 0);
            KeyValueWriter kvWriter = (KeyValueWriter)((LogicalOutput)this.getOutputs().get(SORTER)).getWriter();
            KeyValuesReader kvReader = (KeyValuesReader)((LogicalInput)this.getInputs().get(TOKENIZER)).getReader();
            while (kvReader.next()) {
                Text word = (Text)kvReader.getCurrentKey();
                int sum = 0;
                for (Object value : kvReader.getCurrentValues()) {
                    sum += ((IntWritable)value).get();
                }
                kvWriter.write((Object)new IntWritable(sum), (Object)word);
            }
        }
    }
}

