/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.util.GremlinValueComparator;

public enum Compare implements BiPredicate<Object, Object>
{
    eq{

        @Override
        public boolean test(Object first, Object second) {
            return GremlinValueComparator.COMPARABILITY.equals(first, second);
        }

        @Override
        public Compare negate() {
            return neq;
        }
    }
    ,
    neq{

        @Override
        public boolean test(Object first, Object second) {
            return !eq.test(first, second);
        }

        @Override
        public Compare negate() {
            return eq;
        }
    }
    ,
    gt{

        @Override
        public boolean test(Object first, Object second) {
            return GremlinValueComparator.COMPARABILITY.compare(first, second) > 0;
        }

        @Override
        public Compare negate() {
            return lte;
        }
    }
    ,
    gte{

        @Override
        public boolean test(Object first, Object second) {
            return GremlinValueComparator.COMPARABILITY.compare(first, second) >= 0;
        }

        @Override
        public Compare negate() {
            return lt;
        }
    }
    ,
    lt{

        @Override
        public boolean test(Object first, Object second) {
            return GremlinValueComparator.COMPARABILITY.compare(first, second) < 0;
        }

        @Override
        public Compare negate() {
            return gte;
        }
    }
    ,
    lte{

        @Override
        public boolean test(Object first, Object second) {
            return GremlinValueComparator.COMPARABILITY.compare(first, second) <= 0;
        }

        @Override
        public Compare negate() {
            return gt;
        }
    };


    public abstract Compare negate();
}

