/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.VertexComputing;
import org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.finalization.ComputerFinalizationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DiscardStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectCapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.RequirementsStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ComputerVerificationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;

public final class StandardVerificationStrategy
extends AbstractTraversalStrategy<TraversalStrategy.VerificationStrategy>
implements TraversalStrategy.VerificationStrategy {
    private static final StandardVerificationStrategy INSTANCE = new StandardVerificationStrategy();

    private StandardVerificationStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!(traversal.getStrategies().getStrategy(ComputerFinalizationStrategy.class).isPresent() || traversal.getStrategies().getStrategy(ComputerVerificationStrategy.class).isPresent() || TraversalHelper.getStepsOfAssignableClass(VertexComputing.class, traversal).isEmpty())) {
            throw new VerificationException("VertexComputing steps must be executed with a GraphComputer: " + TraversalHelper.getStepsOfAssignableClass(VertexComputing.class, traversal), traversal);
        }
        for (Step step : traversal.getSteps()) {
            for (String label : new HashSet<String>(step.getLabels())) {
                if (!Graph.Hidden.isHidden(label)) continue;
                step.removeLabel(label);
            }
            if (!(step instanceof ReducingBarrierStep) || !(step.getTraversal().getParent() instanceof RepeatStep) || !step.getTraversal().getParent().getGlobalChildren().get(0).getSteps().contains(step)) continue;
            throw new VerificationException("The parent of a reducing barrier can not be repeat()-step: " + step, traversal);
        }
        Step endStep = traversal.asAdmin().getEndStep();
        if (!(!TraversalHelper.hasStepOfClass(ProfileSideEffectStep.class, traversal) || endStep instanceof ProfileSideEffectStep || endStep instanceof SideEffectCapStep && endStep.getPreviousStep() instanceof ProfileSideEffectStep || endStep instanceof DiscardStep && endStep.getPreviousStep() instanceof SideEffectCapStep && endStep.getPreviousStep().getPreviousStep() instanceof ProfileSideEffectStep || endStep instanceof RequirementsStep && endStep.getPreviousStep() instanceof SideEffectCapStep && endStep.getPreviousStep().getPreviousStep() instanceof ProfileSideEffectStep || endStep instanceof RequirementsStep && endStep.getPreviousStep() instanceof DiscardStep && endStep.getPreviousStep().getPreviousStep() instanceof SideEffectCapStep && endStep.getPreviousStep().getPreviousStep().getPreviousStep() instanceof ProfileSideEffectStep)) {
            throw new VerificationException("When specified, the profile()-Step must be the last step or followed only by the cap()-step.", traversal);
        }
        if (TraversalHelper.getStepsOfClass(ProfileSideEffectStep.class, traversal).size() > 1) {
            throw new VerificationException("The profile()-Step cannot be specified multiple times.", traversal);
        }
    }

    public static StandardVerificationStrategy instance() {
        return INSTANCE;
    }

    @Override
    public Set<Class<? extends TraversalStrategy.VerificationStrategy>> applyPrior() {
        return Collections.singleton(ComputerVerificationStrategy.class);
    }
}

