/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.navigator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batchee.container.jsl.ExecutionElement;
import org.apache.batchee.container.jsl.GlobPatternMatcherImpl;
import org.apache.batchee.container.jsl.IllegalTransitionException;
import org.apache.batchee.container.jsl.Transition;
import org.apache.batchee.container.jsl.TransitionElement;
import org.apache.batchee.container.navigator.ModelNavigator;
import org.apache.batchee.container.status.ExecutionStatus;
import org.apache.batchee.container.status.ExtendedBatchStatus;
import org.apache.batchee.jaxb.Decision;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.Next;
import org.apache.batchee.jaxb.Split;
import org.apache.batchee.jaxb.Step;

public abstract class AbstractNavigator<T>
implements ModelNavigator<T> {
    private Map<String, ExecutionElement> alreadyExecutedElements = new HashMap<String, ExecutionElement>();

    public ExecutionElement getFirstExecutionElement(List<ExecutionElement> peerExecutionElements, String restartOn) throws IllegalTransitionException {
        ExecutionElement startElement;
        if (restartOn != null) {
            startElement = this.getExecutionElementFromId(peerExecutionElements, restartOn);
            if (startElement == null) {
                throw new IllegalStateException("Didn't find an execution element maching restart-on designated element: " + restartOn);
            }
        } else if (peerExecutionElements.size() > 0) {
            startElement = peerExecutionElements.get(0);
        } else {
            return null;
        }
        if (!(startElement instanceof Decision)) {
            this.alreadyExecutedElements.put(startElement.getId(), startElement);
        }
        this.validateElementType(startElement);
        return startElement;
    }

    public Transition getNextTransition(ExecutionElement currentElem, List<ExecutionElement> peerExecutionElements, ExecutionStatus currentStatus) throws IllegalTransitionException {
        Transition returnTransition = new Transition();
        ExecutionElement nextExecutionElement = null;
        List<TransitionElement> transitionElements = currentElem.getTransitionElements();
        if (!transitionElements.isEmpty()) {
            for (TransitionElement t : transitionElements) {
                boolean isMatched = this.matchExitStatusAgainstOnAttribute(currentStatus.getExitStatus(), t);
                if (!isMatched) continue;
                if (t instanceof Next) {
                    Next next = (Next)t;
                    nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, next.getTo());
                    returnTransition.setNextExecutionElement(nextExecutionElement);
                    break;
                }
                returnTransition.setTransitionElement(t);
                return returnTransition;
            }
        }
        if (nextExecutionElement == null) {
            if (currentStatus.getExtendedBatchStatus().equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                returnTransition.setNoTransitionElementMatchAfterException();
                return returnTransition;
            }
            nextExecutionElement = this.getNextExecutionElemFromAttribute(peerExecutionElements, currentElem);
            returnTransition.setNextExecutionElement(nextExecutionElement);
        }
        if (nextExecutionElement != null) {
            if (this.alreadyExecutedElements.containsKey(nextExecutionElement.getId())) {
                throw new IllegalTransitionException("Execution loop detected !!!  Trying to re-execute execution element: " + nextExecutionElement.getId());
            }
            if (!(nextExecutionElement instanceof Decision)) {
                this.alreadyExecutedElements.put(nextExecutionElement.getId(), nextExecutionElement);
            }
        } else {
            returnTransition.setFinishedTransitioning();
        }
        return returnTransition;
    }

    private ExecutionElement getExecutionElementFromId(List<ExecutionElement> executionElements, String id) throws IllegalTransitionException {
        if (id != null) {
            for (ExecutionElement elem : executionElements) {
                if (!elem.getId().equals(id)) continue;
                this.validateElementType(elem);
                return elem;
            }
            throw new IllegalTransitionException("No execution element found with id = " + id);
        }
        return null;
    }

    private static boolean matchSpecifiedExitStatus(String currentStepExitStatus, String exitStatusPattern) {
        return new GlobPatternMatcherImpl().matchWithoutBackslashEscape(currentStepExitStatus, exitStatusPattern);
    }

    private boolean matchExitStatusAgainstOnAttribute(String exitStatus, TransitionElement elem) {
        return AbstractNavigator.matchSpecifiedExitStatus(exitStatus, elem.getOn());
    }

    private ExecutionElement getNextExecutionElemFromAttribute(List<ExecutionElement> peerExecutionElements, ExecutionElement currentElem) throws IllegalTransitionException {
        ExecutionElement nextExecutionElement = null;
        if (currentElem instanceof Step) {
            String nextAttrId = ((Step)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Split) {
            String nextAttrId = ((Split)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Flow) {
            String nextAttrId = ((Flow)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Decision) {
            // empty if block
        }
        this.validateElementType(nextExecutionElement);
        return nextExecutionElement;
    }

    private void validateElementType(ExecutionElement elem) {
        if (!(elem == null || elem instanceof Decision || elem instanceof Flow || elem instanceof Split || elem instanceof Step)) {
            throw new IllegalArgumentException("Unknown execution element found, elem = " + elem + ", found with type: " + elem.getClass().getCanonicalName() + " , which is not an instance of Decision, Flow, Split, or Step.");
        }
    }
}

