/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.Arrays;
import org.apache.openejb.client.ProtocolMetaData;

public class ServerMetaData
implements Externalizable {
    private static final long serialVersionUID = -915541900332460068L;
    private transient URI[] locations;
    private transient URI location;
    private transient ProtocolMetaData metaData;

    public ServerMetaData() {
    }

    public ServerMetaData(URI ... locations) {
        this.locations = locations;
        this.location = locations[0];
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    public void merge(ServerMetaData toMerge) {
        this.locations = toMerge.locations;
    }

    public URI getLocation() {
        return this.location;
    }

    public URI[] getLocations() {
        return this.locations;
    }

    public int buildHash() {
        int locationsHash = 0;
        for (URI location : this.locations) {
            locationsHash += location.hashCode();
        }
        return locationsHash;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.locations = (URI[])in.readObject();
        this.location = this.locations[0];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.locations);
    }

    public String toString() {
        return Arrays.toString(this.locations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerMetaData that = (ServerMetaData)o;
        return !(this.location == null ? that.location != null : !this.location.equals(that.location));
    }

    public int hashCode() {
        return this.location != null ? this.location.hashCode() : 0;
    }
}

