// Package rfc provides symbols for specifications, primarily IETF RFCs.
//
// This includes strings, such as header names, as well as logic functions, such as cache control rules.
//
// All symbols in this package should document the precise RFC and ideally the exact section where they are defined, to allow readers to easily verify correctness.
//
// This is primarily intended for IETF HTTP RFCs, but may include other specifications as well (e.g. ANSI, W3C, WHATWG, etc).
// If a symbol documents simply "RFC" then it refers to an IETF RFC. If the symbol is an RFC from a different organization, it should document the organization or project, e.g. "Rust RFC 2436" or "ISO/IEC 23009."
//
package rfc

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
