/*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
import { ComponentFixture, TestBed } from "@angular/core/testing";
import { MatDialogModule } from "@angular/material/dialog";
import { ActivatedRoute } from "@angular/router";
import { RouterTestingModule } from "@angular/router/testing";
import { ReplaySubject } from "rxjs";

import { APITestingModule } from "src/app/api/testing";
import {
	NavigationService
} from "src/app/shared/navigation/navigation.service";

import { TopologyDetailsComponent } from "./topology-details.component";

describe("TopologyDetailsComponent", () => {
	let component: TopologyDetailsComponent;
	let fixture: ComponentFixture<TopologyDetailsComponent>;
	let route: ActivatedRoute;
	let paramMap: jasmine.Spy;

	const navSvc = jasmine.createSpyObj([], {
		headerHidden: new ReplaySubject<boolean>(),
		headerTitle: new ReplaySubject<string>(),
	});

	beforeEach(async () => {
		TestBed.configureTestingModule({
			declarations: [TopologyDetailsComponent],
			imports: [APITestingModule, RouterTestingModule, MatDialogModule],
			providers: [{provide: NavigationService, useValue: navSvc}],
		});
		route = TestBed.inject(ActivatedRoute);
		paramMap = spyOn(route.snapshot.paramMap, "get");
		paramMap.and.returnValue(null);
		fixture = TestBed.createComponent(TopologyDetailsComponent);
		component = fixture.componentInstance;
		fixture.detectChanges();
		await fixture.whenStable();
	});

	it("should create", () => {
		expect(component).toBeTruthy();
		expect(paramMap).toHaveBeenCalled();
	});

	it("existing topology", async () => {
		paramMap.and.returnValue("test");

		fixture = TestBed.createComponent(TopologyDetailsComponent);
		component = fixture.componentInstance;
		fixture.detectChanges();
		await fixture.whenStable();
		expect(paramMap).toHaveBeenCalled();
		expect(component.topology).toBeDefined();
		expect(component.topology.name).toBe("test");
		expect(component.new).toBeFalse();
	});
});
