#!/usr/bin/env bash

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

set -eu

dns_container_hostname='dns'

dns_domain='ciab.test'
dns_search_domains='infra.ciab.test ciab.test'

while ! dig "@${dns_container_hostname}" "${dns_container_hostname}"; do
	printf "Waiting for dns container \"${dns_container_hostname}\" to serve...\n"
	sleep 1
done

dnsip="$(dig +short ${dns_container_hostname})"

cat << EOF > /etc/resolv.conf
# autogenerated by set-dns.sh
domain ${dns_domain}
search ${dns_search_domains}
nameserver ${dnsip}
EOF
