/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.traffic_control.traffic_router.core.secure;

import org.junit.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsNull.nullValue;


public class CertificatesClientTest {
	@Test
	public void itUsesBase64MimeDecoder() {
		CertificatesClient certificatesClient = new CertificatesClient();
		assertThat(certificatesClient.doubleDecode(MIME_ENCODED_HTTPS_TEST_CERT).length, equalTo(1));
	}

	@Test
	public void itDecodesCertificateChainBundle() {
		CertificatesClient certificatesClient = new CertificatesClient();
		String[] encodedCerts = certificatesClient.doubleDecode(MIME_ENCODED_CERT_CHAIN);
		assertThat(encodedCerts.length, equalTo(3));
	}

	// This is just a self signed test cert for testing
	String MIME_ENCODED_HTTPS_TEST_CERT =
		"LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSUQ4akNDQXRvQ0NRQ25Oelk2L3pZUGNEQU5C\n" +
		"Z2txaGtpRzl3MEJBUXNGQURDQnVqRUxNQWtHQTFVRUJoTUNWVk14RVRBUEJnTlYKQkFnTUNFTnZi\n" +
		"Rzl5WVdSdk1ROHdEUVlEVlFRSERBWkVaVzUyWlhJeEZEQVNCZ05WQkFvTUMwVjRZVzF3YkdVZ1NX\n" +
		"NWpNUmt3RndZRApWUVFMREJCVmJtbGpiM0p1SUZSeVlXbHVaWEp6TVNnd0pnWURWUVFEREI4cUxt\n" +
		"aDBkSEJ6TFhSbGMzUXVkR2hsWTJSdUxtVjRZVzF3CmJHVXVZMjl0TVN3d0tnWUpLb1pJaHZjTkFR\n" +
		"a0JGaDF2Y0dWeVlYUnBiMjV6UUhSb1pXTmtiaTVsZUdGdGNHeGxMbU52YlRBZUZ3MHgKTmpBMk16\n" +
		"QXlNRFUzTVRoYUZ3MHlOakEyTWpneU1EVTNNVGhhTUlHNk1Rc3dDUVlEVlFRR0V3SlZVekVSTUE4\n" +
		"R0ExVUVDQXdJUTI5cwpiM0poWkc4eER6QU5CZ05WQkFjTUJrUmxiblpsY2pFVU1CSUdBMVVFQ2d3\n" +
		"TFJYaGhiWEJzWlNCSmJtTXhHVEFYQmdOVkJBc01FRlZ1CmFXTnZjbTRnVkhKaGFXNWxjbk14S0RB\n" +
		"bUJnTlZCQU1NSHlvdWFIUjBjSE10ZEdWemRDNTBhR1ZqWkc0dVpYaGhiWEJzWlM1amIyMHgKTERB\n" +
		"cUJna3Foa2lHOXcwQkNRRVdIVzl3WlhKaGRHbHZibk5BZEdobFkyUnVMbVY0WVcxd2JHVXVZMjl0\n" +
		"TUlJQklqQU5CZ2txaGtpRwo5dzBCQVFFRkFBT0NBUThBTUlJQkNnS0NBUUVBc2Vldm5NOTBWNmN6\n" +
		"Ny9TSTNVNTlFRzIzRG9WRllvSEE2SHJkOTh4QmNpcHExcXlCCjB3NS9JZllWd0k5NFB3MDNDSitT\n" +
		"a3VpMklkNFpwMythUlQ2Z054eDYxa2RwMWNVaHB0MVk4bGNVVklKckRRM0MzdmpCNkd3Y0tTWHMK\n" +
		"RmxvS1BOUk1IVHcweEZ3NGdJQjlHeCtUenRhYlBzL1IraHAvbzlreWV1b0QyZm9HN3NQbkRWOU8y\n" +
		"ZDVBOGJQWDhYWmNyZ045SnRwVApsd1E0NzVzUG9ZREJWVTJuY1dtWXl1N2JQbmZ2UFJQQm5jTVJI\n" +
		"andLL2JGbG1LLytRTmJQTDBCQTV6aGRxREhETkYwNXFnZWhCN0VQCmdlOG5Za3BGdEtBamJpTVpB\n" +
		"MVQvNFkxRy9iTEE5bFdXcUJFRVA4NmJYMkVxUmc5dmFJT1QyVE8wSCtQYzN0OHFVd0lEQVFBQk1B\n" +
		"MEcKQ1NxR1NJYjNEUUVCQ3dVQUE0SUJBUUNyODJoU1hhNE9kNWRkQXpVMThzM3dnLzVlWmhxK3Bx\n" +
		"bWx2NzFDdWpIL1A1NHUwUmtTNFUwLwo0SzhRQk8zdUZ0dHltclBqbjRvWUgyc2tiS1hHeDh0dkVu\n" +
		"SENxTENPVlkrRzBDTUFkYkdKRTF6dFV1TEJ5RDBVQzY0TmphdDdweHlYCjFJNUI4UFRhZnZXMzdh\n" +
		"cU1sUVFNR1JBay9iUVphUHRvRW1BcmdVZUUrZlFvQUNGQ2pZS3RUYVAvcDgxd3JlZldaczRJTktv\n" +
		"MWJBVE8KajMwYTNKd2NXUXVuWkRNMklNUXdVUGNqYVh5ZnozQ1JqVHRaWjFJQ0dJeWpLYXU4SFh2\n" +
		"WVVubm9XNjNsMVhZV09JRXJYa2J5ZVk0QwpTMTR3RGJLQUVmZk9QVGRCV2xweGJXSThtL094MHk4\n" +
		"bVRBSlFXY2JTR3VUaVR6RlNWM0JpcDQrYTJQR04KLS0tLS1FTkQgQ0VSVElGSUNBVEUtLS0tLQo=";

	// This is a test CA signed certificate chain created by hand where the expiration
	// date has already passed. So it cannot be used to create a false chain of trust.
	// https://jamielinux.com/docs/openssl-certificate-authority/index.html

	String MIME_ENCODED_CERT_CHAIN =
		"LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSUZtVENDQTRHZ0F3SUJBZ0lDRUFBd0RRWUpL\n" +
		"b1pJaHZjTkFRRUxCUUF3WlRFTE1Ba0dBMVVFQmhNQ1ZWTXgKRVRBUEJnTlZCQWdNQ0VOdmJHOXlZ\n" +
		"V1J2TVJBd0RnWURWUVFLREFkRGIyMWpZWE4wTVE4d0RRWURWUVFMREFaSgpVQ0JEUkU0eElEQWVC\n" +
		"Z05WQkFNTUYwTnZiV05oYzNRZ1NXNTBaWEp0WldScFlYUmxJRU5CTUI0WERURTJNRGN5Ck9USXhN\n" +
		"emN4TUZvWERURTJNRGN6TURJeE16Y3hNRm93Z1lZeEN6QUpCZ05WQkFZVEFsVlRNUkV3RHdZRFZR\n" +
		"UUkKREFoRGIyeHZjbUZrYnpFUE1BMEdBMVVFQnd3R1JHVnVkbVZ5TVJBd0RnWURWUVFLREFkWGFX\n" +
		"Um5aWFJ6TVJjdwpGUVlEVlFRTERBNVhhV1JuWlhRZ1YyRnphR1Z5Y3pFb01DWUdBMVVFQXd3Zktp\n" +
		"NTBaWE4wTFdoMGRIQnpMblJvClpXTmtiaTVsZUdGdGNHeGxMbU52YlRDQ0FTSXdEUVlKS29aSWh2\n" +
		"Y05BUUVCQlFBRGdnRVBBRENDQVFvQ2dnRUIKQUtiaEh2LzZYRGN3TkpHRzJVcnVaZmxybWVNLzFL\n" +
		"aTRqOU8xdlcrWGtpbUI1K3N0RVo3aUJ4ZE1XbHorNlMyRgpMcWdVSXBwUjlFeU5mc3VvMDZiMUlO\n" +
		"c2JDT29PZitqWnNRRHdTVlR6TTZJNkxQWkkrc2dMNFNmWk14V09Zbm5kCmhjUUdzT3JaeXNTYmtn\n" +
		"bkJQM2xFQXlQWVovOThFSFBMOUJ1Sm9LUVVkQ1BqZjZYY2YxcGl1SVFnbVg4TStFMFAKZm5VMFRC\n" +
		"Z2ZicUhCZ2srT1lzb21yNDhmVDl5SzdvbjFLUVVJb2V2aFBlbWlrai9HK1YyWWZtdTZIMU1HVkxm\n" +
		"dwp6SmtHWXFFWVhsTHZhODNNYkxXNm1CeVBMbkQzVTJSWTZQNndGL0JBclR0emZBVDRMWEp0blBV\n" +
		"YzNKZDR3UEd0Cmt3bldJWWtscWwwUjR6ZVdDRUxXeUprQ0F3RUFBYU9DQVM4d2dnRXJNQWtHQTFV\n" +
		"ZEV3UUNNQUF3RVFZSllJWkkKQVliNFFnRUJCQVFEQWdaQU1ETUdDV0NHU0FHRytFSUJEUVFtRmlS\n" +
		"UGNHVnVVMU5NSUVkbGJtVnlZWFJsWkNCVApaWEoyWlhJZ1EyVnlkR2xtYVdOaGRHVXdIUVlEVlIw\n" +
		"T0JCWUVGRCtuWWk0NUpxaEVuVlpOZVp2aVNRSDVFVi85Ck1JR1JCZ05WSFNNRWdZa3dnWWFBRkxL\n" +
		"R2k4NmFHTU5VeVVuczd1UDN6N2g0VzQ1d29XcWthREJtTVFzd0NRWUQKVlFRR0V3SlZVekVSTUE4\n" +
		"R0ExVUVDQXdJUTI5c2IzSmhaRzh4RHpBTkJnTlZCQWNNQmtSbGJuWmxjakVRTUE0RwpBMVVFQ2d3\n" +
		"SFEyOXRZMkZ6ZERFUE1BMEdBMVVFQ3d3R1NWQWdRMFJPTVJBd0RnWURWUVFEREFkRGIyMWpZWE4w\n" +
		"CmdnSVFBREFPQmdOVkhROEJBZjhFQkFNQ0JhQXdFd1lEVlIwbEJBd3dDZ1lJS3dZQkJRVUhBd0V3\n" +
		"RFFZSktvWkkKaHZjTkFRRUxCUUFEZ2dJQkFDNFJ4RjBXa2gwWmFjdmViUzJiVWtoNWIwZ1c0T2N4\n" +
		"MUNKWXFvOVNKeVlNbStyVwpXOHVhRHljVXhYWlBsd3lOTCtpamxMYzY5VTZCTGszZThzbWFEekEx\n" +
		"NDZ0MHJRUDQ5UHRNdXRxelNobHg5RXZECjVZa1NjbDNOUTVLQ0FqN05GR2s5ZGtrSnhha1lRNWRK\n" +
		"WVYyZUV2Z1hZS0tKTU9ZMFZRQ3plVnJYMUthcDlqbVIKTUZYcDFCNGYwRHVsL0I2WUwxQWxDRHZZ\n" +
		"TU02Q2ZWZkpRZlhhZ3BpK2owdWtrQnJnU0d5MHQvclVlZ09naW1kRApMSjdvZGxRcURWMnI4UCtB\n" +
		"MklxRlhOajVqa29wVGhWV3FQajY0ZDVXU0J4NVhkbElXUmZZN1ZYajdqc1RuaGl6CmNPcmE0UkxL\n" +
		"RXN5YnpTYklEcFl0U2FEUi8yNnZLbmFIOTFNKzV1QmpsODBNNGdHQ0RYSW1WSXRjU1JDY2VLamcK\n" +
		"VE05VnU0ejZucmNHNXRVa3I5bSszbmhIRHk2UXdJMDFYTFphamQ3S25OSjRUMTB2dUtHZk5EQjVI\n" +
		"cTdrb2xMWApTOEF2YVQ1b09ZN1pxWTd3Y1E1a1JHT0JKRHE1OUEvSWdvQTNnTzFIU29XYVp3cElV\n" +
		"N3V3RTNhVFRFdnIrRGZYCkRkUUxQR3F5cHMyZkFlK1FCanVrNUI2ZitVd1FrY0l6Tk1TWEdpUWlo\n" +
		"UXl1NERKUGZwTGdZRFVZeWM4VEx1UU0KazFJSVBJSnN1VTl6eUE5Uk9ud213dVBqSHVRaGRiVmVa\n" +
		"R0RrRTRYQWFlVDZYa2JpUTNScmRDTmlrclZVNzY3aQphWmU1Tk5nRElFRnAydWJWcTBsN2JoNzRH\n" +
		"K0VLN29xUGlRVGJOQzlkQUNvNjk4aVhacHZyYmdEeTBiVysKLS0tLS1FTkQgQ0VSVElGSUNBVEUt\n" +
		"LS0tLQotLS0tLUJFR0lOIENFUlRJRklDQVRFLS0tLS0KTUlJRnJUQ0NBNVdnQXdJQkFnSUNFQUF3\n" +
		"RFFZSktvWklodmNOQVFFTEJRQXdaakVMTUFrR0ExVUVCaE1DVlZNeApFVEFQQmdOVkJBZ01DRU52\n" +
		"Ykc5eVlXUnZNUTh3RFFZRFZRUUhEQVpFWlc1MlpYSXhFREFPQmdOVkJBb01CME52CmJXTmhjM1F4\n" +
		"RHpBTkJnTlZCQXNNQmtsUUlFTkVUakVRTUE0R0ExVUVBd3dIUTI5dFkyRnpkREFlRncweE5qQTMK\n" +
		"TWpreU1USTBNek5hRncweE5qQTNNekF5TVRJME16TmFNR1V4Q3pBSkJnTlZCQVlUQWxWVE1SRXdE\n" +
		"d1lEVlFRSQpEQWhEYjJ4dmNtRmtiekVRTUE0R0ExVUVDZ3dIUTI5dFkyRnpkREVQTUEwR0ExVUVD\n" +
		"d3dHU1ZBZ1EwUk9NU0F3CkhnWURWUVFEREJkRGIyMWpZWE4wSUVsdWRHVnliV1ZrYVdGMFpTQkRR\n" +
		"VENDQWlJd0RRWUpLb1pJaHZjTkFRRUIKQlFBRGdnSVBBRENDQWdvQ2dnSUJBTGs5Qk9vVk14RmRC\n" +
		"WUdBaUZqZmx3UGE4UVpHQ1ZxVXluUFNZOFRRQnlSYQo5NktLVk5mb003MlRzeGZPcS80UXdPbXQ3\n" +
		"NzF6RitEQWVRSkNpUmxWOWdwTFJPOURSRHFzVFpoazhWcW1QWktwCkgwcWhONnZxMnNmN0lQendt\n" +
		"RlZaU1BWTXEyOWVjeEdwaSt3T0Qrdzg4aW92RkdQdmxYWTdESkV0Rkx2OHlpM0wKSi82NzZ1dTZ3\n" +
		"alNoVDJSNDY5MEhRZU44b3c5NTJoVVFpNm1IRW01UC9VS0RxVEUvd2tnVStvcXlvSGVtS2lqUgpk\n" +
		"M29LREYzYzNCdzV3TXpzVWkwczhEenEydEJKaHVxWEtjQzZVZ3J5eDhKdGRFa3RjRk53VElmM1BQ\n" +
		"N2F1NGNMCm5ZeGpPZ1paczVrZEVaWUhCOTR2N0tKU1Zib2JKZVVleWJ3TzJqV2dJWXd0U2E4N3JK\n" +
		"TWovbzQ5WWRMMWtVVk0KYjZjTHRPcXZ4S2orZXBBMEdFSFlFUmdxTzNXUy9oamRkVUNEVEZwY1Jh\n" +
		"dDFaa0d0dFZ3VUxtanJCRkVxWkNzbwpXVVdvc3ovT0pTUU9IUjA4bENCUU83ZEVZQ0JlbXU0eUpy\n" +
		"Slczbk9hOGlGTFMvQkVIczBBbEtrMXVkTlJXUEJPCjYySGVBcS9RWjVPaUFlaDNqeWlOYnhMQnEv\n" +
		"NzgyTzB3Kzg0a1h2OE8rNm9jOEQ1M1FpbWo2WlpZNWJ5cmxiOUcKdGJ4elZnbDZRTzBZaDFSQ0E5\n" +
		"NmVLY1FQR0ppZnZHMnZyemovR0R4ZUVyT0pQN3VyTjlRckwxOWVCVmtlK0Y3TQpqd0hnL0ZLMUZK\n" +
		"aTA2RldpTVc2MXl0NHdYcjFiUVZRcFdhTDNWQUx4TEl3NmFOejkrZkJPZ0I3bFEvRlJBQ2Z2CkFn\n" +
		"TUJBQUdqWmpCa01CMEdBMVVkRGdRV0JCU3lob3ZPbWhqRFZNbEo3TzdqOTgrNGVGdU9jREFmQmdO\n" +
		"VkhTTUUKR0RBV2dCU2pVNnArdGdXdENZb3BuQzBhMFNLZWVhWlFrREFTQmdOVkhSTUJBZjhFQ0RB\n" +
		"R0FRSC9BZ0VBTUE0RwpBMVVkRHdFQi93UUVBd0lCaGpBTkJna3Foa2lHOXcwQkFRc0ZBQU9DQWdF\n" +
		"QUZqMy9EWEVhMVllTzVZWGJOVEc3Ck1TbnRhb2lkbVc3OHduK29UdjhGU25qZndTZnhMZGFlYm5I\n" +
		"c3N0Y2owbGFwa1czclI0eVJHeFUzMWFJWWlSZHoKcHNqek9mcTdkUnA2WWlvY3pNaWUwTGJXbHRL\n" +
		"MThNOFpYK3BIZnFxNjkxM3k2dzlrK2lGTDBZTVZIbTEzN2lnQQptQXE1aUdTT2RmMjRLUk1CMlJQ\n" +
		"N0Z0SzVBSkFHSGpNL011aUIrNWFyVmh0ZzRrRGlLNWZDaiszaDY1bjVCeGVwClpUNmFrSnY4YXdy\n" +
		"Ykx3MjY2bGp5bFQvejJkQllGOERSdG9oQTNraWVMZVAxczMwREUyU1ZDeVVzeElCU1FtUm0KSmhH\n" +
		"K2xMUFJuSFAyT1FpU0JhRmZVT284YUkwYkxmbW9CMjlDR2RtbWE0dStOS0VqVFNmbDM1Ymx2MlIv\n" +
		"eHJiaQowSnRmSU9XbytLTkU1ZFByVm1uYzJ0Tnc2WU9iampWL29yWXBQamhwdnBmMTUweCtvSUJs\n" +
		"a0JaQzZ0cVlYRFVQCis4MW5ONGtFaW9FUUtjUjYxUFVFRE9vVE80TitkZ2h5RnhtVmtJbnlZeTdt\n" +
		"UHFNWDJKUHZkeStLbXlPRzExeHYKSDdRUkF4MVQ3SWVEd2huRVdTRkZkODNEdXZRQTduTStBQ2Rx\n" +
		"TE5EbTVvVGI0amRaVU8waVFoMm43em1iZkJWQgpTL1lLVExEWXNmbUpPVGdVM0VhWXdjSythcVk3\n" +
		"OWxyY2VzZk5hY2g4NGxpTFhKMVRGN2VvN005ZVQ3eTVidEloCjRObmIrMlIxbkVHamFpNUpEdjhM\n" +
		"RU9SRTRObGhsaFNuMEdhZHNHQlRhMkM1ZFVCaUZIb2NNYWwxSm96eUtKcjAKbVBXY3R0azEyWGVW\n" +
		"Q2Y5ZkYvOWZPMFU9Ci0tLS0tRU5EIENFUlRJRklDQVRFLS0tLS0KLS0tLS1CRUdJTiBDRVJUSUZJ\n" +
		"Q0FURS0tLS0tCk1JSUZzakNDQTVxZ0F3SUJBZ0lKQU5qRGt3dUFDV214TUEwR0NTcUdTSWIzRFFF\n" +
		"QkN3VUFNR1l4Q3pBSkJnTlYKQkFZVEFsVlRNUkV3RHdZRFZRUUlEQWhEYjJ4dmNtRmtiekVQTUEw\n" +
		"R0ExVUVCd3dHUkdWdWRtVnlNUkF3RGdZRApWUVFLREFkRGIyMWpZWE4wTVE4d0RRWURWUVFMREFa\n" +
		"SlVDQkRSRTR4RURBT0JnTlZCQU1NQjBOdmJXTmhjM1F3CkhoY05NVFl3TnpJNU1qRXhOak14V2hj\n" +
		"Tk1UWXdOek13TWpFeE5qTXhXakJtTVFzd0NRWURWUVFHRXdKVlV6RVIKTUE4R0ExVUVDQXdJUTI5\n" +
		"c2IzSmhaRzh4RHpBTkJnTlZCQWNNQmtSbGJuWmxjakVRTUE0R0ExVUVDZ3dIUTI5dApZMkZ6ZERF\n" +
		"UE1BMEdBMVVFQ3d3R1NWQWdRMFJPTVJBd0RnWURWUVFEREFkRGIyMWpZWE4wTUlJQ0lqQU5CZ2tx\n" +
		"CmhraUc5dzBCQVFFRkFBT0NBZzhBTUlJQ0NnS0NBZ0VBcUFDSUNHbkVrMHZwdGNGUjVSUGNzWFN3\n" +
		"eThPamZYdFAKdUxpYjZXbWJQd1lZQWEyUDQ1NUxPVlB4S2ZaYzVIOUJBVWswNUx6ZUk0VC82REUx\n" +
		"NDlYY1lncE1pSXlJOXFSSgo0L1lJQ0FVNTJHSWkzY1FCeWl1VjdnNXEzUkxrM1dtZVhTTnVNeHFH\n" +
		"ZVRpZzdxb2w1MUxJK2UvZ0NKdms2VnowCjlhektYVzkyYXUwV3V1VzMvUnVZRndYWWRpYUdZYVo3\n" +
		"QVZ5cDZiMmUxeDJrdXBicXRQMDQ0czJkZXVSQzFtOWcKb3lUSlk1dHRta1E3ckxUc0czSDcyU01s\n" +
		"T0xRb2czUUtZVmJNTUROZlFJRHpwVkpRbzI3QlQxRGY3ZnpuUWdacApMUG90djA2QitWb2doZGw3\n" +
		"Zk1UZDAvWFhVUkk4S3ZUek1IakhCcDV5ZFpaUlVPMnlIR0N1Mm5uYmNuNm55MmNNCjE1aFQ3dHhp\n" +
		"QWZlNVIvZUpQZDVabnBGeDB0TFkvZ1BPUDJMeU4xTmdsTFBSWWJFQkE3dXFJT3Z2QlpSY3dYbisK\n" +
		"NzdGMWV4WHlreUNGNC8vVVF2ZHVJMndPazBaSVpURnVaaGRnajdMbVpOWlhoUUNsY3BXcDlaUnZM\n" +
		"ekNjODlvRwo2M0lpV1B5RzdNSmRNUHppV0RoQ3JoYkVMVUo0akxRUzBHdDBYbWsvT1MwSitiTHhx\n" +
		"SUZJYmRFNStUWW83K2c4ClNkdWxPUmp3cXRCYW5yeUMvbnlVb0JQSHQ3Q3JNeDlnUlE3NGFiM0s1\n" +
		"OXd1OExhWnQ1MEptaEx2OWk1RDRWaDgKNktPdVlVRitZT3NQRlpwdzlGWFMxRy9lYkdxa2Qvekk0\n" +
		"OFI2MVFESUN3TzF6RDdwYU82OVVhbVRKS29tRGs4Nwo4UGhvbWpXZ3VMVUNBd0VBQWFOak1HRXdI\n" +
		"UVlEVlIwT0JCWUVGS05UcW42MkJhMEppaW1jTFJyUklwNTVwbENRCk1COEdBMVVkSXdRWU1CYUFG\n" +
		"S05UcW42MkJhMEppaW1jTFJyUklwNTVwbENRTUE4R0ExVWRFd0VCL3dRRk1BTUIKQWY4d0RnWURW\n" +
		"UjBQQVFIL0JBUURBZ0dHTUEwR0NTcUdTSWIzRFFFQkN3VUFBNElDQVFDaXJHTWJGa1lFRlNVbQo2\n" +
		"TUJZTnVleUlYbUhNaEN6R1NOeU9UdWJsRDVtUVNEd2NEeTErS09wbGNLK3c5bzM3QnJzQlB6QVZX\n" +
		"L0tjeUJSCjcwMmo0TjB4dG9mR1ExaGJXTnhYMjlSajVLWVhRVVZQRDYzdUxVaVRTc21tSjkxbndD\n" +
		"N2hIOExLOTZFZWVkSHkKR0tVT1NLVjNreFV2UlFlLzk3Ykttbis5d2ZEMkJxd2hIM3E5Z1VUWkZy\n" +
		"ellENnJvRGg4SHJOdFNndzJBSnVLKwpHM0NFWUdMUDU4MFZEcUhsL05VNWxPSVFmekdSbWN4elho\n" +
		"M1JBVEpleE1yeFVsaHdpN2pwQ2dVeG5OWVFuUnBoCm11MVRjSXRJb0lDQXhER29kM0hGajFIWDhx\n" +
		"aWVIU2ZXckZjU0tiZWdpVjRYbEI0eU1FcXdML0x0ems2RUVTdkUKL2FkdlR4dzY1T2htT1Vid2lY\n" +
		"ck0vS1RTZDhwM0ltRFdjSlBoVXk1cHBjR0toVzJ5SWNSc1h5UnhWT2RsSTdnMQp0b1Q1SEc0Tm85\n" +
		"U2RQSGNSTkVPakdGV3BkL1pyZ3ZsWGkyV3ZRYTNNSXpkYi9RV3IvcnRRUGpLSmorelFucFExCjdX\n" +
		"NU9lOUc0NDJQaTZiWThDMEs4K1BjeUMrTkpVWm16MmdvT2hiMllzcFliaWkyMGpVSytNR2tONHZC\n" +
		"ajlyWngKUUs1TEVpMUErZmVoVEI0eTN3bUczN3ZHVjYrNUxyU3ZyWlJnZHF1TWdrSXBHdHpyRC9N\n" +
		"MWUrVVREdWY2bEhwVgplSjdDUW5LeHk4S3FnTVhodm5abVMxV0FGdGhSOUNuMzdxM1paay96ZUZv\n" +
		"MXVrWTJiSE13SU1VWFQ1QWJod0ZyCnk5V3YzdkRJOGZWTHNpNlNBL1IyZ2lqbm9WbmcyUT09Ci0t\n" +
		"LS0tRU5EIENFUlRJRklDQVRFLS0tLS0K";
}
