/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import java.util.HashMap;
import java.util.Map;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.PersistentField;
import ojb.broker.util.ObjectModification;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.TransactionAware;
import ojb.odmg.states.ModificationState;
import ojb.odmg.states.StateNewDirty;
import ojb.odmg.states.StateOldClean;
import org.odmg.ODMGRuntimeException;

public class ObjectEnvelope
implements ObjectModification {
    private transient Object myObj;
    private transient Map beforeImage;
    private transient Map afterImage;
    private ModificationState modificationState = null;
    private boolean needsInsert = false;
    private boolean needsUpdate = false;

    private ObjectEnvelope() {
    }

    public ObjectEnvelope(Object obj) {
        this.manage(obj);
        this.setInitialModificationState();
    }

    public void manage(Object obj) {
        this.myObj = obj;
        try {
            this.beforeImage = this.getMap();
        }
        catch (Exception ex) {
            this.beforeImage = null;
            throw new org.odmg.ClassNotPersistenceCapableException(ex.getMessage());
        }
    }

    public Object getObject() {
        return this.myObj;
    }

    public void beforeCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeCommit();
        }
    }

    public void afterCommit() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterCommit();
        }
    }

    public void beforeAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.beforeAbort();
        }
    }

    public void afterAbort() {
        if (this.myObj instanceof TransactionAware) {
            TransactionAware ta = (TransactionAware)this.myObj;
            ta.afterAbort();
        }
    }

    private Map getMap() throws IllegalAccessException, ClassNotPersistenceCapableException {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        ClassDescriptor mif = DescriptorRepository.getInstance().getDescriptorFor(this.getObject().getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        int i = 0;
        while (i < fieldDescs.length) {
            FieldDescriptor fd = fieldDescs[i];
            PersistentField f = fd.getPersistentField();
            fieldValues.put(fd.getColumnName(), f.get(this.myObj));
            ++i;
        }
        return fieldValues;
    }

    public ModificationState getModificationState() {
        return this.modificationState;
    }

    public boolean needsInsert() {
        return this.getModificationState().needsInsert();
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    private void setFields(Map theMap) throws IllegalAccessException, ClassNotPersistenceCapableException {
        ClassDescriptor mif = DescriptorRepository.getInstance().getDescriptorFor(this.myObj.getClass());
        FieldDescriptor[] fieldDescs = mif.getFieldDescriptions();
        int i = 0;
        while (i < fieldDescs.length) {
            FieldDescriptor fd = fieldDescs[i];
            PersistentField f = fd.getPersistentField();
            f.set(this.myObj, theMap.get(fd.getColumnName()));
            ++i;
        }
    }

    private void setInitialModificationState() {
        Object result;
        try {
            result = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker().getObjectByIdentity(new Identity(this.myObj));
        }
        catch (PersistenceBrokerException ex) {
            throw new ODMGRuntimeException(ex.getMessage());
        }
        ModificationState initialState = result == null ? StateNewDirty.getInstance() : StateOldClean.getInstance();
        this.modificationState = initialState;
    }

    public void setModificationState(ModificationState newModificationState) {
        if (newModificationState != this.modificationState) {
            this.modificationState = newModificationState;
        }
    }

    public String toString() {
        return new Identity(this.myObj) + "(" + this.modificationState + ")";
    }

    public boolean hasChanged() {
        Map currentImage = null;
        try {
            currentImage = this.getMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !this.beforeImage.equals(currentImage);
    }
}

