/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.ODMGException;
import org.odmg.Transaction;
import test.ojb.odmg.Article;

public class DListTest
extends TestCase {
    private static Class CLASS = class$test$ojb$odmg$DListTest == null ? (class$test$ojb$odmg$DListTest = DListTest.class$("test.ojb.odmg.DListTest")) : class$test$ojb$odmg$DListTest;
    private String databaseName;
    static /* synthetic */ Class class$test$ojb$odmg$DListTest;
    static /* synthetic */ Class class$test$ojb$odmg$Article;
    static /* synthetic */ Class class$ojb$odmg$collections$DListImpl;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public DListTest(String name) {
        super(name);
    }

    protected Article createArticle() {
        Article a = new Article();
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        try {
            a.setArticleId(broker.getUniqueId(class$test$ojb$odmg$Article == null ? (class$test$ojb$odmg$Article = DListTest.class$("test.ojb.odmg.Article")) : class$test$ojb$odmg$Article, "articleId"));
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        a.setArticleName("New Funny Article " + a.getArticleId());
        a.setStock(234);
        return a;
    }

    protected void printDList(DList list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Article a = (Article)iter.next();
            System.out.print(a.getArticleId() + ", ");
        }
        System.out.println();
    }

    public void setUp() {
        this.databaseName = "repository.xml";
    }

    public void tearDown() {
        try {
            OJB.getInstance().currentTransaction().abort();
            OJB.getInstance().getDatabase(null).close();
            this.databaseName = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testAdding() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Transaction tx = odmg.newTransaction();
        tx.begin();
        DList list = odmg.newDList();
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        String name = null;
        try {
            name = "the_dlist_" + (broker.getUniqueId(class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = DListTest.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl, "id") - 1);
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
        try {
            db.bind(list, name);
            tx.commit();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        tx = odmg.newTransaction();
        tx.begin();
        int i = 0;
        while (i < 5) {
            Article a = this.createArticle();
            list.add(a);
            ++i;
        }
        tx.commit();
        System.out.println("sequence of items in list:");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Article a = (Article)iter.next();
            System.out.print(a.getArticleId() + ", ");
        }
        System.out.println();
        tx = odmg.newTransaction();
        tx.begin();
        try {
            DList lookedUp = (DList)db.lookup(name);
            System.out.println("sequence of items in lookedup list:");
            iter = lookedUp.iterator();
            while (iter.hasNext()) {
                Article a = (Article)iter.next();
                System.out.print(a.getArticleId() + ", ");
            }
            System.out.println();
        }
        catch (Throwable ignored) {
            System.out.println(ignored.getMessage());
            ignored.printStackTrace();
            Assert.fail();
        }
        tx.commit();
    }

    public void testAddingWithIndex() {
        Article a;
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Transaction tx = odmg.newTransaction();
        tx.begin();
        DList list = odmg.newDList();
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        String name = null;
        try {
            name = "the_dlist_" + (broker.getUniqueId(class$ojb$odmg$collections$DListImpl == null ? (class$ojb$odmg$collections$DListImpl = DListTest.class$("ojb.odmg.collections.DListImpl")) : class$ojb$odmg$collections$DListImpl, "id") - 1);
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
        try {
            db.bind(list, name);
            tx.commit();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        tx = odmg.newTransaction();
        tx.begin();
        int i = 0;
        while (i < 5) {
            a = this.createArticle();
            list.add(a);
            ++i;
        }
        this.printDList(list);
        a = this.createArticle();
        list.add(2, a);
        this.printDList(list);
        a = this.createArticle();
        list.add(0, a);
        this.printDList(list);
        a = this.createArticle();
        list.add(7, a);
        this.printDList(list);
        tx.commit();
        System.out.println("sequence of items in list:");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            a = (Article)iter.next();
            System.out.print(a.getArticleId() + ", ");
        }
        System.out.println();
        tx = odmg.newTransaction();
        tx.begin();
        try {
            DList lookedUp = (DList)db.lookup(name);
            System.out.println("sequence of items in lookedup list:");
            iter = lookedUp.iterator();
            while (iter.hasNext()) {
                a = (Article)iter.next();
                System.out.print(a.getArticleId() + ", ");
            }
            System.out.println();
        }
        catch (Throwable ignored) {
            System.out.println(ignored.getMessage());
            ignored.printStackTrace();
            Assert.fail();
        }
        tx.commit();
    }

    public void testDBag() throws Exception {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        db.open(this.databaseName, 2);
        Transaction tx = odmg.newTransaction();
        tx.begin();
        DBag bag1 = odmg.newDBag();
        DBag bag2 = odmg.newDBag();
        Article a = this.createArticle();
        Article b = this.createArticle();
        Article c = this.createArticle();
        Article d = this.createArticle();
        Article e = this.createArticle();
        bag1.add(a);
        bag1.add(b);
        bag1.add(c);
        bag2.add(b);
        bag2.add(c);
        bag2.add(d);
        bag2.add(e);
        DBag bag3 = bag1.difference(bag2);
        Assert.assertEquals((String)"should contain only 1 element", (int)1, (int)bag3.size());
        bag3 = bag1.intersection(bag2);
        Assert.assertEquals((String)"should contain two elements", (int)2, (int)bag3.size());
        tx.commit();
    }

    public void testDSet() throws Exception {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        db.open(this.databaseName, 2);
        Transaction tx = odmg.newTransaction();
        tx.begin();
        DSet set1 = odmg.newDSet();
        DSet set2 = odmg.newDSet();
        Article a = this.createArticle();
        Article b = this.createArticle();
        Article c = this.createArticle();
        Article d = this.createArticle();
        Article e = this.createArticle();
        set1.add(a);
        set1.add(b);
        set1.add(c);
        set2.add(b);
        set2.add(c);
        set2.add(d);
        set2.add(e);
        db.bind(set1, "set1");
        db.bind(set2, "set2");
        tx.commit();
        tx = odmg.newTransaction();
        tx.begin();
        DSet set1a = (DSet)db.lookup("set1");
        DSet set2a = (DSet)db.lookup("set2");
        Assert.assertTrue((boolean)set1a.containsAll(set1));
        Assert.assertTrue((boolean)set2a.containsAll(set2));
        DSet set3 = set1.difference(set2);
        Assert.assertEquals((int)1, (int)set3.size());
        set3 = set1.intersection(set2);
        Assert.assertEquals((int)2, (int)set3.size());
        set3 = set1.union(set2);
        Assert.assertEquals((int)5, (int)set3.size());
        Assert.assertTrue((boolean)set1.properSubsetOf(set3));
        Assert.assertTrue((boolean)set2.properSubsetOf(set3));
        Assert.assertTrue((boolean)set3.properSupersetOf(set1));
        Assert.assertTrue((boolean)set3.properSupersetOf(set2));
        Assert.assertTrue((!set1.properSubsetOf(set2) ? 1 : 0) != 0);
        tx.commit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

