/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.util.LinkedList;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.MessengerSession;
import org.apache.commons.messenger.MessengerSupport;
import org.apache.commons.messenger.SessionFactory;

public class SimpleMessenger
extends MessengerSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$SimpleMessenger == null ? (class$org$apache$commons$messenger$SimpleMessenger = SimpleMessenger.class$("org.apache.commons.messenger.SimpleMessenger")) : class$org$apache$commons$messenger$SimpleMessenger));
    private SessionFactory sessionFactory;
    private LinkedList pool = new LinkedList();
    private ThreadLocal threadLocalData = new ThreadLocal();
    private static int count;
    static /* synthetic */ Class class$org$apache$commons$messenger$SimpleMessenger;

    public SessionFactory getSessionFactory() throws JMSException {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Connection getConnection() throws JMSException {
        return this.getSessionFactory().getConnection();
    }

    public ServerSessionPool createServerSessionPool(MessageListener messageListener, int maxThreads) throws JMSException {
        return this.getSessionFactory().createServerSessionPool(messageListener, maxThreads);
    }

    public synchronized void close() throws JMSException {
        while (!this.pool.isEmpty()) {
            MessengerSession session = (MessengerSession)this.pool.removeFirst();
            session.close();
        }
        this.getSessionFactory().close();
    }

    public Session getSession() throws JMSException {
        throw new UnsupportedOperationException("Not supported by this Messenger. Please use borrowSession() and returnSession() instead");
    }

    public Session getAsyncSession() throws JMSException {
        throw new UnsupportedOperationException("Not supported by this Messenger. Please use borrowSession() and returnSession() instead");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message call(Destination destination, Message message) throws JMSException {
        Message message2;
        ThreadLocalData data = null;
        MessengerSession messengerSession = this.borrowMessengerSession();
        try {
            data = this.getThreadLocalData(messengerSession.getSession());
            Destination replyTo = data.destination;
            message.setJMSReplyTo(replyTo);
            message2 = null;
            this.returnMessengerSession(messengerSession);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnMessengerSession(messengerSession);
            throw throwable;
        }
        this.send(destination, message);
        messengerSession = this.borrowMessengerSession();
        try {
            MessageConsumer consumer = data.consumer;
            Message response = consumer.receive();
            if (response == null) {
                data.clear();
            }
            message2 = response;
            Object var9_10 = null;
            this.returnMessengerSession(messengerSession);
            return message2;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.returnMessengerSession(messengerSession);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message call(Destination destination, Message message, long timeoutMillis) throws JMSException {
        MessengerSession messengerSession = this.borrowMessengerSession();
        try {
            ThreadLocalData data = this.getThreadLocalData(messengerSession.getSession());
            Destination replyTo = data.destination;
            message.setJMSReplyTo(replyTo);
            MessageProducer producer = messengerSession.getMessageProducer(destination);
            MessageConsumer consumer = data.consumer;
            if (messengerSession.isTopic()) {
                ((TopicPublisher)producer).publish((Topic)destination, message);
            } else {
                ((QueueSender)producer).send((Queue)destination, message);
            }
            Message response = consumer.receive(timeoutMillis);
            if (response == null) {
                data.clear();
            }
            Message message2 = response;
            Object var13_11 = null;
            this.returnMessengerSession(messengerSession);
            return message2;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            this.returnMessengerSession(messengerSession);
            throw throwable;
        }
    }

    protected ThreadLocalData getThreadLocalData(Session session) throws JMSException {
        ThreadLocalData data = (ThreadLocalData)this.threadLocalData.get();
        if (data == null) {
            data = new ThreadLocalData();
            this.threadLocalData.set(data);
        }
        if (data.destination == null) {
            data.destination = this.createTemporaryDestination();
        }
        if (data.consumer == null) {
            data.consumer = this.createConsumer(data.destination);
        }
        return data;
    }

    protected boolean isTopic(Connection connection) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected boolean isTopic(ConnectionFactory factory) throws JMSException {
        return this.getSessionFactory().isTopic();
    }

    protected MessengerSession createMessengerSession() throws JMSException {
        MessengerSession answer = new MessengerSession(this, this.getSessionFactory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created MessengerSession: " + ++count + " value: " + answer));
        }
        return answer;
    }

    protected SessionFactory createSessionFactory() throws JMSException {
        throw new JMSException("No SessionFactory configured for this Messenger. Cannot create a new JMS Session");
    }

    protected synchronized MessengerSession borrowMessengerSession() throws JMSException {
        MessengerSession answer = null;
        answer = this.pool.isEmpty() ? this.createMessengerSession() : (MessengerSession)this.pool.removeFirst();
        if (log.isDebugEnabled()) {
            log.debug((Object)("#### Borrowing messenger session: " + answer));
        }
        return answer;
    }

    protected synchronized void returnMessengerSession(MessengerSession session) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("#### Returning messenger session: " + session));
        }
        this.pool.addLast(session);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ThreadLocalData {
        public MessageConsumer consumer;
        public Destination destination;

        protected ThreadLocalData() {
        }

        public void clear() throws JMSException {
            this.destination = null;
            this.consumer.close();
        }
    }
}

