package org.apache.stratum.messenger;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.TestCase;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Category;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationValue;
import com.mockobjects.Verifiable;
import com.mockobjects.util.Verifier;

/**
 * Test cases to exercise the MessengerComponent.
 *
 * @author <a href="mailto:eric@dobbse.net">Eric Dobbs</a>
 * @version $Id: MessengerComponentTest.java 264191 2005-08-29 18:07:52Z henning $
 *
 * @see MessengerComponent
 */
public class MessengerComponentTest
        extends TestCase
{
    /** TODO: DOCUMENT ME! */
    private static Category log = Category.getInstance(MessengerComponentTest.class);

    /** TODO: DOCUMENT ME! */
    private static MessengerComponent messengerComponent = new MessengerComponent();

    /** TODO: DOCUMENT ME! */
    private static String CONFIG = "src/test-conf/Messenger.properties";

    /** TODO: DOCUMENT ME! */
    private static Configuration config;

    /**
     * Constructor.
     *
     * @param name String name of the method to be tested.
     */
    public MessengerComponentTest(String name)
    {
        super(name);
    }

    /**
     * Verify that MessengerComponent.configure() only asks for one value from the given Configuration, and that the property
     * requested is "messenger.xml.url"
     */
    public void testConfigure()
    {
        MockConfiguration mockConfiguration = new MockConfiguration();
        mockConfiguration.setExpectedGetStringCalls(1);
        mockConfiguration.setExpectedGetStringValue("messenger.xml.url");

        try
        {
            messengerComponent.configure(mockConfiguration);
        }
        catch (Exception e)
        {
            String errorMessage = "Exception should not have been thrown: " + e.getMessage();
            log.error(errorMessage, e);
            fail(errorMessage);
        }

        mockConfiguration.verify();
    }

    /**
     * Verify that a null value in the configuration will cause an Exception to be thrown.  That's about all that makes sense to
     * test for MessengerComponent.initialize().  Other testing would only repeat tests already covered in the Messenger test
     * code.
     */
    public void testInitialize()
    {
        MockConfiguration mockConfiguration = new MockConfiguration();
        mockConfiguration.setupGetString(null);

        try
        {
            messengerComponent.configure(mockConfiguration);
            messengerComponent.initialize();
            fail("Exception should have been thrown");
        }
        catch (Exception e)
        {
            //this space intentionally left blank
        }
    }

    /**
     * Need to mock the Configuration.getString() method for testing the configure method.  See <a
     * href="http://www.mockobjects.com">www.mockobjects.com</a> for more information about mock objects.
     */
    static class MockConfiguration
            extends PropertiesConfiguration
            implements Verifiable
    {
        /** TODO: DOCUMENT ME! */
        private ExpectationCounter getStringCalls = new ExpectationCounter("mockConfiguration.getString");

        /** TODO: DOCUMENT ME! */
        private ExpectationValue getStringValue = new ExpectationValue("mockConfiguration.getString");

        /** TODO: DOCUMENT ME! */
        private String getStringReturnValue = null;

        /**
         * TODO: DOCUMENT ME!
         *
         * @param callCount TODO: DOCUMENT ME!
         */
        public void setExpectedGetStringCalls(int callCount)
        {
            getStringCalls.setExpected(callCount);
        }

        /**
         * TODO: DOCUMENT ME!
         *
         * @param key TODO: DOCUMENT ME!
         */
        public void setExpectedGetStringValue(String key)
        {
            getStringValue.setExpected(key);
        }

        /**
         * TODO: DOCUMENT ME!
         *
         * @param getString TODO: DOCUMENT ME!
         */
        public void setupGetString(String getString)
        {
            getStringReturnValue = getString;
        }

        /**
         * TODO: DOCUMENT ME!
         */
        public void verify()
        {
            Verifier.verifyObject(this);
        }

        /**
         * TODO: DOCUMENT ME!
         *
         * @param key TODO: DOCUMENT ME!
         *
         * @return TODO: DOCUMENT ME!
         */
        public String getString(String key)
        {
            getStringCalls.inc();
            getStringValue.setActual(key);

            return getStringReturnValue;
        }
    }
}
