/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.TurbineException;

public class JobQueue {
    private Vector queue = new Vector(10);

    public JobEntry getNext() {
        if (this.queue.size() > 0) {
            return (JobEntry)this.queue.elementAt(0);
        }
        return null;
    }

    public JobEntry getJob(JobEntry je) {
        int index = -1;
        if (je != null) {
            index = this.queue.indexOf(je);
        }
        if (index < 0) {
            return null;
        }
        return (JobEntry)this.queue.elementAt(index);
    }

    public Vector list() {
        if (this.queue != null && this.queue.size() > 0) {
            return (Vector)this.queue.clone();
        }
        return null;
    }

    public synchronized void add(JobEntry je) {
        this.queue.addElement(je);
        this.sortQueue();
    }

    public synchronized void batchLoad(List jobEntries) {
        if (jobEntries != null) {
            this.queue.addAll(jobEntries);
            this.sortQueue();
        }
    }

    public synchronized void remove(JobEntry je) {
        this.queue.removeElement(je);
        this.sortQueue();
    }

    public synchronized void modify(JobEntry je) throws TurbineException {
        this.remove(je);
        je.calcRunTime();
        this.add(je);
        this.sortQueue();
    }

    public synchronized void updateQueue(JobEntry je) throws TurbineException {
        je.calcRunTime();
        this.sortQueue();
    }

    private void sortQueue() {
        Comparator aComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Long time1 = new Long(((JobEntry)o1).getNextRuntime());
                Long time2 = new Long(((JobEntry)o2).getNextRuntime());
                return time1.compareTo(time2);
            }
        };
        Collections.sort(this.queue, aComparator);
    }
}

