/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.schedule.BaseJobEntry;
import org.apache.turbine.util.TurbineException;

public class JobEntry
extends BaseJobEntry
implements Comparable {
    private static Log log = LogFactory.getLog((String)"scheduler");
    private boolean jobIsActive = false;
    private long runtime = 0L;
    private static final int SECOND = 0;
    private static final int MINUTE = 1;
    private static final int WEEK_DAY = 2;
    private static final int DAY_OF_MONTH = 3;
    private static final int DAILY = 4;

    public JobEntry() {
    }

    public JobEntry(int sec, int min, int hour, int wd, int day_mo, String task) throws TurbineException {
        if (StringUtils.isEmpty((String)task)) {
            throw new TurbineException("Error in JobEntry. Bad Job parameter. Task not set.");
        }
        this.setSecond(sec);
        this.setMinute(min);
        this.setHour(hour);
        this.setWeekDay(wd);
        this.setDayOfMonth(day_mo);
        this.setTask(task);
        this.calcRunTime();
    }

    public int compareTo(Object je) {
        int result = -1;
        if (je instanceof JobEntry) {
            result = this.getJobId() - ((JobEntry)je).getJobId();
        }
        return result;
    }

    public void setActive(boolean isActive) {
        this.jobIsActive = isActive;
    }

    public boolean isActive() {
        return this.jobIsActive;
    }

    public long getNextRuntime() {
        return this.runtime;
    }

    public Date getNextRunDate() {
        return new Date(this.runtime);
    }

    public String getNextRunAsString() {
        return this.getNextRunDate().toString();
    }

    public void calcRunTime() throws TurbineException {
        Calendar schedrun = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        switch (this.evaluateJobType()) {
            case 0: {
                schedrun.add(13, this.getSecond());
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 1: {
                schedrun.add(13, this.getSecond());
                schedrun.add(12, this.getMinute());
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 2: {
                schedrun.set(13, this.getSecond());
                schedrun.set(12, this.getMinute());
                schedrun.set(11, this.getHour());
                schedrun.set(7, this.getWeekDay());
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(7, 7);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 3: {
                schedrun.set(13, this.getSecond());
                schedrun.set(12, this.getMinute());
                schedrun.set(11, this.getHour());
                schedrun.set(5, this.getDayOfMonth());
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(2, 1);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case 4: {
                schedrun.set(13, this.getSecond());
                schedrun.set(12, this.getMinute());
                schedrun.set(11, this.getHour());
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(11, 24);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
        }
        log.info((Object)("Next runtime for task " + this.getTask() + " is " + this.getNextRunDate()));
    }

    private int evaluateJobType() throws TurbineException {
        if (this.getDayOfMonth() < 0) {
            if (this.getWeekDay() < 0) {
                if (this.getHour() < 0) {
                    if (this.getMinute() < 0) {
                        if (this.getSecond() < 0) {
                            throw new TurbineException("Error in JobEntry. Bad Job parameter.");
                        }
                        return 0;
                    }
                    if (this.getMinute() < 0 || this.getSecond() < 0) {
                        throw new TurbineException("Error in JobEntry. Bad Job parameter.");
                    }
                    return 1;
                }
                if (this.getMinute() < 0 || this.getHour() < 0 || this.getSecond() < 0) {
                    throw new TurbineException("Error in JobEntry. Bad Job parameter.");
                }
                return 4;
            }
            if (this.getMinute() < 0 || this.getHour() < 0 || this.getSecond() < 0) {
                throw new TurbineException("Error in JobEntry. Bad Job parameter.");
            }
            return 2;
        }
        if (this.getMinute() < 0 || this.getHour() < 0) {
            throw new TurbineException("Error in JobEntry. Bad Job parameter.");
        }
        return 3;
    }
}

