/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security;

import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.om.security.SecurityObject;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;

public class TurbineUser
extends SecurityObject<User>
implements User {
    private static final long serialVersionUID = 6380024466902321258L;
    private static Log log = LogFactory.getLog(TurbineUser.class);
    private Date createDate = new Date();
    private Date lastAccessDate = null;
    private Hashtable<String, Object> permStorage = null;
    private Hashtable<String, Object> tempStorage = null;

    public TurbineUser() {
        this.setHasLoggedIn(Boolean.FALSE);
    }

    @Override
    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    @Override
    public Date getLastLogin() {
        return (Date)this.getPerm("LAST_LOGIN");
    }

    @Override
    public String getPassword() {
        return (String)this.getPerm("PASSWORD_VALUE");
    }

    @Override
    public Object getPerm(String name) {
        return this.getPerm(name, null);
    }

    @Override
    public Object getPerm(String name, Object def) {
        Object val;
        try {
            val = this.getPermStorage().get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    @Override
    public Hashtable<String, Object> getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable(10);
        }
        return this.permStorage;
    }

    @Override
    public Object getTemp(String name) {
        return this.getTemp(name, null);
    }

    @Override
    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.getTempStorage().get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    @Override
    public String getFirstName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("FIRST_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }

    @Override
    public String getLastName() {
        String tmp = null;
        try {
            tmp = (String)this.getPerm("LAST_NAME");
            if (tmp.length() == 0) {
                tmp = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }

    @Override
    public boolean hasLoggedIn() {
        Boolean loggedIn = this.getHasLoggedIn();
        return loggedIn != null && loggedIn != false;
    }

    @Override
    public String getEmail() {
        return (String)this.getPerm("EMAIL");
    }

    @Override
    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    @Override
    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    @Override
    public Object removeTemp(String name) {
        return this.getTempStorage().remove(name);
    }

    @Override
    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", new Integer(cnt));
    }

    @Override
    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", new Integer(cnt));
    }

    @Override
    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    @Override
    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    @Override
    public void setLastLogin(Date date) {
        this.setPerm("LAST_LOGIN", date);
    }

    @Override
    public void setPassword(String password) {
        this.setPerm("PASSWORD_VALUE", password);
    }

    @Override
    public void setPerm(String name, Object value) {
        this.getPermStorage().put(name, value == null ? "" : value);
    }

    @Override
    public void setPermStorage(Hashtable<String, Object> permStorage) {
        this.permStorage = permStorage;
    }

    @Override
    public Hashtable<String, Object> getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable(10);
        }
        return this.tempStorage;
    }

    @Override
    public void setTempStorage(Hashtable<String, Object> tempStorage) {
        this.tempStorage = tempStorage;
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    @Override
    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    @Override
    public void setTemp(String name, Object value) {
        this.getTempStorage().put(name, value == null ? "" : value);
    }

    @Override
    public void setFirstName(String firstName) {
        this.setPerm("FIRST_NAME", firstName);
    }

    @Override
    public void setLastName(String lastName) {
        this.setPerm("LAST_NAME", lastName);
    }

    @Override
    public void setEmail(String address) {
        this.setPerm("EMAIL", address);
    }

    @Override
    public boolean isConfirmed() {
        String value = this.getConfirmed();
        return value != null && value.equals("CONFIRMED");
    }

    @Override
    public void setConfirmed(String value) {
        String val = "";
        if (value != null) {
            val = value;
        }
        this.setPerm("CONFIRM_VALUE", val);
    }

    @Override
    public String getConfirmed() {
        return (String)this.getPerm("CONFIRM_VALUE");
    }

    @Override
    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveOnSessionUnbind(this);
            }
        }
        catch (Exception e) {
            log.error((Object)("TurbineUser.valueUnbound(): " + e.getMessage()), (Throwable)e);
        }
    }

    public void save() throws Exception {
        if (TurbineSecurity.accountExists(this)) {
            TurbineSecurity.saveUser(this);
        } else {
            TurbineSecurity.addUser(this, this.getPassword());
        }
    }

    public void save(Connection conn) throws Exception {
        throw new Exception("not implemented");
    }

    public void save(String dbname) throws Exception {
        throw new Exception("not implemented");
    }

    @Override
    public String getName() {
        return (String)this.getPerm("LOGIN_NAME");
    }

    @Override
    public void setName(String name) {
        this.setPerm("LOGIN_NAME", name);
    }
}

